/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.alliances.Alliance;
import exerelin.campaign.events.FactionChangedEvent;
import exerelin.utilities.ExerelinUtilsReputation;
import exerelin.utilities.StringHelper;
import java.util.List;
import java.util.Map;

public class JoinFaction
extends BaseCommandPlugin {
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        CampaignEventPlugin eventSuper;
        boolean isDefection;
        String str;
        if (dialog == null) {
            return false;
        }
        SectorAPI sector = Global.getSector();
        String newFactionId = params.get(0).getString(memoryMap);
        FactionAPI newFaction = sector.getFaction(newFactionId);
        Alliance newAlliance = AllianceManager.getFactionAlliance(newFactionId);
        String oldFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI oldFaction = sector.getFaction(oldFactionId);
        Alliance oldAlliance = AllianceManager.getFactionAlliance(oldFactionId);
        boolean oldAllianceDissolved = false;
        boolean newAllianceDissolved = false;
        TextPanelAPI text = dialog.getTextPanel();
        PlayerFactionStore.setPlayerFactionId(newFactionId);
        if (oldFactionId.equals("player_npc")) {
            if (oldAlliance != null) {
                AllianceManager.setPlayerInteractionTarget(dialog.getInteractionTarget());
                AllianceManager.leaveAlliance(oldFactionId, false);
                AllianceManager.setPlayerInteractionTarget(null);
                oldAllianceDissolved = oldAlliance.getMembersCopy().size() <= 1;
                newAllianceDissolved = oldAllianceDissolved && newAlliance == oldAlliance;
                str = StringHelper.getString("exerelin_alliances", "leftAlliance");
                str = StringHelper.substituteToken(str, "$OldAlliance", oldAlliance.getName());
                text.addParagraph(str, Misc.getPositiveHighlightColor());
                if (oldAllianceDissolved) {
                    str = StringHelper.getString("exerelin_alliances", "allianceDissolved");
                    str = StringHelper.substituteToken(str, "$OldAlliance", oldAlliance.getName());
                    text.addParagraph(str, Misc.getPositiveHighlightColor());
                }
            } else {
                PlayerFactionStore.saveIndependentPlayerRelations();
            }
            str = StringHelper.getString("exerelin_factions", "joinedFaction");
            isDefection = false;
        } else {
            str = StringHelper.getString("exerelin_factions", "switchedFactions");
            isDefection = true;
        }
        ExerelinUtilsReputation.syncFactionRelationshipsToPlayer("player_npc");
        MemoryAPI memory = memoryMap.get("player");
        memory.set("$faction", (Object)newFaction, 0.0f);
        memory.set("$factionId", (Object)newFactionId, 0.0f);
        memory.set("$theFaction", (Object)newFaction.getDisplayNameWithArticle(), 0.0f);
        if (newAlliance != null && !newAllianceDissolved) {
            AllianceManager.setMemoryKeys(memory, newAlliance);
        } else {
            AllianceManager.unsetMemoryKeys(memory);
        }
        if (newAllianceDissolved) {
            memory = memoryMap.get("faction");
            AllianceManager.unsetMemoryKeys(memory);
        }
        if ((eventSuper = sector.getEventManager().getOngoingEvent(null, "exerelin_faction_changed")) == null) {
            eventSuper = sector.getEventManager().startEvent(null, "exerelin_faction_changed", null);
        }
        FactionChangedEvent event = (FactionChangedEvent)eventSuper;
        event.reportEvent(oldFaction, newFaction, isDefection ? "switch" : "join", dialog.getInteractionTarget());
        str = StringHelper.substituteToken(str, "$theOldFaction", oldFaction.getDisplayNameWithArticle());
        str = StringHelper.substituteToken(str, "$theNewFaction", newFaction.getDisplayNameWithArticle());
        text.addParagraph(str, Misc.getPositiveHighlightColor());
        return true;
    }
}

