/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.alliances.Alliance;
import exerelin.utilities.StringHelper;
import java.util.List;
import java.util.Map;

public class LeaveAlliance
extends BaseCommandPlugin {
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        String playerFactionId = PlayerFactionStore.getPlayerFactionId();
        if (!playerFactionId.equals("player_npc")) {
            return false;
        }
        Alliance oldAlliance = AllianceManager.getFactionAlliance(playerFactionId);
        boolean oldAllianceDissolved = false;
        TextPanelAPI text = dialog.getTextPanel();
        String str = StringHelper.getString("exerelin_alliances", "leftAlliance");
        AllianceManager.setPlayerInteractionTarget(dialog.getInteractionTarget());
        AllianceManager.leaveAlliance(playerFactionId, false);
        AllianceManager.setPlayerInteractionTarget(null);
        oldAllianceDissolved = oldAlliance.getMembersCopy().size() <= 1;
        MemoryAPI memory = memoryMap.get("player");
        AllianceManager.unsetMemoryKeys(memory);
        if (oldAllianceDissolved) {
            memory = memoryMap.get("faction");
            AllianceManager.unsetMemoryKeys(memory);
        }
        str = StringHelper.substituteToken(str, "$OldAlliance", oldAlliance.getName());
        text.addParagraph(str, Misc.getHighlightColor());
        if (oldAllianceDissolved) {
            str = StringHelper.getString("exerelin_alliances", "allianceDissolved");
            str = StringHelper.substituteToken(str, "$OldAlliance", oldAlliance.getName());
            text.addParagraph(str, Misc.getHighlightColor());
        }
        return true;
    }
}

