/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.MiningHelperLegacy;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class Nex_GetMiningResults
extends BaseCommandPlugin {
    protected static final String STRING_CATEGORY = "exerelin_mining";

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        SectorEntityToken target = dialog.getInteractionTarget();
        TextPanelAPI text = dialog.getTextPanel();
        if (!MiningHelperLegacy.canMine(target)) {
            return false;
        }
        Color hl = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        float miningTime = params.get(0).getFloat(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        MiningHelperLegacy.MiningResult results = MiningHelperLegacy.getMiningResults(playerFleet, target, miningTime, true);
        Map<String, Float> resources = results.report.totalOutput;
        EconomyAPI economy = Global.getSector().getEconomy();
        text.setFontVictor();
        text.setFontSmallInsignia();
        text.addParagraph("-----------------------------------------------------------------------------");
        String headerStr = Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "resourcesExtracted"));
        text.addParagraph(headerStr);
        text.highlightInLastPara(hl, new String[]{headerStr});
        for (Map.Entry<String, Float> tmp : resources.entrySet()) {
            int amount = (int)((double)tmp.getValue().floatValue() + 0.5);
            String resName = economy.getCommoditySpec(tmp.getKey()).getName();
            text.addParagraph("  " + resName + ": " + Misc.getWithDGS((float)amount));
            text.highlightInLastPara(hl, new String[]{resName});
        }
        if (!results.cachesFound.isEmpty()) {
            headerStr = StringHelper.getString(STRING_CATEGORY, "cacheFound");
            text.addParagraph(headerStr);
            text.highlightInLastPara(hl, new String[]{headerStr});
            for (MiningHelperLegacy.CacheResult cache : results.cachesFound) {
                String displayStr = cache.name;
                if (cache.def.type != MiningHelperLegacy.CacheType.FRIGATE && cache.def.type != MiningHelperLegacy.CacheType.FIGHTER_WING) {
                    displayStr = displayStr + " x " + Misc.getWithDGS((float)cache.numItems);
                }
                text.addParagraph("  " + displayStr);
                text.highlightInLastPara(hl, new String[]{cache.name});
            }
        }
        if (results.accidents != null) {
            int machineryLost;
            String displayStr;
            headerStr = StringHelper.getString(STRING_CATEGORY, "accidentsOccured");
            text.addParagraph(headerStr);
            text.highlightInLastPara(red, new String[]{headerStr});
            for (FleetMemberAPI ship : results.accidents.shipsDestroyed) {
                String displayStr2 = StringHelper.getStringAndSubstituteToken(STRING_CATEGORY, "shipDestroyed", "$ship", ship.getShipName());
                text.addParagraph(displayStr2);
                text.highlightInLastPara(red, new String[]{ship.getShipName()});
            }
            for (FleetMemberAPI ship : results.accidents.damage.keySet()) {
                int damage = (int)results.accidents.damage.get(ship).floatValue();
                displayStr = StringHelper.getString(STRING_CATEGORY, "shipDamaged");
                displayStr = StringHelper.substituteToken(displayStr, "$ship", ship.getShipName());
                displayStr = StringHelper.substituteToken(displayStr, "$damage", damage + "");
                text.addParagraph("  " + displayStr);
                text.highlightInLastPara(red, new String[]{ship.getShipName(), damage + ""});
            }
            for (FleetMemberAPI ship : results.accidents.crLost.keySet()) {
                String name = ship.isFighterWing() ? ship.getVariant().getFullDesignationWithHullName() : ship.getShipName();
                int crLost = (int)(results.accidents.crLost.get(ship).floatValue() * 100.0f);
                String crLostStr = crLost + "%";
                String displayStr3 = StringHelper.getString(STRING_CATEGORY, "shipLostCR");
                displayStr3 = StringHelper.substituteToken(displayStr3, "$ship", name);
                displayStr3 = StringHelper.substituteToken(displayStr3, "$crLost", crLostStr);
                text.addParagraph("  " + displayStr3);
                text.highlightInLastPara(red, new String[]{name, crLostStr});
            }
            int crewLost = results.accidents.crewLost;
            if (crewLost > 0) {
                displayStr = Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "crewLost"));
                text.addParagraph("  " + displayStr + ": " + crewLost);
                text.highlightInLastPara(red, new String[]{crewLost + ""});
            }
            if ((machineryLost = results.accidents.machineryLost) > 0) {
                String displayStr4 = Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "machineryLost"));
                text.addParagraph("  " + displayStr4 + ": " + machineryLost);
                text.highlightInLastPara(red, new String[]{machineryLost + ""});
            }
        }
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        return true;
    }
}

