/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.ResourceCostPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.MiningHelperLegacy;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

public class Nex_PrintMiningInfo
extends BaseCommandPlugin {
    protected static final String STRING_CATEGORY = "exerelin_mining";
    public static float COST_HEIGHT = 67.0f;

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String arg;
        if (dialog == null) {
            return false;
        }
        SectorEntityToken target = dialog.getInteractionTarget();
        if (!MiningHelperLegacy.canMine(target)) {
            return false;
        }
        switch (arg = params.get(0).getString(memoryMap)) {
            case "fleet": {
                this.printFleetInfo(dialog.getTextPanel());
                break;
            }
            case "tools": {
                this.printMiningTools(dialog.getTextPanel());
                break;
            }
            case "planet": {
                this.printPlanetInfo(dialog.getInteractionTarget(), dialog.getTextPanel(), memoryMap);
                break;
            }
            default: {
                this.printPlanetInfo(dialog.getInteractionTarget(), dialog.getTextPanel(), memoryMap);
            }
        }
        return true;
    }

    public void printPlanetInfo(SectorEntityToken target, TextPanelAPI text, Map<String, MemoryAPI> memoryMap) {
        Color hl = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        float miningStrength = MiningHelperLegacy.getFleetMiningStrength(playerFleet);
        String miningStrengthStr = String.format("%.1f", Float.valueOf(miningStrength));
        MiningHelperLegacy.MiningReport report = MiningHelperLegacy.getMiningReport(playerFleet, target, 1.0f);
        float danger = report.danger;
        String dangerStr = MessageFormat.format("{0,number,#%}", Float.valueOf(danger));
        float exhaustion = report.exhaustion;
        String exhaustionStr = String.format("%.1f", Float.valueOf(exhaustion * 100.0f)) + "%";
        EconomyAPI economy = Global.getSector().getEconomy();
        String planetType = target.getName();
        if (target instanceof PlanetAPI) {
            planetType = ((PlanetAPI)target).getSpec().getName();
        }
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "planetType")) + ": " + planetType);
        text.highlightInLastPara(hl, new String[]{planetType});
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "miningStrength")) + ": " + miningStrengthStr);
        text.highlightInLastPara(hl, new String[]{miningStrengthStr});
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "danger")) + ": " + dangerStr);
        if ((double)danger > 0.5) {
            text.highlightInLastPara(red, new String[]{dangerStr});
        } else {
            text.highlightInLastPara(hl, new String[]{dangerStr});
        }
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "exhaustion")) + ": " + exhaustionStr);
        text.highlightInLastPara(hl, new String[]{exhaustionStr});
        text.setFontVictor();
        text.setFontSmallInsignia();
        text.addParagraph("-----------------------------------------------------------------------------");
        for (Map.Entry<String, Float> tmp : report.totalOutput.entrySet()) {
            String res = tmp.getKey();
            float amount = tmp.getValue().floatValue();
            String amountStr = String.format("%.2f", Float.valueOf(amount));
            String resName = economy.getCommoditySpec(res).getName();
            text.addParagraph(resName + ": " + amountStr);
            text.highlightInLastPara(hl, new String[]{resName});
        }
        text.addParagraph("-----------------------------------------------------------------------------");
        FactionAPI playerFaction = Global.getSector().getPlayerFaction();
        Color color = playerFaction.getColor();
        ResourceCostPanelAPI cost = text.addCostPanel(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "machineryAvailable")), COST_HEIGHT, color, playerFaction.getDarkUIColor());
        cost.setNumberOnlyMode(true);
        cost.setWithBorder(false);
        cost.setAlignment(Alignment.LMID);
        int usable = (int)Math.ceil(MiningHelperLegacy.getRequiredMachinery(miningStrength));
        int available = (int)playerFleet.getCargo().getCommodityQuantity("heavy_machinery");
        Color curr = color;
        if (usable > available) {
            curr = Misc.getNegativeHighlightColor();
            String warning = StringHelper.getStringAndSubstituteToken(STRING_CATEGORY, "insufficientMachineryWarning", "$shipOrFleet", StringHelper.getShipOrFleet(playerFleet));
            text.addParagraph(warning);
        }
        cost.addCost("heavy_machinery", "" + usable + " (" + available + ")", curr);
        cost.update();
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        MemoryAPI memory = memoryMap.get("player");
        memory.set("$miningStrength", (Object)Float.valueOf(miningStrength), 0.0f);
    }

    public void printFleetInfo(TextPanelAPI text) {
        Color hl = Misc.getHighlightColor();
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        text.setFontVictor();
        text.setFontSmallInsignia();
        text.addParagraph("-----------------------------------------------------------------------------");
        for (FleetMemberAPI member : playerFleet.getFleetData().getMembersInPriorityOrder()) {
            float strength = MiningHelperLegacy.getShipMiningStrength(member, true);
            if (strength == 0.0f) continue;
            float strengthRaw = MiningHelperLegacy.getShipMiningStrength(member, false);
            String strengthStr = String.format("%.2f", Float.valueOf(strength));
            String strengthModStr = String.format("%.2f", Float.valueOf(strength - strengthRaw));
            String shipName = "";
            shipName = member.isFighterWing() ? member.getVariant().getFullDesignationWithHullName() : member.getShipName() + " (" + member.getHullSpec().getHullName() + "-\u7ea7)";
            text.addParagraph(shipName + ": " + strengthStr);
            text.highlightInLastPara(hl, new String[]{strengthStr});
        }
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
    }

    public void printMiningTools(TextPanelAPI text) {
        String strengthStr;
        String name;
        float strength;
        Color hl = Misc.getHighlightColor();
        text.addParagraph(StringHelper.getString(STRING_CATEGORY, "miningToolsListHeader"));
        text.setFontVictor();
        text.setFontSmallInsignia();
        text.addParagraph("-----------------------------------------------------------------------------");
        for (Map.Entry<String, Float> tmp : MiningHelperLegacy.getMiningShipsCopy().entrySet()) {
            ShipVariantAPI variant;
            String shipId = tmp.getKey();
            strength = tmp.getValue().floatValue();
            if (strength == 0.0f) continue;
            try {
                variant = Global.getSettings().getVariant(shipId + "_Hull");
            }
            catch (RuntimeException rex) {
                continue;
            }
            name = variant.getHullSpec().getHullName();
            strengthStr = String.format("%.1f", Float.valueOf(strength));
            text.addParagraph(name + ": " + strengthStr);
            text.highlightInLastPara(hl, new String[]{name});
        }
        text.addParagraph("");
        for (Map.Entry<String, Float> tmp : MiningHelperLegacy.getMiningWeaponsCopy().entrySet()) {
            WeaponSpecAPI weapon;
            String weaponId = tmp.getKey();
            strength = tmp.getValue().floatValue();
            if (strength == 0.0f) continue;
            try {
                weapon = Global.getSettings().getWeaponSpec(weaponId);
            }
            catch (RuntimeException rex) {
                continue;
            }
            name = weapon.getWeaponName();
            strengthStr = String.format("%.1f", Float.valueOf(strength));
            text.addParagraph(name + ": " + strengthStr);
            text.highlightInLastPara(hl, new String[]{name});
        }
        text.addParagraph("");
        text.addParagraph(StringHelper.getString(STRING_CATEGORY, "miningToolsListAddendum"));
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
    }
}

