/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.InvasionRound;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class PredictInvasionResults
extends BaseCommandPlugin {
    protected static final String STRING_CATEGORY = "exerelin_invasion";

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        SectorEntityToken target = dialog.getInteractionTarget();
        TextPanelAPI text = dialog.getTextPanel();
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        boolean isRaid = false;
        InvasionRound.InvasionRoundResult worst = InvasionRound.GetInvasionRoundResult(playerFleet, target, isRaid, InvasionRound.InvasionSimulationType.PESSIMISTIC);
        InvasionRound.InvasionRoundResult best = InvasionRound.GetInvasionRoundResult(playerFleet, target, isRaid, InvasionRound.InvasionSimulationType.OPTIMISTIC);
        float attackerStrengthWorst = worst.getAttackerStrength();
        float attackerStrengthBest = best.getAttackerStrength();
        float defenderStrength = best.getDefenderStrength();
        int marinesLostWorst = worst.getMarinesLost();
        int marinesLostBest = best.getMarinesLost();
        String a1 = String.format("%.1f", Float.valueOf(attackerStrengthWorst));
        String a2 = String.format("%.1f", Float.valueOf(attackerStrengthBest));
        String attackerStrength = a1 + " - " + a2;
        String defenderStrengthStr = String.format("%.1f", Float.valueOf(defenderStrength));
        String marinesLost = marinesLostBest + " - " + marinesLostWorst;
        float defenderAdvantageOverWorstCase = defenderStrength - attackerStrengthWorst;
        float attackerStrengthRange = attackerStrengthBest - attackerStrengthWorst;
        float winChance = 1.0f - defenderAdvantageOverWorstCase / attackerStrengthRange;
        if ((winChance *= 100.0f) < 0.0f) {
            winChance = 0.0f;
        }
        if (winChance > 100.0f) {
            winChance = 100.0f;
        }
        String winChanceStr = String.format("%.1f", Float.valueOf(winChance)) + "%";
        text.setFontVictor();
        text.setFontSmallInsignia();
        Color hl = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        text.addParagraph("-----------------------------------------------------------------------------");
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "attackerStrength")) + ": " + attackerStrength);
        text.highlightInLastPara(hl, new String[]{"" + attackerStrength});
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "defenderStrength")) + ": " + defenderStrengthStr);
        text.highlightInLastPara(red, new String[]{"" + defenderStrengthStr});
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "captureChance")) + ": " + winChanceStr);
        if (winChance < 50.0f) {
            text.highlightInLastPara(red, new String[]{"" + winChanceStr});
        } else {
            text.highlightInLastPara(hl, new String[]{"" + winChanceStr});
        }
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "projectedLosses")) + ": " + marinesLost);
        text.highlightInLastPara(red, new String[]{"" + marinesLost});
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        MemoryAPI memory = memoryMap.get("local");
        memory.set("$exerelinInvasionTimeTaken", (Object)Float.valueOf(best.getTimeTaken()), 0.0f);
        return true;
    }
}

