/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrintFactionMarkets
extends BaseCommandPlugin {
    static final HashMap<Integer, Color> colorByMarketSize = new HashMap();

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        String factionId = params.get(0).getString(memoryMap);
        boolean isExiInCorvus = ExerelinUtilsFaction.isExiInCorvus(factionId);
        List<MarketAPI> markets = ExerelinUtilsFaction.getFactionMarkets(factionId);
        if (markets.isEmpty() && !isExiInCorvus) {
            return false;
        }
        Collections.sort(markets, new MarketComparator());
        FactionAPI faction = Global.getSector().getFaction(factionId);
        TextPanelAPI text = dialog.getTextPanel();
        Color hl = Misc.getHighlightColor();
        int numMarkets = markets.size();
        if (isExiInCorvus) {
            ++numMarkets;
        }
        String str = StringHelper.getString("exerelin_factions", "numMarkets");
        str = StringHelper.substituteFactionTokens(str, faction);
        str = StringHelper.substituteToken(str, "$numMarkets", numMarkets + "");
        text.addParagraph(str);
        text.highlightInLastPara(hl, new String[]{"" + numMarkets});
        text.setFontSmallInsignia();
        text.addParagraph("-----------------------------------------------------------------------------");
        boolean anyBase = false;
        if (isExiInCorvus) {
            String entry = StringHelper.getString("exerelin_markets", "marketDirectoryEntryNoLocation");
            entry = StringHelper.substituteToken(entry, "$market", "Tasserus");
            entry = StringHelper.substituteToken(entry, "$size", "??");
            text.addParagraph(entry);
            text.highlightInLastPara(hl, new String[]{"Tasserus"});
            text.highlightInLastPara(hl, new String[]{"??"});
        }
        for (MarketAPI market : markets) {
            String marketName = market.getName();
            LocationAPI loc = market.getContainingLocation();
            String locName = loc.getName();
            if (loc instanceof StarSystemAPI) {
                locName = ((StarSystemAPI)loc).getBaseName();
            }
            int size = market.getSize();
            Color sizeColor = Color.WHITE;
            if (colorByMarketSize.containsKey(size)) {
                sizeColor = colorByMarketSize.get(size);
            }
            String entry = StringHelper.getString("exerelin_markets", "marketDirectoryEntry");
            entry = StringHelper.substituteToken(entry, "$market", marketName);
            entry = StringHelper.substituteToken(entry, "$location", locName);
            String sizeStr = size + "";
            if (market.hasCondition("military_base")) {
                anyBase = true;
                sizeStr = sizeStr + ", " + StringHelper.getString("base");
            }
            if (market.hasCondition("cabal_influence") && (market.getMemoryWithoutUpdate().getBoolean("$visitedBefore") || Global.getSettings().isDevMode())) {
                sizeStr = sizeStr + ", " + StringHelper.getString("cabal");
            }
            entry = StringHelper.substituteToken(entry, "$size", sizeStr);
            text.addParagraph(entry);
            text.highlightInLastPara(sizeColor, new String[]{"" + size});
        }
        if (anyBase) {
            // empty if block
        }
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        return true;
    }

    static {
        colorByMarketSize.put(2, Color.BLUE);
        colorByMarketSize.put(3, Color.CYAN);
        colorByMarketSize.put(4, Color.GREEN);
        colorByMarketSize.put(5, Color.YELLOW);
        colorByMarketSize.put(6, Color.ORANGE);
        colorByMarketSize.put(7, Color.PINK);
        colorByMarketSize.put(8, Color.RED);
    }

    public class MarketComparator
    implements Comparator<MarketAPI> {
        @Override
        public int compare(MarketAPI market1, MarketAPI market2) {
            int size2;
            String loc2;
            String loc1 = market1.getContainingLocation().getName();
            if (loc1.compareToIgnoreCase(loc2 = market2.getContainingLocation().getName()) > 0) {
                return 1;
            }
            if (loc2.compareToIgnoreCase(loc1) > 0) {
                return -1;
            }
            int size1 = market1.getSize();
            if (size1 > (size2 = market2.getSize())) {
                return -1;
            }
            if (size2 > size1) {
                return 1;
            }
            return 0;
        }
    }
}

