/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.newgame;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.CharacterCreationData;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

public class NGCAddShipAndComplement
extends BaseCommandPlugin {
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        String vid = params.get(0).getString(memoryMap);
        CharacterCreationData data = (CharacterCreationData)memoryMap.get("local").get("$characterData");
        try {
            FleetMemberType type = FleetMemberType.SHIP;
            if (vid.endsWith("_wing")) {
                type = FleetMemberType.FIGHTER_WING;
            }
            data.addStartingFleetMember(vid, type);
            FleetMemberAPI temp = Global.getFactory().createFleetMember(type, vid);
            int crew = (int)Math.min(temp.getNeededCrew() * 1.5f, temp.getMaxCrew());
            int supplies = (int)temp.getCargoCapacity() / 2;
            int machinery = (int)temp.getCargoCapacity() / 8;
            int fuel = (int)Math.min(temp.getFuelUse() * 20.0f, temp.getFuelCapacity());
            data.getStartingCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"crew", (float)crew);
            data.getStartingCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"supplies", (float)supplies);
            data.getStartingCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"heavy_machinery", (float)machinery);
            data.getStartingCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"fuel", (float)fuel);
            AddRemoveCommodity.addFleetMemberGainText((ShipVariantAPI)temp.getVariant(), (TextPanelAPI)dialog.getTextPanel());
            AddRemoveCommodity.addCommodityGainText((String)"crew", (int)crew, (TextPanelAPI)dialog.getTextPanel());
            AddRemoveCommodity.addCommodityGainText((String)"supplies", (int)supplies, (TextPanelAPI)dialog.getTextPanel());
            AddRemoveCommodity.addCommodityGainText((String)"heavy_machinery", (int)machinery, (TextPanelAPI)dialog.getTextPanel());
            AddRemoveCommodity.addCommodityGainText((String)"fuel", (int)fuel, (TextPanelAPI)dialog.getTextPanel());
        }
        catch (RuntimeException rex) {
            Global.getLogger(((Object)((Object)this)).getClass()).error((Object)rex.getMessage());
            dialog.getTextPanel().addParagraph(rex.getMessage());
        }
        return true;
    }
}

