/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.newgame;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.CharacterCreationData;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import java.util.List;
import java.util.Map;

public class NGCAddStartingShipsByFleetType
extends BaseCommandPlugin {
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        String fleetTypeStr = params.get(0).getString(memoryMap);
        CharacterCreationData data = (CharacterCreationData)memoryMap.get("local").get("$characterData");
        ExerelinFactionConfig factionConf = ExerelinConfig.getExerelinFactionConfig(PlayerFactionStore.getPlayerFactionIdNGC());
        List<String> startingVariants = (List<String>)memoryMap.get("local").get("$startShips_" + fleetTypeStr);
        if (startingVariants == null || startingVariants.isEmpty()) {
            startingVariants = factionConf.getStartShipsForType(fleetTypeStr, true);
        }
        int crew = 0;
        int supplies = 0;
        int machinery = 0;
        int fuel = 0;
        for (String variantId : startingVariants) {
            try {
                FleetMemberType type = FleetMemberType.SHIP;
                if (variantId.endsWith("_wing")) {
                    type = FleetMemberType.FIGHTER_WING;
                }
                data.addStartingFleetMember(variantId, type);
                FleetMemberAPI temp = Global.getFactory().createFleetMember(type, variantId);
                crew += (int)Math.min(temp.getNeededCrew() * 1.2f, temp.getMaxCrew());
                supplies += (int)temp.getCargoCapacity() / 2;
                machinery += (int)temp.getCargoCapacity() / 8;
                fuel += (int)Math.min(temp.getFuelUse() * 20.0f, temp.getFuelCapacity());
                AddRemoveCommodity.addFleetMemberGainText((ShipVariantAPI)temp.getVariant(), (TextPanelAPI)dialog.getTextPanel());
            }
            catch (RuntimeException rex) {
                Global.getLogger(((Object)((Object)this)).getClass()).error((Object)rex.getMessage());
                dialog.getTextPanel().addParagraph(rex.getMessage());
            }
        }
        data.getStartingCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"crew", (float)crew);
        data.getStartingCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"supplies", (float)supplies);
        data.getStartingCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"heavy_machinery", (float)machinery);
        data.getStartingCargo().addItems(CargoAPI.CargoItemType.RESOURCES, (Object)"fuel", (float)fuel);
        AddRemoveCommodity.addCommodityGainText((String)"crew", (int)crew, (TextPanelAPI)dialog.getTextPanel());
        AddRemoveCommodity.addCommodityGainText((String)"supplies", (int)supplies, (TextPanelAPI)dialog.getTextPanel());
        AddRemoveCommodity.addCommodityGainText((String)"heavy_machinery", (int)machinery, (TextPanelAPI)dialog.getTextPanel());
        AddRemoveCommodity.addCommodityGainText((String)"fuel", (int)fuel, (TextPanelAPI)dialog.getTextPanel());
        return true;
    }
}

