/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.corvus;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class Corvus {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.getStarSystem("Corvus");
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI star = system.initStar("corvus", "star_yellow", 775.0f, 500.0f, 10.0f, 1.0f, 3.0f);
        PlanetAPI corvusI = system.addPlanet("asharu", (SectorEntityToken)star, "Asharu", "desert", 55.0f, 150.0f, 2800.0f, 100.0f);
        corvusI.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "asharu"));
        corvusI.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        corvusI.getSpec().setUseReverseLightForGlow(true);
        corvusI.applySpecChanges();
        corvusI.setCustomDescriptionId("planet_asharu");
        CustomCampaignEntityAPI asharu_shade = system.addCustomEntity("asharu_shade", "Asharu \u6052\u661f\u7f69", "stellar_shade", "neutral");
        asharu_shade.setCircularOrbitPointingDown(system.getEntityById("corvus"), 115.0f, 2800.0f, 100.0f);
        asharu_shade.setCustomDescriptionId("stellar_shade");
        PlanetAPI corvusII = system.addPlanet("jangala", (SectorEntityToken)star, "Jangala", "jungle", 245.0f, 200.0f, 4500.0f, 200.0f);
        corvusII.setCustomDescriptionId("planet_jangala");
        corvusII.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        corvusII.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        corvusII.getSpec().setUseReverseLightForGlow(true);
        corvusII.applySpecChanges();
        CustomCampaignEntityAPI hegemonyStation = system.addCustomEntity("corvus_hegemony_station", "Jangala \u7a7a\u95f4\u7ad9", "station_jangala_type", "hegemony");
        hegemonyStation.setCircularOrbitPointingDown(system.getEntityById("jangala"), 225.0f, 320.0f, 30.0f);
        hegemonyStation.setCustomDescriptionId("station_jangala");
        CustomCampaignEntityAPI relay = system.addCustomEntity("corvus_relay", "Jangala \u901a\u8baf\u5668", "comm_relay", "hegemony");
        relay.setCircularOrbitPointingDown(system.getEntityById("corvus"), 185.0f, 4500.0f, 200.0f);
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("jangala_jump", "Jangala \u8df3\u8dc3\u70b9");
        jumpPoint.setCircularOrbit(system.getEntityById("corvus"), 305.0f, 4500.0f, 200.0f);
        jumpPoint.setRelatedPlanet((SectorEntityToken)corvusII);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        CustomCampaignEntityAPI gate = system.addCustomEntity("jangala_gate", "Corvus \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("corvus"), 0.0f, 6000.0f, 350.0f);
        system.addAsteroidBelt((SectorEntityToken)star, 90, 5650.0f, 500.0f, 150.0f, 300.0f, "asteroid_belt", "Nemo's Belt");
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 5600.0f, 305.0f, null, null);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_asteroids0", 256.0f, 3, Color.white, 256.0f, 5720.0f, 295.0f, null, null);
        PlanetAPI corvusIII = system.addPlanet("barad", (SectorEntityToken)star, "Barad", "gas_giant", 200.0f, 300.0f, 7800.0f, 400.0f);
        SectorEntityToken barad_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(corvusIII.getRadius() + 200.0f, (corvusIII.getRadius() + 200.0f) / 2.0f, (SectorEntityToken)corvusIII, corvusIII.getRadius() + 50.0f, corvusIII.getRadius() + 50.0f + 250.0f, new Color(50, 20, 100, 40), 0.5f, new Color[]{new Color(140, 100, 235), new Color(180, 110, 210), new Color(150, 140, 190), new Color(140, 190, 210), new Color(90, 200, 170), new Color(65, 230, 160), new Color(20, 220, 70)}));
        barad_field.setCircularOrbit((SectorEntityToken)corvusIII, 0.0f, 0.0f, 100.0f);
        PlanetAPI corvusIIIA = system.addPlanet("corvus_IIIa", (SectorEntityToken)corvusIII, "Garnir", "cryovolcanic", 135.0f, 100.0f, 790.0f, 20.0f);
        corvusIIIA.setCustomDescriptionId("planet_barad_a");
        CustomCampaignEntityAPI pirateStation = system.addCustomEntity("corvus_pirate_station", "Garnir \u63d0\u53d6\u7269\u4ed3\u5e93", "station_mining00", "pirates");
        pirateStation.setCircularOrbitPointingDown(system.getEntityById("corvus_IIIa"), 45.0f, 170.0f, 20.0f);
        pirateStation.setCustomDescriptionId("pirate_base_barad");
        pirateStation.setInteractionImage("illustrations", "pirate_station");
        system.addRingBand((SectorEntityToken)corvusIII, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 1050.0f, 45.0f, "ring", null);
        PlanetAPI corvusIIIB = system.addPlanet("corvus_IIIb", (SectorEntityToken)corvusIII, "Warion", "barren", 235.0f, 70.0f, 1300.0f, 60.0f);
        SectorEntityToken baradL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 20, 30, 4.0f, 16.0f, "Barad L4 \u5c0f\u884c\u661f"));
        SectorEntityToken baradL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 20, 30, 4.0f, 16.0f, "Barad L5 \u5c0f\u884c\u661f"));
        baradL4.setCircularOrbit((SectorEntityToken)star, 140.0f, 7800.0f, 400.0f);
        baradL5.setCircularOrbit((SectorEntityToken)star, 260.0f, 7800.0f, 400.0f);
        SectorEntityToken neutralStation = system.addOrbitalStation("corvus_abandoned_station", system.getEntityById("asharu"), 45.0f, 300.0f, 30.0f, "Abandoned \u5730\u5f62\u6539\u9020\u5e73\u53f0", "neutral");
        neutralStation.setCircularOrbitPointingDown(system.getEntityById("asharu"), 45.0f, 300.0f, 30.0f);
        Misc.setAbandonedStationMarket((String)"corvus_abandoned_station_market", (SectorEntityToken)neutralStation);
        neutralStation.setCustomDescriptionId("asharu_platform");
        neutralStation.setInteractionImage("illustrations", "abandoned_station2");
        neutralStation.getMarket().getSubmarket("storage").getCargo().addMothballedShip(FleetMemberType.SHIP, "hermes_d_Hull", null);
        SectorEntityToken nebula = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("   xx   xx x xxxx xxxxxx  xx      x ", 6, 6, "terrain", "nebula_amber", 4, 4, null));
        nebula.getLocation().set(corvusII.getLocation().x + 1000.0f, corvusII.getLocation().y);
        nebula.setCircularOrbit((SectorEntityToken)star, 140.0f, 10000.0f, 500.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)star, (StarAge)StarAge.AVERAGE, (int)2, (int)4, (float)12500.0f, (int)3, (boolean)true);
        StarSystemGenerator.addSystemwideNebula((StarSystemAPI)system, (StarAge)StarAge.OLD);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

