/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import java.awt.Color;

public class AlGebbar {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Al Gebbar");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI algebbar_star = system.initStar("algebbar", "star_blue_giant", 1200.0f, 800.0f);
        system.setLightColor(new Color(210, 230, 255));
        PlanetAPI gebbar2 = system.addPlanet("gebbar2", (SectorEntityToken)algebbar_star, "Kolasis", "lava_minor", 0.0f, 65.0f, 2400.0f, 80.0f);
        PlanetAPI gebbar3 = system.addPlanet("gebbar3", (SectorEntityToken)algebbar_star, "Basanizo", "lava", 0.0f, 90.0f, 2800.0f, 110.0f);
        system.addRingBand((SectorEntityToken)algebbar_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 3850.0f, 80.0f);
        system.addRingBand((SectorEntityToken)algebbar_star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 4000.0f, 80.0f);
        system.addRingBand((SectorEntityToken)algebbar_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 4120.0f, 130.0f);
        system.addAsteroidBelt((SectorEntityToken)algebbar_star, 100, 4000.0f, 100.0f, 256.0f, 140.0f, "asteroid_belt", null);
        JumpPointAPI jumpPoint2 = Global.getFactory().createJumpPoint("algebbar_jump", "Al Gebbar \u8df3\u8dc3\u70b9");
        jumpPoint2.setCircularOrbit(system.getEntityById("algebbar"), 330.0f, 5000.0f, 225.0f);
        system.addEntity((SectorEntityToken)jumpPoint2);
        PlanetAPI gebbar4 = system.addPlanet("epithany", (SectorEntityToken)algebbar_star, "Epiphany", "barren-bombarded", 270.0f, 80.0f, 5000.0f, 225.0f);
        gebbar4.setCustomDescriptionId("planet_epithany");
        gebbar4.getSpec().setPlanetColor(new Color(255, 240, 225, 255));
        system.addRingBand((SectorEntityToken)gebbar4, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 400.0f, 40.0f);
        system.addAsteroidBelt((SectorEntityToken)gebbar4, 20, 400.0f, 40.0f, 30.0f, 50.0f, "asteroid_belt", "Custodes");
        jumpPoint2.setRelatedPlanet((SectorEntityToken)gebbar4);
        PlanetAPI gebbar5 = system.addPlanet("gebbar5", (SectorEntityToken)algebbar_star, "Loutron", "cryovolcanic", 90.0f, 120.0f, 6400.0f, 295.0f);
        gebbar5.getSpec().setPlanetColor(new Color(235, 255, 245, 255));
        CustomCampaignEntityAPI abandoned_station = system.addCustomEntity("abandoned_station", "Abandoned Skyhook Anchor", "station_mining00", "neutral");
        abandoned_station.setCircularOrbitPointingDown(system.getEntityById("gebbar5"), 90.0f, 220.0f, 25.0f);
        abandoned_station.setCustomDescriptionId("station_abandoned_mining");
        abandoned_station.setInteractionImage("illustrations", "orbital_construction");
        abandoned_station.addTag("abandoned");
        abandoned_station.addTag("volatiles_extraction_platform");
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

