/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import java.awt.Color;

public class Arcadia {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Arcadia");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        PlanetAPI star = system.initStar("arcadia", "star_white", 180.0f, 300.0f);
        system.setLightColor(new Color(200, 200, 200));
        star.setCustomDescriptionId("star_white_dwarf");
        PlanetAPI arcadia1 = system.addPlanet("nomios", (SectorEntityToken)star, "Nomios", "frozen", 90.0f, 130.0f, 3000.0f, 100.0f);
        PlanetAPI arcadia2 = system.addPlanet("syrinx", (SectorEntityToken)star, "Syrinx", "ice_giant", 180.0f, 300.0f, 6000.0f, 200.0f);
        arcadia2.setCustomDescriptionId("planet_syrinx");
        PlanetAPI arcadia2a = system.addPlanet("agreus", (SectorEntityToken)arcadia2, "Agreus", "barren", 0.0f, 130.0f, 1600.0f, 50.0f);
        arcadia2a.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren02"));
        arcadia2a.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "sindria"));
        arcadia2a.getSpec().setGlowColor(new Color(235, 245, 255, 255));
        arcadia2a.getSpec().setUseReverseLightForGlow(true);
        arcadia2a.applySpecChanges();
        arcadia2a.setInteractionImage("illustrations", "industrial_megafacility");
        arcadia2a.setCustomDescriptionId("planet_agreus");
        system.addRingBand((SectorEntityToken)arcadia2, "misc", "rings_asteroids0", 256.0f, 0, new Color(170, 210, 255, 255), 256.0f, 800.0f, 40.0f, "ring", null);
        system.addAsteroidBelt((SectorEntityToken)arcadia2, 20, 1000.0f, 128.0f, 40.0f, 80.0f, "asteroid_belt", null);
        CustomCampaignEntityAPI relay = system.addCustomEntity("syrinx_relay", "Syrinx \u901a\u8baf\u5668", "comm_relay", "hegemony");
        relay.setCircularOrbitPointingDown(system.getEntityById("arcadia"), 240.0f, 6000.0f, 200.0f);
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("syrinx_passage", "Syrinx Passage");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)star, 120.0f, 6000.0f, 200.0f);
        jumpPoint.setOrbit(orbit);
        jumpPoint.setRelatedPlanet((SectorEntityToken)arcadia2a);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        CustomCampaignEntityAPI arc_station = system.addCustomEntity("arcadia_station", "Citadel Arcadia", "station_side02", "hegemony");
        arc_station.setCircularOrbitPointingDown(system.getEntityById("syrinx"), 45.0f, 730.0f, 30.0f);
        arc_station.setCustomDescriptionId("station_arcadia");
        arc_station.setInteractionImage("illustrations", "hound_hangar");
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)star, (StarAge)StarAge.AVERAGE, (int)3, (int)5, (float)9400.0f, (int)2, (boolean)true);
        if ((double)StarSystemGenerator.random.nextFloat() > 0.5) {
            StarSystemGenerator.addSystemwideNebula((StarSystemAPI)system, (StarAge)StarAge.AVERAGE);
        }
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

