/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import java.awt.Color;

public class Askonia {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Askonia");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        PlanetAPI star = system.initStar("askonia", "star_red_giant", 1000.0f, 1500.0f, 5.0f, 0.5f, 2.0f);
        system.setLightColor(new Color(255, 210, 200));
        PlanetAPI a1 = system.addPlanet("sindria", (SectorEntityToken)star, "Sindria", "rocky_metallic", 0.0f, 150.0f, 2900.0f, 100.0f);
        a1.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "sindria"));
        a1.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        a1.getSpec().setUseReverseLightForGlow(true);
        a1.applySpecChanges();
        a1.setCustomDescriptionId("planet_sindria");
        a1.setInteractionImage("illustrations", "urban01");
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("askonia_jump_point_alpha", "Sindria \u8df3\u8dc3\u70b9");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)a1, 0.0f, 500.0f, 30.0f);
        jumpPoint.setOrbit(orbit);
        jumpPoint.setRelatedPlanet((SectorEntityToken)a1);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        jumpPoint.setCircularOrbit(system.getEntityById("askonia"), 60.0f, 3000.0f, 100.0f);
        system.addEntity((SectorEntityToken)jumpPoint);
        CustomCampaignEntityAPI sindria_relay = system.addCustomEntity("sindria_relay", "Sindria \u901a\u8baf\u5668", "comm_relay", "sindrian_diktat");
        sindria_relay.setCircularOrbitPointingDown(system.getEntityById("askonia"), -60.0f, 3000.0f, 100.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 3570.0f, 220.0f, null, null);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 3660.0f, 226.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)star, 150, 3600.0f, 170.0f, 200.0f, 250.0f, "asteroid_belt", "Stone River");
        PlanetAPI a2 = system.addPlanet("salus", (SectorEntityToken)star, "Salus", "gas_giant", 230.0f, 350.0f, 7500.0f, 250.0f);
        a2.setCustomDescriptionId("planet_salus");
        a2.getSpec().setPlanetColor(new Color(255, 225, 170, 255));
        a2.getSpec().setAtmosphereColor(new Color(160, 110, 45, 140));
        a2.getSpec().setCloudColor(new Color(255, 164, 96, 200));
        a2.getSpec().setTilt(15.0f);
        a2.applySpecChanges();
        PlanetAPI a2a = system.addPlanet("cruor", (SectorEntityToken)a2, "Cruor", "rocky_unstable", 45.0f, 80.0f, 700.0f, 25.0f);
        a2a.setInteractionImage("illustrations", "desert_moons_ruins");
        a2a.setCustomDescriptionId("planet_cruor");
        system.addAsteroidBelt((SectorEntityToken)a2, 50, 1100.0f, 128.0f, 40.0f, 80.0f, "asteroid_belt", "Opis Ring");
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 1100.0f, 40.0f);
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 1120.0f, 50.0f);
        SectorEntityToken opis_debris_cloud = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(200.0f, 400.0f, 20, 30, 4.0f, 12.0f, "Opis Debris Cloud"));
        opis_debris_cloud.setCircularOrbitPointingDown(system.getEntityById("salus"), 45.0f, 1100.0f, 70.0f);
        PlanetAPI a2b = system.addPlanet("volturn", (SectorEntityToken)a2, "Volturn", "water", 110.0f, 120.0f, 1400.0f, 45.0f);
        a2b.setCustomDescriptionId("planet_volturn");
        a2b.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        a2b.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        a2b.getSpec().setUseReverseLightForGlow(true);
        a2b.applySpecChanges();
        a2b.setInteractionImage("illustrations", "space_bar");
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 1800.0f, 70.0f);
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 1800.0f, 90.0f);
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 1800.0f, 110.0f, "ring", "Dust Ring");
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_ice0", 256.0f, 0, Color.white, 256.0f, 2150.0f, 50.0f);
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_ice0", 256.0f, 0, Color.white, 256.0f, 2150.0f, 70.0f);
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_ice0", 256.0f, 0, Color.white, 256.0f, 2150.0f, 80.0f);
        system.addRingBand((SectorEntityToken)a2, "misc", "rings_ice0", 256.0f, 1, Color.white, 256.0f, 2150.0f, 90.0f, "ring", "Cloud Ring");
        PlanetAPI a3 = system.addPlanet("nortia", (SectorEntityToken)star, "Nortia", "barren-bombarded", 290.0f, 80.0f, 7500.0f, 250.0f);
        a3.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "asharu"));
        a3.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        a3.getSpec().setUseReverseLightForGlow(true);
        a3.applySpecChanges();
        a3.setInteractionImage("illustrations", "hound_hangar");
        a3.setCustomDescriptionId("planet_nortia");
        SectorEntityToken salusL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(400.0f, 600.0f, 20, 30, 4.0f, 16.0f, "Salus L4 \u5c0f\u884c\u661f"));
        SectorEntityToken salusL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(400.0f, 600.0f, 20, 30, 4.0f, 16.0f, "Salus L5 \u5c0f\u884c\u661f"));
        salusL4.setCircularOrbit((SectorEntityToken)star, 290.0f, 7500.0f, 250.0f);
        salusL5.setCircularOrbit((SectorEntityToken)star, 170.0f, 7500.0f, 250.0f);
        JumpPointAPI jumpPoint2 = Global.getFactory().createJumpPoint("salus_jump", "Salus L5 \u8df3\u8dc3\u70b9");
        jumpPoint2.setCircularOrbit((SectorEntityToken)star, 170.0f, 7500.0f, 250.0f);
        jumpPoint2.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint2);
        CustomCampaignEntityAPI askonia_gate = system.addCustomEntity("askonia_gate", "Askonia \u4e4b\u95e8", "inactive_gate", null);
        askonia_gate.setCircularOrbit((SectorEntityToken)star, 50.0f, 7000.0f, 230.0f);
        PlanetAPI a4 = system.addPlanet("umbra", (SectorEntityToken)star, "Umbra", "rocky_ice", 280.0f, 150.0f, 10000.0f, 600.0f);
        a4.setCustomDescriptionId("planet_umbra");
        a4.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "asharu"));
        a4.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        a4.getSpec().setUseReverseLightForGlow(true);
        a4.applySpecChanges();
        a4.setInteractionImage("illustrations", "pirate_station");
        CustomCampaignEntityAPI station = system.addCustomEntity("diktat_cnc", "Command & Control", "station_side02", "sindrian_diktat");
        station.setCircularOrbitPointingDown(system.getEntityById("sindria"), 45.0f, 300.0f, 50.0f);
        station.setInteractionImage("illustrations", "orbital");
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)star, (StarAge)StarAge.OLD, (int)1, (int)2, (float)11750.0f, (int)4, (boolean)false);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

