/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import java.awt.Color;

public class Aztlan {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Aztlan");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI aztlan_star = system.initStar("aztlan", "star_yellow", 700.0f, 500.0f);
        system.setLightColor(new Color(255, 220, 190));
        PlanetAPI aztlan1 = system.addPlanet("xolotl", (SectorEntityToken)aztlan_star, "Xolotl", "toxic", 30.0f, 150.0f, 2200.0f, 90.0f);
        system.addRingBand((SectorEntityToken)aztlan_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 3100.0f, 70.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)aztlan_star, 150, 3100.0f, 128.0f, 60.0f, 80.0f, "asteroid_belt", "The Ciltetl");
        PlanetAPI aztlan2 = system.addPlanet("chicomoztoc", (SectorEntityToken)aztlan_star, "Chicomoztoc", "barren-desert", 60.0f, 200.0f, 4200.0f, 300.0f);
        aztlan2.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "sindria"));
        aztlan2.getSpec().setGlowColor(new Color(255, 128, 16, 255));
        aztlan2.getSpec().setUseReverseLightForGlow(true);
        aztlan2.applySpecChanges();
        aztlan2.setCustomDescriptionId("planet_chicomoztoc");
        aztlan2.setInteractionImage("illustrations", "urban03");
        system.addRingBand((SectorEntityToken)aztlan2, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 500.0f, 33.0f, "ring", null);
        CustomCampaignEntityAPI hegemonyStation = system.addCustomEntity("aztlan_starport", "Aztlan \u661f\u9645\u6e2f", "station_side00", "hegemony");
        hegemonyStation.setCircularOrbitPointingDown(system.getEntityById("chicomoztoc"), 0.0f, 350.0f, 30.0f);
        hegemonyStation.setInteractionImage("illustrations", "orbital");
        JumpPointAPI jumpPoint_aztlan = Global.getFactory().createJumpPoint("aztlan_jump_point_alpha", "Aztlan Inner System \u8df3\u8dc3\u70b9");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)aztlan_star, 0.0f, 4200.0f, 300.0f);
        jumpPoint_aztlan.setOrbit(orbit);
        jumpPoint_aztlan.setRelatedPlanet((SectorEntityToken)aztlan2);
        jumpPoint_aztlan.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint_aztlan);
        CustomCampaignEntityAPI gate = system.addCustomEntity("aztlan_gate", "Aztlan \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("aztlan"), 120.0f, 4200.0f, 300.0f);
        PlanetAPI aztlan3 = system.addPlanet("tlalocan", (SectorEntityToken)aztlan_star, "Tlalocan", "ice_giant", 130.0f, 290.0f, 7500.0f, 500.0f);
        aztlan3.getSpec().setPlanetColor(new Color(255, 210, 170, 255));
        aztlan3.getSpec().setPitch(20.0f);
        aztlan3.getSpec().setTilt(10.0f);
        aztlan3.applySpecChanges();
        system.addAsteroidBelt((SectorEntityToken)aztlan3, 50, 650.0f, 100.0f, 30.0f, 40.0f, "asteroid_belt", null);
        system.addRingBand((SectorEntityToken)aztlan3, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 630.0f, 43.0f, "ring", null);
        PlanetAPI aztlan3a = system.addPlanet("coatl", (SectorEntityToken)aztlan3, "Coatl", "barren-bombarded", 30.0f, 90.0f, 1050.0f, 25.0f);
        aztlan3a.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "barren"));
        aztlan3a.getSpec().setGlowColor(new Color(200, 225, 255, 255));
        aztlan3a.getSpec().setUseReverseLightForGlow(true);
        aztlan3a.applySpecChanges();
        aztlan3a.setCustomDescriptionId("planet_coatl");
        CustomCampaignEntityAPI coatl_station = system.addCustomEntity("coatl_station", "Coatl Bastion", "station_side02", "hegemony");
        coatl_station.setCircularOrbitPointingDown(system.getEntityById("coatl"), 45.0f, 200.0f, 20.0f);
        coatl_station.setCustomDescriptionId("station_coatl");
        coatl_station.setInteractionImage("illustrations", "hound_hangar");
        PlanetAPI aztlan3b = system.addPlanet("zorrah", (SectorEntityToken)aztlan3, "Zorrah", "rocky_ice", 30.0f, 50.0f, 1400.0f, 60.0f);
        aztlan3b.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "asharu"));
        aztlan3b.getSpec().setGlowColor(new Color(255, 205, 128, 255));
        aztlan3b.getSpec().setUseReverseLightForGlow(true);
        aztlan3b.applySpecChanges();
        aztlan3b.setCustomDescriptionId("planet_zorrah");
        CustomCampaignEntityAPI relay = system.addCustomEntity("aztlan_relay", "Aztlan \u901a\u8baf\u5668", "comm_relay", "hegemony");
        relay.setCircularOrbitPointingDown(system.getEntityById("tlalocan"), 150.0f, 1900.0f, 180.0f);
        SectorEntityToken tlalocan_L4_nebula = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("  x     xx xxxxxx  xxx   x  x    x  ", 6, 6, "terrain", "nebula", 4, 4, null));
        SectorEntityToken tlalocan_L5_nebula = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("  x    xx xxx  xx  xxxx  x x x  x   ", 6, 6, "terrain", "nebula", 4, 4, null));
        tlalocan_L5_nebula.setCircularOrbit((SectorEntityToken)aztlan_star, 70.0f, 7500.0f, 500.0f);
        tlalocan_L4_nebula.setCircularOrbit((SectorEntityToken)aztlan_star, 190.0f, 7500.0f, 500.0f);
        JumpPointAPI jumpPoint_aztlan2 = Global.getFactory().createJumpPoint("aztlan_jump_point_beta", "Aztlan Outer System \u8df3\u8dc3\u70b9");
        OrbitAPI orbit2 = Global.getFactory().createCircularOrbit((SectorEntityToken)aztlan_star, 190.0f, 7500.0f, 500.0f);
        jumpPoint_aztlan2.setOrbit(orbit2);
        jumpPoint_aztlan2.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint_aztlan2);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)aztlan_star, (StarAge)StarAge.OLD, (int)2, (int)4, (float)10000.0f, (int)3, (boolean)true);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

