/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import java.awt.Color;

public class Canaan {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Canaan");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        PlanetAPI canaan_star = system.initStar("canaan", "star_yellow", 600.0f, 150.0f);
        system.setLightColor(new Color(210, 210, 255));
        PlanetAPI khna = system.addPlanet("khna", (SectorEntityToken)canaan_star, "Khna", "barren_venuslike", 0.0f, 105.0f, 2500.0f, 120.0f);
        PlanetAPI gilead = system.addPlanet("gilead", (SectorEntityToken)canaan_star, "Gilead", "terran", 60.0f, 190.0f, 5000.0f, 250.0f);
        gilead.getSpec().setPitch(190.0f);
        gilead.getSpec().setPlanetColor(new Color(255, 245, 225, 255));
        gilead.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        gilead.getSpec().setGlowColor(new Color(250, 225, 195, 255));
        gilead.getSpec().setUseReverseLightForGlow(true);
        gilead.applySpecChanges();
        gilead.setCustomDescriptionId("planet_gilead");
        PlanetAPI og = system.addPlanet("og", (SectorEntityToken)gilead, "Og", "barren", 0.0f, 50.0f, 500.0f, 30.0f);
        og.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren03"));
        og.getSpec().setPlanetColor(new Color(235, 255, 245, 255));
        og.getSpec().setPitch(140.0f);
        og.applySpecChanges();
        CustomCampaignEntityAPI relay = system.addCustomEntity("gilead_relay", "Gilead \u901a\u8baf\u5668", "comm_relay", "luddic_church");
        relay.setCircularOrbitPointingDown((SectorEntityToken)canaan_star, 0.0f, 5000.0f, 250.0f);
        JumpPointAPI jumpPoint1 = Global.getFactory().createJumpPoint("gilead_jump", "Gilead \u8df3\u8dc3\u70b9");
        jumpPoint1.setCircularOrbit((SectorEntityToken)canaan_star, 120.0f, 5000.0f, 250.0f);
        jumpPoint1.setRelatedPlanet((SectorEntityToken)gilead);
        system.addEntity((SectorEntityToken)jumpPoint1);
        PlanetAPI gad = system.addPlanet("gad", (SectorEntityToken)canaan_star, "Gad", "gas_giant", 180.0f, 220.0f, 6500.0f, 350.0f);
        gad.getSpec().setPitch(100.0f);
        gad.getSpec().setPlanetColor(new Color(245, 255, 195, 255));
        gad.applySpecChanges();
        system.addRingBand((SectorEntityToken)gad, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 400.0f, 30.0f, null, null);
        PlanetAPI asher = system.addPlanet("asher", (SectorEntityToken)gad, "Asher", "barren-desert", 0.0f, 100.0f, 1000.0f, 40.0f);
        asher.getSpec().setTilt(190.0f);
        asher.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        asher.getSpec().setGlowColor(new Color(250, 225, 195, 255));
        asher.applySpecChanges();
        asher.setCustomDescriptionId("planet_asher");
        SectorEntityToken gadL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(450.0f, 600.0f, 25, 45, 4.0f, 12.0f, "Gad L5 \u5c0f\u884c\u661f"));
        gadL5.setCircularOrbit((SectorEntityToken)canaan_star, 120.0f, 6500.0f, 350.0f);
        CustomCampaignEntityAPI gate1 = system.addCustomEntity("canaan_gate", "Gate of Canaan", "inactive_gate", null);
        gate1.setCircularOrbit(system.getEntityById("canaan"), 240.0f, 6500.0f, 350.0f);
        SectorEntityToken gadL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(450.0f, 600.0f, 25, 45, 4.0f, 12.0f, "Gad L4 \u5c0f\u884c\u661f"));
        gadL4.setCircularOrbit((SectorEntityToken)canaan_star, 240.0f, 6500.0f, 350.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)canaan_star, (StarAge)StarAge.OLD, (int)1, (int)3, (float)10000.0f, (int)4, (boolean)true);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

