/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import java.awt.Color;

public class Duzahk {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Duzahk");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background1.jpg");
        PlanetAPI duzahk_star = system.initStar("duzahk", "star_orange", 600.0f, 500.0f);
        duzahk_star.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        duzahk_star.getSpec().setGlowColor(new Color(255, 235, 50, 128));
        duzahk_star.getSpec().setAtmosphereThickness(0.5f);
        duzahk_star.applySpecChanges();
        system.setLightColor(new Color(255, 240, 220));
        PlanetAPI duzahk1 = system.addPlanet("duzahk1", (SectorEntityToken)duzahk_star, "Aka Mainyu", "gas_giant", 0.0f, 230.0f, 1550.0f, 24.0f);
        duzahk1.getSpec().setPlanetColor(new Color(16, 16, 255, 255));
        duzahk1.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        duzahk1.getSpec().setGlowColor(new Color(235, 38, 8, 145));
        duzahk1.getSpec().setUseReverseLightForGlow(true);
        duzahk1.getSpec().setAtmosphereThickness(0.5f);
        duzahk1.getSpec().setCloudRotation(15.0f);
        duzahk1.getSpec().setAtmosphereColor(new Color(138, 118, 255, 245));
        duzahk1.getSpec().setPitch(-5.0f);
        duzahk1.getSpec().setTilt(30.0f);
        duzahk1.applySpecChanges();
        duzahk1.setCustomDescriptionId("planet_aka_mainyu");
        system.addCorona((SectorEntityToken)duzahk1, "corona_aka_mainyu", 300.0f, 5.0f, 0.0f, 1.0f);
        SectorEntityToken field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(500.0f, 2000.0f, (SectorEntityToken)duzahk_star, 1750.0f, 2250.0f, new Color(50, 20, 100, 40), 1.0f, new Color[]{new Color(50, 20, 110, 130), new Color(150, 30, 120, 150), new Color(200, 50, 130, 190), new Color(250, 70, 150, 240), new Color(200, 80, 130, 255), new Color(75, 0, 160), new Color(127, 0, 255)}));
        field.setCircularOrbit((SectorEntityToken)duzahk_star, 0.0f, 0.0f, 150.0f);
        system.addRingBand((SectorEntityToken)duzahk_star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 2420.0f, 34.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)duzahk_star, 50, 2400.0f, 100.0f, 30.0f, 40.0f, "asteroid_belt", "The Daevas");
        PlanetAPI duzahk2 = system.addPlanet("duzahk2", (SectorEntityToken)duzahk_star, "Druj", "barren", 130.0f, 60.0f, 4200.0f, 135.0f);
        duzahk2.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        duzahk2.getSpec().setGlowColor(new Color(20, 255, 48, 125));
        duzahk2.getSpec().setUseReverseLightForGlow(true);
        duzahk2.applySpecChanges();
        duzahk2.setCustomDescriptionId("planet_druj");
        CustomCampaignEntityAPI druj_relay = system.addCustomEntity("druj_relay", "Druj \u901a\u8baf\u5668", "comm_relay", "pirates");
        druj_relay.setCircularOrbitPointingDown((SectorEntityToken)duzahk_star, 70.0f, 4200.0f, 135.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)duzahk_star, (StarAge)StarAge.AVERAGE, (int)1, (int)3, (float)7000.0f, (int)2, (boolean)false);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

