/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class Eos {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Eos Exodus");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background6.jpg");
        SectorEntityToken eos_nebula = Misc.addNebulaFromPNG((String)"data/campaign/terrain/eos_nebula.png", (float)0.0f, (float)0.0f, (LocationAPI)system, (String)"terrain", (String)"nebula_amber", (int)4, (int)4, (StarAge)StarAge.OLD);
        PlanetAPI star = system.initStar("eos", "star_white", 750.0f, 500.0f);
        system.setLightColor(new Color(255, 255, 255));
        PlanetAPI eos1 = system.addPlanet("phaosphoros", (SectorEntityToken)star, "Phaosphoros", "gas_giant", 240.0f, 300.0f, 2300.0f, 40.0f);
        eos1.getSpec().setAtmosphereColor(new Color(255, 245, 200, 220));
        eos1.getSpec().setPlanetColor(new Color(245, 250, 255, 255));
        eos1.applySpecChanges();
        eos1.setCustomDescriptionId("hot_gas_giant");
        eos1.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        eos1.getSpec().setGlowColor(new Color(245, 50, 20, 100));
        eos1.getSpec().setUseReverseLightForGlow(true);
        eos1.getSpec().setAtmosphereThickness(0.5f);
        eos1.getSpec().setCloudRotation(10.0f);
        eos1.getSpec().setPitch(20.0f);
        eos1.getSpec().setAtmosphereThicknessMin(80.0f);
        eos1.getSpec().setAtmosphereThickness(0.3f);
        eos1.getSpec().setAtmosphereColor(new Color(255, 150, 50, 205));
        PlanetAPI eos1a = system.addPlanet("lucifer", (SectorEntityToken)eos1, "Lucifer", "lava", 0.0f, 60.0f, 650.0f, 18.0f);
        system.addAsteroidBelt((SectorEntityToken)eos1, 30, 500.0f, 100.0f, 15.0f, 25.0f, "asteroid_belt", null);
        SectorEntityToken phaosphorosL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(300.0f, 500.0f, 10, 15, 4.0f, 12.0f, "Cherubim \u5c0f\u884c\u661f"));
        SectorEntityToken phaosphorosL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(300.0f, 500.0f, 10, 15, 4.0f, 12.0f, "Seraphim \u5c0f\u884c\u661f"));
        phaosphorosL4.setCircularOrbit((SectorEntityToken)star, 300.0f, 2300.0f, 40.0f);
        phaosphorosL5.setCircularOrbit((SectorEntityToken)star, 180.0f, 2300.0f, 40.0f);
        PlanetAPI eos2 = system.addPlanet("tartessus", (SectorEntityToken)star, "Tartessus", "arid", 200.0f, 180.0f, 4400.0f, 120.0f);
        eos2.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "sindria"));
        eos2.getSpec().setGlowColor(new Color(245, 255, 250, 255));
        eos2.getSpec().setUseReverseLightForGlow(true);
        eos2.applySpecChanges();
        eos2.setCustomDescriptionId("planet_tartessus");
        system.addRingBand((SectorEntityToken)eos2, "misc", "rings_special0", 256.0f, 1, new Color(225, 215, 255, 200), 128.0f, 380.0f, 30.0f, "ring", "The Grace of Tartessus");
        JumpPointAPI eos2JumpPoint = Global.getFactory().createJumpPoint("paladins_bridge", "Paladins' Bridge");
        eos2JumpPoint.setCircularOrbit(system.getEntityById("eos"), 140.0f, 4400.0f, 120.0f);
        eos2JumpPoint.setRelatedPlanet((SectorEntityToken)eos2);
        eos2JumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)eos2JumpPoint);
        PlanetAPI eos2a = system.addPlanet("baetis", (SectorEntityToken)star, "Baetis", "barren-bombarded", 260.0f, 60.0f, 4400.0f, 120.0f);
        eos2a.setCustomDescriptionId("planet_baetis");
        eos2a.getSpec().setAtmosphereThicknessMin(20.0f);
        eos2a.getSpec().setAtmosphereThickness(0.06f);
        eos2a.getSpec().setAtmosphereColor(new Color(250, 220, 120, 128));
        eos2a.applySpecChanges();
        system.addRingBand((SectorEntityToken)star, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 5980.0f, 205.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)star, 150, 6000.0f, 250.0f, 150.0f, 250.0f, "asteroid_belt", "The Pilgrims");
        PlanetAPI eos3 = system.addPlanet("hesperus", (SectorEntityToken)star, "Hesperus", "rocky_ice", 0.0f, 150.0f, 7400.0f, 200.0f);
        eos3.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "sindria"));
        eos3.getSpec().setGlowColor(new Color(245, 255, 250, 255));
        eos3.getSpec().setUseReverseLightForGlow(true);
        eos3.applySpecChanges();
        eos3.setCustomDescriptionId("planet_hesperus");
        PlanetAPI eos3a = system.addPlanet("ceyx", (SectorEntityToken)eos3, "Ceyx", "barren-bombarded", 0.0f, 35.0f, 440.0f, 16.0f);
        eos3a.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "barren"));
        eos3a.getSpec().setGlowColor(new Color(200, 230, 255, 200));
        eos3a.getSpec().setUseReverseLightForGlow(true);
        eos3a.applySpecChanges();
        eos3a.setCustomDescriptionId("planet_ceyx");
        PlanetAPI eos3b = system.addPlanet("daedaleon", (SectorEntityToken)eos3, "Daedaleon", "irradiated", 0.0f, 50.0f, 620.0f, 33.0f);
        eos3b.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        eos3b.getSpec().setGlowColor(new Color(255, 55, 250, 200));
        eos3b.getSpec().setUseReverseLightForGlow(true);
        eos3b.applySpecChanges();
        eos3b.setCustomDescriptionId("planet_daedaleon");
        SectorEntityToken eos3b_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(200.0f, 160.0f, (SectorEntityToken)eos3b, 60.0f, 260.0f, new Color(50, 20, 100, 50), 0.25f, new Color[]{new Color(90, 180, 140), new Color(130, 145, 190), new Color(165, 110, 225), new Color(95, 55, 240), new Color(45, 0, 250), new Color(20, 0, 240), new Color(10, 0, 150)}));
        eos3b_field.setCircularOrbit((SectorEntityToken)eos3b, 0.0f, 0.0f, 100.0f);
        CustomCampaignEntityAPI beacon = system.addCustomEntity(null, null, "warning_beacon", "neutral");
        beacon.setCircularOrbitPointingDown((SectorEntityToken)eos3, 0.0f, 750.0f, 33.0f);
        beacon.getMemoryWithoutUpdate().set("$daedaleon", (Object)true);
        CustomCampaignEntityAPI relay = system.addCustomEntity("hesperus_relay", "Hesperus \u901a\u8baf\u5668", "comm_relay", "luddic_church");
        relay.setCircularOrbitPointingDown(system.getEntityById("hesperus"), 90.0f, 1000.0f, 45.0f);
        CustomCampaignEntityAPI gate = system.addCustomEntity("eos_exodus_gate", "Eos Exodus \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("eos"), 210.0f, 7400.0f, 200.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)star, (StarAge)StarAge.AVERAGE, (int)1, (int)3, (float)10000.0f, (int)3, (boolean)true);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

