/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.DefenderDataOverride;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class Galatia {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Galatia");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background5.jpg");
        PlanetAPI star = system.initStar("galatia", "star_yellow", 600.0f, 700.0f, 10.0f, 0.5f, 3.0f);
        system.setLightColor(new Color(255, 220, 190));
        PlanetAPI ancyra = system.addPlanet("ancyra", (SectorEntityToken)star, "Ancyra", "arid", 55.0f, 150.0f, 2800.0f, 170.0f);
        ancyra.setFaction("hegemony");
        ancyra.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "asharu"));
        ancyra.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        ancyra.getSpec().setUseReverseLightForGlow(true);
        ancyra.applySpecChanges();
        ancyra.setCustomDescriptionId("planet_ancyra");
        CustomCampaignEntityAPI ancyraStation = system.addCustomEntity("ancyra_station", "Ancyra \u7814\u7a76\u8bbe\u65bd", "station_side00", "hegemony");
        ancyraStation.setCircularOrbitPointingDown((SectorEntityToken)ancyra, 300.0f, 350.0f, 30.0f);
        ancyraStation.setInteractionImage("illustrations", "orbital");
        ancyraStation.setCustomDescriptionId("station_ancyra");
        MarketAPI market = Global.getFactory().createMarket("ancyra_market", ancyra.getName(), 0);
        market.setSize(5);
        market.setFactionId("hegemony");
        market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        market.setPrimaryEntity((SectorEntityToken)ancyra);
        market.getConnectedEntities().add(ancyraStation);
        market.setFactionId(ancyraStation.getFaction().getId());
        market.addCondition("arid");
        market.addCondition("hot");
        market.addCondition("habitable");
        market.addCondition("population_5");
        market.addCondition("orbital_station");
        market.addCondition("light_industrial_complex");
        market.addSubmarket("open_market");
        market.addSubmarket("black_market");
        market.addSubmarket("storage");
        ancyraStation.setMarket(market);
        ancyra.setMarket(market);
        CustomCampaignEntityAPI relay = system.addCustomEntity("ancyra_relay", "Ancyra \u901a\u8baf\u5668", "comm_relay", "hegemony");
        relay.setCircularOrbitPointingDown((SectorEntityToken)star, ancyra.getCircularOrbitAngle() - 60.0f, ancyra.getCircularOrbitRadius(), ancyra.getCircularOrbitPeriod());
        relay.getMemoryWithoutUpdate().set("$commRelayNonFunctional", (Object)true);
        PlanetAPI pontus = system.addPlanet("pontus", (SectorEntityToken)star, "Pontus", "gas_giant", 200.0f, 300.0f, 6200.0f, 400.0f);
        SectorEntityToken probe = DerelictThemeGenerator.addSalvageEntity((LocationAPI)system, (String)"derelict_probe", (String)"derelict");
        probe.setId("galatia_probe");
        probe.setCircularOrbit((SectorEntityToken)star, 200.0f, 10500.0f, 400.0f);
        Misc.setDefenderOverride((SectorEntityToken)probe, (DefenderDataOverride)new DefenderDataOverride("derelict", 1.0f, 2.0f, 2.0f));
        CargoAPI extraProbeSalvage = Global.getFactory().createCargo(true);
        extraProbeSalvage.addCommodity("gamma_core", 1.0f);
        BaseSalvageSpecial.setExtraSalvage((CargoAPI)extraProbeSalvage, (MemoryAPI)probe.getMemoryWithoutUpdate(), (float)-1.0f);
        system.addRingBand((SectorEntityToken)pontus, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 650.0f, 45.0f, "ring", null);
        system.addRingBand((SectorEntityToken)pontus, "misc", "rings_ice0", 256.0f, 3, Color.white, 256.0f, 800.0f, 50.0f, "ring", null);
        float beltOrbitRadius = 8000.0f;
        system.addAsteroidBelt((SectorEntityToken)star, 150, beltOrbitRadius, 500.0f, 150.0f, 300.0f, "asteroid_belt", null);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, beltOrbitRadius - 50.0f, 305.0f, null, null);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_asteroids0", 256.0f, 3, Color.white, 256.0f, beltOrbitRadius + 50.0f, 295.0f, null, null);
        PlanetAPI tetra = system.addPlanet("tetra", (SectorEntityToken)star, "Tetra", "barren", 315.0f, 70.0f, beltOrbitRadius + 1000.0f, 310.0f);
        this.addDerelict(system, (SectorEntityToken)tetra, "wolf_Assault", ShipRecoverySpecial.ShipCondition.BATTERED, 200.0f, true);
        this.addDerelict(system, (SectorEntityToken)tetra, "lasher_CS", ShipRecoverySpecial.ShipCondition.BATTERED, 270.0f, false);
        this.addDerelict(system, (SectorEntityToken)tetra, "kite_Standard", ShipRecoverySpecial.ShipCondition.AVERAGE, 300.0f, true);
        this.addDerelict(system, (SectorEntityToken)tetra, "kite_Standard", ShipRecoverySpecial.ShipCondition.BATTERED, 350.0f, false);
        this.addDerelict(system, (SectorEntityToken)tetra, "tarsus_d_Standard", ShipRecoverySpecial.ShipCondition.BATTERED, 375.0f, false);
        this.addDerelict(system, (SectorEntityToken)tetra, "buffalo2_FS", ShipRecoverySpecial.ShipCondition.BATTERED, 400.0f, false);
        this.addDerelict(system, (SectorEntityToken)tetra, "hammerhead_Balanced", ShipRecoverySpecial.ShipCondition.AVERAGE, 450.0f, true);
        this.addDerelict(system, (SectorEntityToken)tetra, "condor_Support", ShipRecoverySpecial.ShipCondition.BATTERED, 500.0f, true);
        CustomCampaignEntityAPI derinkuyuStation = system.addCustomEntity("derinkuyu_station", "Derinkuyu Mining \u7a7a\u95f4\u7ad9", "station_mining00", "pirates");
        derinkuyuStation.setCircularOrbitWithSpin((SectorEntityToken)star, 135.0f, beltOrbitRadius - 100.0f, 300.0f, 3.0f, 5.0f);
        derinkuyuStation.setInteractionImage("illustrations", "orbital");
        market = Global.getFactory().createMarket("derinkuyu_market", derinkuyuStation.getName(), 0);
        market.setSize(4);
        market.setFactionId("pirates");
        market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        market.setPrimaryEntity((SectorEntityToken)derinkuyuStation);
        market.setFactionId(derinkuyuStation.getFaction().getId());
        market.addCondition("population_4");
        market.addCondition("orbital_station");
        market.addCondition("ore_complex");
        market.addCondition("ore_complex");
        market.addCondition("free_market");
        market.addSubmarket("open_market");
        market.addSubmarket("black_market");
        market.addSubmarket("storage");
        derinkuyuStation.setMarket(market);
        CustomCampaignEntityAPI gate = system.addCustomEntity("galatia_gate", "Galatia \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit((SectorEntityToken)star, 120.0f, 4200.0f, 400.0f);
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(500.0f, 1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.baseSalvageXP = 250L;
        SectorEntityToken debrisNextToBelt = Misc.addDebrisField((LocationAPI)system, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, (Random)StarSystemGenerator.random);
        debrisNextToBelt.setSensorProfile(null);
        debrisNextToBelt.setDiscoverable(null);
        debrisNextToBelt.setCircularOrbit((SectorEntityToken)star, 210.0f, beltOrbitRadius - 500.0f, 320.0f);
        debrisNextToBelt.setId("galatia_debrisNextToBelt");
        params = new DebrisFieldTerrainPlugin.DebrisFieldParams(500.0f, 1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.baseSalvageXP = 250L;
        SectorEntityToken debrisNextToGate = Misc.addDebrisField((LocationAPI)system, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, (Random)StarSystemGenerator.random);
        debrisNextToGate.setSensorProfile(null);
        debrisNextToGate.setDiscoverable(null);
        debrisNextToGate.setCircularOrbit((SectorEntityToken)gate, 0.0f, 0.0f, 100.0f);
        debrisNextToGate.setId("galatia_debrisNextToGate");
        JumpPointAPI inner = Global.getFactory().createJumpPoint("galatia_jump_point_alpha", "Inner System \u8df3\u8dc3\u70b9");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)star, pontus.getCircularOrbitAngle() + 180.0f, pontus.getCircularOrbitRadius() + 1000.0f, pontus.getCircularOrbitPeriod());
        inner.setOrbit(orbit);
        inner.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)inner);
        JumpPointAPI fringe = Global.getFactory().createJumpPoint("galatia_jump_point_fringe", "Fringe \u8df3\u8dc3\u70b9");
        orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)star, 160.0f, 11200.0f, 600.0f);
        fringe.setOrbit(orbit);
        fringe.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)fringe);
        inner.getMemoryWithoutUpdate().set("$unstable", (Object)true);
        fringe.getMemoryWithoutUpdate().set("$unstable", (Object)true);
        SectorEntityToken pontus_L4_nebula = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("  x     xx xxxxxx  xxx   x  x    x  ", 6, 6, "terrain", "nebula_blue", 4, 4, null));
        pontus_L4_nebula.setId("pontus_L4");
        SectorEntityToken pontus_L5_nebula = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("  x    xx xxx  xx  xxxx  x x x  x   ", 6, 6, "terrain", "nebula_blue", 4, 4, null));
        pontus_L5_nebula.setId("pontus_L5");
        pontus_L4_nebula.setCircularOrbit((SectorEntityToken)star, 260.0f, 7800.0f, 500.0f);
        pontus_L5_nebula.setCircularOrbit((SectorEntityToken)star, 140.0f, 7800.0f, 500.0f);
        params = new DebrisFieldTerrainPlugin.DebrisFieldParams(350.0f, 1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.baseSalvageXP = 250L;
        SectorEntityToken debris = Misc.addDebrisField((LocationAPI)system, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, (Random)StarSystemGenerator.random);
        debris.setId("debris_tutorial");
        CargoAPI extraSalvage = Global.getFactory().createCargo(true);
        extraSalvage.addSupplies(20.0f);
        extraSalvage.addCommodity("heavy_machinery", 10.0f);
        BaseSalvageSpecial.setExtraSalvage((CargoAPI)extraSalvage, (MemoryAPI)debris.getMemoryWithoutUpdate(), (float)-1.0f);
        debris.setSensorProfile(null);
        debris.setDiscoverable(null);
        debris.getLocation().set(1000.0f, -12000.0f);
        system.autogenerateHyperspaceJumpPoints(true, false);
        system.setEnteredByPlayer(true);
        Misc.setAllPlanetsSurveyed((StarSystemAPI)system);
    }

    protected void addDerelict(StarSystemAPI system, SectorEntityToken focus, String variantId, ShipRecoverySpecial.ShipCondition condition, float orbitRadius, boolean recoverable) {
        DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(new ShipRecoverySpecial.PerShipData(variantId, condition), false);
        SectorEntityToken ship = BaseThemeGenerator.addSalvageEntity((LocationAPI)system, (String)"wreck", (String)"neutral", (Object)params);
        ship.setDiscoverable(Boolean.valueOf(true));
        float orbitDays = orbitRadius / (10.0f + (float)Math.random() * 5.0f);
        ship.setCircularOrbit(focus, (float)Math.random() * 360.0f, orbitRadius, orbitDays);
        if (recoverable) {
            SalvageSpecialAssigner.ShipRecoverySpecialCreator creator = new SalvageSpecialAssigner.ShipRecoverySpecialCreator(null, 0, 0, false, null, null);
            Misc.setSalvageSpecial((SectorEntityToken)ship, (Object)creator.createSpecial(ship, null));
        }
    }
}

