/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class Hybrasil {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Hybrasil");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background5.jpg");
        SectorEntityToken hybrasil_nebula = Misc.addNebulaFromPNG((String)"data/campaign/terrain/hybrasil_nebula.png", (float)0.0f, (float)0.0f, (LocationAPI)system, (String)"terrain", (String)"nebula_blue", (int)4, (int)4, (StarAge)StarAge.YOUNG);
        PlanetAPI hybrasil_star = system.initStar("hybrasil", "star_white", 600.0f, 500.0f);
        system.setLightColor(new Color(245, 250, 255));
        PlanetAPI hybrasil1 = system.addPlanet("culann", (SectorEntityToken)hybrasil_star, "Culann", "barren", 10.0f, 110.0f, 2150.0f, 110.0f);
        hybrasil1.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "castiron"));
        hybrasil1.getSpec().setPlanetColor(new Color(220, 235, 245, 255));
        hybrasil1.setCustomDescriptionId("planet_culann");
        hybrasil1.applySpecChanges();
        CustomCampaignEntityAPI culannStation = system.addCustomEntity("culann_starforge", "Culann Starforge", "station_side07", "tritachyon");
        culannStation.setCircularOrbitPointingDown(system.getEntityById("culann"), 0.0f, 250.0f, 30.0f);
        culannStation.setInteractionImage("illustrations", "orbital");
        culannStation.setCustomDescriptionId("station_culann");
        PlanetAPI hybrasil2 = system.addPlanet("elada", (SectorEntityToken)hybrasil_star, "Elada", "gas_giant", 20.0f, 400.0f, 4750.0f, 220.0f);
        hybrasil2.getSpec().setPlanetColor(new Color(200, 255, 245, 255));
        hybrasil2.getSpec().setAtmosphereColor(new Color(220, 250, 240, 150));
        hybrasil2.getSpec().setCloudColor(new Color(220, 250, 240, 200));
        hybrasil2.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        hybrasil2.getSpec().setGlowColor(new Color(0, 255, 205, 62));
        hybrasil2.getSpec().setUseReverseLightForGlow(true);
        hybrasil2.getSpec().setIconColor(new Color(250, 225, 205, 255));
        hybrasil2.applySpecChanges();
        system.addRingBand((SectorEntityToken)hybrasil2, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 875.0f, 33.0f, "ring", null);
        system.addRingBand((SectorEntityToken)hybrasil2, "misc", "rings_dust0", 256.0f, 4, Color.white, 256.0f, 1050.0f, 33.0f, "ring", null);
        PlanetAPI hybrasil2a = system.addPlanet("eochu_bres", (SectorEntityToken)hybrasil2, "Eochu Bres", "tundra", 30.0f, 140.0f, 1550.0f, 40.0f);
        hybrasil2a.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        hybrasil2a.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        hybrasil2a.getSpec().setUseReverseLightForGlow(true);
        hybrasil2a.applySpecChanges();
        hybrasil2a.setCustomDescriptionId("planet_eochu_bres");
        hybrasil2a.setInteractionImage("illustrations", "eochu_bres");
        CustomCampaignEntityAPI eochu_bres_mirror1 = system.addCustomEntity("eochu_bres_mirror1", "Eochu Bres \u6052\u661f\u955c", "stellar_mirror", "tritachyon");
        eochu_bres_mirror1.setCircularOrbitPointingDown(system.getEntityById("eochu_bres"), 0.0f, 220.0f, 40.0f);
        eochu_bres_mirror1.setCustomDescriptionId("stellar_mirror");
        CustomCampaignEntityAPI eochu_bres_mirror2 = system.addCustomEntity("eochu_bres_mirror2", "Eochu Bres \u6052\u661f\u955c", "stellar_mirror", "tritachyon");
        eochu_bres_mirror2.setCircularOrbitPointingDown(system.getEntityById("eochu_bres"), 120.0f, 220.0f, 40.0f);
        eochu_bres_mirror2.setCustomDescriptionId("stellar_mirror");
        CustomCampaignEntityAPI eochu_bres_mirror3 = system.addCustomEntity("eochu_bres_mirror3", "Eochu Bres \u6052\u661f\u955c", "stellar_mirror", "tritachyon");
        eochu_bres_mirror3.setCircularOrbitPointingDown(system.getEntityById("eochu_bres"), 240.0f, 220.0f, 40.0f);
        eochu_bres_mirror3.setCustomDescriptionId("stellar_mirror");
        PlanetAPI hybrasil2b = system.addPlanet("ogma", (SectorEntityToken)hybrasil2, "Ogma", "rocky_metallic", 40.0f, 100.0f, 2050.0f, 56.0f);
        CustomCampaignEntityAPI relay = system.addCustomEntity("elada_relay", "Elada \u901a\u8baf\u5668", "comm_relay", "tritachyon");
        relay.setCircularOrbitPointingDown(system.getEntityById("hybrasil"), 320.0f, 4750.0f, 220.0f);
        PlanetAPI hybrasil3 = system.addPlanet("crom_cruach", (SectorEntityToken)hybrasil_star, "Crom Cruach", "barren-bombarded", 50.0f, 180.0f, 7300.0f, 340.0f);
        hybrasil3.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren03"));
        hybrasil3.getSpec().setPlanetColor(new Color(185, 240, 255, 255));
        hybrasil3.applySpecChanges();
        hybrasil3.setCustomDescriptionId("planet_crom_cruach");
        Misc.initConditionMarket((PlanetAPI)hybrasil3);
        hybrasil3.getMarket().addCondition("decivilized");
        hybrasil3.getMarket().addCondition("ruins_scattered");
        hybrasil3.getMarket().getFirstCondition("ruins_scattered").setSurveyed(true);
        hybrasil3.getMarket().addCondition("ore_moderate");
        hybrasil3.getMarket().addCondition("rare_ore_moderate");
        hybrasil3.getMarket().addCondition("hot");
        hybrasil3.getMarket().addCondition("thin_atmosphere");
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("hybrasil_inner_jump", "Hybrasil Inner \u661f\u7cfb\u8df3\u8dc3\u70b9");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)hybrasil3, 0.0f, 1500.0f, 65.0f);
        jumpPoint.setOrbit(orbit);
        jumpPoint.setRelatedPlanet((SectorEntityToken)hybrasil3);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        PlanetAPI hybrasil4 = system.addPlanet("balar", (SectorEntityToken)hybrasil_star, "Balar", "ice_giant", 60.0f, 340.0f, 11500.0f, 820.0f);
        hybrasil4.getSpec().setPlanetColor(new Color(255, 245, 215, 255));
        hybrasil4.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        hybrasil4.getSpec().setGlowColor(new Color(0, 255, 205, 64));
        hybrasil4.getSpec().setUseReverseLightForGlow(true);
        hybrasil4.applySpecChanges();
        hybrasil4.setCustomDescriptionId("planet_balar");
        system.addRingBand((SectorEntityToken)hybrasil4, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 650.0f, 21.0f, "ring", null);
        SectorEntityToken hybrasil4_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(hybrasil4.getRadius() + 150.0f, (hybrasil4.getRadius() + 150.0f) / 2.0f, (SectorEntityToken)hybrasil4, hybrasil4.getRadius() + 50.0f, hybrasil4.getRadius() + 50.0f + 200.0f, new Color(50, 20, 100, 50), 0.5f, new Color[]{new Color(90, 180, 40), new Color(130, 145, 90), new Color(165, 110, 145), new Color(95, 55, 160), new Color(45, 0, 130), new Color(20, 0, 130), new Color(10, 0, 150)}));
        hybrasil4_field.setCircularOrbit((SectorEntityToken)hybrasil4, 0.0f, 0.0f, 100.0f);
        PlanetAPI hybrasil4a = system.addPlanet("ena", (SectorEntityToken)hybrasil4, "Ena", "rocky_ice", 0.0f, 70.0f, 900.0f, 15.0f);
        hybrasil4a.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        hybrasil4a.getSpec().setGlowColor(new Color(0, 255, 205, 64));
        hybrasil4a.getSpec().setUseReverseLightForGlow(true);
        hybrasil4a.applySpecChanges();
        hybrasil4a.setCustomDescriptionId("planet_ena");
        PlanetAPI hybrasil4b = system.addPlanet("cethlenn", (SectorEntityToken)hybrasil4, "Cethlenn", "cryovolcanic", 70.0f, 120.0f, 1300.0f, 30.0f);
        hybrasil4b.setCustomDescriptionId("planet_cethlenn");
        PlanetAPI hybrasil4c = system.addPlanet("birog", (SectorEntityToken)hybrasil4, "Birog", "frozen", 140.0f, 80.0f, 1580.0f, 60.0f);
        hybrasil4c.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "frozen00"));
        hybrasil4c.applySpecChanges();
        PlanetAPI hybrasil4d = system.addPlanet("cian", (SectorEntityToken)hybrasil4, "Cian", "barren-bombarded", 210.0f, 50.0f, 1800.0f, 90.0f);
        hybrasil4d.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren02"));
        hybrasil4d.applySpecChanges();
        SectorEntityToken balar_L4_nebula = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("           x   xxxx    xxx      xx  xx    xxxxx     xxxxx x    xxxx   x  xxxxx    xxxxxxx     xxx   ", 10, 10, "terrain", "nebula_blue", 4, 4, null));
        balar_L4_nebula.setCircularOrbit((SectorEntityToken)hybrasil_star, 120.0f, 11500.0f, 820.0f);
        SectorEntityToken balar_L5_nebula = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("           x   xxxx    xxx      xx  xx    xxxxx     xxxxx x    xxxx   x  xxxxx    xxxxxxx     xxx   ", 10, 10, "terrain", "nebula_blue", 4, 4, null));
        balar_L5_nebula.setCircularOrbit((SectorEntityToken)hybrasil_star, 0.0f, 11500.0f, 820.0f);
        PlanetAPI hybrasil5 = system.addPlanet("donn", (SectorEntityToken)hybrasil_star, "Donn", "barren", 180.0f, 140.0f, 13050.0f, 800.0f);
        hybrasil5.setCustomDescriptionId("planet_donn");
        hybrasil5.setInteractionImage("illustrations", "pirate_station");
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

