/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import java.awt.Color;

public class Isirah {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Isirah");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI isirah_star = system.initStar("isirah", "star_blue_giant", 1100.0f, 650.0f);
        system.setLightColor(new Color(210, 230, 255));
        PlanetAPI isirah_b = system.addPlanet("sutr", (SectorEntityToken)isirah_star, "Surtr", "lava", 180.0f, 190.0f, 2000.0f, 50.0f);
        SectorEntityToken isirah_b_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(200.0f, 380.0f, (SectorEntityToken)isirah_b, 180.0f, 580.0f, new Color(100, 30, 50, 30), 1.0f, new Color[]{new Color(165, 35, 135, 130), new Color(200, 30, 115, 150), new Color(220, 25, 100, 190), new Color(235, 25, 90, 240), new Color(240, 35, 80, 255), new Color(240, 65, 60), new Color(240, 90, 45)}));
        isirah_b_field.setCircularOrbit((SectorEntityToken)isirah_b, 0.0f, 0.0f, 100.0f);
        PlanetAPI isirah_c = system.addPlanet("gilling", (SectorEntityToken)isirah_star, "Gilling", "lava", 270.0f, 100.0f, 2750.0f, 80.0f);
        PlanetAPI isirah_c1 = system.addPlanet("fjalar", (SectorEntityToken)isirah_c, "Fjalar", "lava_minor", 270.0f, 40.0f, 200.0f, 20.0f);
        PlanetAPI isirah_c2 = system.addPlanet("galar", (SectorEntityToken)isirah_c, "Galar", "barren", 270.0f, 30.0f, 280.0f, 37.0f);
        JumpPointAPI jumpPoint2 = Global.getFactory().createJumpPoint("isirah_jump", "Isirah \u5185\u90e8\u8df3\u8dc3\u70b9");
        jumpPoint2.setCircularOrbit(system.getEntityById("isirah"), 180.0f, 2700.0f, 80.0f);
        jumpPoint2.setRelatedPlanet((SectorEntityToken)isirah_c);
        system.addEntity((SectorEntityToken)jumpPoint2);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 3200.0f, 80.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 3400.0f, 100.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 3300.0f, 100.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_asteroids0", 256.0f, 2, Color.white, 256.0f, 3400.0f, 100.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 3500.0f, 100.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_asteroids0", 256.0f, 3, Color.white, 256.0f, 3600.0f, 130.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 3750.0f, 80.0f);
        system.addAsteroidBelt((SectorEntityToken)isirah_star, 100, 3300.0f, 180.0f, 100.0f, 140.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)isirah_star, 140, 3500.0f, 180.0f, 120.0f, 160.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)isirah_star, 80, 3700.0f, 180.0f, 140.0f, 180.0f, "asteroid_belt", null);
        SectorEntityToken ring1 = system.addTerrain("ring", (Object)new BaseRingTerrain.RingParams(900.0f, 3500.0f, null, "Utgarda's Wall"));
        ring1.setCircularOrbit((SectorEntityToken)isirah_star, 0.0f, 0.0f, 100.0f);
        PlanetAPI isirah_d = system.addPlanet("corb", (SectorEntityToken)isirah_star, "Corb", "lava_minor", 180.0f, 90.0f, 4300.0f, 400.0f);
        SectorEntityToken isirah_d1 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(400.0f, 600.0f, 20, 30, 4.0f, 14.0f, "Corb Accretion Swarm"));
        isirah_d1.setCircularOrbit((SectorEntityToken)isirah_star, 170.0f, 4300.0f, 400.0f);
        system.addAsteroidBelt((SectorEntityToken)isirah_star, 50, 4200.0f, 150.0f, 170.0f, 210.0f, "asteroid_belt", null);
        SectorEntityToken station1 = system.addOrbitalStation("laicaille_habitat", (SectorEntityToken)isirah_star, 240.0f, 4300.0f, 400.0f, "Laicaille \u8f68\u9053\u57ce\u5e02", "persean");
        station1.setCustomDescriptionId("station_laicaille");
        station1.setInteractionImage("illustrations", "orbital");
        station1.setCircularOrbitWithSpin((SectorEntityToken)isirah_star, 240.0f, 4300.0f, 400.0f, -1.0f, -3.0f);
        CustomCampaignEntityAPI station2 = system.addCustomEntity("station_kapteyn", "Kapteyn \u661f\u9645\u5de5\u5382", "station_mining00", "pirates");
        station2.setCustomDescriptionId("station_kapteyn");
        station2.setInteractionImage("illustrations", "industrial_megafacility");
        station2.setCircularOrbitWithSpin((SectorEntityToken)isirah_star, 120.0f, 4300.0f, 400.0f, -1.0f, -3.0f);
        CustomCampaignEntityAPI gate = system.addCustomEntity("isirah_gate", "Isirah \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("isirah"), 0.0f, 4300.0f, 160.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_ice0", 256.0f, 0, Color.white, 256.0f, 4700.0f, 80.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 4800.0f, 100.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_ice0", 256.0f, 1, Color.white, 256.0f, 4900.0f, 100.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_asteroids0", 256.0f, 2, Color.white, 256.0f, 5000.0f, 100.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 5100.0f, 130.0f);
        system.addRingBand((SectorEntityToken)isirah_star, "misc", "rings_ice0", 256.0f, 1, Color.white, 256.0f, 5250.0f, 80.0f);
        system.addAsteroidBelt((SectorEntityToken)isirah_star, 100, 5300.0f, 180.0f, 100.0f, 140.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)isirah_star, 80, 5700.0f, 180.0f, 140.0f, 180.0f, "asteroid_belt", null);
        SectorEntityToken ring2 = system.addTerrain("ring", (Object)new BaseRingTerrain.RingParams(900.0f, 4900.0f, null, "Disk of Vosud"));
        ring2.setCircularOrbit((SectorEntityToken)isirah_star, 0.0f, 0.0f, 100.0f);
        PlanetAPI isirah_e = system.addPlanet("norvia", (SectorEntityToken)isirah_star, "Norvia", "frozen", 270.0f, 100.0f, 7000.0f, 500.0f);
        PlanetAPI isirah_e1 = system.addPlanet("nott", (SectorEntityToken)isirah_e, "Nott", "frozen", 180.0f, 40.0f, 240.0f, 60.0f);
        isirah_e1.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "frozen00"));
        isirah_e1.applySpecChanges();
        SectorEntityToken station3 = system.addOrbitalStation("groombridge_habitat", (SectorEntityToken)isirah_star, 330.0f, 7000.0f, 500.0f, "Groombridge \u8f68\u9053\u57ce\u5e02", "neutral");
        station3.setCustomDescriptionId("station_groombridge");
        station3.setInteractionImage("illustrations", "abandoned_station3");
        station3.setCircularOrbitPointingDown((SectorEntityToken)isirah_star, 330.0f, 7000.0f, 500.0f);
        system.autogenerateHyperspaceJumpPoints(true, true);
        StarSystemGenerator.addSystemwideNebula((StarSystemAPI)system, (StarAge)StarAge.YOUNG);
    }
}

