/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class KumariKandam {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Kumari Kandam");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background6.jpg");
        PlanetAPI kumarikandam_star = system.initStar("kumarikandam", "star_red_dwarf", 450.0f, 400.0f);
        system.setLightColor(new Color(210, 230, 255));
        PlanetAPI kumarikandam_b = system.addPlanet("kumari_aru", (SectorEntityToken)kumarikandam_star, "Kumari Aru", "gas_giant", 270.0f, 300.0f, 2800.0f, 80.0f);
        kumarikandam_b.getSpec().setPlanetColor(new Color(150, 235, 245, 255));
        kumarikandam_b.getSpec().setAtmosphereColor(new Color(150, 170, 240, 150));
        kumarikandam_b.getSpec().setCloudColor(new Color(180, 250, 240, 200));
        kumarikandam_b.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        kumarikandam_b.getSpec().setGlowColor(new Color(250, 50, 105, 100));
        kumarikandam_b.getSpec().setUseReverseLightForGlow(true);
        kumarikandam_b.getSpec().setIconColor(new Color(180, 255, 225, 255));
        kumarikandam_b.applySpecChanges();
        kumarikandam_b.setCustomDescriptionId("planet_kumari_aru");
        CustomCampaignEntityAPI beholder_station = system.addCustomEntity("beholder_station", "\u89c2\u5bdf\u7ad9", "station_side05", "luddic_church");
        beholder_station.setCircularOrbitPointingDown(system.getEntityById("kumari_aru"), 270.0f, 430.0f, 30.0f);
        beholder_station.setCustomDescriptionId("station_beholder");
        beholder_station.setInteractionImage("illustrations", "luddic_shrine");
        beholder_station.addTag("luddicShrine");
        PlanetAPI kumarikandam_b1 = system.addPlanet("makal", (SectorEntityToken)kumarikandam_b, "Makal", "barren", 270.0f, 60.0f, 520.0f, 40.0f);
        kumarikandam_b1.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren02"));
        kumarikandam_b1.getSpec().setPlanetColor(new Color(255, 235, 150, 255));
        kumarikandam_b1.applySpecChanges();
        PlanetAPI kumarikandam_b2 = system.addPlanet("kulantai", (SectorEntityToken)kumarikandam_b, "Kulantai", "barren-bombarded", 270.0f, 40.0f, 650.0f, 35.0f);
        SectorEntityToken kumari_aruL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(300.0f, 500.0f, 16, 24, 4.0f, 16.0f, "Kumari Aru L4 \u5c0f\u884c\u661f"));
        SectorEntityToken kumari_aruL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(300.0f, 500.0f, 16, 24, 4.0f, 16.0f, "Kumari Aru L5 \u5c0f\u884c\u661f"));
        kumari_aruL4.setCircularOrbit((SectorEntityToken)kumarikandam_star, 330.0f, 2800.0f, 80.0f);
        kumari_aruL5.setCircularOrbit((SectorEntityToken)kumarikandam_star, 210.0f, 2800.0f, 80.0f);
        PlanetAPI chalcedon = system.addPlanet("chalcedon", (SectorEntityToken)kumarikandam_star, "Chalcedon", "terran-eccentric", 220.0f, 160.0f, 4300.0f, 180.0f);
        chalcedon.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        chalcedon.getSpec().setGlowColor(new Color(170, 255, 240, 255));
        chalcedon.getSpec().setUseReverseLightForGlow(true);
        chalcedon.applySpecChanges();
        chalcedon.setCustomDescriptionId("planet_chalcedon");
        SectorEntityToken abandoned_station1 = system.addOrbitalStation("abandoned_spacedock", (SectorEntityToken)kumarikandam_star, 72.0f, 4300.0f, 180.0f, "\u5e9f\u5f03\u7684\u8239\u575e", "neutral");
        abandoned_station1.setInteractionImage("illustrations", "abandoned_station3");
        abandoned_station1.setCircularOrbitPointingDown((SectorEntityToken)kumarikandam_star, 234.0f, 4300.0f, 180.0f);
        abandoned_station1.setCustomDescriptionId("station_chalcedon");
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(200.0f, 1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.SALVAGE;
        params.baseSalvageXP = 250L;
        SectorEntityToken debris = Misc.addDebrisField((LocationAPI)system, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, (Random)StarSystemGenerator.random);
        SalvageSpecialAssigner.assignSpecialForDebrisField((SectorEntityToken)debris);
        debris.setSensorProfile(null);
        debris.setDiscoverable(null);
        debris.setCircularOrbit((SectorEntityToken)kumarikandam_star, 236.0f, 4300.0f, 180.0f);
        CustomCampaignEntityAPI gate = system.addCustomEntity("kumari_gate", "Kumarian \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit((SectorEntityToken)kumarikandam_star, 160.0f, 4300.0f, 180.0f);
        JumpPointAPI jumpPoint2 = Global.getFactory().createJumpPoint("kumarikandam_jump", "Rama's Bridge");
        jumpPoint2.setCircularOrbit(system.getEntityById("kumarikandam"), 280.0f, 4300.0f, 180.0f);
        jumpPoint2.setRelatedPlanet((SectorEntityToken)chalcedon);
        system.addEntity((SectorEntityToken)jumpPoint2);
        PlanetAPI kaykos = system.addPlanet("kaykos", (SectorEntityToken)kumarikandam_star, "Kaykos", "barren-bombarded", 180.0f, 100.0f, 5300.0f, 210.0f);
        kaykos.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren02"));
        kaykos.getSpec().setPlanetColor(new Color(255, 250, 245, 255));
        kaykos.getSpec().setPitch(-60.0f);
        kaykos.getSpec().setTilt(10.0f);
        kaykos.applySpecChanges();
        PlanetAPI crocodile = system.addPlanet("crocodile", (SectorEntityToken)kaykos, "Crocodile", "barren", 0.0f, 40.0f, 200.0f, 30.0f);
        crocodile.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren03"));
        crocodile.getSpec().setPlanetColor(new Color(225, 240, 255, 255));
        kaykos.getSpec().setPitch(-45.0f);
        kaykos.getSpec().setTilt(-20.0f);
        crocodile.applySpecChanges();
        system.addRingBand((SectorEntityToken)kumarikandam_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 5900.0f, 220.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)kumarikandam_star, 150, 5900.0f, 128.0f, 200.0f, 240.0f, "asteroid_belt", "The Mullam");
        PlanetAPI olinadu = system.addPlanet("olinadu", (SectorEntityToken)kumarikandam_star, "Olinadu", "cryovolcanic", 270.0f, 100.0f, 6800.0f, 340.0f);
        olinadu.setCustomDescriptionId("planet_olinadu");
        olinadu.setInteractionImage("illustrations", "cargo_loading");
        PlanetAPI kanni = system.addPlanet("kanni", (SectorEntityToken)kumarikandam_star, "Kanni", "barren", 180.0f, 100.0f, 8100.0f, 500.0f);
        kanni.setCustomDescriptionId("planet_kanni");
        kanni.setInteractionImage("illustrations", "mine");
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)kumarikandam_star, (StarAge)StarAge.AVERAGE, (int)1, (int)2, (float)9500.0f, (int)6, (boolean)false);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

