/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class Magec {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Magec");
        system.setType(StarSystemGenerator.StarSystemType.BINARY_FAR);
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI star = system.initStar("magec", "star_blue_giant", 900.0f, 500.0f);
        system.setLightColor(new Color(225, 245, 255));
        PlanetAPI magec1 = system.addPlanet("chaxiraxi", (SectorEntityToken)star, "Chaxiraxi", "gas_giant", 0.0f, 280.0f, 1850.0f, 40.0f);
        magec1.getSpec().setPlanetColor(new Color(50, 100, 255, 255));
        magec1.getSpec().setAtmosphereColor(new Color(120, 130, 100, 150));
        magec1.getSpec().setCloudColor(new Color(195, 230, 255, 200));
        magec1.getSpec().setIconColor(new Color(120, 130, 100, 255));
        magec1.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        magec1.getSpec().setGlowColor(new Color(235, 38, 8, 145));
        magec1.getSpec().setUseReverseLightForGlow(true);
        magec1.getSpec().setAtmosphereThickness(0.5f);
        magec1.applySpecChanges();
        magec1.setCustomDescriptionId("planet_chaxiraxi");
        SectorEntityToken magec1_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(200.0f, 380.0f, (SectorEntityToken)magec1, 280.0f, 480.0f, new Color(50, 30, 100, 30), 1.0f, new Color[]{new Color(50, 20, 110, 130), new Color(150, 30, 120, 150), new Color(200, 50, 130, 190), new Color(250, 70, 150, 240), new Color(200, 80, 130, 255), new Color(75, 0, 160), new Color(127, 0, 255)}));
        magec1_field.setCircularOrbit((SectorEntityToken)magec1, 0.0f, 0.0f, 100.0f);
        PlanetAPI magec2 = system.addPlanet("maxios", (SectorEntityToken)star, "Maxios", "barren", 230.0f, 100.0f, 2675.0f, 100.0f);
        Misc.initConditionMarket((PlanetAPI)magec2);
        magec2.getMarket().addCondition("decivilized");
        magec2.getMarket().addCondition("ruins_extensive");
        magec2.getMarket().getFirstCondition("ruins_extensive").setSurveyed(true);
        magec2.getMarket().addCondition("meteor_impacts");
        magec2.getMarket().addCondition("ore_moderate");
        magec2.getMarket().addCondition("rare_ore_sparse");
        magec2.getMarket().addCondition("hot");
        magec2.getMarket().addCondition("thin_atmosphere");
        magec2.setCustomDescriptionId("planet_maxios");
        magec2.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "asharu"));
        magec2.getSpec().setGlowColor(new Color(255, 245, 235, 255));
        magec2.getSpec().setUseReverseLightForGlow(true);
        magec2.getSpec().setAtmosphereThicknessMin(25.0f);
        magec2.getSpec().setAtmosphereThickness(0.2f);
        magec2.getSpec().setAtmosphereColor(new Color(80, 90, 100, 120));
        magec2.applySpecChanges();
        PlanetAPI magec3 = system.addPlanet("achaman", (SectorEntityToken)star, "Achaman", "star_white", 45.0f, 120.0f, 8000.0f, 1000.0f);
        system.setSecondary(magec3);
        system.addCorona((SectorEntityToken)magec3, 150.0f, 3.0f, 0.05f, 1.0f);
        CustomCampaignEntityAPI relay = system.addCustomEntity("achaman_relay", "Achaman \u901a\u8baf\u5668", "comm_relay", "tritachyon");
        relay.setCircularOrbitPointingDown(system.getEntityById("achaman"), 90.0f, 1000.0f, 45.0f);
        PlanetAPI magec3a = system.addPlanet("tibicena", (SectorEntityToken)magec3, "Tibicena", "rocky_metallic", 200.0f, 80.0f, 800.0f, 45.0f);
        CustomCampaignEntityAPI achaman_station = system.addCustomEntity("achaman_enterprise_station", "Achaman \u4f01\u4e1a\u661f\u9645\u6e2f", "station_side04", "tritachyon");
        achaman_station.setCircularOrbitPointingDown(system.getEntityById("tibicena"), 90.0f, 200.0f, 25.0f);
        achaman_station.setCustomDescriptionId("station_achaman_enterprise");
        achaman_station.setInteractionImage("illustrations", "hound_hangar");
        system.addAsteroidBelt((SectorEntityToken)star, 100, 3300.0f, 256.0f, 150.0f, 250.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)star, 100, 3700.0f, 256.0f, 150.0f, 250.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)star, 100, 4150.0f, 128.0f, 200.0f, 300.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)star, 100, 4450.0f, 188.0f, 200.0f, 300.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)star, 100, 4675.0f, 256.0f, 200.0f, 300.0f, "asteroid_belt", null);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 3200.0f, 80.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 3400.0f, 100.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 3600.0f, 130.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 3800.0f, 80.0f);
        SectorEntityToken ring = system.addTerrain("ring", (Object)new BaseRingTerrain.RingParams(856.0f, 3500.0f, null, "Guayota's Disk"));
        ring.setCircularOrbit((SectorEntityToken)star, 0.0f, 0.0f, 100.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 4000.0f, 80.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 4100.0f, 120.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 4200.0f, 160.0f);
        ring = system.addTerrain("ring", (Object)new BaseRingTerrain.RingParams(456.0f, 4100.0f, null, "Guayota's Disk"));
        ring.setCircularOrbit((SectorEntityToken)star, 0.0f, 0.0f, 100.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 4300.0f, 140.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 4400.0f, 180.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 4500.0f, 220.0f);
        ring = system.addTerrain("ring", (Object)new BaseRingTerrain.RingParams(456.0f, 4400.0f, null, "Guayota's Disk"));
        ring.setCircularOrbit((SectorEntityToken)star, 0.0f, 0.0f, 100.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_ice0", 256.0f, 0, Color.white, 256.0f, 4500.0f, 100.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 4600.0f, 140.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_ice0", 256.0f, 1, Color.white, 256.0f, 4700.0f, 160.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 4800.0f, 180.0f);
        ring = system.addTerrain("ring", (Object)new BaseRingTerrain.RingParams(556.0f, 4650.0f, null, "Guayota's Disk"));
        ring.setCircularOrbit((SectorEntityToken)star, 0.0f, 0.0f, 100.0f);
        CustomCampaignEntityAPI civilianStation = system.addCustomEntity("new_maxios", "Nova Maxios", "station_side07", "independent");
        civilianStation.setCustomDescriptionId("station_new_maxios");
        civilianStation.setInteractionImage("illustrations", "cargo_loading");
        civilianStation.setCircularOrbitWithSpin((SectorEntityToken)star, 0.0f, 3900.0f, 160.0f, 2.0f, 5.0f);
        CustomCampaignEntityAPI guayota_relay = system.addCustomEntity("guayota_relay", "Guayota \u901a\u8baf\u5668", "comm_relay", "independent");
        guayota_relay.setCircularOrbitPointingDown((SectorEntityToken)star, 30.0f, 3900.0f, 160.0f);
        CustomCampaignEntityAPI pirateStation = system.addCustomEntity("kantas_den", "Kanta's Den", "station_side06", "pirates");
        pirateStation.setCustomDescriptionId("station_kantas_den");
        pirateStation.setInteractionImage("illustrations", "pirate_station");
        pirateStation.setCircularOrbitWithSpin((SectorEntityToken)star, 220.0f, 4250.0f, 160.0f, 3.0f, 5.0f);
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("maxios_jump_point", "Maxios \u8df3\u8dc3\u70b9");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)magec2, 0.0f, 500.0f, 30.0f);
        jumpPoint.setOrbit(orbit);
        jumpPoint.setRelatedPlanet((SectorEntityToken)magec2);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)star, (StarAge)StarAge.YOUNG, (int)1, (int)2, (float)11500.0f, (int)4, (boolean)true);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

