/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class Mayasura {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Mayasura");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background5.jpg");
        PlanetAPI mayasura_star = system.initStar("mayasura", "star_yellow", 800.0f, 500.0f, 10.0f, 1.0f, 3.0f);
        system.setLightColor(new Color(255, 245, 205));
        PlanetAPI mayasura_b = system.addPlanet("kasyapa", (SectorEntityToken)mayasura_star, "Kasyapa", "barren", 0.0f, 60.0f, 1550.0f, 36.0f);
        mayasura_b.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        mayasura_b.getSpec().setGlowColor(new Color(255, 150, 50, 50));
        mayasura_b.getSpec().setUseReverseLightForGlow(true);
        mayasura_b.getSpec().setAtmosphereThicknessMin(16.0f);
        mayasura_b.getSpec().setAtmosphereThickness(0.14f);
        mayasura_b.getSpec().setAtmosphereColor(new Color(150, 125, 100, 30));
        mayasura_b.applySpecChanges();
        PlanetAPI mayasura_c = system.addPlanet("gelan", (SectorEntityToken)mayasura_star, "Gelan", "toxic", 300.0f, 200.0f, 2400.0f, 104.0f);
        mayasura_c.setCustomDescriptionId("planet_gelan");
        mayasura_c.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        mayasura_c.getSpec().setGlowColor(new Color(255, 150, 0, 255));
        mayasura_c.getSpec().setUseReverseLightForGlow(true);
        mayasura_c.getSpec().setCloudColor(new Color(255, 245, 205, 220));
        mayasura_c.applySpecChanges();
        system.addRingBand((SectorEntityToken)mayasura_c, "misc", "rings_special0", 256.0f, 0, new Color(255, 230, 100, 255), 256.0f, 420.0f, 60.0f, "ring", "Gelan's Shackle");
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("mayasura_jump", "Mayasura \u8df3\u8dc3\u70b9");
        jumpPoint.setCircularOrbit((SectorEntityToken)mayasura_star, 360.0f, 2400.0f, 104.0f);
        jumpPoint.setRelatedPlanet((SectorEntityToken)mayasura_c);
        system.addEntity((SectorEntityToken)jumpPoint);
        PlanetAPI mayasura_d = system.addPlanet("mairaath", (SectorEntityToken)mayasura_star, "Mairaath", "desert", 0.0f, 200.0f, 3800.0f, 183.0f);
        mayasura_d.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "desert01"));
        mayasura_d.getSpec().setPlanetColor(new Color(255, 210, 225, 255));
        mayasura_d.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        mayasura_d.getSpec().setGlowColor(new Color(255, 250, 200, 80));
        mayasura_d.getSpec().setUseReverseLightForGlow(true);
        mayasura_d.applySpecChanges();
        mayasura_d.setCustomDescriptionId("planet_mairaath");
        mayasura_d.setInteractionImage("illustrations", "mairaath");
        CustomCampaignEntityAPI mairaathStation1 = system.addCustomEntity("mairaath_abandoned_station1", "\u5e9f\u5f03\u7684\u751f\u6001\u7a7a\u95f4\u7ad9", "station_side06", "neutral");
        mairaathStation1.setCircularOrbitPointingDown(system.getEntityById("mairaath"), 45.0f, 350.0f, 50.0f);
        Misc.setAbandonedStationMarket((String)"mairaath_abandoned_station1_market", (SectorEntityToken)mairaathStation1);
        mairaathStation1.setCustomDescriptionId("mairaath_station1");
        mairaathStation1.setInteractionImage("illustrations", "abandoned_station3");
        CustomCampaignEntityAPI mairaath_shade = system.addCustomEntity("mairaath_shade", "Shade Chah", "stellar_shade", "neutral");
        mairaath_shade.setCircularOrbitPointingDown((SectorEntityToken)mayasura_star, 300.0f, 3550.0f, 183.0f);
        mairaath_shade.setCustomDescriptionId("stellar_shade");
        system.addAsteroidBelt((SectorEntityToken)mayasura_star, 90, 4300.0f, 200.0f, 140.0f, 180.0f, "asteroid_belt", "The Danavas");
        system.addRingBand((SectorEntityToken)mayasura_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 4360.0f, 160.0f);
        CustomCampaignEntityAPI pirateStation = system.addCustomEntity("mairaath_abandoned_station2", "\u5931\u843d\u7684\u751f\u6001\u7a7a\u95f4\u7ad9", "station_side06", "pirates");
        pirateStation.setCircularOrbitPointingDown(system.getEntityById("mayasura"), 45.0f, 4500.0f, 250.0f);
        pirateStation.setCustomDescriptionId("mairaath_station2");
        pirateStation.setInteractionImage("illustrations", "pirate_station");
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(150.0f, 1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.baseSalvageXP = 500L;
        SectorEntityToken debris = Misc.addDebrisField((LocationAPI)system, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, (Random)StarSystemGenerator.random);
        SalvageSpecialAssigner.assignSpecialForDebrisField((SectorEntityToken)debris);
        debris.setSensorProfile(null);
        debris.setDiscoverable(null);
        debris.setCircularOrbit((SectorEntityToken)mayasura_star, 55.0f, 4500.0f, 250.0f);
        CustomCampaignEntityAPI gate = system.addCustomEntity("mayasura_gate", "Mayasura \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("mayasura"), 225.0f, 4520.0f, 250.0f);
        system.addRingBand((SectorEntityToken)mayasura_star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 5100.0f, 100.0f);
        system.addAsteroidBelt((SectorEntityToken)mayasura_star, 120, 5130.0f, 300.0f, 200.0f, 300.0f, "asteroid_belt", "The Daitya");
        PlanetAPI mayasura_e = system.addPlanet("diti", (SectorEntityToken)mayasura_star, "Diti", "ice_giant", 270.0f, 240.0f, 6200.0f, 290.0f);
        mayasura_e.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        mayasura_e.getSpec().setGlowColor(new Color(255, 50, 240, 245));
        mayasura_e.getSpec().setUseReverseLightForGlow(true);
        mayasura_e.getSpec().setPitch(15.0f);
        mayasura_e.getSpec().setTilt(40.0f);
        mayasura_e.getSpec().setPlanetColor(new Color(255, 240, 235));
        mayasura_e.applySpecChanges();
        SectorEntityToken tritachStation = system.addOrbitalStation("port_tse", (SectorEntityToken)mayasura_e, 120.0f, 4750.0f, 160.0f, "Port Tse \u7279\u8bb8\u7ecf\u8425\u7ad9", "tritachyon");
        tritachStation.setCustomDescriptionId("station_tse_enterprise");
        tritachStation.setInteractionImage("illustrations", "space_bar");
        tritachStation.setCircularOrbitWithSpin((SectorEntityToken)mayasura_e, 60.0f, 510.0f, 30.0f, 3.0f, 5.0f);
        PlanetAPI mayasura_e1 = system.addPlanet("arjun", (SectorEntityToken)mayasura_e, "Arjun's World", "rocky_unstable", 0.0f, 60.0f, 510.0f, 30.0f);
        mayasura_e1.getSpec().setAtmosphereThicknessMin(16.0f);
        mayasura_e1.getSpec().setAtmosphereThickness(0.2f);
        mayasura_e1.getSpec().setAtmosphereColor(new Color(160, 175, 200, 10));
        mayasura_e1.getSpec().setPlanetColor(new Color(200, 240, 255));
        mayasura_e1.applySpecChanges();
        CustomCampaignEntityAPI mayasura_relay = system.addCustomEntity("mayasura_relay", "Mayasura \u901a\u8baf\u5668", "comm_relay", "tritachyon");
        mayasura_relay.setCircularOrbitPointingDown((SectorEntityToken)mayasura_star, 330.0f, 6200.0f, 290.0f);
        system.addAsteroidBelt((SectorEntityToken)mayasura_star, 150, 7500.0f, 400.0f, 370.0f, 430.0f, "asteroid_belt", "The Takshaka");
        system.addRingBand((SectorEntityToken)mayasura_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 7520.0f, 400.0f);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

