/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import java.awt.Color;

public class Naraka {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Naraka");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI naraka_star = system.initStar("naraka", "star_orange", 650.0f, 160.0f, 5.0f, 0.65f, 2.2f);
        system.setLightColor(new Color(255, 220, 200));
        system.addRingBand((SectorEntityToken)naraka_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 3300.0f, 220.0f, "ring", "The Yamuna");
        PlanetAPI naraka_b = system.addPlanet("yama", (SectorEntityToken)naraka_star, "Yama", "arid", 60.0f, 165.0f, 4600.0f, 140.0f);
        naraka_b.setCustomDescriptionId("planet_yama");
        PlanetAPI naraka_b1 = system.addPlanet("yami", (SectorEntityToken)naraka_b, "Yami", "barren-bombarded", 0.0f, 60.0f, 450.0f, 40.0f);
        system.addAsteroidBelt((SectorEntityToken)naraka_b, 60, 900.0f, 170.0f, 200.0f, 250.0f, "asteroid_belt", "The Servants");
        system.addRingBand((SectorEntityToken)naraka_b, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 900.0f, 220.0f);
        PlanetAPI naraka_b2 = system.addPlanet("nachiketa", (SectorEntityToken)naraka_star, "Nachiketa", "barren", 0.0f, 65.0f, 4600.0f, 140.0f);
        naraka_b2.setCustomDescriptionId("planet_nachiketa");
        naraka_b2.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        naraka_b2.getSpec().setGlowColor(new Color(255, 60, 240, 200));
        naraka_b2.getSpec().setUseReverseLightForGlow(true);
        naraka_b2.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren02"));
        naraka_b2.applySpecChanges();
        PlanetAPI naraka_c = system.addPlanet("chitagupta", (SectorEntityToken)naraka_star, "Chitagupta", "barren", 90.0f, 100.0f, 5750.0f, 380.0f);
        JumpPointAPI jumpPoint1 = Global.getFactory().createJumpPoint("naraka_jump", "Naraka \u8df3\u8dc3\u70b9");
        jumpPoint1.setCircularOrbit(system.getEntityById("naraka"), 120.0f, 4600.0f, 140.0f);
        jumpPoint1.setRelatedPlanet((SectorEntityToken)naraka_c);
        system.addEntity((SectorEntityToken)jumpPoint1);
        CustomCampaignEntityAPI relay = system.addCustomEntity("naraka_relay", "Naraka \u901a\u8baf\u5668", "comm_relay", "hegemony");
        relay.setCircularOrbitPointingDown(system.getEntityById("naraka"), 240.0f, 4600.0f, 140.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)naraka_star, (StarAge)StarAge.AVERAGE, (int)4, (int)5, (float)6500.0f, (int)3, (boolean)true);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

