/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import java.awt.Color;

public class Penelope {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Penelope's Star");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        PlanetAPI penelope_star = system.initStar("penelope", "star_red_giant", 1100.0f, 500.0f);
        system.setLightColor(new Color(255, 200, 210));
        system.addAsteroidBelt((SectorEntityToken)penelope_star, 50, 2200.0f, 100.0f, 30.0f, 40.0f, "asteroid_belt", null);
        system.addRingBand((SectorEntityToken)penelope_star, "misc", "rings_asteroids0", 256.0f, 3, Color.white, 256.0f, 13750.0f, 345.0f, "asteroid_belt", null);
        PlanetAPI penelope1 = system.addPlanet("penelope1", (SectorEntityToken)penelope_star, "Thrinakia", "lava_minor", 30.0f, 110.0f, 2850.0f, 90.0f);
        PlanetAPI penelope2 = system.addPlanet("penelope2", (SectorEntityToken)penelope_star, "Ithaca", "desert", 50.0f, 150.0f, 4500.0f, 135.0f);
        penelope2.setCustomDescriptionId("planet_ithaca");
        PlanetAPI penelope3 = system.addPlanet("penelope3", (SectorEntityToken)penelope_star, "Ogygia", "barren-bombarded", 80.0f, 130.0f, 6800.0f, 225.0f);
        penelope3.getSpec().setPlanetColor(new Color(230, 240, 255, 255));
        penelope3.applySpecChanges();
        penelope3.setCustomDescriptionId("planet_ogygia");
        PlanetAPI penelope3a = system.addPlanet("penelope3a", (SectorEntityToken)penelope3, "Calypso", "barren-bombarded", 80.0f, 60.0f, 400.0f, 25.0f);
        penelope3a.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren02"));
        penelope3a.getSpec().setPlanetColor(new Color(220, 230, 255, 255));
        penelope3a.applySpecChanges();
        JumpPointAPI p_jumpPoint = Global.getFactory().createJumpPoint("penelope_jump", "Penelope's \u5185\u90e8\u8df3\u8dc3\u70b9");
        p_jumpPoint.setCircularOrbit(system.getEntityById("penelope"), 140.0f, 6800.0f, 225.0f);
        p_jumpPoint.setRelatedPlanet((SectorEntityToken)penelope3);
        p_jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)p_jumpPoint);
        PlanetAPI penelope4 = system.addPlanet("penelope4", (SectorEntityToken)penelope_star, "Aeolus", "gas_giant", 230.0f, 275.0f, 9500.0f, 450.0f);
        penelope4.getSpec().setPlanetColor(new Color(150, 245, 255, 255));
        penelope4.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        penelope4.getSpec().setGlowColor(new Color(250, 225, 55, 64));
        penelope4.getSpec().setUseReverseLightForGlow(true);
        penelope4.applySpecChanges();
        SectorEntityToken penelope4_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(penelope4.getRadius() + 160.0f, (penelope4.getRadius() + 160.0f) / 2.0f, (SectorEntityToken)penelope4, penelope4.getRadius() + 50.0f, penelope4.getRadius() + 50.0f + 200.0f, new Color(50, 20, 100, 50), 0.5f, new Color[]{new Color(90, 180, 40), new Color(130, 145, 90), new Color(165, 110, 145), new Color(95, 55, 160), new Color(45, 0, 130), new Color(20, 0, 130), new Color(10, 0, 150)}));
        penelope4_field.setCircularOrbit((SectorEntityToken)penelope4, 0.0f, 0.0f, 100.0f);
        PlanetAPI penelope4a = system.addPlanet("penelope4a", (SectorEntityToken)penelope4, "Dorus", "barren", 30.0f, 50.0f, 700.0f, 22.0f);
        penelope4a.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "venuslike"));
        penelope4a.getSpec().setPlanetColor(new Color(185, 245, 255, 255));
        penelope4a.applySpecChanges();
        PlanetAPI penelope4b = system.addPlanet("penelope4b", (SectorEntityToken)penelope4, "Xuthus", "toxic_cold", 120.0f, 70.0f, 1000.0f, 45.0f);
        penelope4b.getSpec().setPlanetColor(new Color(190, 235, 255, 255));
        penelope4b.applySpecChanges();
        SectorEntityToken penelopeL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(400.0f, 600.0f, 16, 24, 4.0f, 16.0f, "Penelope L4 \u5c0f\u884c\u661f"));
        SectorEntityToken penelopeL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(400.0f, 600.0f, 16, 24, 4.0f, 16.0f, "Penelope L5 \u5c0f\u884c\u661f"));
        penelopeL4.setCircularOrbit((SectorEntityToken)penelope_star, 290.0f, 9500.0f, 450.0f);
        penelopeL5.setCircularOrbit((SectorEntityToken)penelope_star, 170.0f, 9500.0f, 450.0f);
        PlanetAPI penelope5 = system.addPlanet("penelope5", (SectorEntityToken)penelope_star, "Telepylus", "gas_giant", 250.0f, 280.0f, 12050.0f, 650.0f);
        penelope5.getSpec().setPlanetColor(new Color(170, 190, 255, 255));
        penelope5.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        penelope5.getSpec().setGlowColor(new Color(250, 225, 155, 32));
        penelope5.applySpecChanges();
        CustomCampaignEntityAPI telepylus_station = system.addCustomEntity("telepylus_station", "Telepylus \u7a7a\u95f4\u7ad9", "station_sporeship_derelict", "neutral");
        telepylus_station.setCircularOrbitPointingDown(system.getEntityById("penelope5"), 90.0f, 420.0f, 25.0f);
        telepylus_station.setCustomDescriptionId("station_telepylus");
        telepylus_station.setInteractionImage("illustrations", "abandoned_station3");
        system.addRingBand((SectorEntityToken)penelope5, "misc", "rings_special0", 256.0f, 1, new Color(200, 200, 200, 255), 256.0f, 600.0f, 30.0f, "ring", null);
        JumpPointAPI p_jumpPoint2 = Global.getFactory().createJumpPoint("penelope_jump", "Penelope's \u8fb9\u7f18\u8df3\u8dc3\u70b9");
        p_jumpPoint2.setCircularOrbit(system.getEntityById("penelope"), 190.0f, 12050.0f, 650.0f);
        p_jumpPoint2.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)p_jumpPoint2);
        system.addRingBand((SectorEntityToken)penelope_star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 13750.0f, 345.0f, "ring", null);
        system.addAsteroidBelt((SectorEntityToken)penelope_star, 100, 13750.0f, 200.0f, 330.0f, 360.0f, "asteroid_belt", "The Cyclopeans");
        PlanetAPI penelope6 = system.addPlanet("penelope6", (SectorEntityToken)penelope_star, "Ismara", "cryovolcanic", 130.0f, 100.0f, 14520.0f, 335.0f);
        penelope6.setCustomDescriptionId("planet_ismara");
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

