/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import java.awt.Color;

public class Samarra {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Samarra");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        PlanetAPI samarra_star = system.initStar("samarra", "star_orange", 650.0f, 500.0f);
        system.setLightColor(new Color(255, 235, 205));
        system.addAsteroidBelt((SectorEntityToken)samarra_star, 100, 3000.0f, 500.0f, 100.0f, 190.0f, "asteroid_belt", "Tigra Ring");
        system.addRingBand((SectorEntityToken)samarra_star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 3000.0f, 201.0f, null, null);
        system.addRingBand((SectorEntityToken)samarra_star, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 3100.0f, 225.0f, null, null);
        CustomCampaignEntityAPI tigra_city = system.addCustomEntity("tigra_city", "Tigra \u4e4b\u57ce", "station_side00", "hegemony");
        tigra_city.setCircularOrbitPointingDown(system.getEntityById("samarra"), 270.0f, 3020.0f, 185.0f);
        tigra_city.setCustomDescriptionId("station_tigra_city");
        tigra_city.setInteractionImage("illustrations", "hound_hangar");
        PlanetAPI samarra0 = system.addPlanet("eridu", (SectorEntityToken)samarra_star, "Eridu", "barren-bombarded", 90.0f, 30.0f, 2940.0f, 185.0f);
        PlanetAPI samarra1 = system.addPlanet("eventide", (SectorEntityToken)samarra_star, "Eventide", "terran-eccentric", 30.0f, 150.0f, 4000.0f, 200.0f);
        samarra1.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        samarra1.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        samarra1.getSpec().setUseReverseLightForGlow(true);
        samarra1.getSpec().setRotation(0.0f);
        samarra1.applySpecChanges();
        samarra1.setCustomDescriptionId("planet_eventide");
        CustomCampaignEntityAPI eventide_mirror1 = system.addCustomEntity("eventide_mirror1", "Eventide \u6052\u661f\u955c Alpha", "stellar_mirror", "hegemony");
        CustomCampaignEntityAPI eventide_mirror2 = system.addCustomEntity("eventide_mirror2", "Eventide \u6052\u661f\u955c Beta", "stellar_mirror", "hegemony");
        CustomCampaignEntityAPI eventide_mirror3 = system.addCustomEntity("eventide_mirror3", "Eventide \u6052\u661f\u955c Gamma", "stellar_mirror", "hegemony");
        CustomCampaignEntityAPI eventide_mirror4 = system.addCustomEntity("eventide_mirror4", "Eventide \u6052\u661f\u955c Delta", "stellar_mirror", "hegemony");
        CustomCampaignEntityAPI eventide_mirror5 = system.addCustomEntity("eventide_mirror5", "Eventide S\u6052\u661f\u955c Epsilon", "stellar_mirror", "hegemony");
        eventide_mirror1.setCircularOrbitPointingDown(system.getEntityById("eventide"), -30.0f, 400.0f, 200.0f);
        eventide_mirror2.setCircularOrbitPointingDown(system.getEntityById("eventide"), 0.0f, 400.0f, 200.0f);
        eventide_mirror3.setCircularOrbitPointingDown(system.getEntityById("eventide"), 30.0f, 400.0f, 200.0f);
        eventide_mirror4.setCircularOrbitPointingDown(system.getEntityById("eventide"), 60.0f, 400.0f, 200.0f);
        eventide_mirror5.setCircularOrbitPointingDown(system.getEntityById("eventide"), 90.0f, 400.0f, 200.0f);
        eventide_mirror1.setCustomDescriptionId("stellar_mirror");
        eventide_mirror2.setCustomDescriptionId("stellar_mirror");
        eventide_mirror3.setCustomDescriptionId("stellar_mirror");
        eventide_mirror4.setCustomDescriptionId("stellar_mirror");
        eventide_mirror5.setCustomDescriptionId("stellar_mirror");
        CustomCampaignEntityAPI eventide_shade1 = system.addCustomEntity("eventide_mirror1", "Eventide \u6052\u661f\u7f69 Omega", "stellar_shade", "hegemony");
        CustomCampaignEntityAPI eventide_shade2 = system.addCustomEntity("eventide_mirror3", "Eventide \u6052\u661f\u7f69 Psi", "stellar_shade", "hegemony");
        CustomCampaignEntityAPI eventide_shade3 = system.addCustomEntity("eventide_mirror5", "Eventide \u6052\u661f\u7f69 Chi", "stellar_shade", "hegemony");
        eventide_shade1.setCircularOrbitPointingDown(system.getEntityById("eventide"), 184.0f, 390.0f, 200.0f);
        eventide_shade2.setCircularOrbitPointingDown(system.getEntityById("eventide"), 210.0f, 425.0f, 200.0f);
        eventide_shade3.setCircularOrbitPointingDown(system.getEntityById("eventide"), 236.0f, 390.0f, 200.0f);
        eventide_shade1.setCustomDescriptionId("stellar_shade");
        eventide_shade2.setCustomDescriptionId("stellar_shade");
        eventide_shade3.setCustomDescriptionId("stellar_shade");
        PlanetAPI samarra1a = system.addPlanet("lumen", (SectorEntityToken)samarra1, "Lumen", "barren-bombarded", 30.0f, 25.0f, 610.0f, 26.0f);
        CustomCampaignEntityAPI samarra_relay = system.addCustomEntity("samarra_relay", "Samarra \u901a\u8baf\u5668", "comm_relay", "hegemony");
        samarra_relay.setCircularOrbitPointingDown(system.getEntityById("samarra"), -30.0f, 4000.0f, 200.0f);
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("samarra_jump_point_alpha", "Samarra \u8df3\u8dc3\u70b9");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)samarra_star, 90.0f, 4000.0f, 200.0f);
        jumpPoint.setOrbit(orbit);
        jumpPoint.setRelatedPlanet((SectorEntityToken)samarra1);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        CustomCampaignEntityAPI samarra_gate = system.addCustomEntity("samarra_gate", "Samarra \u4e4b\u95e8", "inactive_gate", null);
        samarra_gate.setCircularOrbit((SectorEntityToken)samarra_star, 210.0f, 4250.0f, 200.0f);
        PlanetAPI samarra2 = system.addPlanet("typhon", (SectorEntityToken)samarra_star, "Typon", "gas_giant", 60.0f, 350.0f, 7000.0f, 500.0f);
        samarra2.getSpec().setPlanetColor(new Color(250, 180, 120, 255));
        samarra2.getSpec().setCloudColor(new Color(250, 180, 120, 150));
        samarra2.getSpec().setAtmosphereColor(new Color(250, 180, 120, 150));
        samarra2.applySpecChanges();
        PlanetAPI samarra2a = system.addPlanet("chimera", (SectorEntityToken)samarra2, "Chimera", "toxic", 20.0f, 50.0f, 500.0f, 12.0f);
        PlanetAPI samarra2b = system.addPlanet("ladon", (SectorEntityToken)samarra2, "Ladon", "barren-bombarded", 40.0f, 30.0f, 620.0f, 16.0f);
        system.addRingBand((SectorEntityToken)samarra2, "misc", "rings_ice0", 256.0f, 3, Color.white, 256.0f, 850.0f, 30.0f, "ring", null);
        system.addRingBand((SectorEntityToken)samarra2, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 975.0f, 33.0f, "ring", null);
        PlanetAPI samarra2c = system.addPlanet("orthrus", (SectorEntityToken)samarra2, "Orthrus", "rocky_ice", 40.0f, 70.0f, 1475.0f, 41.0f);
        CustomCampaignEntityAPI orthrus_relay = system.addCustomEntity("orthrus_relay", "Orthrus \u901a\u8baf\u5668", "comm_relay", "independent");
        orthrus_relay.setCircularOrbit((SectorEntityToken)samarra2, -20.0f, 1475.0f, 41.0f);
        PlanetAPI samarra3d = system.addPlanet("sphinx", (SectorEntityToken)samarra2, "Sphinx", "barren", 50.0f, 60.0f, 1600.0f, 56.0f);
        samarra3d.setCustomDescriptionId("planet_sphinx");
        SectorEntityToken typhonL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 20, 30, 4.0f, 16.0f, "Typhon L4 \u5c0f\u884c\u661f"));
        SectorEntityToken typhonL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 20, 30, 4.0f, 16.0f, "Typhon L5 \u5c0f\u884c\u661f"));
        typhonL4.setCircularOrbit((SectorEntityToken)samarra_star, 120.0f, 7000.0f, 500.0f);
        typhonL5.setCircularOrbit((SectorEntityToken)samarra_star, 0.0f, 7000.0f, 500.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)samarra_star, (StarAge)StarAge.OLD, (int)1, (int)2, (float)9000.0f, (int)3, (boolean)true);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

