/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import java.awt.Color;

public class Thule {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Thule");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI thule_star = system.initStar("thule", "star_white", 600.0f, 150.0f, 4.0f, 0.5f, 1.5f);
        system.setLightColor(new Color(200, 230, 255));
        PlanetAPI hekla = system.addPlanet("hekla", (SectorEntityToken)thule_star, "Hekla", "toxic", 0.0f, 160.0f, 2870.0f, 90.0f);
        hekla.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        hekla.getSpec().setGlowColor(new Color(255, 190, 10, 100));
        hekla.getSpec().setUseReverseLightForGlow(true);
        hekla.getSpec().setPlanetColor(new Color(255, 235, 170, 255));
        hekla.applySpecChanges();
        system.addAsteroidBelt((SectorEntityToken)thule_star, 90, 3750.0f, 500.0f, 100.0f, 120.0f, "asteroid_belt", "The Ingwin");
        system.addRingBand((SectorEntityToken)thule_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 3600.0f, 105.0f, null, null);
        system.addRingBand((SectorEntityToken)thule_star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 3720.0f, 115.0f, null, null);
        PlanetAPI laki = system.addPlanet("laki", (SectorEntityToken)thule_star, "Laki", "barren3", 0.0f, 95.0f, 4000.0f, 100.0f);
        system.addAsteroidBelt((SectorEntityToken)thule_star, 90, 4550.0f, 500.0f, 290.0f, 310.0f, "asteroid_belt", "Hama's Band");
        system.addRingBand((SectorEntityToken)thule_star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 4500.0f, 305.0f, null, null);
        system.addRingBand((SectorEntityToken)thule_star, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 4600.0f, 295.0f, null, null);
        PlanetAPI kazeron = system.addPlanet("kazeron", (SectorEntityToken)thule_star, "Kazeron", "barren_castiron", 90.0f, 170.0f, 5200.0f, 225.0f);
        kazeron.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "sindria"));
        kazeron.getSpec().setGlowColor(new Color(255, 160, 30, 255));
        kazeron.getSpec().setUseReverseLightForGlow(true);
        kazeron.getSpec().setPitch(-15.0f);
        kazeron.getSpec().setTilt(20.0f);
        kazeron.applySpecChanges();
        kazeron.setCustomDescriptionId("planet_kazeron");
        PlanetAPI draugr = system.addPlanet("draugr", (SectorEntityToken)kazeron, "Draugr", "barren-bombarded", 0.0f, 50.0f, 400.0f, 24.0f);
        draugr.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        draugr.getSpec().setGlowColor(new Color(255, 220, 50, 35));
        draugr.getSpec().setUseReverseLightForGlow(true);
        draugr.getSpec().setPitch(-90.0f);
        draugr.getSpec().setTilt(90.0f);
        draugr.getSpec().setPlanetColor(new Color(255, 245, 230, 255));
        draugr.applySpecChanges();
        JumpPointAPI jumpPoint1 = Global.getFactory().createJumpPoint("thule_jump", "Thule \u8df3\u8dc3\u70b9");
        jumpPoint1.setCircularOrbit(system.getEntityById("thule"), 30.0f, 5200.0f, 225.0f);
        jumpPoint1.setRelatedPlanet((SectorEntityToken)kazeron);
        system.addEntity((SectorEntityToken)jumpPoint1);
        CustomCampaignEntityAPI relay = system.addCustomEntity("kazeron_relay", "Kazeron \u901a\u8baf\u5668", "comm_relay", "persean");
        relay.setCircularOrbitPointingDown(system.getEntityById("thule"), 150.0f, 5200.0f, 225.0f);
        system.addAsteroidBelt((SectorEntityToken)thule_star, 90, 5950.0f, 500.0f, 150.0f, 300.0f, "asteroid_belt", "Inged's Crown");
        system.addRingBand((SectorEntityToken)thule_star, "misc", "rings_ice0", 256.0f, 1, Color.white, 256.0f, 5900.0f, 305.0f, null, null);
        system.addRingBand((SectorEntityToken)thule_star, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 6020.0f, 295.0f, null, null);
        PlanetAPI eldfell = system.addPlanet("eldfell", (SectorEntityToken)thule_star, "Eldfell", "barren2", 180.0f, 140.0f, 6700.0f, 360.0f);
        eldfell.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        eldfell.getSpec().setGlowColor(new Color(250, 220, 210, 45));
        eldfell.getSpec().setUseReverseLightForGlow(true);
        eldfell.getSpec().setPitch(20.0f);
        eldfell.getSpec().setTilt(30.0f);
        eldfell.getSpec().setPlanetColor(new Color(220, 245, 255, 255));
        eldfell.getSpec().setAtmosphereThicknessMin(16.0f);
        eldfell.getSpec().setAtmosphereThickness(0.14f);
        eldfell.getSpec().setAtmosphereColor(new Color(230, 245, 255, 30));
        eldfell.applySpecChanges();
        eldfell.setCustomDescriptionId("planet_eldfell");
        CustomCampaignEntityAPI gate = system.addCustomEntity("thule_gate", "Gate of Thule", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("thule"), 240.0f, 6700.0f, 360.0f);
        JumpPointAPI jumpPoint2 = Global.getFactory().createJumpPoint("eldfell_jump", "Eldfell \u8df3\u8dc3\u70b9");
        jumpPoint2.setCircularOrbit(system.getEntityById("thule"), 120.0f, 6700.0f, 360.0f);
        jumpPoint2.setRelatedPlanet((SectorEntityToken)eldfell);
        system.addEntity((SectorEntityToken)jumpPoint1);
        system.addAsteroidBelt((SectorEntityToken)thule_star, 90, 7650.0f, 500.0f, 150.0f, 300.0f, "asteroid_belt", "Garmund's Ring");
        system.addRingBand((SectorEntityToken)thule_star, "misc", "rings_ice0", 256.0f, 2, Color.white, 256.0f, 7750.0f, 385.0f, null, null);
        system.addRingBand((SectorEntityToken)thule_star, "misc", "rings_ice0", 256.0f, 1, new Color(230, 240, 255, 255), 256.0f, 7870.0f, 395.0f, null, null);
        CustomCampaignEntityAPI thule_pirate_station = system.addCustomEntity("thule_pirate_station", "Thulian \u63a0\u593a\u8005\u57fa\u5730", "station_pirate_type", "pirates");
        thule_pirate_station.setCircularOrbitPointingDown(system.getEntityById("thule"), 240.0f, 7900.0f, 380.0f);
        thule_pirate_station.setCustomDescriptionId("station_thulian_raiders");
        thule_pirate_station.setInteractionImage("illustrations", "pirate_station");
        PlanetAPI morn = system.addPlanet("morn", (SectorEntityToken)thule_star, "Morn", "ice_giant", 90.0f, 240.0f, 8500.0f, 390.0f);
        morn.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        morn.getSpec().setGlowColor(new Color(235, 250, 150, 45));
        morn.getSpec().setUseReverseLightForGlow(true);
        morn.getSpec().setPitch(-5.0f);
        morn.getSpec().setTilt(20.0f);
        morn.getSpec().setPlanetColor(new Color(255, 185, 165, 255));
        morn.applySpecChanges();
        SectorEntityToken nebula1 = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("        xx x xxxxxxxx xx xxx    xxx ", 6, 6, "terrain", "nebula", 4, 4, "Morn L5 \u661f\u4e91"));
        nebula1.getLocation().set(morn.getLocation().x + 1000.0f, morn.getLocation().y);
        nebula1.setCircularOrbit((SectorEntityToken)thule_star, morn.getCircularOrbitAngle() - 60.0f, morn.getCircularOrbitRadius(), 390.0f);
        SectorEntityToken nebula2 = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("  x xx xxx     xx xxxxxx  xx   x    ", 6, 6, "terrain", "nebula", 4, 4, "Morn L4 \u661f\u4e91"));
        nebula2.getLocation().set(morn.getLocation().x - 1000.0f, morn.getLocation().y);
        nebula2.setCircularOrbit((SectorEntityToken)thule_star, morn.getCircularOrbitAngle() + 60.0f, morn.getCircularOrbitRadius(), 390.0f);
        PlanetAPI skoll = system.addPlanet("skoll", (SectorEntityToken)thule_star, "Skoll", "ice_giant", 270.0f, 260.0f, 9450.0f, 420.0f);
        skoll.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        skoll.getSpec().setGlowColor(new Color(50, 255, 250, 75));
        skoll.getSpec().setUseReverseLightForGlow(true);
        skoll.getSpec().setPitch(150.0f);
        skoll.getSpec().setTilt(80.0f);
        skoll.getSpec().setPlanetColor(new Color(150, 255, 205, 255));
        skoll.applySpecChanges();
        SectorEntityToken skoll_magfield = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(skoll.getRadius() + 150.0f, (skoll.getRadius() + 150.0f) / 2.0f, (SectorEntityToken)skoll, skoll.getRadius() + 50.0f, skoll.getRadius() + 50.0f + 200.0f, new Color(50, 20, 100, 50), 0.15f, new Color[]{new Color(90, 180, 40), new Color(130, 145, 90), new Color(165, 110, 145), new Color(95, 55, 160), new Color(45, 0, 130), new Color(20, 0, 130), new Color(10, 0, 150)}));
        skoll_magfield.setCircularOrbit((SectorEntityToken)skoll, 0.0f, 0.0f, 100.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)thule_star, (StarAge)StarAge.AVERAGE, (int)1, (int)2, (float)11200.0f, (int)6, (boolean)true);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

