/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class TiaTaxet {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Tia");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI tia_star = system.initStar("tia", "star_orange_giant", 950.0f, 200.0f);
        system.setLightColor(new Color(255, 230, 200));
        PlanetAPI taxet_star = system.addPlanet("taxet", (SectorEntityToken)tia_star, "Ta'xet", "star_red_dwarf", 0.0f, 400.0f, 1600.0f, 30.0f);
        SectorEntityToken taxet_star_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(taxet_star.getRadius() + 160.0f, (taxet_star.getRadius() + 160.0f) / 2.0f, (SectorEntityToken)taxet_star, taxet_star.getRadius() + 50.0f, taxet_star.getRadius() + 50.0f + 200.0f, new Color(75, 105, 165, 75), 1.0f, new Color[]{new Color(55, 60, 140), new Color(65, 85, 155), new Color(175, 105, 165), new Color(90, 130, 180), new Color(105, 150, 190), new Color(120, 175, 205), new Color(135, 200, 220)}));
        taxet_star_field.setCircularOrbit((SectorEntityToken)taxet_star, 0.0f, 0.0f, 50.0f);
        system.addRingBand((SectorEntityToken)tia_star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 4300.0f, 220.0f, null, null);
        system.addRingBand((SectorEntityToken)tia_star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 4400.0f, 226.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)tia_star, 150, 3600.0f, 170.0f, 200.0f, 250.0f, "asteroid_belt", "Lagua's Torus");
        SectorEntityToken tia_field1 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 30, 40, 4.0f, 16.0f, "Tia-Tax'et \u5c0f\u884c\u661f\u5e26"));
        tia_field1.setCircularOrbit((SectorEntityToken)tia_star, 180.0f, 4500.0f, 250.0f);
        SectorEntityToken abandoned_station1 = system.addOrbitalStation("abandoned_spacedock", (SectorEntityToken)tia_star, 330.0f, 7100.0f, 500.0f, "\u5e9f\u5f03\u7684\u7814\u7a76\u7ad9", "neutral");
        abandoned_station1.setInteractionImage("illustrations", "space_wreckage");
        abandoned_station1.setCircularOrbitPointingDown(system.getEntityById("tia"), 180.0f, 4450.0f, 250.0f);
        abandoned_station1.setCustomDescriptionId("station_tiataxet_spacedock");
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(200.0f, 1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.baseSalvageXP = 250L;
        SectorEntityToken debris = Misc.addDebrisField((LocationAPI)system, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, (Random)StarSystemGenerator.random);
        SalvageSpecialAssigner.assignSpecialForDebrisField((SectorEntityToken)debris);
        debris.setSensorProfile(null);
        debris.setDiscoverable(null);
        debris.setCircularOrbit(system.getEntityById("tia"), 195.0f, 4550.0f, 250.0f);
        system.addRingBand((SectorEntityToken)tia_star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 5000.0f, 320.0f, null, null);
        system.addRingBand((SectorEntityToken)tia_star, "misc", "rings_asteroids0", 256.0f, 3, Color.white, 256.0f, 5100.0f, 326.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)tia_star, 150, 5050.0f, 350.0f, 200.0f, 250.0f, "asteroid_belt", null);
        SectorEntityToken tia_field2 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 35, 45, 4.0f, 16.0f, null));
        tia_field2.setCircularOrbit((SectorEntityToken)tia_star, 45.0f, 5500.0f, 340.0f);
        SectorEntityToken tia_field3 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(300.0f, 500.0f, 24, 30, 4.0f, 16.0f, null));
        tia_field3.setCircularOrbit((SectorEntityToken)tia_star, 225.0f, 5400.0f, 340.0f);
        PlanetAPI tia2 = system.addPlanet("tia2", (SectorEntityToken)tia_star, "Ogre", "irradiated", 0.0f, 90.0f, 5700.0f, 400.0f);
        SectorEntityToken tia_field4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(300.0f, 500.0f, 38, 50, 4.0f, 16.0f, "The Mosquitos"));
        tia_field4.setCircularOrbit((SectorEntityToken)tia_star, 180.0f, 5700.0f, 400.0f);
        JumpPointAPI jumpPoint2 = Global.getFactory().createJumpPoint("tia-taxet_jump", "Tia-Tax'et \u8df3\u8dc3\u70b9");
        jumpPoint2.setCircularOrbit(system.getEntityById("tia"), 330.0f, 11500.0f, 800.0f);
        jumpPoint2.setRelatedPlanet((SectorEntityToken)tia2);
        system.addEntity((SectorEntityToken)jumpPoint2);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

