/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import java.awt.Color;

public class Tyle {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Tyle");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background3.jpg");
        PlanetAPI tyle_star = system.initStar("tyle", "star_orange", 675.0f, 460.0f, 10.0f, 0.75f, 3.2f);
        system.setLightColor(new Color(245, 230, 235));
        PlanetAPI tyle_a = system.addPlanet("satanazes", (SectorEntityToken)tyle_star, "Satanazes", "gas_giant", 0.0f, 280.0f, 1900.0f, 40.0f);
        tyle_a.getSpec().setPlanetColor(new Color(40, 25, 35, 255));
        tyle_a.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        tyle_a.getSpec().setGlowColor(new Color(255, 50, 20, 45));
        tyle_a.getSpec().setAtmosphereThickness(0.2f);
        tyle_a.getSpec().setUseReverseLightForGlow(true);
        tyle_a.getSpec().setPitch(-20.0f);
        tyle_a.getSpec().setTilt(-10.0f);
        tyle_a.applySpecChanges();
        tyle_a.setCustomDescriptionId("planet_satanazes");
        PlanetAPI tyle_b = system.addPlanet("cibola", (SectorEntityToken)tyle_star, "Cibola", "desert", 0.0f, 145.0f, 3500.0f, 210.0f);
        tyle_b.setCustomDescriptionId("planet_cibola");
        tyle_b.setInteractionImage("illustrations", "desert_moons_ruins");
        PlanetAPI tyle_b1 = system.addPlanet("dorado", (SectorEntityToken)tyle_b, "Dorado", "barren-bombarded", 0.0f, 48.0f, 400.0f, 24.0f);
        system.addRingBand((SectorEntityToken)tyle_star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 4300.0f, 220.0f, null, null);
        system.addRingBand((SectorEntityToken)tyle_star, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 4400.0f, 226.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)tyle_star, 60, 4350.0f, 170.0f, 200.0f, 250.0f, "asteroid_belt", "Tyle's Archipelago");
        PlanetAPI tyle_c = system.addPlanet("zuni", (SectorEntityToken)tyle_star, "Zuni", "barren", 90.0f, 60.0f, 4800.0f, 260.0f);
        SectorEntityToken tyle_field1 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(300.0f, 640.0f, 30, 40, 4.0f, 16.0f, "The Wuya"));
        tyle_field1.setCircularOrbit((SectorEntityToken)tyle_star, 150.0f, 4800.0f, 260.0f);
        CustomCampaignEntityAPI gate = system.addCustomEntity("wuya_gate", "Wuya \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("tyle"), 152.0f, 4800.0f, 260.0f);
        JumpPointAPI jumpPoint1 = Global.getFactory().createJumpPoint("wuya_jump", "Wuya \u8df3\u8dc3\u70b9");
        jumpPoint1.setCircularOrbit(system.getEntityById("tyle"), 30.0f, 4800.0f, 260.0f);
        jumpPoint1.setRelatedPlanet((SectorEntityToken)tyle_c);
        system.addEntity((SectorEntityToken)jumpPoint1);
        PlanetAPI tyle_d = system.addPlanet("canaria", (SectorEntityToken)tyle_star, "Canaria", "ice_giant", 240.0f, 250.0f, 9000.0f, 750.0f);
        PlanetAPI tyle_d1 = system.addPlanet("madeira", (SectorEntityToken)tyle_d, "Madeira", "tundra", 0.0f, 80.0f, 700.0f, 34.0f);
        tyle_d1.setCustomDescriptionId("planet_madeira");
        CustomCampaignEntityAPI canaria_relay = system.addCustomEntity("canaria_relay", "Canaria \u901a\u8baf\u5668", "comm_relay", "persean");
        canaria_relay.setCircularOrbitPointingDown(system.getEntityById("canaria"), 180.0f, 700.0f, 34.0f);
        SectorEntityToken tyle_field2 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 740.0f, 45, 60, 4.0f, 20.0f, "Sargossa"));
        tyle_field2.setCircularOrbit((SectorEntityToken)tyle_star, 120.0f, 9000.0f, 750.0f);
        PlanetAPI antillia_star = system.addPlanet("antillia", (SectorEntityToken)tyle_star, "Antillia", "star_white", 180.0f, 350.0f, 9000.0f, 750.0f);
        SectorEntityToken antillia_star_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(antillia_star.getRadius() + 160.0f, (antillia_star.getRadius() + 160.0f) / 2.0f, (SectorEntityToken)antillia_star, antillia_star.getRadius() + 50.0f, antillia_star.getRadius() + 50.0f + 200.0f, new Color(75, 105, 165, 75), 1.0f, new Color[]{new Color(55, 60, 140), new Color(65, 85, 155), new Color(175, 105, 165), new Color(90, 130, 180), new Color(105, 150, 190), new Color(120, 175, 205), new Color(135, 200, 220)}));
        antillia_star_field.setCircularOrbit((SectorEntityToken)antillia_star, 0.0f, 0.0f, 50.0f);
        PlanetAPI antillia_b = system.addPlanet("antillia_b", (SectorEntityToken)antillia_star, "Kardara", "barren-bombarded", 0.0f, 65.0f, 2000.0f, 120.0f);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)tyle_star, (StarAge)StarAge.OLD, (int)2, (int)3, (float)11500.0f, (int)5, (boolean)true);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

