/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class Valhalla {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Valhalla");
        system.setType(StarSystemGenerator.StarSystemType.BINARY_FAR);
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background5.jpg");
        SectorEntityToken valhalla_nebula = Misc.addNebulaFromPNG((String)"data/campaign/terrain/valhalla_nebula.png", (float)0.0f, (float)0.0f, (LocationAPI)system, (String)"terrain", (String)"nebula", (int)4, (int)4, (StarAge)StarAge.AVERAGE);
        PlanetAPI star = system.initStar("valhalla", "star_orange", 650.0f, 500.0f);
        system.setLightColor(new Color(255, 230, 220));
        PlanetAPI val1 = system.addPlanet("glasnir", (SectorEntityToken)star, "Glasnir", "barren", 0.0f, 90.0f, 1800.0f, 100.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 3100.0f, 190.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)star, 100, 3150.0f, 256.0f, 150.0f, 250.0f, "asteroid_belt", "The Valkyries");
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("valkyrie_jump", " Valkyrie \u8df3\u8dc3\u70b9");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)star, 180.0f, 3325.0f, 195.0f);
        jumpPoint.setOrbit(orbit);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 3450.0f, 200.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)star, 100, 3350.0f, 256.0f, 150.0f, 250.0f, "asteroid_belt", "The Valkyries");
        PlanetAPI val2 = system.addPlanet("yggdrasil", (SectorEntityToken)star, "Yggdrasil", "gas_giant", 230.0f, 350.0f, 6000.0f, 250.0f);
        val2.getSpec().setPlanetColor(new Color(110, 255, 135, 255));
        val2.applySpecChanges();
        PlanetAPI val2a = system.addPlanet("nidhogg", (SectorEntityToken)val2, "Nidhogg", "lava_minor", 40.0f, 40.0f, 700.0f, 22.0f);
        val2a.setCustomDescriptionId("planet_nidhogg");
        system.addRingBand((SectorEntityToken)val2, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 1100.0f, 40.0f, "ring", null);
        PlanetAPI val2b = system.addPlanet("ratatosk", (SectorEntityToken)val2, "Ratatosk", "barren-bombarded", 50.0f, 80.0f, 1400.0f, 45.0f);
        val2b.setCustomDescriptionId("planet_ratatosk");
        val2b.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren03"));
        val2b.applySpecChanges();
        PlanetAPI val2c = system.addPlanet("raesvelg", (SectorEntityToken)val2, "Raesvelg", "frozen", 50.0f, 70.0f, 1700.0f, 40.0f);
        val2c.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        val2c.getSpec().setGlowColor(new Color(0, 125, 255, 64));
        val2c.getSpec().setUseReverseLightForGlow(true);
        val2c.applySpecChanges();
        val2c.setInteractionImage("illustrations", "industrial_megafacility");
        val2c.setCustomDescriptionId("planet_raesvelg");
        SectorEntityToken yggdrasilL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 20, 30, 4.0f, 16.0f, "Yggdrasil L4 \u5c0f\u884c\u661f"));
        SectorEntityToken yggdrasilL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 20, 30, 4.0f, 16.0f, "Yggdrasil L5 \u5c0f\u884c\u661f"));
        yggdrasilL4.setCircularOrbit((SectorEntityToken)star, 170.0f, 6000.0f, 250.0f);
        yggdrasilL5.setCircularOrbit((SectorEntityToken)star, 290.0f, 6000.0f, 250.0f);
        PlanetAPI val3 = system.addPlanet("niflheim", (SectorEntityToken)star, "Niflheim", "ice_giant", 230.0f, 250.0f, 9000.0f, 450.0f);
        CustomCampaignEntityAPI mimir_station = system.addCustomEntity("mimir_platform", "Mimir \u8679\u5438\u7ad9", "station_side05", "tritachyon");
        mimir_station.setCircularOrbitPointingDown(system.getEntityById("niflheim"), 45.0f, 500.0f, 50.0f);
        mimir_station.setCustomDescriptionId("station_mimir");
        PlanetAPI val3a = system.addPlanet("skathi", (SectorEntityToken)val3, "Skathi", "frozen", 45.0f, 70.0f, 620.0f, 50.0f);
        val3a.setCustomDescriptionId("planet_skathi");
        val3a.setInteractionImage("illustrations", "cargo_loading");
        PlanetAPI val4 = system.addPlanet("ragnar", (SectorEntityToken)star, "Ragnar", "star_red_dwarf", 45.0f, 350.0f, 14000.0f, 1000.0f);
        system.setSecondary(val4);
        system.addCorona((SectorEntityToken)val4, 150.0f, 2.0f, 0.0f, 1.0f);
        CustomCampaignEntityAPI ragnar_station = system.addCustomEntity("ragnar_complex", "Ragnar \u7efc\u5408\u8bbe\u65bd", "station_side02", "hegemony");
        ragnar_station.setCircularOrbitPointingDown(system.getEntityById("ragnar"), 45.0f, 1400.0f, 50.0f);
        ragnar_station.setCustomDescriptionId("station_ragnar");
        ragnar_station.setInteractionImage("illustrations", "hound_hangar");
        CustomCampaignEntityAPI relay = system.addCustomEntity("ragnar_relay", "Ragnar \u901a\u8baf\u5668", "comm_relay", "hegemony");
        relay.setCircularOrbitPointingDown(system.getEntityById("ragnar"), 165.0f, 1400.0f, 50.0f);
        SectorEntityToken ragnar_asteroid_field = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 25, 40, 4.0f, 16.0f, "The Vipers"));
        ragnar_asteroid_field.setCircularOrbit(system.getEntityById("ragnar"), 285.0f, 1400.0f, 50.0f);
        system.addRingBand((SectorEntityToken)val4, "misc", "rings_asteroids0", 256.0f, 0, Color.white, 256.0f, 2000.0f, 250.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)val4, 50, 2000.0f, 256.0f, 200.0f, 300.0f, "asteroid_belt", null);
        JumpPointAPI jumpPoint_ragnar = Global.getFactory().createJumpPoint("ragnar_jump", "Ragnar \u8df3\u8dc3\u70b9");
        OrbitAPI orbit2 = Global.getFactory().createCircularOrbit((SectorEntityToken)val4, 180.0f, 2400.0f, 45.0f);
        jumpPoint_ragnar.setOrbit(orbit2);
        jumpPoint_ragnar.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint_ragnar);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

