/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import java.awt.Color;

public class Westernesse {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Westernesse");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background6.jpg");
        PlanetAPI westernesse_star = system.initStar("westernesse", "star_yellow", 750.0f, 500.0f, 10.0f, 1.0f, 3.0f);
        system.setLightColor(new Color(255, 245, 185));
        float radiusAfter1 = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)westernesse_star, (StarAge)StarAge.OLD, (int)1, (int)2, (float)1800.0f, (int)0, (boolean)true);
        PlanetAPI horn = system.addPlanet("horn", (SectorEntityToken)westernesse_star, "Horn", "rocky_unstable", 90.0f, 225.0f, radiusAfter1 + 1500.0f, 90.0f);
        horn.setCustomDescriptionId("planet_horn");
        PlanetAPI athulf = system.addPlanet("athulf", (SectorEntityToken)horn, "Athulf", "rocky_metallic", 30.0f, 65.0f, 575.0f, 24.0f);
        athulf.setCustomDescriptionId("planet_athulf");
        PlanetAPI fikenhild = system.addPlanet("fikenhild", (SectorEntityToken)horn, "Fikenhild", "water", 270.0f, 85.0f, 800.0f, 34.0f);
        fikenhild.getSpec().setPlanetColor(new Color(240, 225, 255, 255));
        fikenhild.applySpecChanges();
        fikenhild.setCustomDescriptionId("planet_fikenhild");
        JumpPointAPI jumpPoint1 = Global.getFactory().createJumpPoint("westernesse_jump", "Westernesse \u8df3\u8dc3\u70b9");
        jumpPoint1.setCircularOrbit(system.getEntityById("westernesse"), 150.0f, radiusAfter1 + 1500.0f, 90.0f);
        jumpPoint1.setRelatedPlanet((SectorEntityToken)horn);
        system.addEntity((SectorEntityToken)jumpPoint1);
        CustomCampaignEntityAPI westernesse_relay = system.addCustomEntity("westernesse_relay", "Westernesse \u901a\u8baf\u5668", "comm_relay", "persean");
        westernesse_relay.setCircularOrbitPointingDown(system.getEntityById("westernesse"), 30.0f, radiusAfter1 + 1500.0f, 90.0f);
        PlanetAPI suddene = system.addPlanet("suddene", (SectorEntityToken)westernesse_star, "Suddene", "barren-desert", 180.0f, 145.0f, radiusAfter1 + 2600.0f, 210.0f);
        PlanetAPI ailmar = system.addPlanet("ailmar", (SectorEntityToken)westernesse_star, "Ailmar", "tundra", 0.0f, 165.0f, radiusAfter1 + 3300.0f, 400.0f);
        PlanetAPI rymenhild = system.addPlanet("rymenhild", (SectorEntityToken)ailmar, "Rymenhild", "barren-bombarded", 180.0f, 65.0f, 450.0f, 40.0f);
        float radiusAfter2 = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)westernesse_star, (StarAge)StarAge.AVERAGE, (int)2, (int)3, (float)(radiusAfter1 + 7600.0f), (int)4, (boolean)true);
        StarSystemGenerator.addSystemwideNebula((StarSystemAPI)system, (StarAge)StarAge.OLD);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

