/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class Yma {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Yma");
        system.setType(StarSystemGenerator.StarSystemType.BINARY_FAR);
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background2.jpg");
        PlanetAPI yma_star = system.initStar("yma", "star_yellow", 900.0f, 500.0f);
        system.setLightColor(new Color(250, 240, 210));
        PlanetAPI yma1 = system.addPlanet("huascar", (SectorEntityToken)yma_star, "Huascar", "lava", 0.0f, 120.0f, 2200.0f, 100.0f);
        system.addRingBand((SectorEntityToken)yma_star, "misc", "rings_asteroids0", 256.0f, 2, Color.white, 256.0f, 3700.0f, 175.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)yma_star, 75, 3700.0f, 256.0f, 150.0f, 200.0f, "asteroid_belt", null);
        PlanetAPI yma2 = system.addPlanet("hanan_pacha", (SectorEntityToken)yma_star, "Hanan Pacha", "irradiated", 180.0f, 200.0f, 4400.0f, 330.0f);
        yma2.getSpec().setPlanetColor(new Color(220, 245, 255, 255));
        yma2.getSpec().setAtmosphereColor(new Color(150, 120, 100, 250));
        yma2.getSpec().setCloudColor(new Color(150, 120, 120, 150));
        yma2.setCustomDescriptionId("planet_hanan_pacha");
        Misc.initConditionMarket((PlanetAPI)yma2);
        yma2.getMarket().addCondition("decivilized");
        yma2.getMarket().addCondition("ruins_extensive");
        yma2.getMarket().getFirstCondition("ruins_extensive").setSurveyed(true);
        yma2.getMarket().addCondition("meteor_impacts");
        yma2.getMarket().addCondition("ore_moderate");
        yma2.getMarket().addCondition("rare_ore_sparse");
        PlanetAPI yma2a = system.addPlanet("killa", (SectorEntityToken)yma2, "Killa", "barren-bombarded", 90.0f, 50.0f, 380.0f, 16.0f);
        Misc.initConditionMarket((PlanetAPI)yma2a);
        yma2a.getMarket().addCondition("decivilized");
        yma2a.getMarket().addCondition("ruins_widespread");
        yma2a.getMarket().getFirstCondition("ruins_widespread").setSurveyed(true);
        yma2a.getMarket().addCondition("no_atmosphere");
        yma2a.getMarket().addCondition("rare_ore_sparse");
        yma2a.setCustomDescriptionId("planet_killa");
        system.addRingBand((SectorEntityToken)yma_star, "misc", "rings_asteroids0", 256.0f, 3, Color.white, 256.0f, 5100.0f, 475.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)yma_star, 100, 5100.0f, 256.0f, 450.0f, 500.0f, "asteroid_belt", null);
        PlanetAPI yma3 = system.addPlanet("chupi_orco", (SectorEntityToken)yma_star, "Chupi Orco", "gas_giant", 45.0f, 300.0f, 7300.0f, 450.0f);
        yma3.getSpec().setPlanetColor(new Color(200, 235, 245, 255));
        yma3.getSpec().setAtmosphereColor(new Color(210, 240, 250, 250));
        yma3.getSpec().setCloudColor(new Color(220, 250, 240, 200));
        yma3.getSpec().setPitch(-22.0f);
        yma3.getSpec().setTilt(-9.0f);
        yma3.applySpecChanges();
        CustomCampaignEntityAPI neutralStation = system.addCustomEntity("yma_abandoned_station", "Abandoned \u8679\u5438\u7ad9", "station_side05", "neutral");
        neutralStation.setCircularOrbitPointingDown(system.getEntityById("chupi_orco"), 45.0f, 360.0f, 50.0f);
        neutralStation.setCustomDescriptionId("station_chupi_orco");
        neutralStation.setInteractionImage("illustrations", "abandoned_station3");
        Misc.setAbandonedStationMarket((String)"yma_abandoned_station_market", (SectorEntityToken)neutralStation);
        system.addRingBand((SectorEntityToken)yma3, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 600.0f, 31.0f);
        system.addRingBand((SectorEntityToken)yma3, "misc", "rings_ice0", 256.0f, 3, Color.white, 256.0f, 750.0f, 35.0f);
        SectorEntityToken ring = system.addTerrain("ring", (Object)new BaseRingTerrain.RingParams(406.0f, 675.0f, null, null));
        ring.setCircularOrbit((SectorEntityToken)yma3, 0.0f, 0.0f, 100.0f);
        PlanetAPI yma3a = system.addPlanet("viscacha", (SectorEntityToken)yma3, "Viscacha", "toxic_cold", 0.0f, 65.0f, 1000.0f, 21.0f);
        yma3a.getSpec().setPlanetColor(new Color(255, 210, 170, 255));
        yma3a.getSpec().setAtmosphereColor(new Color(255, 190, 210, 255));
        yma3a.getSpec().setCloudColor(new Color(255, 180, 200, 255));
        yma3a.applySpecChanges();
        yma3a.setCustomDescriptionId("planet_viscacha");
        PlanetAPI yma3b = system.addPlanet("salamanca", (SectorEntityToken)yma3, "Salamanca", "toxic_cold", 0.0f, 95.0f, 1400.0f, 29.0f);
        yma3b.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        yma3b.getSpec().setGlowColor(new Color(255, 20, 60, 255));
        yma3b.getSpec().setAtmosphereThickness(0.2f);
        yma3b.getSpec().setUseReverseLightForGlow(true);
        yma3b.applySpecChanges();
        yma3b.setCustomDescriptionId("planet_salamanca");
        SectorEntityToken chupi_orcoL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 20, 30, 4.0f, 16.0f, "Chupi Orco L4 \u5c0f\u884c\u661f"));
        SectorEntityToken chupi_orcoL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 20, 30, 4.0f, 16.0f, "Chupi Orco L5 \u5c0f\u884c\u661f"));
        chupi_orcoL4.setCircularOrbit((SectorEntityToken)yma_star, 105.0f, 7300.0f, 450.0f);
        chupi_orcoL5.setCircularOrbit((SectorEntityToken)yma_star, -15.0f, 7300.0f, 450.0f);
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("viscacha_jump", "Viscacha \u8df3\u8dc3\u70b9");
        jumpPoint.setCircularOrbit(system.getEntityById("yma"), 105.0f, 7300.0f, 450.0f);
        jumpPoint.setRelatedPlanet((SectorEntityToken)yma3a);
        system.addEntity((SectorEntityToken)jumpPoint);
        CustomCampaignEntityAPI gate = system.addCustomEntity("yma_gate", "Yma \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("yma"), 350.0f, 7300.0f, 450.0f);
        PlanetAPI yma_star_b = system.addPlanet("warawara", (SectorEntityToken)yma_star, "Warawara", "star_white", 270.0f, 400.0f, 12500.0f, 800.0f);
        system.setSecondary(yma_star_b);
        PlanetAPI yma_b1 = system.addPlanet("qaras", (SectorEntityToken)yma_star_b, "Qaras", "tundra", 0.0f, 140.0f, 2000.0f, 100.0f);
        yma_b1.getSpec().setPitch(180.0f);
        yma_b1.getSpec().setTilt(-30.0f);
        yma_b1.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        yma_b1.getSpec().setGlowColor(new Color(240, 255, 250, 64));
        yma_b1.getSpec().setUseReverseLightForGlow(true);
        yma_b1.applySpecChanges();
        yma_b1.setCustomDescriptionId("planet_qaras");
        CustomCampaignEntityAPI qaras_mirror1 = system.addCustomEntity("qaras_mirror1", "Qaras \u6052\u661f\u955c", "stellar_mirror", "pirates");
        qaras_mirror1.setCircularOrbitPointingDown(system.getEntityById("qaras"), 0.0f, 220.0f, 40.0f);
        qaras_mirror1.setCustomDescriptionId("stellar_mirror");
        system.addRingBand((SectorEntityToken)yma_b1, "misc", "rings_ice0", 256.0f, 1, Color.white, 256.0f, 400.0f, 30.0f, "ring", null);
        CustomCampaignEntityAPI qaras_relay = system.addCustomEntity("qaras_relay", "Qaras \u901a\u8baf\u5668", "comm_relay", "pirates");
        qaras_relay.setCircularOrbitPointingDown((SectorEntityToken)yma_star_b, -60.0f, 2000.0f, 100.0f);
        JumpPointAPI jumpPoint2 = Global.getFactory().createJumpPoint("viscacha_jump", "Yma B \u8df3\u8dc3\u70b9");
        jumpPoint2.setCircularOrbit(system.getEntityById("yma"), 330.0f, 12500.0f, 800.0f);
        jumpPoint2.setRelatedPlanet((SectorEntityToken)yma_b1);
        system.addEntity((SectorEntityToken)jumpPoint2);
        SectorEntityToken warawaraL4 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 30, 40, 4.0f, 24.0f, "Warawara Orco L4 \u5c0f\u884c\u661f"));
        SectorEntityToken warawaraL5 = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(500.0f, 700.0f, 30, 40, 4.0f, 24.0f, "Warawara Orco L5 \u5c0f\u884c\u661f"));
        warawaraL4.setCircularOrbit((SectorEntityToken)yma_star, 210.0f, 12500.0f, 800.0f);
        warawaraL5.setCircularOrbit((SectorEntityToken)yma_star, 330.0f, 12500.0f, 800.0f);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

