/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import java.awt.Color;

public class Zagan {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Zagan");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background5.jpg");
        PlanetAPI zagan_star = system.initStar("zagan", "star_white", 700.0f, 600.0f, 17.0f, 1.5f, 5.5f);
        system.setLightColor(new Color(235, 255, 240));
        PlanetAPI geburah = system.addPlanet("geburah", (SectorEntityToken)zagan_star, "Geburah", "lava", 0.0f, 110.0f, 2500.0f, 80.0f);
        geburah.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        geburah.getSpec().setGlowColor(new Color(255, 140, 10, 200));
        geburah.getSpec().setUseReverseLightForGlow(true);
        geburah.applySpecChanges();
        system.addAsteroidBelt((SectorEntityToken)zagan_star, 90, 3650.0f, 500.0f, 150.0f, 300.0f, "asteroid_belt", "Shoals of Perdition");
        system.addRingBand((SectorEntityToken)zagan_star, "misc", "rings_asteroids0", 256.0f, 3, Color.white, 256.0f, 3600.0f, 295.0f, null, null);
        system.addRingBand((SectorEntityToken)zagan_star, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 3720.0f, 305.0f, null, null);
        PlanetAPI mazalot = system.addPlanet("mazalot", (SectorEntityToken)zagan_star, "Mazalot", "arid", 180.0f, 165.0f, 5500.0f, 220.0f);
        mazalot.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "sindria"));
        mazalot.getSpec().setGlowColor(new Color(240, 175, 200, 255));
        mazalot.getSpec().setPitch(10.0f);
        mazalot.getSpec().setUseReverseLightForGlow(true);
        mazalot.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "terran_eccentric"));
        mazalot.getSpec().setPlanetColor(new Color(255, 230, 150, 255));
        mazalot.applySpecChanges();
        mazalot.setCustomDescriptionId("planet_mazalot");
        SectorEntityToken mazalot_magfield = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(mazalot.getRadius() + 150.0f, (mazalot.getRadius() + 150.0f) / 2.0f, (SectorEntityToken)mazalot, mazalot.getRadius() + 50.0f, mazalot.getRadius() + 50.0f + 200.0f, new Color(50, 20, 100, 50), 0.15f, new Color[]{new Color(90, 180, 40), new Color(130, 145, 90), new Color(165, 110, 145), new Color(95, 55, 160), new Color(45, 0, 130), new Color(20, 0, 130), new Color(10, 0, 150)}));
        mazalot_magfield.setCircularOrbit((SectorEntityToken)mazalot, 0.0f, 0.0f, 100.0f);
        PlanetAPI tiferet = system.addPlanet("tiferet", (SectorEntityToken)mazalot, "Tiferet", "barren-bombarded", 0.0f, 75.0f, 600.0f, 55.0f);
        tiferet.getSpec().setPitch(-30.0f);
        tiferet.getSpec().setTexture(Global.getSettings().getSpriteName("planets", "barren02"));
        tiferet.getSpec().setPlanetColor(new Color(210, 230, 255, 255));
        tiferet.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "aurorae"));
        tiferet.getSpec().setGlowColor(new Color(50, 230, 255, 155));
        tiferet.getSpec().setUseReverseLightForGlow(true);
        tiferet.applySpecChanges();
        CustomCampaignEntityAPI relay = system.addCustomEntity("mazalot_relay", "Mazalot \u901a\u8baf\u5668", "comm_relay", "persean");
        relay.setCircularOrbitPointingDown(system.getEntityById("zagan"), 120.0f, 5500.0f, 220.0f);
        CustomCampaignEntityAPI gate = system.addCustomEntity("mazalot_gate", "Mazalot \u4e4b\u95e8", "inactive_gate", null);
        gate.setCircularOrbit(system.getEntityById("zagan"), 240.0f, 5500.0f, 220.0f);
        PlanetAPI melikah = system.addPlanet("melikah", (SectorEntityToken)zagan_star, "Melikah", "gas_giant", 0.0f, 350.0f, 7800.0f, 400.0f);
        melikah.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "banded"));
        melikah.getSpec().setGlowColor(new Color(255, 20, 200, 55));
        melikah.getSpec().setAtmosphereThickness(0.2f);
        melikah.getSpec().setUseReverseLightForGlow(true);
        melikah.getSpec().setPitch(-30.0f);
        melikah.getSpec().setTilt(20.0f);
        melikah.getSpec().setPlanetColor(new Color(200, 55, 240, 255));
        melikah.applySpecChanges();
        SectorEntityToken melikah_magfield = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(mazalot.getRadius() + 150.0f, (melikah.getRadius() + 150.0f) / 2.0f, (SectorEntityToken)melikah, melikah.getRadius() + 50.0f, melikah.getRadius() + 50.0f + 200.0f, new Color(50, 20, 100, 50), 0.3f, new Color[]{new Color(90, 180, 40), new Color(130, 145, 90), new Color(165, 110, 145), new Color(95, 55, 160), new Color(45, 0, 130), new Color(20, 0, 130), new Color(10, 0, 150)}));
        melikah_magfield.setCircularOrbit((SectorEntityToken)melikah, 0.0f, 0.0f, 100.0f);
        PlanetAPI hikmah = system.addPlanet("hikmah", (SectorEntityToken)melikah, "Hikmah", "toxic_cold", 0.0f, 95.0f, 750.0f, 30.0f);
        hikmah.getSpec().setAtmosphereThickness(0.2f);
        hikmah.getSpec().setUseReverseLightForGlow(true);
        hikmah.applySpecChanges();
        PlanetAPI ilm = system.addPlanet("ilm", (SectorEntityToken)melikah, "Ilm", "cryovolcanic", 0.0f, 75.0f, 1000.0f, 40.0f);
        ilm.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "volturn"));
        ilm.getSpec().setGlowColor(new Color(0, 255, 150, 255));
        ilm.getSpec().setUseReverseLightForGlow(true);
        ilm.applySpecChanges();
        ilm.setCustomDescriptionId("planet_ilm");
        SectorEntityToken nebula1 = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("   x    xx x xxxxxxxx xx xxx      x ", 6, 6, "terrain", "nebula", 4, 4, null));
        nebula1.getLocation().set(melikah.getLocation().x + 1000.0f, melikah.getLocation().y);
        nebula1.setCircularOrbit((SectorEntityToken)zagan_star, 60.0f, 7800.0f, 500.0f);
        SectorEntityToken nebula2 = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("  x x  xxx     xx xxxxxx  xx   x xx ", 6, 6, "terrain", "nebula", 4, 4, null));
        nebula2.getLocation().set(melikah.getLocation().x - 1000.0f, melikah.getLocation().y);
        nebula2.setCircularOrbit((SectorEntityToken)zagan_star, 300.0f, 7800.0f, 500.0f);
        PlanetAPI yesod = system.addPlanet("yesod", (SectorEntityToken)zagan_star, "Yesod", "rocky_ice", 180.0f, 115.0f, 9500.0f, 580.0f);
        yesod.setCustomDescriptionId("planet_yesod");
        JumpPointAPI jumpPoint2 = Global.getFactory().createJumpPoint("yesod_jump", "Yesod \u8df3\u8dc3\u70b9");
        jumpPoint2.setCircularOrbit((SectorEntityToken)zagan_star, 240.0f, 9500.0f, 580.0f);
        jumpPoint2.setRelatedPlanet((SectorEntityToken)yesod);
        system.addEntity((SectorEntityToken)jumpPoint2);
        float radiusAfter = StarSystemGenerator.addOrbitingEntities((StarSystemAPI)system, (SectorEntityToken)zagan_star, (StarAge)StarAge.AVERAGE, (int)1, (int)3, (float)11250.0f, (int)4, (boolean)true);
        StarSystemGenerator.addSystemwideNebula((StarSystemAPI)system, (StarAge)StarAge.AVERAGE);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

