/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.alliances.Alliance;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AllianceManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(AllianceManager.class);
    protected static AllianceManager allianceManager;
    protected static final String MANAGER_MAP_KEY = "exerelin_allianceManager";
    protected static final String ALLIANCE_NAMES_FILE = "data/config/exerelin/allianceNames.json";
    protected static final float MIN_ALIGNMENT_FOR_NEW_ALLIANCE = 1.0f;
    public static final float MIN_ALIGNMENT_TO_JOIN_ALLIANCE = 0.0f;
    protected static final float MIN_RELATIONSHIP_TO_JOIN;
    protected static final float MIN_RELATIONSHIP_TO_STAY;
    protected static final float JOIN_CHANCE_MULT = 0.7f;
    protected static final float JOIN_CHANCE_MULT_PER_MEMBER = 0.8f;
    protected static final float FORM_CHANCE_MULT = 0.6f;
    protected static final float JOIN_CHANCE_FAIL_PER_NEW_ENEMY = 0.4f;
    protected static final List<String> INVALID_FACTIONS;
    public static final float HOSTILE_THRESHOLD;
    protected static Map<Alliance.Alignment, List<String>> allianceNamesByAlignment;
    protected static Map<Alliance.Alignment, List<String>> alliancePrefixesByAlignment;
    protected static List<String> allianceNameCommonPrefixes;
    protected final Set<Alliance> alliances = new HashSet<Alliance>();
    protected final Map<String, Alliance> alliancesByName = new HashMap<String, Alliance>();
    protected final Map<String, Alliance> alliancesById = new HashMap<String, Alliance>();
    protected final Map<String, Alliance> alliancesByFactionId = new HashMap<String, Alliance>();
    protected float daysElapsed = 0.0f;
    protected final IntervalUtil tracker;
    protected static SectorEntityToken playerInteractionTarget;

    public AllianceManager() {
        super(true);
        float interval = ExerelinConfig.allianceFormationInterval;
        this.tracker = new IntervalUtil(interval * 0.8f, interval * 1.2f);
    }

    public static void loadAllianceNames() {
        try {
            JSONObject nameConfig = Global.getSettings().loadJSON(ALLIANCE_NAMES_FILE);
            JSONObject namesByAlignment = nameConfig.getJSONObject("namesByAlignment");
            JSONObject namePrefixes = nameConfig.getJSONObject("prefixes");
            JSONArray namePrefixesCommon = namePrefixes.getJSONArray("common");
            allianceNameCommonPrefixes = ExerelinUtils.JSONArrayToArrayList(namePrefixesCommon);
            for (Alliance.Alignment alignment : Alliance.Alignment.values()) {
                ArrayList<String> names = ExerelinUtils.JSONArrayToArrayList(namesByAlignment.getJSONArray(alignment.toString().toLowerCase(Locale.ROOT)));
                allianceNamesByAlignment.put(alignment, names);
                ArrayList<String> prefixes = ExerelinUtils.JSONArrayToArrayList(namePrefixes.getJSONArray(alignment.toString().toLowerCase(Locale.ROOT)));
                alliancePrefixesByAlignment.put(alignment, prefixes);
            }
        }
        catch (IOException | JSONException ex) {
            Global.getLogger(AllianceManager.class).log((Priority)Level.ERROR, (Object)ex);
        }
    }

    public static Alliance.Alignment getBestAlignment(String factionId, String otherFactionId) {
        float bestAlignmentValue = 0.0f;
        ArrayList<Alliance.Alignment> bestAlignments = new ArrayList<Alliance.Alignment>();
        ExerelinFactionConfig config1 = ExerelinConfig.getExerelinFactionConfig(factionId);
        ExerelinFactionConfig config2 = ExerelinConfig.getExerelinFactionConfig(otherFactionId);
        for (Alliance.Alignment alignment : Alliance.Alignment.values()) {
            float sum;
            float alignment1 = 0.0f;
            float alignment2 = 0.0f;
            if (config1 != null) {
                alignment1 = config1.alignments.get((Object)alignment).floatValue();
            }
            if (config2 != null) {
                alignment2 = config2.alignments.get((Object)alignment).floatValue();
            }
            if ((sum = alignment1 + alignment2) < 1.0f && !ExerelinConfig.ignoreAlignmentForAlliances) continue;
            if (sum > bestAlignmentValue) {
                bestAlignments.clear();
                bestAlignmentValue = sum;
                bestAlignments.add(alignment);
                continue;
            }
            if (sum != bestAlignmentValue) continue;
            bestAlignments.add(alignment);
        }
        if (!bestAlignments.isEmpty()) {
            return (Alliance.Alignment)((Object)ExerelinUtils.getRandomListElement(bestAlignments));
        }
        return null;
    }

    public static float getAlignmentCompatibilityWithAlliance(String factionId, Alliance alliance) {
        if (alliance == null) {
            return 0.0f;
        }
        float value = 0.0f;
        ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (config != null && config.alignments != null) {
            log.info((Object)("Checking alliance join validity for faction " + factionId + ", alliance " + alliance.getName()));
            Alliance.Alignment align = alliance.getAlignment();
            if (config.alignments.containsKey((Object)align)) {
                value = config.alignments.get((Object)align).floatValue();
            }
        }
        return value;
    }

    public static Alliance createAlliance(String member1, String member2, Alliance.Alignment type) {
        return AllianceManager.createAlliance(member1, member2, type, null);
    }

    public static Alliance createAlliance(String member1, String member2, Alliance.Alignment type, String name) {
        String systemName;
        if (allianceManager == null) {
            return null;
        }
        Alliance alliance1 = AllianceManager.allianceManager.alliancesByFactionId.get(member1);
        Alliance alliance2 = AllianceManager.allianceManager.alliancesByFactionId.get(member2);
        if (alliance1 != null && alliance2 != null) {
            log.error((Object)"Attempt to form alliance with two factions who are already in an alliance");
            return null;
        }
        if (alliance1 != null) {
            allianceManager.joinAlliance(member2, alliance1);
            return alliance1;
        }
        if (alliance2 != null) {
            allianceManager.joinAlliance(member1, alliance2);
            return alliance2;
        }
        FactionAPI memberFaction1 = Global.getSector().getFaction(member1);
        FactionAPI memberFaction2 = Global.getSector().getFaction(member2);
        if (type == null) {
            type = (Alliance.Alignment)((Object)ExerelinUtils.getRandomArrayElement((Object[])Alliance.Alignment.values()));
        }
        float pop1 = 0.0f;
        float pop2 = 0.0f;
        ArrayList<String> namePrefixes = new ArrayList<String>(allianceNameCommonPrefixes);
        log.info((Object)("Getting name prefixes of alliance type " + (Object)((Object)type)));
        if (!alliancePrefixesByAlignment.containsKey((Object)type)) {
            log.error((Object)("Missing name prefixes for alliance type " + (Object)((Object)type)));
        } else {
            namePrefixes.addAll((Collection<String>)alliancePrefixesByAlignment.get((Object)type));
        }
        if (namePrefixes.isEmpty()) {
            log.error((Object)"Missing name prefixes");
            namePrefixes.add("Common");
        }
        List<MarketAPI> markets = ExerelinUtilsFaction.getFactionMarkets(member1);
        for (MarketAPI market : markets) {
            pop1 += (float)market.getSize();
            if (market.getPrimaryEntity().isInHyperspace()) continue;
            systemName = ((StarSystemAPI)market.getContainingLocation()).getBaseName();
            namePrefixes.add(systemName);
        }
        markets = ExerelinUtilsFaction.getFactionMarkets(member2);
        for (MarketAPI market : markets) {
            pop2 += (float)market.getSize();
            if (market.getPrimaryEntity().isInHyperspace()) continue;
            systemName = ((StarSystemAPI)market.getContainingLocation()).getBaseName();
            namePrefixes.add(systemName);
        }
        if (name == null || name.isEmpty()) {
            boolean validName;
            int tries = 0;
            namePrefixes.addAll((Collection<String>)alliancePrefixesByAlignment.get((Object)type));
            do {
                name = (String)ExerelinUtils.getRandomListElement(namePrefixes);
                List<String> alignmentNames = allianceNamesByAlignment.get((Object)type);
                boolean bl = validName = !AllianceManager.allianceManager.alliancesByName.containsKey(name = name + " " + (String)ExerelinUtils.getRandomListElement(alignmentNames));
            } while (!validName && ++tries < 25);
        }
        SectorAPI sector = Global.getSector();
        sector.getFaction(member1).ensureAtWorst(member2, RepLevel.FRIENDLY);
        Alliance alliance = new Alliance(name, type, member1, member2);
        AllianceManager.allianceManager.alliancesByFactionId.put(member1, alliance);
        AllianceManager.allianceManager.alliancesByFactionId.put(member2, alliance);
        AllianceManager.allianceManager.alliancesByName.put(name, alliance);
        AllianceManager.allianceManager.alliancesById.put(alliance.uuId, alliance);
        AllianceManager.allianceManager.alliances.add(alliance);
        alliance.createEvents(member1, member2);
        SectorManager.checkForVictory();
        return alliance;
    }

    public void joinAlliance(String factionId, Alliance alliance) {
        SectorAPI sector = Global.getSector();
        FactionAPI faction = sector.getFaction(factionId);
        FactionAPI firstMember = null;
        Iterator<String> iterator = alliance.getMembersCopy().iterator();
        if (iterator.hasNext()) {
            String memberId = iterator.next();
            firstMember = sector.getFaction(memberId);
        }
        if (firstMember == null) {
            log.error((Object)"Alliance does not exist");
            return;
        }
        boolean playerIsHostile = faction.isHostileTo("player");
        alliance.addMember(factionId);
        this.alliancesByFactionId.put(factionId, alliance);
        boolean playerWasHostile = faction.isHostileTo("player");
        if (playerIsHostile != playerWasHostile) {
            DiplomacyManager.printPlayerHostileStateMessage(faction, playerIsHostile);
        }
        alliance.reportEvent(factionId, null, alliance, "join");
        SectorManager.checkForVictory();
    }

    public void leaveAlliance(String factionId, Alliance alliance, boolean noEvent) {
        alliance.removeMember(factionId);
        this.alliancesByFactionId.remove(factionId);
        if (alliance.getMembersCopy().size() <= 1) {
            this.dissolveAlliance(alliance);
            return;
        }
        if (!noEvent) {
            alliance.reportEvent(factionId, null, alliance, "leave");
        }
        SectorManager.checkForVictory();
    }

    public void leaveAlliance(String factionId, Alliance alliance) {
        this.leaveAlliance(factionId, alliance, false);
    }

    public void dissolveAlliance(Alliance alliance) {
        if (!this.alliances.contains(alliance)) {
            return;
        }
        String randomMember = null;
        for (String member : alliance.getMembersCopy()) {
            this.alliancesByFactionId.remove(member);
            randomMember = member;
        }
        this.alliancesByName.remove(alliance.getName());
        this.alliances.remove(alliance);
        alliance.clearMembers();
        if (randomMember != null) {
            alliance.reportEvent(randomMember, null, alliance, "dissolved");
        }
        alliance.getEvent().setDone(true);
        SectorManager.checkForVictory();
    }

    public void tryMakeAlliance() {
        FactionAPI faction;
        SectorAPI sector = Global.getSector();
        ArrayList<String> liveFactionIds = SectorManager.getLiveFactionIdsCopy();
        Collections.shuffle(liveFactionIds);
        for (String factionId : liveFactionIds) {
            if (this.alliancesByFactionId.containsKey(factionId) || ExerelinUtilsFaction.isPirateFaction(factionId) || INVALID_FACTIONS.contains(factionId)) continue;
            faction = sector.getFaction(factionId);
            for (String otherFactionId : liveFactionIds) {
                Alliance.Alignment bestAlignment;
                if (this.alliancesByFactionId.containsKey(otherFactionId) || otherFactionId.equals(factionId) || ExerelinUtilsFaction.isPirateFaction(otherFactionId) || INVALID_FACTIONS.contains(otherFactionId) || faction.isAtBest(otherFactionId, RepLevel.WELCOMING)) continue;
                float rel = faction.getRelationship(otherFactionId);
                if (Math.random() > (double)(rel * 0.6f) || (bestAlignment = AllianceManager.getBestAlignment(factionId, otherFactionId)) == null) continue;
                AllianceManager.createAlliance(factionId, otherFactionId, bestAlignment);
                return;
            }
        }
        for (String factionId : liveFactionIds) {
            if (this.alliancesByFactionId.containsKey(factionId) || INVALID_FACTIONS.contains(factionId)) continue;
            faction = sector.getFaction(factionId);
            WeightedRandomPicker picker = new WeightedRandomPicker();
            for (Alliance alliance : this.alliances) {
                float relationship;
                float value = AllianceManager.getAlignmentCompatibilityWithAlliance(factionId, alliance);
                if (value < 0.0f && !ExerelinConfig.ignoreAlignmentForAlliances || Math.random() > Math.pow(0.8f, alliance.getMembersCopy().size()) || (relationship = alliance.getAverageRelationshipWithFaction(factionId)) < MIN_RELATIONSHIP_TO_JOIN || Math.random() > (double)(relationship * 0.7f)) continue;
                boolean abort = false;
                for (String memberId : alliance.getMembersCopy()) {
                    if (!faction.isHostileTo(memberId)) continue;
                    abort = true;
                    break;
                }
                if (abort) continue;
                picker.add((Object)alliance, relationship * (value + 1.0f));
            }
            if (picker.isEmpty()) continue;
            this.joinAlliance(factionId, (Alliance)picker.pick());
            return;
        }
    }

    public void advance(float amount) {
        if (Global.getSector().isInNewGameAdvance()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.daysElapsed < ExerelinConfig.allianceGracePeriod) {
            this.daysElapsed += days;
            return;
        }
        this.tracker.advance(days);
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        float interval = ExerelinConfig.allianceFormationInterval;
        this.tracker.setInterval(interval * 0.8f, interval * 1.2f);
        this.tryMakeAlliance();
    }

    public boolean runWhilePaused() {
        return false;
    }

    public boolean isDone() {
        return false;
    }

    public static void remainInAllianceCheck(String factionId, String otherFactionId) {
        if (allianceManager == null) {
            return;
        }
        Alliance alliance1 = AllianceManager.allianceManager.alliancesByFactionId.get(factionId);
        Alliance alliance2 = AllianceManager.allianceManager.alliancesByFactionId.get(otherFactionId);
        if (alliance1 == null || alliance2 == null || alliance1 != alliance2) {
            return;
        }
        FactionAPI faction = Global.getSector().getFaction(factionId);
        if (faction.isHostileTo(otherFactionId)) {
            if (alliance1.getMembersCopy().size() <= 3) {
                allianceManager.dissolveAlliance(alliance1);
            } else {
                allianceManager.leaveAlliance(factionId, alliance1);
                allianceManager.leaveAlliance(otherFactionId, alliance1);
            }
        } else {
            boolean leave1 = false;
            boolean leave2 = false;
            int numLeavers = 0;
            float averageRel1 = alliance1.getAverageRelationshipWithFaction(factionId);
            float averageRel2 = alliance1.getAverageRelationshipWithFaction(otherFactionId);
            if (averageRel1 < MIN_RELATIONSHIP_TO_STAY) {
                leave1 = true;
                ++numLeavers;
            }
            if (averageRel2 < MIN_RELATIONSHIP_TO_STAY) {
                leave2 = true;
                ++numLeavers;
            }
            if (numLeavers == 2) {
                if (alliance1.getMembersCopy().size() <= 3) {
                    allianceManager.dissolveAlliance(alliance1);
                } else {
                    allianceManager.leaveAlliance(factionId, alliance1);
                    allianceManager.leaveAlliance(otherFactionId, alliance1);
                }
            } else if (leave1) {
                allianceManager.leaveAlliance(factionId, alliance1);
            } else if (leave2) {
                allianceManager.leaveAlliance(otherFactionId, alliance1);
            }
        }
    }

    public static void doAlliancePeaceStateChange(String faction1Id, String faction2Id, boolean isWar) {
        AllianceManager.doAlliancePeaceStateChange(faction1Id, faction2Id, AllianceManager.getFactionAlliance(faction1Id), AllianceManager.getFactionAlliance(faction2Id), isWar, new HashSet<String>());
    }

    public static void doAlliancePeaceStateChange(String faction1Id, String faction2Id, Alliance alliance1, Alliance alliance2, boolean isWar, Set<String> defyingFactions) {
        String party2;
        String party1;
        FactionAPI member;
        if (alliance1 == null && alliance2 == null) {
            return;
        }
        SectorAPI sector = Global.getSector();
        FactionAPI faction1 = sector.getFaction(faction1Id);
        FactionAPI faction2 = sector.getFaction(faction2Id);
        float delta = isWar ? -0.1f : 0.3f;
        RepLevel ensureAtBest = isWar ? RepLevel.HOSTILE : null;
        RepLevel ensureAtWorst = isWar ? null : RepLevel.INHOSPITABLE;
        RepLevel limit = faction1.getRelationshipLevel(faction2);
        boolean anyChanges = false;
        if (alliance1 != null) {
            for (String memberId : alliance1.getMembersCopy()) {
                if (defyingFactions.contains(memberId)) continue;
                member = sector.getFaction(memberId);
                if (alliance2 != null) {
                    for (String otherMemberId : alliance2.getMembersCopy()) {
                        if (defyingFactions.contains(otherMemberId)) continue;
                        FactionAPI otherMember = sector.getFaction(otherMemberId);
                        if (isWar && member.isHostileTo(otherMemberId) || !isWar && !member.isHostileTo(otherMemberId)) continue;
                        DiplomacyManager.adjustRelations(member, otherMember, delta, ensureAtBest, ensureAtWorst, limit, true);
                        anyChanges = true;
                    }
                    continue;
                }
                if (isWar && member.isHostileTo(faction2Id) || !isWar && !member.isHostileTo(faction2Id)) continue;
                DiplomacyManager.adjustRelations(member, faction2, delta, ensureAtBest, ensureAtWorst, limit, true);
                anyChanges = true;
            }
        } else if (alliance2 != null) {
            for (String memberId : alliance2.getMembersCopy()) {
                if (defyingFactions.contains(memberId)) continue;
                member = sector.getFaction(memberId);
                if (isWar && member.isHostileTo(faction1Id) || !isWar && !member.isHostileTo(faction1Id)) continue;
                DiplomacyManager.adjustRelations(member, faction1, delta, ensureAtBest, ensureAtWorst, limit, true);
                anyChanges = true;
            }
        }
        if (!anyChanges) {
            return;
        }
        String highlight1 = party1 = Misc.ucFirst((String)ExerelinUtilsFaction.getFactionShortName(faction1));
        if (alliance1 != null) {
            party1 = alliance1.getAllianceNameAndMembers();
            highlight1 = alliance1.getName();
        }
        String highlight2 = party2 = Misc.ucFirst((String)ExerelinUtilsFaction.getFactionShortName(faction2));
        if (alliance2 != null) {
            party2 = alliance2.getAllianceNameAndMembers();
            highlight2 = alliance2.getName();
        }
        String messageStr = isWar ? StringHelper.getString("exerelin_alliances", "joinsWarAgainst") : StringHelper.getString("exerelin_alliances", "makesPeaceWith");
        String highlightOrdered1 = highlight1;
        String highlightOrdered2 = highlight2;
        if (alliance1 == null) {
            messageStr = StringHelper.substituteToken(messageStr, "$factionOrAlliance1", party2);
            messageStr = StringHelper.substituteToken(messageStr, "$factionOrAlliance2", party1);
            highlightOrdered1 = highlight2;
            highlightOrdered2 = highlight1;
        } else {
            messageStr = StringHelper.substituteToken(messageStr, "$factionOrAlliance1", party1);
            messageStr = StringHelper.substituteToken(messageStr, "$factionOrAlliance2", party2);
        }
        Color highlightColor = Misc.getHighlightColor();
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        Alliance playerAlliance = AllianceManager.getFactionAlliance(playerAlignedFactionId);
        if (playerAlliance != null && (playerAlliance == alliance1 || playerAlliance == alliance2) || faction1.getId().equals(playerAlignedFactionId) || faction2.getId().equals(playerAlignedFactionId)) {
            highlightColor = isWar ? Misc.getNegativeHighlightColor() : Misc.getPositiveHighlightColor();
        }
        CampaignUIAPI ui = sector.getCampaignUI();
        ui.addMessage(messageStr, Color.WHITE, highlightOrdered1, highlightOrdered2, highlightColor, highlightColor);
        SectorManager.checkForVictory();
    }

    public static void setPlayerInteractionTarget(SectorEntityToken interactionTarget) {
        playerInteractionTarget = interactionTarget;
    }

    public static SectorEntityToken getPlayerInteractionTarget() {
        return playerInteractionTarget;
    }

    public static void joinAllianceStatic(String factionId, Alliance alliance) {
        if (allianceManager == null) {
            return;
        }
        allianceManager.joinAlliance(factionId, alliance);
    }

    public static void leaveAlliance(String factionId, boolean noEvent) {
        if (allianceManager == null) {
            return;
        }
        Alliance alliance = AllianceManager.allianceManager.alliancesByFactionId.get(factionId);
        if (alliance == null) {
            return;
        }
        allianceManager.leaveAlliance(factionId, alliance, noEvent);
    }

    public static List<Alliance> getAllianceList() {
        if (allianceManager == null) {
            return new ArrayList<Alliance>();
        }
        return new ArrayList<Alliance>(AllianceManager.allianceManager.alliances);
    }

    public static Alliance getAllianceByName(String allianceName) {
        if (allianceManager == null) {
            return null;
        }
        return AllianceManager.allianceManager.alliancesByName.get(allianceName);
    }

    public static Alliance getAllianceByUUID(String id) {
        if (allianceManager == null) {
            return null;
        }
        return AllianceManager.allianceManager.alliancesById.get(id);
    }

    public static Alliance getFactionAlliance(String factionId) {
        if (allianceManager == null) {
            return null;
        }
        return AllianceManager.allianceManager.alliancesByFactionId.get(factionId);
    }

    public static boolean areFactionsAllied(String factionId1, String factionId2) {
        if (factionId1.equals(factionId2)) {
            return true;
        }
        if (allianceManager == null) {
            return false;
        }
        Alliance alliance1 = AllianceManager.getFactionAlliance(factionId1);
        if (alliance1 == null) {
            return false;
        }
        Alliance alliance2 = AllianceManager.getFactionAlliance(factionId2);
        if (alliance2 == null) {
            return false;
        }
        return alliance1 == alliance2;
    }

    public static void renameAlliance(Alliance alliance, String newName) {
        if (allianceManager == null) {
            return;
        }
        if (alliance == null || newName == null) {
            throw new IllegalArgumentException("Alliance or new name is null");
        }
        String oldName = alliance.getName();
        if (AllianceManager.allianceManager.alliancesByName.containsKey(oldName)) {
            AllianceManager.allianceManager.alliancesByName.remove(oldName);
            AllianceManager.allianceManager.alliancesByName.put(newName, alliance);
        }
        alliance.setName(newName);
    }

    public static void setMemoryKeys(MemoryAPI memory, Alliance alliance) {
        memory.set("$isInAlliance", (Object)true, 0.0f);
        memory.set("$allianceId", (Object)alliance.uuId, 0.0f);
        memory.set("$allianceName", (Object)alliance.getName(), 0.0f);
    }

    public static void unsetMemoryKeys(MemoryAPI memory) {
        memory.set("$isInAlliance", (Object)false, 0.0f);
        memory.unset("$allianceId");
        memory.unset("$allianceName");
    }

    public static AllianceManager create() {
        Map data = Global.getSector().getPersistentData();
        allianceManager = (AllianceManager)((Object)data.get(MANAGER_MAP_KEY));
        if (allianceManager != null) {
            return allianceManager;
        }
        allianceManager = new AllianceManager();
        data.put(MANAGER_MAP_KEY, allianceManager);
        return allianceManager;
    }

    public static void printAllianceList(TextPanelAPI text) {
        List<Alliance> alliances = AllianceManager.getAllianceList();
        Collections.sort(alliances, new AllianceComparator());
        Color hl = Misc.getHighlightColor();
        text.addParagraph(StringHelper.getStringAndSubstituteToken("exerelin_alliances", "numAlliances", "$numAlliances", alliances.size() + ""));
        text.highlightInLastPara(hl, new String[]{"" + alliances.size()});
        text.setFontSmallInsignia();
        text.addParagraph("-----------------------------------------------------------------------------");
        for (Alliance alliance : alliances) {
            String allianceName = alliance.getName();
            String allianceString = alliance.getAllianceNameAndMembers();
            text.addParagraph(allianceString);
            text.highlightInLastPara(hl, new String[]{allianceName});
        }
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
    }

    static {
        MIN_RELATIONSHIP_TO_JOIN = RepLevel.FRIENDLY.getMin();
        MIN_RELATIONSHIP_TO_STAY = RepLevel.WELCOMING.getMin();
        INVALID_FACTIONS = Arrays.asList("templars", "independent", "player_npc");
        HOSTILE_THRESHOLD = -RepLevel.HOSTILE.getMin();
        allianceNamesByAlignment = new HashMap<Alliance.Alignment, List<String>>();
        alliancePrefixesByAlignment = new HashMap<Alliance.Alignment, List<String>>();
        playerInteractionTarget = null;
        AllianceManager.loadAllianceNames();
    }

    public static class AllianceComparator
    implements Comparator<Alliance> {
        @Override
        public int compare(Alliance alliance1, Alliance alliance2) {
            int size2;
            int size1 = alliance1.getMembersCopy().size();
            if (size1 > (size2 = alliance2.getMembersCopy().size())) {
                return -1;
            }
            if (size2 > size1) {
                return 1;
            }
            return 0;
        }
    }
}

