/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.ExerelinReputationAdjustmentResult;
import exerelin.campaign.SectorManager;
import exerelin.campaign.events.AgentDestabilizeMarketEventForCondition;
import exerelin.campaign.events.SecurityAlertEvent;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;

public class CovertOpsManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(CovertOpsManager.class);
    private static CovertOpsManager covertWarfareManager;
    private static final String MANAGER_MAP_KEY = "exerelin_covertWarfareManager";
    private static final String CONFIG_FILE = "data/config/exerelin/agentConfig.json";
    protected static final float NPC_EFFECT_MULT = 1.5f;
    protected static final ExerelinReputationAdjustmentResult NO_EFFECT;
    private static Map<String, Object> config;
    public static final List<String> DISALLOWED_FACTIONS;
    private static float baseInterval;
    private float interval = baseInterval;
    private final IntervalUtil intervalUtil = new IntervalUtil(this.interval * 0.75f, this.interval * 1.25f);

    private static void loadSettings() throws IOException, JSONException {
        JSONObject configJson = Global.getSettings().loadJSON(CONFIG_FILE);
        config = ExerelinUtils.jsonToMap(configJson);
        baseInterval = (float)configJson.optDouble("eventFrequency", 15.0);
    }

    public CovertOpsManager() {
        super(true);
    }

    public void handleNpcCovertActions() {
        log.info((Object)"Starting covert warfare event creation");
        SectorAPI sector = Global.getSector();
        WeightedRandomPicker agentFactionPicker = new WeightedRandomPicker();
        WeightedRandomPicker targetFactionPicker = new WeightedRandomPicker();
        WeightedRandomPicker marketPicker = new WeightedRandomPicker();
        WeightedRandomPicker actionPicker = new WeightedRandomPicker();
        ArrayList<FactionAPI> factions = new ArrayList<FactionAPI>();
        for (String factionId : SectorManager.getLiveFactionIdsCopy()) {
            factions.add(sector.getFaction(factionId));
        }
        List markets = sector.getEconomy().getMarketsCopy();
        actionPicker.add((Object)CovertActionType.RAISE_RELATIONS, 1.2f);
        actionPicker.add((Object)CovertActionType.LOWER_RELATIONS, 1.5f);
        actionPicker.add((Object)CovertActionType.DESTABILIZE_MARKET, 1.25f);
        actionPicker.add((Object)CovertActionType.SABOTAGE_RESERVE, 1.25f);
        CovertActionType actionType = (CovertActionType)((Object)actionPicker.pick());
        int factionCount = 0;
        for (FactionAPI factionAPI : factions) {
            ExerelinFactionConfig factionConf;
            String factionId = factionAPI.getId();
            if (DISALLOWED_FACTIONS.contains(factionId) || ExerelinUtilsFaction.isPirateFaction(factionId) || !ExerelinConfig.followersAgents && factionId.equals("player_npc") || (factionConf = ExerelinConfig.getExerelinFactionConfig(factionId)) != null && !factionConf.allowAgentActions) continue;
            agentFactionPicker.add((Object)factionAPI);
            ++factionCount;
        }
        if (factionCount < 2) {
            return;
        }
        FactionAPI agentFaction = (FactionAPI)agentFactionPicker.pick();
        log.info((Object)("Trying action: " + actionType.name()));
        factionCount = 0;
        for (FactionAPI faction : factions) {
            String factionId = faction.getId();
            ExerelinFactionConfig factionConf = ExerelinConfig.getExerelinFactionConfig(factionId);
            if (factionConf != null && !factionConf.allowAgentActions || ExerelinUtilsFaction.isPirateFaction(factionId) || DISALLOWED_FACTIONS.contains(faction.getId()) || faction == agentFaction) continue;
            RepLevel repLevel = faction.getRelationshipLevel(agentFaction);
            float dominance = DiplomacyManager.getDominanceFactor(faction.getId());
            float weight = 1.0f;
            if (actionType == CovertActionType.RAISE_RELATIONS) {
                if (repLevel == RepLevel.FAVORABLE || repLevel == RepLevel.WELCOMING) {
                    weight = 1.0f;
                } else if (repLevel == RepLevel.NEUTRAL) {
                    weight = 1.5f;
                } else if (repLevel == RepLevel.SUSPICIOUS) {
                    weight = 2.0f;
                } else {
                    if (repLevel != RepLevel.INHOSPITABLE) continue;
                    weight = 3.0f;
                }
                weight *= 1.25f - dominance;
            } else if (actionType == CovertActionType.LOWER_RELATIONS) {
                if (repLevel == RepLevel.FAVORABLE) {
                    weight = 0.25f;
                } else if (repLevel == RepLevel.NEUTRAL) {
                    weight = 1.0f;
                } else if (repLevel == RepLevel.SUSPICIOUS) {
                    weight = 1.5f;
                } else if (repLevel == RepLevel.INHOSPITABLE) {
                    weight = 2.0f;
                } else if (repLevel == RepLevel.HOSTILE) {
                    weight = 2.5f;
                } else {
                    if (repLevel != RepLevel.VENGEFUL) continue;
                    weight = 3.0f;
                }
                weight *= 1.0f + dominance * 2.0f;
            } else if (actionType == CovertActionType.DESTABILIZE_MARKET || actionType == CovertActionType.DESTROY_FOOD || actionType == CovertActionType.SABOTAGE_RESERVE) {
                if (repLevel == RepLevel.INHOSPITABLE) {
                    weight = 1.0f;
                } else if (repLevel == RepLevel.HOSTILE) {
                    weight = 3.0f;
                } else {
                    if (repLevel != RepLevel.VENGEFUL) continue;
                    weight = 5.0f;
                }
                weight *= 1.0f + dominance;
            }
            if (ExerelinUtilsFaction.isPirateFaction(factionId)) {
                weight *= 0.25f;
            }
            if (weight <= 0.0f) continue;
            targetFactionPicker.add((Object)faction, weight);
            ++factionCount;
        }
        log.info((Object)("Number of target factions: " + factionCount));
        if (factionCount < 1 || actionType == CovertActionType.LOWER_RELATIONS && factionCount < 2) {
            return;
        }
        FactionAPI factionAPI = (FactionAPI)targetFactionPicker.pickAndRemove();
        FactionAPI thirdFaction = null;
        if (factionCount >= 2) {
            thirdFaction = (FactionAPI)targetFactionPicker.pickAndRemove();
        }
        log.info((Object)("Target faction: " + factionAPI.getDisplayName()));
        for (MarketAPI market : markets) {
            if (market.getFaction() != factionAPI) continue;
            marketPicker.add((Object)market);
        }
        MarketAPI market = (MarketAPI)marketPicker.pick();
        if (market == null) {
            log.info((Object)"No market available");
            return;
        }
        if (actionType == CovertActionType.RAISE_RELATIONS) {
            CovertOpsManager.agentRaiseRelations(market, agentFaction, factionAPI, false);
        } else if (actionType == CovertActionType.LOWER_RELATIONS) {
            CovertOpsManager.agentLowerRelations(market, agentFaction, factionAPI, thirdFaction, false);
        } else if (actionType == CovertActionType.DESTABILIZE_MARKET) {
            CovertOpsManager.agentDestabilizeMarket(market, agentFaction, factionAPI, false);
        } else if (actionType == CovertActionType.SABOTAGE_RESERVE) {
            CovertOpsManager.saboteurSabotageReserve(market, agentFaction, factionAPI, false);
        } else if (actionType == CovertActionType.DESTROY_FOOD) {
            CovertOpsManager.saboteurDestroyFood(market, agentFaction, factionAPI, false);
        }
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.intervalUtil.advance(days);
        if (!this.intervalUtil.intervalElapsed()) {
            return;
        }
        this.handleNpcCovertActions();
        this.interval = this.getCovertWarfareInterval();
        this.intervalUtil.setInterval(this.interval * 0.75f, this.interval * 1.25f);
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public float getCovertWarfareInterval() {
        int numFactions = SectorManager.getLiveFactionIdsCopy().size() - 2;
        if (numFactions < 0) {
            numFactions = 0;
        }
        return baseInterval * (float)Math.pow(0.95, numFactions);
    }

    public static void modifyAlertLevel(MarketAPI market, float amount) {
        SectorAPI sector = Global.getSector();
        CampaignEventPlugin eventSuper = sector.getEventManager().getOngoingEvent(new CampaignEventTarget(market), "exerelin_security_alert");
        if (eventSuper == null) {
            eventSuper = sector.getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_security_alert", null);
        }
        SecurityAlertEvent event = (SecurityAlertEvent)eventSuper;
        event.increaseAlertLevel(amount);
    }

    public static float getAlertLevel(MarketAPI market) {
        if (market.getId().equals("fake_market")) {
            return 0.0f;
        }
        SectorAPI sector = Global.getSector();
        CampaignEventPlugin eventSuper = sector.getEventManager().getOngoingEvent(new CampaignEventTarget(market), "exerelin_security_alert");
        if (eventSuper == null) {
            return 0.0f;
        }
        SecurityAlertEvent event = (SecurityAlertEvent)eventSuper;
        return event.getAlertLevel();
    }

    public static CovertActionResult covertActionRoll(double sChance, double sDetectChance, double fDetectChance, boolean playerInvolved) {
        return CovertOpsManager.covertActionRoll(sChance, sDetectChance, fDetectChance, false, null, playerInvolved);
    }

    public static CovertActionResult covertActionRoll(double sChance, double sDetectChance, double fDetectChance, boolean useAlertLevel, MarketAPI market, boolean playerInvolved) {
        CampaignFleetAPI playerFleet;
        CovertActionResult result = null;
        if (useAlertLevel) {
            sChance *= (double)(1.0f - CovertOpsManager.getAlertLevel(market));
        }
        if (playerInvolved && !(playerFleet = Global.getSector().getPlayerFleet()).isTransponderOn()) {
            sDetectChance *= 0.5;
            fDetectChance *= 0.75;
        }
        if (Math.random() < sChance) {
            result = CovertActionResult.SUCCESS;
            if (Math.random() < sDetectChance) {
                result = CovertActionResult.SUCCESS_DETECTED;
            }
        } else {
            result = CovertActionResult.FAILURE;
            if (Math.random() < fDetectChance) {
                result = CovertActionResult.FAILURE_DETECTED;
            }
        }
        return result;
    }

    public static Map<String, Object> makeEventParams(FactionAPI agentFaction, CovertActionResult result, ExerelinReputationAdjustmentResult repResult, boolean playerInvolved) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("agentFaction", agentFaction);
        params.put("result", (Object)result);
        params.put("playerInvolved", playerInvolved);
        params.put("repEffect", Float.valueOf(repResult.delta));
        params.put("repResult", (Object)repResult);
        return params;
    }

    public static CovertActionResult agentRaiseRelations(MarketAPI market, FactionAPI agentFaction, FactionAPI targetFaction, boolean playerInvolved) {
        log.info((Object)"Agent trying to raise relations");
        CovertActionResult result = CovertOpsManager.covertActionRoll((Double)config.get("agentRaiseRelationsSuccessChance"), 0.0, (Double)config.get("agentRaiseRelationsDetectionChanceFail"), playerInvolved);
        if (result.isSucessful()) {
            float effectMin = (float)((Double)config.get("agentRaiseRelationsEffectMin")).doubleValue();
            float effectMax = (float)((Double)config.get("agentRaiseRelationsEffectMax")).doubleValue();
            float effect = MathUtils.getRandomNumberInRange((float)effectMin, (float)effectMax);
            if (!playerInvolved) {
                effect *= 1.5f;
            }
            ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, effect, null, null, null);
            if (Math.abs(repResult.delta) >= 0.01f || playerInvolved) {
                Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, repResult, playerInvolved);
                Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_raise_relations", params);
            }
        } else if (result.isDetected()) {
            float effectMin = (float)((Double)config.get("agentRaiseRelationsRepLossOnDetectionMin")).doubleValue();
            float effectMax = (float)((Double)config.get("agentRaiseRelationsRepLossOnDetectionMax")).doubleValue();
            float effect = -MathUtils.getRandomNumberInRange((float)effectMin, (float)effectMax);
            if (!playerInvolved) {
                effect *= 1.5f;
            }
            ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, effect, RepLevel.FAVORABLE, null, RepLevel.INHOSPITABLE);
            if (Math.abs(repResult.delta) >= 0.01f || playerInvolved) {
                Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, repResult, playerInvolved);
                Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_raise_relations", params);
            }
        } else if (playerInvolved) {
            Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, NO_EFFECT, playerInvolved);
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_raise_relations", params);
        }
        return result;
    }

    public static CovertActionResult agentLowerRelations(MarketAPI market, FactionAPI agentFaction, FactionAPI targetFaction, FactionAPI thirdFaction, boolean playerInvolved) {
        log.info((Object)"Agent trying to lower relations");
        CovertActionResult result = CovertOpsManager.covertActionRoll((Double)config.get("agentLowerRelationsSuccessChance"), 0.0, (Double)config.get("agentLowerRelationsDetectionChanceFail"), playerInvolved);
        if (result.isSucessful()) {
            float effectMin = (float)((Double)config.get("agentLowerRelationsEffectMin")).doubleValue();
            float effectMax = (float)((Double)config.get("agentLowerRelationsEffectMax")).doubleValue();
            float effect = -MathUtils.getRandomNumberInRange((float)effectMin, (float)effectMax);
            if (!playerInvolved) {
                effect *= 1.5f;
            }
            ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(thirdFaction, targetFaction, effect, null, null, RepLevel.HOSTILE);
            if (Math.abs(repResult.delta) >= 0.01f || playerInvolved) {
                Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, repResult, playerInvolved);
                params.put("thirdFaction", thirdFaction);
                params.put("repEffect2", Float.valueOf(effect));
                Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_lower_relations", params);
            }
        } else if (result.isDetected()) {
            float effectMin = (float)((Double)config.get("agentLowerRelationsRepLossOnDetectionMin")).doubleValue();
            float effectMax = (float)((Double)config.get("agentLowerRelationsRepLossOnDetectionMax")).doubleValue();
            float effect = -MathUtils.getRandomNumberInRange((float)effectMin, (float)effectMax);
            if (!playerInvolved) {
                effect *= 1.5f;
            }
            ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, effect, RepLevel.NEUTRAL, null, RepLevel.HOSTILE);
            ExerelinReputationAdjustmentResult repResult2 = DiplomacyManager.adjustRelations(agentFaction, thirdFaction, effect, RepLevel.NEUTRAL, null, RepLevel.HOSTILE);
            if (Math.abs(repResult.delta) >= 0.01f || Math.abs(repResult2.delta) >= 0.01f || playerInvolved) {
                Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, repResult, playerInvolved);
                params.put("thirdFaction", thirdFaction);
                params.put("repResult2", (Object)repResult2);
                params.put("repEffect2", Float.valueOf(repResult2.delta));
                Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_lower_relations", params);
            }
        } else if (playerInvolved) {
            Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, NO_EFFECT, playerInvolved);
            params.put("thirdFaction", thirdFaction);
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_lower_relations", params);
        }
        return result;
    }

    public static CovertActionResult agentDestabilizeMarket(MarketAPI market, FactionAPI agentFaction, FactionAPI targetFaction, boolean playerInvolved) {
        log.info((Object)"Agent trying to destablize market");
        CovertActionResult result = CovertOpsManager.covertActionRoll((Double)config.get("agentDestabilizeSuccessChance"), (Double)config.get("agentDestabilizeDetectionChance"), (Double)config.get("agentDestabilizeDetectionChanceFail"), true, market, playerInvolved);
        if (result.isSucessful()) {
            SectorAPI sector = Global.getSector();
            CampaignEventPlugin eventSuper = sector.getEventManager().getOngoingEvent(new CampaignEventTarget(market), "exerelin_agent_destabilize_market_for_condition");
            if (eventSuper == null) {
                eventSuper = sector.getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_destabilize_market_for_condition", null);
            }
            AgentDestabilizeMarketEventForCondition event = (AgentDestabilizeMarketEventForCondition)eventSuper;
            int currentPenalty = event.getStabilityPenalty();
            int delta = 1;
            if (currentPenalty < 2) {
                delta = 2;
            }
            if (!playerInvolved) {
                delta = Math.round((float)delta * 1.5f);
            }
            event.increaseStabilityPenalty(delta);
            Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, NO_EFFECT, playerInvolved);
            params.put("stabilityPenalty", delta);
            if (result.isDetected()) {
                float repMin = (float)((Double)config.get("agentDestabilizeRepLossOnDetectionMin")).doubleValue();
                float repMax = (float)((Double)config.get("agentDestabilizeRepLossOnDetectionMax")).doubleValue();
                float rep = -MathUtils.getRandomNumberInRange((float)repMin, (float)repMax);
                ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, rep, RepLevel.INHOSPITABLE, null, null);
                params.put("repResult", (Object)repResult);
                params.put("repEffect", Float.valueOf(repResult.delta));
                params.put("stage", (Object)result);
            }
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_destabilize_market", params);
            market.updatePrices();
        } else if (result.isDetected()) {
            float repMin = (float)((Double)config.get("agentDestabilizeRepLossOnDetectionMin")).doubleValue();
            float repMax = (float)((Double)config.get("agentDestabilizeRepLossOnDetectionMax")).doubleValue();
            float rep = -MathUtils.getRandomNumberInRange((float)repMin, (float)repMax);
            ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, rep, RepLevel.INHOSPITABLE, null, RepLevel.HOSTILE);
            if (Math.abs(repResult.delta) >= 0.01f || playerInvolved) {
                Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, repResult, playerInvolved);
                Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_destabilize_market", params);
            }
        } else if (playerInvolved) {
            Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, NO_EFFECT, playerInvolved);
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_agent_destabilize_market", params);
        }
        CovertOpsManager.modifyAlertLevel(market, (float)((Double)config.get("agentDestabilizeSecurityLevelRise")).doubleValue());
        return result;
    }

    public static CovertActionResult saboteurSabotageReserve(MarketAPI market, FactionAPI agentFaction, FactionAPI targetFaction, boolean playerInvolved) {
        log.info((Object)"Saboteur attacking reserve fleet");
        CovertActionResult result = CovertOpsManager.covertActionRoll((Double)config.get("sabotageReserveSuccessChance"), (Double)config.get("sabotageReserveDetectionChance"), (Double)config.get("sabotageReserveDetectionChanceFail"), true, market, playerInvolved);
        if (result.isSucessful()) {
            SectorAPI sector = Global.getSector();
            float effectMin = (float)((Double)config.get("sabotageReserveEffectMin")).doubleValue();
            float effectMax = (float)((Double)config.get("sabotageReserveEffectMax")).doubleValue();
            float effect = -MathUtils.getRandomNumberInRange((float)effectMin, (float)effectMax);
            if (!playerInvolved) {
                effect *= 1.5f;
            }
            float delta = ResponseFleetManager.modifyReserveSize(market, effect);
            Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, NO_EFFECT, playerInvolved);
            params.put("reserveDamage", Float.valueOf(-delta));
            if (Math.random() <= (Double)config.get("sabotageReserveDetectionChance")) {
                float repMin = (float)((Double)config.get("sabotageReserveRepLossOnDetectionMin")).doubleValue();
                float repMax = (float)((Double)config.get("sabotageReserveRepLossOnDetectionMax")).doubleValue();
                float rep = -MathUtils.getRandomNumberInRange((float)repMin, (float)repMax);
                ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, rep, RepLevel.INHOSPITABLE, null, null);
                params.put("repResult", (Object)repResult);
                params.put("repEffect", Float.valueOf(repResult.delta));
                params.put("stage", (Object)result);
            }
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_saboteur_sabotage_reserve", params);
        } else if (result.isDetected()) {
            float repMin = (float)((Double)config.get("sabotageReserveRepLossOnDetectionMin")).doubleValue();
            float repMax = (float)((Double)config.get("sabotageReserveRepLossOnDetectionMax")).doubleValue();
            float rep = -MathUtils.getRandomNumberInRange((float)repMin, (float)repMax);
            ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, rep, RepLevel.INHOSPITABLE, null, RepLevel.HOSTILE);
            if (Math.abs(repResult.delta) >= 0.01f || playerInvolved) {
                Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, repResult, playerInvolved);
                Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_saboteur_sabotage_reserve", params);
            }
        } else if (playerInvolved) {
            Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, NO_EFFECT, playerInvolved);
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_saboteur_sabotage_reserve", params);
        }
        CovertOpsManager.modifyAlertLevel(market, (float)((Double)config.get("sabotageReserveSecurityLevelRise")).doubleValue());
        return result;
    }

    public static CovertActionResult saboteurDestroyFood(MarketAPI market, FactionAPI agentFaction, FactionAPI targetFaction, boolean playerInvolved) {
        log.info((Object)"Saboteur destroying food");
        CovertActionResult result = CovertOpsManager.covertActionRoll((Double)config.get("sabotageDestroyFoodSuccessChance"), (Double)config.get("sabotageDestroyFoodDetectionChance"), (Double)config.get("sabotageDestroyFoodDetectionChanceFail"), true, market, playerInvolved);
        if (result.isSucessful()) {
            float effectMin = (float)((Double)config.get("sabotageDestroyFoodEffectMin")).doubleValue();
            float effectMax = (float)((Double)config.get("sabotageDestroyFoodEffectMax")).doubleValue();
            float effect = MathUtils.getRandomNumberInRange((float)effectMin, (float)effectMax);
            if (!playerInvolved) {
                effect *= 1.5f;
            }
            float foodDestroyed = (float)Math.pow(market.getSize(), 2.0) * effect;
            CommodityOnMarketAPI food = market.getCommodityData("food");
            float before = food.getStockpile();
            food.removeFromStockpile(foodDestroyed);
            float after = food.getStockpile();
            log.info((Object)("Remaining food: " + food.getStockpile()));
            Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, NO_EFFECT, playerInvolved);
            params.put("foodDestroyed", Float.valueOf(before - after));
            if (result.isDetected()) {
                float repMin = (float)((Double)config.get("sabotageDestroyFoodRepLossOnDetectionMin")).doubleValue();
                float repMax = (float)((Double)config.get("sabotageDestroyFoodRepLossOnDetectionMax")).doubleValue();
                float rep = -MathUtils.getRandomNumberInRange((float)repMin, (float)repMax);
                ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, rep, RepLevel.INHOSPITABLE, null, null);
                params.put("repResult", (Object)repResult);
                params.put("repEffect", Float.valueOf(repResult.delta));
                params.put("stage", (Object)result);
            }
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_saboteur_destroy_food", params);
        } else if (result.isDetected()) {
            float repMin = (float)((Double)config.get("sabotageDestroyFoodRepLossOnDetectionMin")).doubleValue();
            float repMax = (float)((Double)config.get("sabotageDestroyFoodRepLossOnDetectionMax")).doubleValue();
            float rep = -MathUtils.getRandomNumberInRange((float)repMin, (float)repMax);
            ExerelinReputationAdjustmentResult repResult = DiplomacyManager.adjustRelations(agentFaction, targetFaction, rep, RepLevel.INHOSPITABLE, null, RepLevel.HOSTILE);
            if (Math.abs(repResult.delta) >= 0.01f || playerInvolved) {
                Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, repResult, playerInvolved);
                Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_saboteur_destroy_food", params);
            }
        } else if (playerInvolved) {
            Map<String, Object> params = CovertOpsManager.makeEventParams(agentFaction, result, NO_EFFECT, playerInvolved);
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_saboteur_destroy_food", params);
        }
        CovertOpsManager.modifyAlertLevel(market, (float)((Double)config.get("sabotageDestroyFoodSecurityLevelRise")).doubleValue());
        return result;
    }

    public static void checkForWarmongerPenalty() {
    }

    public static CovertOpsManager create() {
        Map data = Global.getSector().getPersistentData();
        covertWarfareManager = (CovertOpsManager)((Object)data.get(MANAGER_MAP_KEY));
        if (covertWarfareManager != null) {
            return covertWarfareManager;
        }
        covertWarfareManager = new CovertOpsManager();
        data.put(MANAGER_MAP_KEY, covertWarfareManager);
        return covertWarfareManager;
    }

    static {
        NO_EFFECT = new ExerelinReputationAdjustmentResult(0.0f);
        baseInterval = 45.0f;
        String[] factions = new String[]{"neutral", "player", "independent"};
        DISALLOWED_FACTIONS = Arrays.asList(factions);
        try {
            CovertOpsManager.loadSettings();
        }
        catch (IOException | NullPointerException | JSONException ex) {
            log.error((Object)ex);
        }
    }

    public static enum CovertActionResult {
        SUCCESS,
        SUCCESS_DETECTED,
        FAILURE,
        FAILURE_DETECTED;


        public boolean isSucessful() {
            return this == SUCCESS || this == SUCCESS_DETECTED;
        }

        public boolean isDetected() {
            return this == SUCCESS_DETECTED || this == FAILURE_DETECTED;
        }
    }

    protected static enum CovertActionType {
        RAISE_RELATIONS,
        LOWER_RELATIONS,
        DESTABILIZE_MARKET,
        SABOTAGE_RESERVE,
        DESTROY_FOOD;

    }
}

