/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.ExerelinReputationAdjustmentResult;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.alliances.Alliance;
import exerelin.campaign.alliances.AllianceVoter;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.ExerelinUtilsReputation;
import exerelin.utilities.StringHelper;
import exerelin.world.VanillaSystemsGenerator;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;

public class DiplomacyManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(DiplomacyManager.class);
    private static DiplomacyManager diplomacyManager;
    protected static final String CONFIG_FILE = "data/config/exerelin/diplomacyConfig.json";
    protected static final String MANAGER_MAP_KEY = "exerelin_diplomacyManager";
    protected static final List<String> disallowedFactions;
    protected static List<DiplomacyEventDef> eventDefs;
    protected static Map<String, DiplomacyEventDef> eventDefsByStage;
    public static final float STARTING_RELATIONSHIP_HOSTILE = -0.6f;
    public static final float STARTING_RELATIONSHIP_INHOSPITABLE = -0.35f;
    public static final float STARTING_RELATIONSHIP_WELCOMING = 0.4f;
    public static final float STARTING_RELATIONSHIP_FRIENDLY = 0.6f;
    public static final float WAR_WEARINESS_INTERVAL = 3.0f;
    public static final float WAR_WEARINESS_FLEET_WIN_MULT = 0.5f;
    public static final float PEACE_TREATY_CHANCE = 0.3f;
    public static final float DOMINANCE_MIN = 0.25f;
    public static final float DOMINANCE_DIPLOMACY_POSITIVE_EVENT_MOD = -0.67f;
    public static final float DOMINANCE_DIPLOMACY_NEGATIVE_EVENT_MOD = 3.0f;
    public static final float HARD_MODE_DOMINANCE_MOD = 0.5f;
    public static final List<String> DO_NOT_RANDOMIZE;
    protected Map<String, Float> warWeariness;
    protected static float warWearinessPerInterval;
    protected static DiplomacyEventDef peaceTreatyEvent;
    protected static DiplomacyEventDef ceasefireEvent;
    protected static float baseInterval;
    protected float interval = this.getDiplomacyInterval();
    protected final IntervalUtil intervalUtil = new IntervalUtil(this.interval * 0.75f, this.interval * 1.25f);
    protected float daysElapsed = 0.0f;
    protected boolean randomFactionRelationships = false;

    private static void loadSettings() throws IOException, JSONException {
        JSONObject config = Global.getSettings().loadJSON(CONFIG_FILE);
        baseInterval = (float)config.optDouble("eventFrequency", 10.0);
        warWearinessPerInterval = (float)config.optDouble("warWearinessPerInterval", 10.0);
        JSONArray eventsJson = config.getJSONArray("events");
        for (int i = 0; i < eventsJson.length(); ++i) {
            String repEnsureAtBest;
            String repEnsureAtWorst;
            String maxRepLevelToOccur;
            String minRepLevelToOccur;
            String repLimit;
            JSONObject eventDefJson = eventsJson.getJSONObject(i);
            DiplomacyEventDef eventDef = new DiplomacyEventDef();
            eventDef.name = eventDefJson.getString("name");
            eventDef.stage = eventDefJson.getString("stage");
            eventDef.minRepChange = (float)eventDefJson.getDouble("minRepChange");
            eventDef.maxRepChange = (float)eventDefJson.getDouble("maxRepChange");
            eventDef.allowPiratesToPirates = eventDefJson.optBoolean("allowPiratesToPirates", false);
            eventDef.allowPiratesToNonPirates = eventDefJson.optBoolean("allowPiratesToNonPirates", false);
            eventDef.allowNonPiratesToPirates = eventDefJson.optBoolean("allowNonPiratesToPirates", false);
            eventDef.chance = (float)eventDefJson.optDouble("chance", 1.0);
            if (eventDefJson.has("allowedFactions1")) {
                eventDef.allowedFactions1 = ExerelinUtils.JSONArrayToArrayList(eventDefJson.getJSONArray("allowedFactions1"));
            }
            if (eventDefJson.has("allowedFactions2")) {
                eventDef.allowedFactions2 = ExerelinUtils.JSONArrayToArrayList(eventDefJson.getJSONArray("allowedFactions2"));
            }
            if (!(repLimit = eventDefJson.optString("repLimit")).isEmpty()) {
                eventDef.repLimit = RepLevel.valueOf((String)StringHelper.flattenToAscii(repLimit.toUpperCase()));
            }
            if (!(minRepLevelToOccur = eventDefJson.optString("minRepLevelToOccur")).isEmpty()) {
                eventDef.minRepLevelToOccur = RepLevel.valueOf((String)StringHelper.flattenToAscii(minRepLevelToOccur.toUpperCase()));
            }
            if (!(maxRepLevelToOccur = eventDefJson.optString("maxRepLevelToOccur")).isEmpty()) {
                eventDef.maxRepLevelToOccur = RepLevel.valueOf((String)StringHelper.flattenToAscii(maxRepLevelToOccur.toUpperCase()));
            }
            if (!(repEnsureAtWorst = eventDefJson.optString("repEnsureAtWorst")).isEmpty()) {
                eventDef.repEnsureAtWorst = RepLevel.valueOf((String)StringHelper.flattenToAscii(repEnsureAtWorst.toUpperCase()));
            }
            if (!(repEnsureAtBest = eventDefJson.optString("repEnsureAtBest")).isEmpty()) {
                eventDef.repEnsureAtBest = RepLevel.valueOf((String)StringHelper.flattenToAscii(repEnsureAtBest.toUpperCase()));
            }
            eventDefs.add(eventDef);
            eventDefsByStage.put(eventDef.stage, eventDef);
            if (eventDef.name.equals("Peace Treaty")) {
                peaceTreatyEvent = eventDef;
                continue;
            }
            if (!eventDef.name.equals("Ceasefire")) continue;
            ceasefireEvent = eventDef;
        }
    }

    public static DiplomacyEventDef getEventByStage(String stage) {
        if (!eventDefsByStage.containsKey(stage)) {
            return null;
        }
        return eventDefsByStage.get(stage);
    }

    public DiplomacyManager() {
        super(true);
        if (this.warWeariness == null) {
            this.warWeariness = new HashMap<String, Float>();
        }
    }

    public static float getDominanceFactor(String factionId) {
        List allMarkets = Global.getSector().getEconomy().getMarketsCopy();
        int globalSize = 0;
        for (MarketAPI market : allMarkets) {
            globalSize += market.getSize();
        }
        if (globalSize == 0) {
            return 0.0f;
        }
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        List<MarketAPI> ourMarkets = null;
        Alliance alliance = AllianceManager.getFactionAlliance(factionId);
        ourMarkets = alliance != null ? alliance.getAllianceMarkets() : ExerelinUtilsFaction.getFactionMarkets(factionId);
        if (factionId.equals(playerAlignedFactionId) && !playerAlignedFactionId.equals("player_npc") && (alliance == null || AllianceManager.getFactionAlliance("player_npc") != alliance)) {
            List<MarketAPI> playerNpcMarkets = ExerelinUtilsFaction.getFactionMarkets("player_npc");
            ourMarkets.addAll(playerNpcMarkets);
        }
        int ourSize = 0;
        for (MarketAPI market : ourMarkets) {
            ourSize += market.getSize();
        }
        if (ourSize == 0) {
            return 0.0f;
        }
        boolean isPlayer = factionId.equals(playerAlignedFactionId) || alliance != null && alliance == AllianceManager.getFactionAlliance(playerAlignedFactionId);
        float dominance = (float)ourSize / (float)globalSize;
        if (SectorManager.getHardMode() && isPlayer) {
            dominance += (1.0f - dominance) * 0.5f;
        }
        return dominance;
    }

    protected float getDiplomacyInterval() {
        int numFactions = SectorManager.getLiveFactionIdsCopy().size() - 2;
        if (numFactions < 0) {
            numFactions = 0;
        }
        return baseInterval * (float)Math.pow(0.95, numFactions);
    }

    protected static void printPlayerHostileStateMessage(FactionAPI faction, boolean isHostile) {
        String msg;
        Color highlightColor = Misc.getPositiveHighlightColor();
        String factionOrAllianceName = faction.getDisplayName();
        Alliance alliance = AllianceManager.getFactionAlliance(faction.getId());
        if (alliance != null) {
            factionOrAllianceName = alliance.getAllianceNameAndMembers();
        }
        if (isHostile) {
            msg = StringHelper.getStringAndSubstituteToken("exerelin_diplomacy", "player_war_msg", "$factionOrAlliance", factionOrAllianceName);
            highlightColor = Misc.getNegativeHighlightColor();
        } else {
            msg = StringHelper.getStringAndSubstituteToken("exerelin_diplomacy", "player_peace_msg", "$factionOrAlliance", factionOrAllianceName);
        }
        Global.getSector().getCampaignUI().addMessage(msg, highlightColor);
    }

    public static boolean clampRelations(String faction1Id, String faction2Id, float delta) {
        if (DiplomacyManager.diplomacyManager.randomFactionRelationships) {
            return false;
        }
        FactionAPI faction1 = Global.getSector().getFaction(faction1Id);
        float curr = faction1.getRelationship(faction2Id);
        float max = ExerelinFactionConfig.getMaxRelationship(faction1Id, faction2Id);
        float min = ExerelinFactionConfig.getMinRelationship(faction1Id, faction2Id);
        if (delta >= 0.0f && max < curr) {
            faction1.setRelationship(faction2Id, max);
            return true;
        }
        if (delta <= 0.0f && min > curr) {
            faction1.setRelationship(faction2Id, min);
            return true;
        }
        return false;
    }

    public static ExerelinReputationAdjustmentResult adjustRelations(FactionAPI faction1, FactionAPI faction2, float delta, RepLevel ensureAtBest, RepLevel ensureAtWorst, RepLevel limit) {
        return DiplomacyManager.adjustRelations(faction1, faction2, delta, ensureAtBest, ensureAtWorst, limit, false);
    }

    public static ExerelinReputationAdjustmentResult adjustRelations(FactionAPI faction1, FactionAPI faction2, float delta, RepLevel ensureAtBest, RepLevel ensureAtWorst, RepLevel limit, boolean isAllianceAction) {
        String commissionFactionId;
        SectorAPI sector = Global.getSector();
        float before = faction1.getRelationship(faction2.getId());
        boolean wasHostile = faction1.isHostileTo(faction2);
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI playerAlignedFaction = sector.getFaction(playerAlignedFactionId);
        FactionAPI playerFaction = sector.getPlayerFleet().getFaction();
        String faction1Id = faction1.getId();
        String faction2Id = faction2.getId();
        if (limit != null) {
            faction1.adjustRelationship(faction2Id, delta, limit);
        } else {
            faction1.adjustRelationship(faction2Id, delta);
        }
        if (ensureAtBest != null) {
            faction1.ensureAtBest(faction2Id, ensureAtBest);
        }
        if (ensureAtWorst != null) {
            faction1.ensureAtWorst(faction2Id, ensureAtWorst);
        }
        boolean playerWasHostile1 = faction1.isHostileTo("player");
        boolean playerWasHostile2 = faction2.isHostileTo("player");
        DiplomacyManager.clampRelations(faction1Id, faction2Id, delta);
        float after = faction1.getRelationship(faction2Id);
        delta = after - before;
        boolean isHostile = faction1.isHostileTo(faction2);
        ExerelinReputationAdjustmentResult repResult = new ExerelinReputationAdjustmentResult(delta, wasHostile, isHostile);
        if (repResult.wasHostile && !repResult.isHostile) {
            commissionFactionId = ExerelinUtilsFaction.getCommissionFactionId();
            if (commissionFactionId != null && playerAlignedFactionId.equals("player_npc")) {
                if (commissionFactionId.equals(faction1Id) || AllianceManager.areFactionsAllied(commissionFactionId, faction1Id)) {
                    playerAlignedFaction.ensureAtWorst(faction2Id, RepLevel.INHOSPITABLE);
                    playerFaction.ensureAtWorst(faction2Id, RepLevel.INHOSPITABLE);
                }
                if (commissionFactionId.equals(faction2Id) || AllianceManager.areFactionsAllied(commissionFactionId, faction2Id)) {
                    playerAlignedFaction.ensureAtWorst(faction1Id, RepLevel.INHOSPITABLE);
                    playerFaction.ensureAtWorst(faction1Id, RepLevel.INHOSPITABLE);
                }
            }
            if (!isAllianceAction) {
                AllianceVoter.allianceVote(faction1Id, faction2Id, false);
            }
        } else if (!repResult.wasHostile && repResult.isHostile) {
            commissionFactionId = ExerelinUtilsFaction.getCommissionFactionId();
            if (commissionFactionId != null && playerAlignedFactionId.equals("player_npc")) {
                if (commissionFactionId.equals(faction1Id) || AllianceManager.areFactionsAllied(commissionFactionId, faction1Id)) {
                    playerAlignedFaction.ensureAtBest(faction2Id, RepLevel.HOSTILE);
                    playerFaction.ensureAtBest(faction2Id, RepLevel.HOSTILE);
                }
                if (commissionFactionId.equals(faction2Id) || AllianceManager.areFactionsAllied(commissionFactionId, faction2Id)) {
                    playerAlignedFaction.ensureAtBest(faction1Id, RepLevel.HOSTILE);
                    playerFaction.ensureAtBest(faction1Id, RepLevel.HOSTILE);
                }
            }
            if (!isAllianceAction) {
                AllianceVoter.allianceVote(faction1Id, faction2Id, true);
            }
        }
        if (!isAllianceAction) {
            AllianceManager.remainInAllianceCheck(faction1Id, faction2Id);
        }
        if (faction1Id.equals(playerAlignedFactionId) || faction2Id.equals(playerAlignedFactionId)) {
            ExerelinUtilsReputation.syncPlayerRelationshipsToFaction();
        }
        boolean playerIsHostile1 = faction1.isHostileTo("player");
        boolean playerIsHostile2 = faction2.isHostileTo("player");
        if (playerIsHostile1 != playerWasHostile1) {
            DiplomacyManager.printPlayerHostileStateMessage(faction1, playerIsHostile1);
        }
        if (playerIsHostile2 != playerWasHostile2) {
            DiplomacyManager.printPlayerHostileStateMessage(faction2, playerIsHostile2);
        }
        if (faction1Id.equals(playerAlignedFactionId) || faction2Id.equals(playerAlignedFactionId)) {
            // empty if block
        }
        SectorManager.checkForVictory();
        return repResult;
    }

    public static ExerelinReputationAdjustmentResult adjustRelations(DiplomacyEventDef event, FactionAPI faction1, FactionAPI faction2, float delta) {
        return DiplomacyManager.adjustRelations(faction1, faction2, delta, event.repEnsureAtBest, event.repEnsureAtWorst, event.repLimit);
    }

    public void doDiplomacyEvent(DiplomacyEventDef event, MarketAPI market, FactionAPI faction1, FactionAPI faction2) {
        SectorAPI sector = Global.getSector();
        float delta = MathUtils.getRandomNumberInRange((float)event.minRepChange, (float)event.maxRepChange);
        if (delta < 0.0f && delta > -0.01f) {
            delta = -0.01f;
        }
        if (delta > 0.0f && delta < 0.01f) {
            delta = 0.01f;
        }
        delta = (float)Math.round(delta * 100.0f) / 100.0f;
        ExerelinReputationAdjustmentResult result = DiplomacyManager.adjustRelations(event, faction1, faction2, delta);
        delta = result.delta;
        if (Math.abs(delta) >= 0.01f) {
            log.info((Object)("Transmitting event: " + event.name));
            HashMap<String, Object> params = new HashMap<String, Object>();
            String eventType = "exerelin_diplomacy";
            params.put("eventStage", event.stage);
            params.put("result", (Object)result);
            params.put("delta", Float.valueOf(delta));
            params.put("otherFaction", faction2);
            sector.getEventManager().startEvent(new CampaignEventTarget(market), eventType, params);
        }
    }

    public static void createDiplomacyEvent(FactionAPI faction1, FactionAPI faction2) {
        DiplomacyManager.createDiplomacyEvent(faction1, faction2, null);
    }

    public static void createDiplomacyEvent(FactionAPI faction1, FactionAPI faction2, String eventId) {
        if (diplomacyManager == null) {
            return;
        }
        String factionId1 = faction1.getId();
        String factionId2 = faction2.getId();
        WeightedRandomPicker eventPicker = new WeightedRandomPicker();
        WeightedRandomPicker marketPicker = new WeightedRandomPicker();
        List<MarketAPI> markets = ExerelinUtilsFaction.getFactionMarkets(factionId1);
        log.info((Object)("Factions are: " + faction1.getDisplayName() + ", " + faction2.getDisplayName()));
        float dominance = Math.max(DiplomacyManager.getDominanceFactor(factionId1), DiplomacyManager.getDominanceFactor(factionId2));
        log.info((Object)("Dominance factor: " + dominance));
        DiplomacyEventDef event = null;
        for (DiplomacyEventDef eventDef : eventDefs) {
            float mult;
            if (eventDef.stage.equals(eventId)) {
                event = eventDef;
                break;
            }
            boolean pirate1 = ExerelinUtilsFaction.isPirateFaction(factionId1);
            boolean pirate2 = ExerelinUtilsFaction.isPirateFaction(factionId2);
            if (pirate1 && pirate2 && !eventDef.allowPiratesToPirates || pirate1 != pirate2 && (pirate1 && !eventDef.allowPiratesToNonPirates || pirate2 && !eventDef.allowNonPiratesToPirates || !ExerelinConfig.allowPirateInvasions) || eventDef.minRepLevelToOccur != null && !faction1.isAtWorst(faction2, eventDef.minRepLevelToOccur) || eventDef.maxRepLevelToOccur != null && !faction1.isAtBest(faction2, eventDef.maxRepLevelToOccur) || eventDef.allowedFactions1 != null && !eventDef.allowedFactions1.contains(factionId1) || eventDef.allowedFactions2 != null && !eventDef.allowedFactions2.contains(factionId2)) continue;
            boolean isNegative = (eventDef.maxRepChange + eventDef.minRepChange) / 2.0f < 0.0f;
            float chance = eventDef.chance;
            if (DiplomacyManager.diplomacyManager.randomFactionRelationships) continue;
            if (isNegative) {
                mult = ExerelinFactionConfig.getDiplomacyNegativeChance(factionId1, factionId2);
                chance *= mult;
            } else {
                mult = ExerelinFactionConfig.getDiplomacyPositiveChance(factionId1, factionId2);
                chance *= mult;
            }
            if (dominance > 0.25f) {
                float strength = (dominance - 0.25f) / 0.75f;
                chance = isNegative ? (chance += 3.0f * strength) : (chance += -0.67f * strength);
            }
            if (chance <= 0.0f) continue;
            eventPicker.add((Object)eventDef, chance);
        }
        if (event == null) {
            event = (DiplomacyEventDef)eventPicker.pick();
        }
        if (event == null) {
            log.info((Object)"No event available");
            return;
        }
        log.info((Object)("Trying event: " + event.name));
        for (MarketAPI market : markets) {
            marketPicker.add((Object)market);
        }
        MarketAPI market = (MarketAPI)marketPicker.pick();
        if (market == null) {
            log.info((Object)"No market available");
            return;
        }
        diplomacyManager.doDiplomacyEvent(event, market, faction1, faction2);
    }

    public static void createDiplomacyEvent() {
        if (diplomacyManager == null) {
            return;
        }
        log.info((Object)"Starting diplomacy event creation");
        SectorAPI sector = Global.getSector();
        WeightedRandomPicker factionPicker = new WeightedRandomPicker();
        ArrayList<FactionAPI> factions = new ArrayList<FactionAPI>();
        for (String string : SectorManager.getLiveFactionIdsCopy()) {
            factions.add(sector.getFaction(string));
        }
        int factionCount = 0;
        for (FactionAPI faction : factions) {
            if (faction.isNeutralFaction() || faction.getId().equals("player_npc") && !faction.getId().equals(PlayerFactionStore.getPlayerFactionId()) || disallowedFactions.contains(faction.getId())) continue;
            factionPicker.add((Object)faction);
            ++factionCount;
        }
        if (factionCount < 2) {
            return;
        }
        FactionAPI factionAPI = (FactionAPI)factionPicker.pickAndRemove();
        FactionAPI faction2 = (FactionAPI)factionPicker.pickAndRemove();
        DiplomacyManager.createDiplomacyEvent(factionAPI, faction2, null);
    }

    private void reduceWarWeariness(String factionId, float amount) {
        Alliance alliance = AllianceManager.getFactionAlliance(factionId);
        if (alliance != null) {
            for (String member : alliance.getMembersCopy()) {
                float weariness = DiplomacyManager.getWarWeariness(member);
                weariness = Math.max(weariness - amount, 0.0f);
                this.warWeariness.put(member, Float.valueOf(weariness));
            }
        } else {
            float weariness = DiplomacyManager.getWarWeariness(factionId);
            weariness = Math.max(weariness - amount, 0.0f);
            this.warWeariness.put(factionId, Float.valueOf(weariness));
        }
    }

    private void updateWarWeariness() {
        SectorAPI sector = Global.getSector();
        ArrayList<String> factionIds = SectorManager.getLiveFactionIdsCopy();
        FactionAPI factionWithMostWars = null;
        int mostWarCount = 0;
        List<Object> enemiesOfFaction = new ArrayList();
        for (String factionId : factionIds) {
            FactionAPI faction;
            if (ExerelinUtilsFaction.isPirateFaction(factionId) || disallowedFactions.contains(factionId) || (faction = sector.getFaction(factionId)).isNeutralFaction() || faction.getId().equals("player_npc") && !faction.getId().equals(PlayerFactionStore.getPlayerFactionId())) continue;
            float weariness = DiplomacyManager.getWarWeariness(factionId);
            List<String> enemies = DiplomacyManager.getFactionsAtWarWithFaction(faction, false, false, true);
            int warCount = enemies.size();
            if (warCount > 0) {
                if ((weariness += (float)enemies.size() * warWearinessPerInterval) >= ExerelinConfig.minWarWearinessForPeace && warCount > mostWarCount) {
                    factionWithMostWars = faction;
                    enemiesOfFaction = enemies;
                    mostWarCount = warCount;
                }
            } else {
                weariness -= warWearinessPerInterval;
            }
            if (weariness < 0.0f) {
                weariness = 0.0f;
            }
            this.warWeariness.put(factionId, Float.valueOf(weariness));
        }
        if (factionWithMostWars != null) {
            log.info((Object)("Faction " + factionWithMostWars.getDisplayName() + " wants to sue for peace"));
            String factionId = factionWithMostWars.getId();
            ExerelinFactionConfig factionConfig = ExerelinConfig.getExerelinFactionConfig(factionId);
            WeightedRandomPicker picker = new WeightedRandomPicker();
            for (String enemy : enemiesOfFaction) {
                picker.add((Object)enemy, DiplomacyManager.getWarWeariness(enemy));
            }
            String toPeace = (String)picker.pick();
            float sumWeariness = DiplomacyManager.getWarWeariness(factionWithMostWars.getId()) + DiplomacyManager.getWarWeariness(toPeace);
            log.info((Object)("Sum with " + sector.getFaction(toPeace).getDisplayName() + ": " + sumWeariness));
            float divisor = ExerelinConfig.warWearinessDivisorModPerLevel + ExerelinConfig.warWearinessDivisorModPerLevel * (float)sector.getPlayerPerson().getStats().getLevel();
            if (Math.random() > (double)(sumWeariness / divisor)) {
                return;
            }
            log.info((Object)"Negotiating treaty");
            boolean peaceTreaty = false;
            if (factionWithMostWars.isAtWorst(toPeace, RepLevel.HOSTILE)) {
                peaceTreaty = Math.random() < (double)0.3f;
            }
            DiplomacyEventDef event = peaceTreaty ? peaceTreatyEvent : ceasefireEvent;
            float reduction = peaceTreaty ? ExerelinConfig.warWearinessPeaceTreatyReduction : ExerelinConfig.warWearinessCeasefireReduction;
            List markets = sector.getEconomy().getMarketsCopy();
            for (MarketAPI market : markets) {
                if (market.getFaction() != factionWithMostWars) continue;
                this.doDiplomacyEvent(event, market, factionWithMostWars, sector.getFaction(toPeace));
                this.reduceWarWeariness(factionWithMostWars.getId(), reduction);
                this.reduceWarWeariness(toPeace, reduction);
                return;
            }
        }
    }

    private void handleMarketCapture(MarketAPI market, FactionAPI oldOwner, FactionAPI newOwner) {
        String loseFactionId = oldOwner.getId();
        if (!this.warWeariness.containsKey(loseFactionId)) {
            return;
        }
        float value = (market.getSize() ^ 3) * 5;
        this.warWeariness.put(loseFactionId, Float.valueOf(DiplomacyManager.getWarWeariness(loseFactionId) + value));
    }

    public void reportBattleFinished(CampaignFleetAPI winner, BattleAPI battle) {
        if (winner == null) {
            return;
        }
        CampaignFleetAPI loser = battle.getPrimary(battle.getOtherSideFor(winner));
        if (loser == null) {
            return;
        }
        FactionAPI winFaction = winner.getFaction();
        FactionAPI loseFaction = loser.getFaction();
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI playerAlignedFaction = Global.getSector().getFaction(playerAlignedFactionId);
        if (winFaction.isPlayerFaction()) {
            winFaction = playerAlignedFaction;
        } else if (loseFaction.isPlayerFaction()) {
            loseFaction = playerAlignedFaction;
        }
        String winFactionId = winFaction.getId();
        String loseFactionId = loseFaction.getId();
        if (!this.warWeariness.containsKey(winFactionId) || !this.warWeariness.containsKey(loseFactionId)) {
            return;
        }
        if (ExerelinUtilsFaction.isPirateFaction(winFactionId)) {
            return;
        }
        if (ExerelinUtilsFaction.isPirateFaction(loseFactionId)) {
            return;
        }
        float loserLosses = 0.0f;
        float winnerLosses = 0.0f;
        List loserCurrent = loser.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : loser.getFleetData().getSnapshot()) {
            if (loserCurrent.contains(member)) continue;
            loserLosses += (float)member.getFleetPointCost();
        }
        List winnerCurrent = winner.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : winner.getFleetData().getSnapshot()) {
            if (winnerCurrent.contains(member)) continue;
            winnerLosses += (float)member.getFleetPointCost();
        }
        this.warWeariness.put(winFactionId, Float.valueOf(DiplomacyManager.getWarWeariness(winFactionId) + (winnerLosses *= 0.5f)));
        this.warWeariness.put(loseFactionId, Float.valueOf(DiplomacyManager.getWarWeariness(loseFactionId) + loserLosses));
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysElapsed += days;
        if (this.daysElapsed >= 3.0f) {
            this.daysElapsed -= 3.0f;
            this.updateWarWeariness();
        }
        this.intervalUtil.advance(days);
        if (!this.intervalUtil.intervalElapsed()) {
            return;
        }
        DiplomacyManager.createDiplomacyEvent();
        this.interval = this.getDiplomacyInterval();
        this.intervalUtil.setInterval(this.interval * 0.75f, this.interval * 1.25f);
    }

    public void reportPlayerReputationChange(String factionId, float delta) {
        FactionAPI player = Global.getSector().getFaction("player");
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        ExerelinUtilsReputation.syncFactionRelationshipToPlayer(playerAlignedFactionId, factionId);
        ExerelinUtilsReputation.syncPlayerRelationshipToFaction(playerAlignedFactionId, factionId);
        if (!playerAlignedFactionId.equals("player_npc")) {
            ExerelinUtilsReputation.syncFactionRelationshipToPlayer("player_npc", factionId);
        }
        float currentRel = player.getRelationship(factionId);
        boolean isHostile = player.isHostileTo(factionId);
        if (isHostile && currentRel - delta > AllianceManager.HOSTILE_THRESHOLD || !isHostile && currentRel - delta < AllianceManager.HOSTILE_THRESHOLD) {
            AllianceVoter.allianceVote(playerAlignedFactionId, factionId, isHostile);
        }
        if (player.isAtBest(PlayerFactionStore.getPlayerFactionId(), RepLevel.INHOSPITABLE)) {
            SectorManager.scheduleExpelPlayerFromFaction();
        }
        SectorManager.checkForVictory();
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static DiplomacyManager create() {
        Map data = Global.getSector().getPersistentData();
        diplomacyManager = (DiplomacyManager)((Object)data.get(MANAGER_MAP_KEY));
        if (diplomacyManager != null) {
            try {
                DiplomacyManager.loadSettings();
            }
            catch (IOException | JSONException ex) {
                Global.getLogger(DiplomacyManager.class).log((Priority)Level.ERROR, (Object)ex);
            }
            return diplomacyManager;
        }
        diplomacyManager = new DiplomacyManager();
        data.put(MANAGER_MAP_KEY, diplomacyManager);
        return diplomacyManager;
    }

    public static List<String> getFactionsAtWarWithFaction(String factionId, boolean includePirates, boolean includeTemplars, boolean mustAllowCeasefire) {
        return DiplomacyManager.getFactionsAtWarWithFaction(Global.getSector().getFaction(factionId), includePirates, includeTemplars, mustAllowCeasefire);
    }

    public static List<String> getFactionsAtWarWithFaction(FactionAPI faction, boolean includePirates, boolean includeTemplars, boolean mustAllowCeasefire) {
        SectorAPI sector = Global.getSector();
        String factionId = faction.getId();
        ArrayList<String> enemies = new ArrayList<String>();
        ArrayList<String> factions = SectorManager.getLiveFactionIdsCopy();
        for (String otherFactionId : factions) {
            if (!faction.isAtBest(otherFactionId, RepLevel.HOSTILE) || disallowedFactions.contains(otherFactionId) || !includePirates && ExerelinUtilsFaction.isPirateFaction(otherFactionId) || !includeTemplars && otherFactionId.equals("templars") || mustAllowCeasefire && !ExerelinFactionConfig.canCeasefire(factionId, otherFactionId)) continue;
            enemies.add(otherFactionId);
        }
        return enemies;
    }

    public static boolean isFactionAtWar(String factionId, boolean excludeNeutralAndRebels) {
        return DiplomacyManager.getFactionsAtWarWithFaction(factionId, !excludeNeutralAndRebels, true, false).size() > 0;
    }

    public static List<String> getFactionsAlliedWithFaction(String factionId) {
        ArrayList<String> allies = new ArrayList<String>();
        List factions = Global.getSector().getAllFactions();
        for (int i = 0; i < factions.size(); ++i) {
            if (!((FactionAPI)factions.get(i)).isAtWorst(factionId, RepLevel.WELCOMING)) continue;
            allies.add(((FactionAPI)factions.get(i)).getId());
        }
        return allies;
    }

    public static void notifyMarketCaptured(MarketAPI market, FactionAPI oldOwner, FactionAPI newOwner) {
        if (diplomacyManager == null) {
            return;
        }
        diplomacyManager.handleMarketCapture(market, oldOwner, newOwner);
    }

    public static float getWarWeariness(String factionId) {
        if (diplomacyManager == null) {
            log.info((Object)"No diplomacy manager found");
            return 0.0f;
        }
        if (!DiplomacyManager.diplomacyManager.warWeariness.containsKey(factionId)) {
            DiplomacyManager.diplomacyManager.warWeariness.put(factionId, Float.valueOf(0.0f));
            return 0.0f;
        }
        return DiplomacyManager.diplomacyManager.warWeariness.get(factionId).floatValue();
    }

    public static void setRelationshipAtBest(String factionId, String otherFactionId, float rel) {
        FactionAPI faction = Global.getSector().getFaction(factionId);
        float currentRel = faction.getRelationship(otherFactionId);
        if (rel < currentRel) {
            faction.setRelationship(otherFactionId, rel);
        }
    }

    public static void handleHostileToAllFaction(String factionId, List<String> factionIds) {
        ExerelinFactionConfig factionConfig = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (factionConfig == null) {
            return;
        }
        if (factionConfig.hostileToAll <= 0) {
            return;
        }
        float relationship = -0.6f;
        if (factionConfig.hostileToAll == 3) {
            relationship = -1.0f;
        }
        boolean isPirateNeutral = factionConfig.isPirateNeutral;
        for (String otherFactionId : factionIds) {
            if (otherFactionId.equals(factionId) || isPirateNeutral && ExerelinUtilsFaction.isPirateFaction(otherFactionId)) continue;
            boolean isPlayer = otherFactionId.equals("player_npc") || otherFactionId.equals("player");
            FactionAPI otherFaction = Global.getSector().getFaction(otherFactionId);
            if (factionConfig.hostileToAll == 1 && isPlayer) {
                otherFaction.setRelationship(factionId, -0.35f);
                continue;
            }
            if (otherFaction.isNeutralFaction()) continue;
            DiplomacyManager.setRelationshipAtBest(factionId, otherFactionId, relationship);
        }
    }

    public static void initFactionRelationships(boolean midgameReset) {
        FactionAPI famousBounty;
        SectorAPI sector = Global.getSector();
        FactionAPI player = sector.getFaction("player");
        String selectedFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI selectedFaction = sector.getFaction(selectedFactionId);
        log.info((Object)("Selected faction is " + selectedFaction + " | " + selectedFactionId));
        ArrayList<String> factionIds = new ArrayList<String>();
        ArrayList<String> alreadyRandomizedIds = new ArrayList<String>();
        alreadyRandomizedIds.addAll(DO_NOT_RANDOMIZE);
        for (FactionAPI faction2 : sector.getAllFactions()) {
            if (faction2.isNeutralFaction()) continue;
            factionIds.add(faction2.getId());
        }
        boolean randomize = false;
        if (diplomacyManager != null) {
            randomize = DiplomacyManager.diplomacyManager.randomFactionRelationships;
        }
        if (SectorManager.getCorvusMode() && !randomize) {
            VanillaSystemsGenerator.initFactionRelationships(sector);
        } else {
            Random random = new Random();
            if (!midgameReset) {
                random.setSeed(ExerelinUtils.getStartingSeed());
            } else {
                random.setSeed(Misc.genRandomSeed());
            }
            if (midgameReset) {
                for (String factionId : factionIds) {
                    FactionAPI faction3 = sector.getFaction(factionId);
                    for (String otherFactionId : factionIds) {
                        if (factionId.equals(otherFactionId)) continue;
                        faction3.setRelationship(otherFactionId, 0.0f);
                    }
                }
            }
            for (String factionId : factionIds) {
                if (!ExerelinUtilsFaction.isPirateFaction(factionId)) continue;
                for (String string : factionIds) {
                    ExerelinFactionConfig exerelinFactionConfig;
                    FactionAPI otherFaction;
                    if (string.equals(factionId) || (otherFaction = sector.getFaction(string)).isNeutralFaction() || (exerelinFactionConfig = ExerelinConfig.getExerelinFactionConfig(string)) != null && (exerelinFactionConfig.isPirateNeutral || exerelinFactionConfig.pirateFaction)) continue;
                    otherFaction.setRelationship(factionId, -0.6f);
                }
            }
            for (String factionId : factionIds) {
                FactionAPI faction = sector.getFaction(factionId);
                if (randomize) {
                    if (faction.isNeutralFaction() || faction.isPlayerFaction() || alreadyRandomizedIds.contains(factionId)) continue;
                    alreadyRandomizedIds.add(factionId);
                    for (String otherFactionId : factionIds) {
                        FactionAPI factionAPI;
                        if (alreadyRandomizedIds.contains(otherFactionId) || otherFactionId.equals(factionId) || (factionAPI = sector.getFaction(otherFactionId)).isNeutralFaction() || factionAPI.isPlayerFaction()) continue;
                        if ((double)random.nextFloat() < 0.5) {
                            if (ExerelinUtilsFaction.isPirateFaction(factionId) || ExerelinUtilsFaction.isPirateFaction(otherFactionId)) {
                                faction.setRelationship(otherFactionId, -0.6f);
                            } else {
                                faction.setRelationship(otherFactionId, 0.0f);
                            }
                        } else {
                            float min = -0.85f;
                            float max = 0.6f;
                            float randomRel = random.nextFloat() * (max - min) + min;
                            faction.setRelationship(otherFactionId, randomRel);
                        }
                        if (!ExerelinUtilsFaction.isPirateFaction(factionId) || !otherFactionId.equals(selectedFactionId) && !otherFactionId.equals("player")) continue;
                        faction.setRelationship(otherFactionId, -0.6f);
                    }
                    DiplomacyManager.handleHostileToAllFaction(factionId, factionIds);
                    continue;
                }
                ExerelinFactionConfig exerelinFactionConfig = ExerelinConfig.getExerelinFactionConfig(factionId);
                if (exerelinFactionConfig == null) continue;
                DiplomacyManager.handleHostileToAllFaction(factionId, factionIds);
                for (String likedFactionId : exerelinFactionConfig.factionsLiked) {
                    FactionAPI likedFaction = sector.getFaction(likedFactionId);
                    if (likedFaction == null) continue;
                    faction.setRelationship(likedFactionId, 0.4f);
                }
                for (String dislikedFactionId : exerelinFactionConfig.factionsDisliked) {
                    FactionAPI dislikedFaction = sector.getFaction(dislikedFactionId);
                    if (dislikedFaction == null) continue;
                    DiplomacyManager.setRelationshipAtBest(factionId, dislikedFactionId, -0.6f);
                }
                for (String indifferentFactionId : exerelinFactionConfig.factionsNeutral) {
                    FactionAPI indifferentFaction = sector.getFaction(indifferentFactionId);
                    if (indifferentFaction == null) continue;
                    faction.setRelationship(indifferentFactionId, 0.0f);
                }
                for (Map.Entry entry : exerelinFactionConfig.startRelationships.entrySet()) {
                    faction.setRelationship((String)entry.getKey(), ((Float)entry.getValue()).floatValue());
                }
            }
        }
        FactionAPI bountyHunters = sector.getFaction("merc_hostile");
        if (bountyHunters != null) {
            bountyHunters.setRelationship("independent", 1.0f);
            bountyHunters.setRelationship("player", -1.0f);
            bountyHunters.setRelationship("player_npc", -1.0f);
        }
        if ((famousBounty = sector.getFaction("famous_bounty")) != null) {
            for (String factionId : factionIds) {
                FactionAPI factionAPI = sector.getFaction(factionId);
                if (factionAPI.isNeutralFaction() || factionId.equals("famous_bounty")) continue;
                famousBounty.setRelationship(factionId, 0.0f);
            }
            famousBounty.setRelationship("player", -1.0f);
        }
        player.setRelationship("shippackfaction", RepLevel.FRIENDLY);
        player.setRelationship("player_npc", 1.0f);
        PlayerFactionStore.saveIndependentPlayerRelations();
        if (selectedFactionId.equals("player_npc")) {
            ExerelinUtilsReputation.syncFactionRelationshipsToPlayer();
        } else {
            ExerelinUtilsReputation.syncPlayerRelationshipsToFaction(selectedFactionId);
            player.setRelationship(selectedFactionId, 0.6f);
        }
        for (String factionId : factionIds) {
            FactionAPI factionAPI = sector.getFaction(factionId);
            factionAPI.setRelationship("mysterious_contact", 0.0f);
        }
    }

    public static void resetFactionRelationships(String factionId) {
        if (!(factionId.equals(PlayerFactionStore.getPlayerFactionId()) || ExerelinUtilsFaction.isFactionHostileToAll(factionId) || ExerelinUtilsFaction.isExiInCorvus(factionId))) {
            for (FactionAPI faction : Global.getSector().getAllFactions()) {
                String otherFactionId = faction.getId();
                if (ExerelinUtilsFaction.isFactionHostileToAll(otherFactionId) || ExerelinUtilsFaction.isExiInCorvus(otherFactionId) || otherFactionId.equals(factionId)) continue;
                faction.setRelationship(factionId, 0.0f);
            }
        }
    }

    public static void setRandomFactionRelationships(boolean random) {
        if (diplomacyManager == null) {
            return;
        }
        DiplomacyManager.diplomacyManager.randomFactionRelationships = random;
    }

    public static boolean isRandomFactionRelationships() {
        return DiplomacyManager.diplomacyManager.randomFactionRelationships;
    }

    static {
        DO_NOT_RANDOMIZE = Arrays.asList("independent", "derelict", "remnant", "famous_bounty", "merc_hostile", "shippackfaction");
        warWearinessPerInterval = 50.0f;
        baseInterval = 10.0f;
        String[] factions = new String[]{"templars", "independent"};
        disallowedFactions = new ArrayList<String>(Arrays.asList(factions));
        if (!ExerelinConfig.followersDiplomacy) {
            disallowedFactions.add("player_npc");
        }
        eventDefs = new ArrayList<DiplomacyEventDef>();
        eventDefsByStage = new HashMap<String, DiplomacyEventDef>();
        try {
            DiplomacyManager.loadSettings();
        }
        catch (IOException | JSONException ex) {
            Global.getLogger(DiplomacyManager.class).log((Priority)Level.ERROR, (Object)ex);
        }
    }

    public static class DiplomacyEventDef {
        public String name;
        public String stage;
        public RepLevel minRepLevelToOccur;
        public RepLevel maxRepLevelToOccur;
        public RepLevel repEnsureAtWorst;
        public RepLevel repEnsureAtBest;
        public RepLevel repLimit;
        public float minRepChange;
        public float maxRepChange;
        public List<String> allowedFactions1;
        public List<String> allowedFactions2;
        public boolean allowPiratesToPirates;
        public boolean allowPiratesToNonPirates;
        public boolean allowNonPiratesToPirates;
        public float chance;
    }
}

