/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.GetLiveFactions;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.AllianceManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.StringHelper;
import java.util.Map;
import org.lwjgl.input.Keyboard;

public class DirectoryScreenScript
implements EveryFrameScript {
    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return true;
    }

    public void advance(float amount) {
        CampaignUIAPI ui = Global.getSector().getCampaignUI();
        if (Global.getSector().isInNewGameAdvance() || ui.isShowingDialog()) {
            return;
        }
        if (Keyboard.isKeyDown((int)ExerelinConfig.directoryDialogKey)) {
            ui.showInteractionDialog((InteractionDialogPlugin)new FactionDirectoryDialog(), (SectorEntityToken)Global.getSector().getPlayerFleet());
        }
    }

    private static class FactionDirectoryDialog
    implements InteractionDialogPlugin,
    CoreInteractionListener {
        private InteractionDialogAPI dialog;
        private TextPanelAPI text;
        private OptionPanelAPI options;
        protected RuleBasedInteractionDialogPluginImpl optionsDialogDelegate;

        private FactionDirectoryDialog() {
        }

        public void init(InteractionDialogAPI dialog) {
            FleetInteractionDialogPluginImpl.inConversation = false;
            this.dialog = dialog;
            this.options = dialog.getOptionPanel();
            this.text = dialog.getTextPanel();
            this.initMenu();
        }

        void initMenu() {
            this.options.clearOptions();
            this.options.addOption(StringHelper.getString("exerelin_factions", "factionDirectoryOption"), (Object)Menu.DIRECTORY);
            this.options.addOption(StringHelper.getString("exerelin_alliances", "allianceListOption"), (Object)Menu.ALLIANCES);
            this.options.addOption(Misc.ucFirst((String)StringHelper.getString("close")), (Object)Menu.EXIT);
            this.options.setShortcut((Object)Menu.EXIT, 1, false, false, false, true);
            this.dialog.setPromptText(StringHelper.getString("exerelin_misc", "directoryOptions") + ":");
        }

        public void optionSelected(String optionText, Object optionData) {
            if (optionData == null) {
                return;
            }
            if (FleetInteractionDialogPluginImpl.inConversation) {
                if (this.optionsDialogDelegate == null) {
                    this.optionsDialogDelegate = new RuleBasedInteractionDialogPluginImpl();
                    this.optionsDialogDelegate.setEmbeddedMode(true);
                    this.optionsDialogDelegate.init(this.dialog);
                }
                this.optionsDialogDelegate.optionSelected(optionText, optionData);
                if (!FleetInteractionDialogPluginImpl.inConversation) {
                    this.optionSelected(null, (Object)Menu.INIT);
                }
                return;
            }
            if (optionText != null) {
                this.text.addParagraph(optionText, Global.getSettings().getColor("buttonText"));
            }
            if (optionData == Menu.INIT) {
                this.initMenu();
            }
            if (optionData == Menu.DIRECTORY) {
                FleetInteractionDialogPluginImpl.inConversation = true;
                this.optionsDialogDelegate = new RuleBasedInteractionDialogPluginImpl();
                this.optionsDialogDelegate.setEmbeddedMode(true);
                this.optionsDialogDelegate.init(this.dialog);
                MemoryAPI mem = (MemoryAPI)this.optionsDialogDelegate.getMemoryMap().get("local");
                mem.set("$specialDialog", (Object)true, 0.0f);
                GetLiveFactions.addLiveFactionsToMemory(mem);
                this.optionsDialogDelegate.fireAll("ExerelinFactionDirectory");
            } else if (optionData == Menu.ALLIANCES) {
                AllianceManager.printAllianceList(this.text);
            } else if (optionData == Menu.INTEL_SCREEN) {
                this.dialog.getVisualPanel().showCore(CoreUITabId.INTEL, this.dialog.getInteractionTarget(), (CoreInteractionListener)this);
            } else if (optionData == Menu.EXIT) {
                FleetInteractionDialogPluginImpl.inConversation = false;
                this.dialog.dismiss();
            }
        }

        public void optionMousedOver(String optionText, Object optionData) {
        }

        public void advance(float amount) {
        }

        public void backFromEngagement(EngagementResultAPI battleResult) {
        }

        public Object getContext() {
            return null;
        }

        public Map<String, MemoryAPI> getMemoryMap() {
            return null;
        }

        public void coreUIDismissed() {
        }

        private static enum Menu {
            INIT,
            DIRECTORY,
            ALLIANCES,
            INTEL_SCREEN,
            EXIT;

        }
    }
}

