/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import java.util.List;
import org.apache.log4j.Logger;

public class EconomyLogger
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(EconomyLogger.class);
    int lastDays = -7;
    private boolean firstFrame = true;

    public EconomyLogger() {
        super(true);
    }

    public void advance(float amount) {
        SectorAPI sector = Global.getSector();
        float days = sector.getClock().convertToDays(amount);
        if (days - (float)this.lastDays >= 1.0f) {
            this.lastDays = (int)days;
            this.printMarketInfo(this.lastDays);
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return true;
    }

    private void printMarketInfo(int days) {
        log.info((Object)("MARKET STATUS ON DAY " + days));
        SectorAPI sector = Global.getSector();
        EconomyAPI econ = sector.getEconomy();
        List markets = econ.getMarketsCopy();
        for (int i = 0; i < markets.size(); ++i) {
            MarketAPI market = (MarketAPI)markets.get(i);
            String name = market.getName();
            int size = market.getSize();
            CommodityOnMarketAPI commodity = market.getCommodityData("crew");
            float stockpile = commodity.getStockpile();
            float supply = commodity.getSupply().getModifiedValue();
            float demand = commodity.getDemand().getDemandValue();
            log.info((Object)("\t" + name + " (" + size + ") : " + supply + ", " + demand + ", " + stockpile));
        }
    }
}

