/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.StatsTracker;
import exerelin.campaign.events.MarketAttackedEvent;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsMarket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;

public class InvasionRound {
    public static Logger log = Global.getLogger(InvasionRound.class);
    public static final float ATTACKER_BASE_STRENGTH = 0.6f;
    public static final float ATTACKER_RANDOM_BONUS = 0.2f;
    public static final float ATTACKER_FLEET_MULT = 0.5f;
    public static final float DEFENDER_BASE_STRENGTH = 0.2f;
    public static final float DEFENDER_STABILITY_MOD = 0.5f;
    public static final float DEFENDER_MILITARY_BASE_MOD = 0.25f;
    public static final float DEFENDER_REGIONAL_CAPITAL_MOD = 0.25f;
    public static final float DEFENDER_HEADQUARTERS_MOD = 0.4f;
    public static final float DEFENDER_URBAN_MOD = 0.2f;
    public static final float DEFENDER_RURAL_MOD = -0.2f;
    public static final float DEFENDER_AVALON_MOD = 1.0f;
    public static final float DEFENDER_RAID_STRENGTH_MULT = 0.75f;
    public static final float DEFENDER_STRENGTH_XP_MULT = 500.0f;
    public static final float MARINE_LOSS_MULT = 0.4f;
    public static final float MARINE_LOSS_RANDOM_MOD = 0.1f;
    public static final float MARINE_LOSS_RAID_MULT = 0.5f;
    public static final int BASE_DESTABILIZATION = 3;
    public static final float COMMODITY_DESTRUCTION_MULT_SUCCESS = 0.2f;
    public static final float COMMODITY_DESTRUCTION_MULT_FAILURE = 0.1f;
    public static final float COMMODITY_DESTRUCTION_VARIANCE = 0.2f;

    public static float GetDefenderStrength(MarketAPI market) {
        return InvasionRound.GetDefenderStrength(market, 1.0f, false);
    }

    public static float GetDefenderStrength(MarketAPI market, float bonusMult, boolean isRaid) {
        ExerelinFactionConfig factionConfig;
        float marketSize = market.getSize();
        if (market.getId().equals("exipirated_avesta")) {
            marketSize += 2.0f;
        }
        float baseDefenderStrength = 0.2f * (float)Math.pow(marketSize + 1.0f, 3.0);
        float defenderStrength = baseDefenderStrength = baseDefenderStrength * (market.getStabilityValue() + 1.0f - 0.5f) * 0.5f;
        float defenderBonus = 0.0f;
        if (market.hasCondition("military_base")) {
            defenderBonus += baseDefenderStrength * 0.25f;
        }
        if (market.hasCondition("regional_capital")) {
            defenderBonus += baseDefenderStrength * 0.25f;
        }
        if (market.hasCondition("headquarters")) {
            defenderBonus += baseDefenderStrength * 0.4f;
        }
        if (market.hasCondition("urbanized_polity")) {
            defenderBonus += baseDefenderStrength * 0.2f;
        }
        if (market.hasCondition("rural_polity")) {
            defenderBonus += baseDefenderStrength * -0.2f;
        }
        if (market.hasCondition("tem_avalon")) {
            defenderBonus += baseDefenderStrength * 1.0f;
        }
        if ((factionConfig = ExerelinConfig.getExerelinFactionConfig(market.getFactionId())) != null) {
            defenderBonus += baseDefenderStrength * factionConfig.invasionStrengthBonusDefend;
        }
        defenderStrength += defenderBonus * bonusMult;
        if (isRaid) {
            defenderStrength *= 0.75f;
        }
        return defenderStrength;
    }

    public static InvasionRoundResult GetInvasionRoundResult(CampaignFleetAPI attacker, SectorEntityToken defender, boolean isRaid) {
        return InvasionRound.GetInvasionRoundResult(attacker, defender, isRaid, InvasionSimulationType.REALISTIC);
    }

    public static InvasionRoundResult GetInvasionRoundResult(CampaignFleetAPI attacker, SectorEntityToken defender, boolean isRaid, InvasionSimulationType simType) {
        int marinesLost;
        float baseAttackerStrength;
        MarketAPI market = defender.getMarket();
        if (market == null) {
            return new InvasionRoundResult(true);
        }
        CargoAPI attackerCargo = attacker.getCargo();
        int marineCount = attackerCargo.getMarines();
        if (marineCount <= 0) {
            InvasionRoundResult result = new InvasionRoundResult(false);
            result.defenderStrength = InvasionRound.GetDefenderStrength(market);
            return result;
        }
        float randomBonus = (float)Math.random() * 0.2f;
        if (simType == InvasionSimulationType.PESSIMISTIC) {
            randomBonus = 0.0f;
        } else if (simType == InvasionSimulationType.OPTIMISTIC) {
            randomBonus = 0.2f;
        }
        float marketSize = market.getSize();
        if (market.getId().equals("exipirated_avesta")) {
            marketSize += 1.0f;
        }
        float attackerMarineMult = attacker.getCommanderStats().getMarineEffectivnessMult().getModifiedValue();
        float attackerAssets = (float)marineCount * attackerMarineMult + (float)attacker.getFleetPoints() * 0.5f;
        float attackerStrength = baseAttackerStrength = (0.6f + randomBonus) * attackerAssets;
        ExerelinFactionConfig factionConfig = ExerelinConfig.getExerelinFactionConfig(attacker.getFaction().getId());
        if (factionConfig != null) {
            attackerStrength += baseAttackerStrength * factionConfig.invasionStrengthBonusAttack;
        }
        float defenderStrength = InvasionRound.GetDefenderStrength(market);
        InvasionRoundResult result = new InvasionRoundResult();
        if (market.hasCondition("military_base")) {
            result.addDefenderBonus("Military base", 0.25f);
        }
        if (market.hasCondition("regional_capital")) {
            result.addDefenderBonus("Regional capital", 0.25f);
        }
        if (market.hasCondition("headquarters")) {
            result.addDefenderBonus("Headquarters", 0.4f);
        }
        if (market.hasCondition("tem_avalon")) {
            result.addDefenderBonus("Avalon", 1.0f);
        }
        float outcome = attackerStrength - defenderStrength;
        float marineLossFactor = defenderStrength * (0.5f + 0.5f * defenderStrength / attackerStrength);
        float marineLossMod = 0.3f;
        if (simType == InvasionSimulationType.REALISTIC) {
            marineLossMod += (float)(2.0 * Math.random() * (double)0.1f);
        } else if (simType == InvasionSimulationType.PESSIMISTIC) {
            marineLossMod += 0.2f;
        }
        if (isRaid) {
            marineLossMod *= 0.5f;
        }
        if ((marinesLost = (int)(marineLossFactor * marineLossMod + 0.5f)) > marineCount) {
            marinesLost = marineCount;
        }
        if (marinesLost < 0) {
            marinesLost = 0;
        }
        result.setSuccess(outcome > 0.0f);
        result.setAttackerStrength(attackerStrength);
        result.setDefenderStrength(defenderStrength);
        result.setMarinesLost(marinesLost);
        result.setTimeTaken(marketSize / 2.0f);
        return result;
    }

    public static InvasionRoundResult AttackMarket(CampaignFleetAPI attacker, SectorEntityToken defender, boolean isRaid) {
        InvasionRoundResult result = InvasionRound.GetInvasionRoundResult(attacker, defender, isRaid);
        SectorAPI sector = Global.getSector();
        FactionAPI attackerFaction = attacker.getFaction();
        String attackerFactionId = attackerFaction.getId();
        FactionAPI defenderFaction = defender.getFaction();
        String defenderFactionId = defenderFaction.getId();
        MarketAPI market = defender.getMarket();
        boolean playerInvolved = false;
        CampaignFleetAPI playerFleet = sector.getPlayerFleet();
        if (attacker == playerFleet) {
            playerInvolved = true;
            attackerFactionId = PlayerFactionStore.getPlayerFactionId();
            attackerFaction = sector.getFaction(attackerFactionId);
        }
        if (attackerFaction == defenderFaction || !attackerFaction.isHostileTo(defenderFaction)) {
            return null;
        }
        boolean captured = false;
        boolean success = result.getSuccess();
        CampaignEventPlugin eventSuper = sector.getEventManager().getOngoingEvent(new CampaignEventTarget(market), "exerelin_market_attacked");
        if (eventSuper == null) {
            eventSuper = sector.getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_market_attacked", null);
        }
        MarketAttackedEvent event = (MarketAttackedEvent)eventSuper;
        int currentPenalty = event.getStabilityPenalty();
        if (isRaid && success || !isRaid && !success) {
            if (currentPenalty < 3) {
                event.increaseStabilityPenalty(1);
            }
        } else if (!isRaid && success) {
            if (currentPenalty < 3) {
                event.increaseStabilityPenalty(3);
                if (event.getStabilityPenalty() > 4) {
                    event.setStabilityPenalty(4);
                }
            } else {
                event.increaseStabilityPenalty(1);
            }
        }
        if (success) {
            ExerelinUtilsMarket.destroyAllCommodityStocks(market, 0.2f, 0.2f);
        } else {
            ExerelinUtilsMarket.destroyAllCommodityStocks(market, 0.1f, 0.2f);
        }
        ExerelinUtilsMarket.refreshMarket(market, true);
        CargoAPI attackerCargo = attacker.getCargo();
        attackerCargo.removeMarines(result.getMarinesLost());
        if (!isRaid && success) {
            captured = true;
        }
        List markets = Global.getSector().getEconomy().getMarketsCopy();
        ArrayList<String> factionsToNotify = new ArrayList<String>();
        HashSet<String> seenFactions = new HashSet<String>();
        float repChangeStrength = market.getSize() * 5;
        if (success) {
            repChangeStrength *= 2.0f;
        }
        if (isRaid) {
            repChangeStrength *= 0.5f;
        }
        for (MarketAPI otherMarket : markets) {
            if (!otherMarket.getFaction().isHostileTo(defenderFaction) || seenFactions.contains(otherMarket.getFactionId())) continue;
            RepLevel level = attackerFaction.getRelationshipLevel(otherMarket.getFaction());
            seenFactions.add(otherMarket.getFactionId());
            if (!level.isAtWorst(RepLevel.HOSTILE) || !playerInvolved) continue;
            factionsToNotify.add(otherMarket.getFactionId());
        }
        if (captured) {
            SectorManager.captureMarket(market, attackerFaction, defenderFaction, playerInvolved, factionsToNotify, repChangeStrength);
            if (playerInvolved) {
                float xp = result.defenderStrength * 500.0f;
                playerFleet.getCargo().gainCrewXP(xp);
                playerFleet.getCommander().getStats().addXP((long)xp);
                playerFleet.getCommander().getStats().levelUpIfNeeded();
            }
        }
        if (playerInvolved && !defenderFactionId.equals("spire") && !defenderFactionId.equals("darkspire")) {
            float deathsInflicted = InvasionRound.GetDefenderStrength(market, 0.5f, isRaid);
            float numAvgKids = MathUtils.getRandomNumberInRange((float)0.0f, (float)1.5f) + MathUtils.getRandomNumberInRange((float)0.0f, (float)1.5f);
            StatsTracker.getStatsTracker().modifyOrphansMade((int)(deathsInflicted * numAvgKids));
        }
        log.info((Object)String.format("Invasion of [%s] by " + attacker.getNameWithFaction() + (success ? " successful" : " failed"), defender.getName()));
        return result;
    }

    public static class InvasionRoundResult {
        private boolean success;
        private boolean isRaid;
        private CargoAPI enemyCargoDamaged;
        private int marinesLost;
        private float attackerStrength;
        private float defenderStrength;
        private float timeTaken;
        private Map<String, Float> attackerBonuses;
        private Map<String, Float> defenderBonuses;

        public InvasionRoundResult() {
            this(false);
        }

        public InvasionRoundResult(boolean success) {
            this.success = success;
            this.attackerStrength = 0.0f;
            this.defenderStrength = 0.0f;
            this.marinesLost = 0;
            this.attackerBonuses = new HashMap<String, Float>();
            this.defenderBonuses = new HashMap<String, Float>();
        }

        public boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public boolean getIsRaid() {
            return this.isRaid;
        }

        public void setIsRaid(boolean isRaid) {
            this.isRaid = isRaid;
        }

        public float getAttackerStrength() {
            return this.attackerStrength;
        }

        public void setAttackerStrength(float strength) {
            this.attackerStrength = strength;
        }

        public float getDefenderStrength() {
            return this.defenderStrength;
        }

        public void setDefenderStrength(float strength) {
            this.defenderStrength = strength;
        }

        public float getTimeTaken() {
            return this.timeTaken;
        }

        public void setTimeTaken(float time) {
            this.timeTaken = time;
        }

        public CargoAPI getDamageDone() {
            return this.enemyCargoDamaged;
        }

        public void setDamageDone(CargoAPI damage) {
            this.enemyCargoDamaged = damage;
        }

        public int getMarinesLost() {
            return this.marinesLost;
        }

        public void setMarinesLost(int losses) {
            this.marinesLost = losses;
        }

        public Map<String, Float> getAttackerBonuses() {
            return new HashMap<String, Float>(this.attackerBonuses);
        }

        public void addAttackerBonus(String name, float amount) {
            this.attackerBonuses.put(name, Float.valueOf(amount));
        }

        public Map<String, Float> getDefenderBonuses() {
            return new HashMap<String, Float>(this.defenderBonuses);
        }

        public void addDefenderBonus(String name, float amount) {
            this.defenderBonuses.put(name, Float.valueOf(amount));
        }
    }

    public static enum InvasionSimulationType {
        PESSIMISTIC,
        REALISTIC,
        OPTIMISTIC;

    }
}

