/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.submarkets.PrismMarket;
import exerelin.utilities.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MiningHelperLegacy {
    protected static final String CONFIG_FILE = "data/config/exerelin/miningConfig.json";
    protected static final String MINING_SHIP_DEFS = "data/config/exerelin/mining_ships.csv";
    protected static final String MINING_WEAPON_DEFS = "data/config/exerelin/mining_weapons.csv";
    protected static final String RESOURCE_DEFS = "data/config/exerelin/mining_resources.csv";
    protected static final String EXHAUSTION_DATA_KEY = "nex_miningExhaustion";
    public static final Set<String> OUTPUT_COMMODITIES = new HashSet<String>(Arrays.asList("ore", "rare_ore", "volatiles", "organics"));
    public static final List<String> ROLES_FOR_FIGHTERS = Arrays.asList("combatSmall", "freighterSmall", "combatFreighterSmall", "carrierSmall", "combatMedium", "escortMedium", "freighterMedium", "combatFreighterMedium", "carrierMedium", "carrierLarge", "freighterLarge", "combatFreighterLarge", "carrierLarge", "combatCapital");
    public static final Set<String> CACHE_DISALLOWED_FACTIONS = new HashSet<String>(Arrays.asList("templars", "derelict", "remnant"));
    public static final float MAX_EXHAUSTION = 0.9f;
    protected static float miningProductionMult = 2.0f;
    protected static float cacheSizeMult = 1.0f;
    protected static float baseCacheChance = 0.1f;
    protected static float baseAccidentChance = 0.5f;
    protected static float baseAccidentCRLoss = 0.1f;
    protected static float baseAccidentHullDamage = 400.0f;
    protected static float exhaustionPer100MiningStrength = 0.04f;
    protected static float renewRatePerDay = 0.002f;
    protected static float planetDangerMult = 1.25f;
    protected static float planetExhaustionMult = 0.75f;
    protected static float planetRenewMult = 1.25f;
    protected static float xpPerMiningStrength = 10.0f;
    protected static float machineryPerMiningStrength = 0.4f;
    protected static final Map<String, Float> miningWeapons = new HashMap<String, Float>();
    protected static final Map<String, Float> miningShips = new HashMap<String, Float>();
    protected static final Map<String, Map<String, Float>> miningConditions = new HashMap<String, Map<String, Float>>();
    protected static final List<CacheDef> cacheDefs = new ArrayList<CacheDef>();
    public static final Logger log = Global.getLogger(MiningHelperLegacy.class);
    protected static final WeightedRandomPicker<AccidentType> accidentPicker = new WeightedRandomPicker();

    public static void loadMiningShips(String path) {
        try {
            JSONArray miningShipsCsv = Global.getSettings().getMergedSpreadsheetDataForMod("id", path, "nexerelin");
            for (int x = 0; x < miningShipsCsv.length(); ++x) {
                String shipId = "<unknown>";
                try {
                    JSONObject row = miningShipsCsv.getJSONObject(x);
                    shipId = row.getString("id");
                    if (shipId.isEmpty()) continue;
                    float strength = (float)row.getDouble("strength");
                    miningShips.put(shipId, Float.valueOf(strength));
                    continue;
                }
                catch (JSONException ex) {
                    log.error((Object)("Error loading mining ship " + shipId + ": " + (Object)((Object)ex)));
                }
            }
        }
        catch (IOException | JSONException ex) {
            log.error((Object)("Error loading mining ships: " + ex));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void loadMiningWeapons(String path) {
        try {
            JSONArray miningWeaponsCsv = Global.getSettings().getMergedSpreadsheetDataForMod("id", path, "nexerelin");
            for (int x = 0; x < miningWeaponsCsv.length(); ++x) {
                String weaponId = "<unknown>";
                try {
                    JSONObject row = miningWeaponsCsv.getJSONObject(x);
                    weaponId = row.getString("id");
                    if (weaponId.isEmpty()) continue;
                    float strength = (float)row.getDouble("strength");
                    miningWeapons.put(weaponId, Float.valueOf(strength));
                    continue;
                }
                catch (JSONException ex) {
                    log.error((Object)("Error loading mining weapon " + weaponId + ": " + (Object)((Object)ex)));
                }
            }
        }
        catch (IOException | JSONException ex) {
            log.error((Object)("Error loading mining weapons: " + ex));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void initCacheDefs() {
        cacheDefs.add(new CacheDef("weapon", CacheType.WEAPON, null, 1.0f, 0.8f));
        cacheDefs.add(new CacheDef("frigate", CacheType.FRIGATE, null, 1.0f, 0.2f));
        cacheDefs.add(new CacheDef("fighters", CacheType.FIGHTER_WING, null, 1.0f, 0.3f));
        cacheDefs.add(new CacheDef("supplies", CacheType.COMMODITY, "supplies", 3.0f, 1.0f));
        cacheDefs.add(new CacheDef("fuel", CacheType.COMMODITY, "fuel", 4.0f, 1.0f));
        cacheDefs.add(new CacheDef("food", CacheType.COMMODITY, "food", 5.0f, 1.0f));
        cacheDefs.add(new CacheDef("hand_weapons", CacheType.COMMODITY, "hand_weapons", 3.0f, 1.0f));
        cacheDefs.add(new CacheDef("heavy_machinery", CacheType.COMMODITY, "heavy_machinery", 2.0f, 0.7f));
        cacheDefs.add(new CacheDef("rare_metals", CacheType.COMMODITY, "rare_metals", 1.5f, 0.7f));
        cacheDefs.add(new CacheDef("drugs", CacheType.COMMODITY, "drugs", 1.25f, 0.5f));
        cacheDefs.add(new CacheDef("gamma_core", CacheType.COMMODITY, "gamma_core", 0.0f, 0.05f));
        cacheDefs.add(new CacheDef("beta_core", CacheType.COMMODITY, "beta_core", 0.0f, 0.01f));
    }

    public static Map<SectorEntityToken, Float> getExhaustionMap() {
        HashMap<SectorEntityToken, Float> exhaustionMap;
        Map data = Global.getSector().getPersistentData();
        if (data.containsKey(EXHAUSTION_DATA_KEY)) {
            exhaustionMap = (Map)data.get(EXHAUSTION_DATA_KEY);
        } else {
            exhaustionMap = new HashMap();
            data.put(EXHAUSTION_DATA_KEY, exhaustionMap);
        }
        return exhaustionMap;
    }

    public static boolean canMine(SectorEntityToken entity) {
        if (entity instanceof AsteroidAPI) {
            return true;
        }
        if (entity.getMarket() != null && !entity.getMarket().isPlanetConditionMarketOnly()) {
            return false;
        }
        if (entity instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)entity;
            return !planet.isStar();
        }
        return false;
    }

    protected static void addToResourcesResult(Map<String, Float> base, Map<String, Float> added) {
        if (base == null || added == null) {
            return;
        }
        for (Map.Entry<String, Float> entry : added.entrySet()) {
            String commodityId = entry.getKey();
            float value = entry.getValue().floatValue();
            if (!base.containsKey(commodityId)) {
                base.put(commodityId, Float.valueOf(value));
                continue;
            }
            base.put(commodityId, Float.valueOf(value + base.get(commodityId).floatValue()));
        }
    }

    protected static Map<String, Float> getResourcesForCondition(String conditionId) {
        if (!miningConditions.containsKey(conditionId)) {
            return null;
        }
        return new HashMap<String, Float>(miningConditions.get(conditionId));
    }

    protected static Map<String, Float> processCondition(String conditionId, float mult, MiningReport report) {
        Map<String, Float> resources = MiningHelperLegacy.getResourcesForCondition(conditionId);
        if (resources == null) {
            return null;
        }
        if (mult != 1.0f) {
            HashMap<String, Float> resourcesAdjusted = new HashMap<String, Float>();
            for (Map.Entry<String, Float> tmp : resources.entrySet()) {
                float thisMult = mult * MathUtils.getRandomNumberInRange((float)0.85f, (float)1.15f);
                resourcesAdjusted.put(tmp.getKey(), Float.valueOf(tmp.getValue().floatValue() * thisMult));
            }
            resources = resourcesAdjusted;
        }
        if (report != null) {
            MiningHelperLegacy.addToResourcesResult(report.totalOutput, resources);
            report.outputByCondition.put(conditionId, resources);
        }
        return resources;
    }

    protected static void getResources(SectorEntityToken entity, float mult, MiningReport report) {
        if (entity == null) {
            return;
        }
        boolean isGasGiant = entity instanceof PlanetAPI && ((PlanetAPI)entity).isGasGiant();
        MarketAPI market = entity.getMarket();
        if (market != null) {
            for (MarketConditionAPI cond : market.getConditions()) {
                if (!cond.isSurveyed() && report.isPlayer) continue;
                String id = cond.getId();
                MiningHelperLegacy.processCondition(id, mult, report);
            }
        }
        if (entity instanceof AsteroidAPI) {
            MiningHelperLegacy.processCondition("asteroid", mult, report);
        }
    }

    public static float getDanger(SectorEntityToken entity) {
        PlanetAPI planet;
        if (entity instanceof AsteroidAPI) {
            return 0.2f;
        }
        float val = entity.getMarket().getHazardValue();
        if (entity instanceof PlanetAPI && !(planet = (PlanetAPI)entity).isMoon()) {
            val *= planetDangerMult;
        }
        return val;
    }

    public static float getExhaustion(SectorEntityToken entity) {
        if (entity instanceof AsteroidAPI) {
            return 0.0f;
        }
        Map<SectorEntityToken, Float> exhaustionMap = MiningHelperLegacy.getExhaustionMap();
        if (exhaustionMap.containsKey(entity)) {
            return exhaustionMap.get(entity).floatValue();
        }
        return 0.0f;
    }

    public static float getRequiredMachinery(float strength) {
        return strength * machineryPerMiningStrength;
    }

    public static float getMachinerySufficiency(CampaignFleetAPI fleet) {
        float requiredMachinery = MiningHelperLegacy.getRequiredMachinery(MiningHelperLegacy.getFleetMiningStrength(fleet));
        float availableMachinery = fleet.getCargo().getCommodityQuantity("heavy_machinery");
        return Math.min(availableMachinery / requiredMachinery, 1.0f);
    }

    public static MiningReport getMiningReport(CampaignFleetAPI fleet, SectorEntityToken entity, float strength) {
        MiningReport report = new MiningReport();
        report.danger = MiningHelperLegacy.getDanger(entity);
        report.exhaustion = MiningHelperLegacy.getExhaustion(entity);
        if (fleet != null && fleet.getFaction().isPlayerFaction()) {
            report.isPlayer = true;
        }
        MiningHelperLegacy.getResources(entity, strength *= 1.0f - report.exhaustion, report);
        return report;
    }

    public static Map<String, Float> getMiningShipsCopy() {
        return new HashMap<String, Float>(miningShips);
    }

    public static Map<String, Float> getMiningWeaponsCopy() {
        return new HashMap<String, Float>(miningWeapons);
    }

    public static float getWingMiningStrength(String wing) {
        FighterWingSpecAPI wingSpec = Global.getSettings().getFighterWingSpec(wing);
        float strength = 0.0f;
        ShipVariantAPI variant = wingSpec.getVariant();
        String hullId = variant.getHullSpec().getHullId();
        if (miningShips.containsKey(hullId)) {
            strength += miningShips.get(hullId).floatValue();
        }
        Collection weaponSlots = variant.getFittedWeaponSlots();
        for (String slot : weaponSlots) {
            String weaponId = variant.getWeaponSpec(slot).getWeaponId();
            if (!miningWeapons.containsKey(weaponId)) continue;
            strength += miningWeapons.get(weaponId).floatValue();
        }
        float count = wingSpec.getNumFighters();
        return strength * count;
    }

    public static float getShipMiningStrength(FleetMemberAPI member, boolean useCRMod) {
        String hullId;
        if (member.isMothballed()) {
            return 0.0f;
        }
        float strength = 0.0f;
        float crModifier = 1.0f;
        if (useCRMod) {
            float cr = member.getRepairTracker().getCR();
            crModifier = cr / 0.6f;
        }
        if (miningShips.containsKey(hullId = member.getHullId())) {
            strength += miningShips.get(hullId).floatValue();
        }
        Collection weaponSlots = member.getVariant().getFittedWeaponSlots();
        for (String slot : weaponSlots) {
            String weaponId = member.getVariant().getWeaponSpec(slot).getWeaponId();
            if (!miningWeapons.containsKey(weaponId)) continue;
            strength += miningWeapons.get(weaponId).floatValue();
        }
        for (String wing : member.getVariant().getFittedWings()) {
            strength += MiningHelperLegacy.getWingMiningStrength(wing);
        }
        return strength * crModifier;
    }

    public static float getFleetMiningStrength(CampaignFleetAPI fleet) {
        float strength = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            strength += MiningHelperLegacy.getShipMiningStrength(member, true);
        }
        return strength;
    }

    public static FleetMemberAPI getRandomSmallShip() {
        WeightedRandomPicker shipPicker = new WeightedRandomPicker();
        WeightedRandomPicker rolePicker = new WeightedRandomPicker();
        rolePicker.add((Object)"civilianRandom", 1.0f);
        rolePicker.add((Object)"freighterSmall", 1.0f);
        rolePicker.add((Object)"tankerSmall", 1.0f);
        rolePicker.add((Object)"combatFreighterSmall", 1.0f);
        rolePicker.add((Object)"combatSmall", 5.0f);
        String role = (String)rolePicker.pick();
        List factions = Global.getSector().getAllFactions();
        Set restrictedShips = PrismMarket.getRestrictedShips();
        for (FactionAPI faction : factions) {
            if (!faction.isShowInIntelTab() || CACHE_DISALLOWED_FACTIONS.contains(faction.getId())) continue;
            List picks = faction.pickShip(role, 1.0f, rolePicker.getRandom());
            for (ShipRolePick pick : picks) {
                FleetMemberAPI member;
                if (restrictedShips.contains(pick.variantId) || (member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, pick.variantId)).getHullSpec().getHints().contains(ShipHullSpecAPI.ShipTypeHints.STATION)) continue;
                float cost = member.getBaseBuyValue();
                shipPicker.add((Object)member, 10000.0f / cost);
            }
        }
        return (FleetMemberAPI)shipPicker.pick();
    }

    public static FighterWingSpecAPI getRandomFighter() {
        List factions = Global.getSector().getAllFactions();
        Set restrictedShips = PrismMarket.getRestrictedShips();
        WeightedRandomPicker picker = new WeightedRandomPicker();
        for (FactionAPI faction : factions) {
            if (CACHE_DISALLOWED_FACTIONS.contains(faction.getId())) continue;
            for (String role : ROLES_FOR_FIGHTERS) {
                List picks = faction.pickShip(role, 1.0f);
                for (ShipRolePick pick : picks) {
                    FleetMemberType type = FleetMemberType.SHIP;
                    if (pick.isFighterWing()) continue;
                    FleetMemberAPI member = Global.getFactory().createFleetMember(type, pick.variantId);
                    for (String wingId : member.getVariant().getFittedWings()) {
                        FighterWingSpecAPI spec;
                        if (restrictedShips.contains(wingId) || (spec = Global.getSettings().getFighterWingSpec(wingId)).getTags().contains("no_sell")) continue;
                        picker.add((Object)spec, (float)(6 - spec.getTier()));
                    }
                }
            }
        }
        return (FighterWingSpecAPI)picker.pick();
    }

    public static WeaponSpecAPI getRandomWeapon() {
        WeightedRandomPicker weaponPicker = new WeightedRandomPicker();
        List weaponIds = Global.getSector().getAllWeaponIds();
        Set restrictedWeapons = PrismMarket.getRestrictedWeapons();
        for (String weaponId : weaponIds) {
            WeaponSpecAPI weapon;
            if (weaponId.startsWith("tem_") || restrictedWeapons.contains(weaponId) || (weapon = Global.getSettings().getWeaponSpec(weaponId)).getAIHints().contains(WeaponAPI.AIHints.SYSTEM)) continue;
            float weight = 10000.0f / weapon.getBaseValue();
            if (weapon.getSize() == WeaponAPI.WeaponSize.LARGE) {
                weight *= 4.0f;
            } else if (weapon.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                weight *= 2.0f;
            }
            weaponPicker.add((Object)weapon, weight);
        }
        return (WeaponSpecAPI)weaponPicker.pick();
    }

    protected static float computeCrewLossFraction(FleetMemberAPI member, float hullFraction, float hullDamage) {
        if (hullFraction == 0.0f) {
            return (0.75f + (float)Math.random() * 0.25f) * member.getStats().getCrewLossMult().getModifiedValue();
        }
        return hullDamage * hullDamage * (0.5f + (float)Math.random() * 0.5f) * member.getStats().getCrewLossMult().getModifiedValue();
    }

    public static MiningAccident handleAccidents(CampaignFleetAPI fleet, float strength, float danger) {
        MiningAccident accident = null;
        float accidentChance = (float)MathUtils.getRandomNumberInRange((int)-1, (int)3) * strength / 10.0f;
        if (accidentChance < 0.0f) {
            return null;
        }
        List ships = fleet.getFleetData().getCombatReadyMembersListCopy();
        WeightedRandomPicker picker = new WeightedRandomPicker();
        for (FleetMemberAPI ship : ships) {
            float shipStrength = MiningHelperLegacy.getShipMiningStrength(ship, true);
            if (!(shipStrength > 0.0f)) continue;
            picker.add((Object)ship, shipStrength);
        }
        while (accidentChance > 0.0f) {
            FleetMemberAPI fm;
            accidentChance -= MathUtils.getRandomNumberInRange((float)0.75f, (float)1.25f);
            if (!(Math.random() < (double)(danger * baseAccidentChance))) continue;
            if (accident == null) {
                accident = new MiningAccident();
            }
            if ((fm = (FleetMemberAPI)picker.pick()) == null || fm.getStatus() == null) continue;
            AccidentType accidentType = (AccidentType)((Object)accidentPicker.pick());
            if (accidentType == AccidentType.HULL_DAMAGE) {
                float hull = fm.getStatus().getHullFraction();
                float hullDamageFactor = 0.0f;
                float damage = baseAccidentHullDamage * MathUtils.getRandomNumberInRange((float)0.5f, (float)1.5f);
                fm.getStatus().applyDamage(damage);
                if (fm.getStatus().getHullFraction() <= 0.0f) {
                    fm.getStatus().disable();
                    picker.remove((Object)fm);
                    fleet.getFleetData().removeFleetMember(fm);
                    hullDamageFactor = 1.0f;
                    if (accident.damage.containsKey(fm)) {
                        accident.damage.remove(fm);
                    }
                    if (accident.crLost.containsKey(fm)) {
                        accident.crLost.remove(fm);
                    }
                    accident.shipsDestroyed.add(fm);
                    boolean spawnShip = true;
                    if (spawnShip) {
                        DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(new ShipRecoverySpecial.PerShipData(fm.getVariant().getHullVariantId(), DerelictShipEntityPlugin.pickBadCondition(null)), false);
                        params.durationDays = DerelictShipEntityPlugin.getBaseDuration((ShipAPI.HullSize)fm.getHullSpec().getHullSize());
                        CustomCampaignEntityAPI entity = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity((LocationAPI)fleet.getContainingLocation(), (String)"wreck", (String)"neutral", (Object)params);
                        entity.addTag("expires");
                        float angle = (float)Math.random() * 360.0f;
                        float speed = 10.0f + 10.0f * (float)Math.random();
                        Vector2f vel = Misc.getUnitVectorAtDegreeAngle((float)angle);
                        vel.scale(speed);
                        entity.getVelocity().set((ReadableVector2f)vel);
                        entity.getLocation().x = fleet.getLocation().x + vel.x * 3.0f;
                        entity.getLocation().y = fleet.getLocation().y + vel.y * 3.0f;
                    }
                } else {
                    float newHull = fm.getStatus().getHullFraction();
                    float diff = hull - newHull;
                    if (diff < 0.0f) {
                        diff = 0.0f;
                    }
                    hullDamageFactor = diff;
                    accident.damage.put(fm, Float.valueOf(damage));
                }
                float dead = fm.getCrewComposition().getCrew();
                float lossFraction = MiningHelperLegacy.computeCrewLossFraction(fm, fm.getStatus().getHullFraction(), hullDamageFactor);
                accident.crewLost = (int)((float)accident.crewLost + (dead *= lossFraction));
                continue;
            }
            if (accidentType == AccidentType.CR_LOSS) {
                float crLost = baseAccidentCRLoss * MathUtils.getRandomNumberInRange((float)0.75f, (float)1.25f);
                ShipAPI.HullSize size = fm.getHullSpec().getHullSize();
                if (size == ShipAPI.HullSize.DESTROYER) {
                    crLost *= 0.5f;
                } else if (size == ShipAPI.HullSize.CRUISER) {
                    crLost *= 0.25f;
                } else if (size == ShipAPI.HullSize.CAPITAL_SHIP) {
                    crLost *= 0.125f;
                }
                fm.getRepairTracker().applyCREvent(-crLost, StringHelper.getString("exerelin_mining", "miningAccident"));
                if (!accident.crLost.containsKey(fm)) {
                    accident.crLost.put(fm, Float.valueOf(0.0f));
                }
                accident.crLost.put(fm, Float.valueOf(accident.crLost.get(fm).floatValue() + crLost));
                continue;
            }
            if (accidentType == AccidentType.CREW_LOSS) {
                int dead = MathUtils.getRandomNumberInRange((int)1, (int)5);
                dead = Math.min(dead, fleet.getCargo().getTotalCrew());
                CargoAPI cargo = fleet.getCargo();
                cargo.removeItems(CargoAPI.CargoItemType.RESOURCES, (Object)"crew", (float)dead);
                accident.crewLost += dead;
                continue;
            }
            if (accidentType != AccidentType.MACHINERY_LOSS) continue;
            int lost = MathUtils.getRandomNumberInRange((int)1, (int)3) + MathUtils.getRandomNumberInRange((int)0, (int)2);
            lost = Math.min(lost, (int)fleet.getCargo().getCommodityQuantity("heavy_machinery"));
            CargoAPI cargo = fleet.getCargo();
            cargo.removeItems(CargoAPI.CargoItemType.RESOURCES, (Object)"heavy_machinery", (float)lost);
            accident.machineryLost += lost;
        }
        return accident;
    }

    public static List<CacheResult> findCaches(CampaignFleetAPI fleet, float strength, SectorEntityToken entity) {
        ArrayList<CacheResult> caches = new ArrayList<CacheResult>();
        int numCaches = MathUtils.getRandomNumberInRange((int)0, (int)2) + MathUtils.getRandomNumberInRange((int)0, (int)1);
        if (numCaches <= 0) {
            numCaches = 1;
        }
        WeightedRandomPicker cachePicker = new WeightedRandomPicker();
        for (CacheDef def : cacheDefs) {
            cachePicker.add((Object)def, def.chance);
        }
        for (int i = 0; i < numCaches; ++i) {
            int num = 1;
            String name = "";
            CacheDef def = (CacheDef)cachePicker.pickAndRemove();
            if (def.type == CacheType.FRIGATE) {
                FleetMemberAPI member = MiningHelperLegacy.getRandomSmallShip();
                member.getRepairTracker().setMothballed(true);
                fleet.getFleetData().addFleetMember(member);
                fleet.updateCounts();
                name = member.getVariant().getFullDesignationWithHullName();
            } else if (def.type == CacheType.FIGHTER_WING) {
                FighterWingSpecAPI spec = MiningHelperLegacy.getRandomFighter();
                fleet.getCargo().addFighters(spec.getId(), 1);
                name = StringHelper.getStringAndSubstituteToken("exerelin_mining", "LPC", "$fighterName", spec.getVariant().getFullDesignationWithHullName());
            } else if (def.type == CacheType.WEAPON) {
                WeaponSpecAPI weapon = MiningHelperLegacy.getRandomWeapon();
                if (weapon.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                    num = MathUtils.getRandomNumberInRange((int)1, (int)3);
                } else if (weapon.getSize() == WeaponAPI.WeaponSize.SMALL) {
                    num = MathUtils.getRandomNumberInRange((int)1, (int)3) + MathUtils.getRandomNumberInRange((int)0, (int)2);
                }
                fleet.getCargo().addWeapons(weapon.getWeaponId(), num);
                for (CargoStackAPI stack : fleet.getCargo().getStacksCopy()) {
                    if (stack.getWeaponSpecIfWeapon() != weapon) continue;
                    name = stack.getDisplayName();
                    break;
                }
            } else if (def.type == CacheType.COMMODITY) {
                num = (int)(Math.sqrt(strength) * (double)def.mult * (double)miningProductionMult * (double)cacheSizeMult);
                if (def.mult == 0.0f) {
                    num = 1;
                }
                fleet.getCargo().addCommodity(def.commodityId, (float)num);
                name = Global.getSector().getEconomy().getCommoditySpec(def.commodityId).getName();
            }
            caches.add(new CacheResult(def, name, num));
        }
        return caches;
    }

    public static float applyResourceExhaustion(SectorEntityToken entity, float miningStrength) {
        Map<SectorEntityToken, Float> exhaustionMap = MiningHelperLegacy.getExhaustionMap();
        String type = "default";
        float currExhaustion = 0.0f;
        if (exhaustionMap.containsKey(entity)) {
            currExhaustion = exhaustionMap.get(entity).floatValue();
        }
        float delta = miningStrength * exhaustionPer100MiningStrength / 100.0f;
        if (entity instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)entity;
            type = planet.getTypeId();
            if (!planet.isMoon()) {
                delta *= planetExhaustionMult;
            }
        }
        if (delta <= 0.0f) {
            return 0.0f;
        }
        float exhaustion = currExhaustion + delta;
        if (exhaustion > 0.9f) {
            exhaustion = 0.9f;
        }
        exhaustionMap.put(entity, Float.valueOf(exhaustion));
        return exhaustion - currExhaustion;
    }

    public static MiningResult getMiningResults(CampaignFleetAPI fleet, SectorEntityToken entity, float mult, boolean isPlayer) {
        float baseStrength = MiningHelperLegacy.getFleetMiningStrength(fleet) * mult;
        float machineryMult = 0.5f + 0.5f * MiningHelperLegacy.getMachinerySufficiency(fleet);
        float strength = baseStrength * machineryMult;
        MiningReport report = MiningHelperLegacy.getMiningReport(fleet, entity, strength * miningProductionMult);
        MiningResult result = new MiningResult();
        result.report = report;
        for (Map.Entry<String, Float> tmp : report.totalOutput.entrySet()) {
            int amount = (int)((double)tmp.getValue().floatValue() + 0.5);
            fleet.getCargo().addCommodity(tmp.getKey(), (float)amount);
        }
        if (isPlayer && Math.random() < (double)baseCacheChance) {
            result.cachesFound = MiningHelperLegacy.findCaches(fleet, strength, entity);
        }
        result.accidents = MiningHelperLegacy.handleAccidents(fleet, baseStrength, MiningHelperLegacy.getDanger(entity));
        if (isPlayer) {
            float xp = strength * xpPerMiningStrength;
            fleet.getCommander().getStats().addXP((long)xp);
            fleet.getCommander().getStats().levelUpIfNeeded();
            MiningHelperLegacy.applyResourceExhaustion(entity, strength);
        }
        return result;
    }

    public static void renewResources(float days) {
        Map<SectorEntityToken, Float> exhaustionMap = MiningHelperLegacy.getExhaustionMap();
        ArrayList<SectorEntityToken> toRemove = new ArrayList<SectorEntityToken>();
        for (Map.Entry<SectorEntityToken, Float> tmp : exhaustionMap.entrySet()) {
            float exhaustion;
            PlanetAPI planet;
            SectorEntityToken entity = tmp.getKey();
            float currentExhaustion = tmp.getValue().floatValue();
            float regen = days * renewRatePerDay;
            if (entity instanceof PlanetAPI && !(planet = (PlanetAPI)entity).isMoon()) {
                regen *= planetRenewMult;
            }
            if ((exhaustion = currentExhaustion - regen) <= 0.0f) {
                toRemove.add(entity);
            } else {
                exhaustionMap.put(entity, Float.valueOf(exhaustion));
            }
            log.info((Object)("Regenerating resources for " + entity.getName() + ": " + exhaustion));
        }
        for (SectorEntityToken token : toRemove) {
            exhaustionMap.remove(token);
        }
    }

    static {
        try {
            JSONObject config = Global.getSettings().loadJSON(CONFIG_FILE);
            miningProductionMult = (float)config.optDouble("miningProductionMult", (double)miningProductionMult);
            cacheSizeMult = (float)config.optDouble("cacheSizeMult", (double)cacheSizeMult);
            baseCacheChance = (float)config.optDouble("baseCacheChance", (double)baseCacheChance);
            baseAccidentChance = (float)config.optDouble("baseAccidentChance", (double)baseAccidentChance);
            xpPerMiningStrength = (float)config.optDouble("xpPerMiningStrength", (double)xpPerMiningStrength);
            machineryPerMiningStrength = (float)config.optDouble("machineryPerMiningStrength", (double)machineryPerMiningStrength);
            baseAccidentCRLoss = (float)config.optDouble("baseAccidentCRLoss", (double)baseAccidentCRLoss);
            baseAccidentHullDamage = (float)config.optDouble("baseAccidentHullDamage", (double)baseAccidentHullDamage);
            exhaustionPer100MiningStrength = (float)config.optDouble("exhaustionPer100MiningStrength", (double)exhaustionPer100MiningStrength);
            renewRatePerDay = (float)config.optDouble("renewRatePerDay", (double)renewRatePerDay);
            planetDangerMult = (float)config.optDouble("planetDangerMult", (double)planetDangerMult);
            planetExhaustionMult = (float)config.optDouble("planetExhaustionMult", (double)planetExhaustionMult);
            planetRenewMult = (float)config.optDouble("planetRenewMult", (double)planetRenewMult);
            MiningHelperLegacy.loadMiningShips(MINING_SHIP_DEFS);
            MiningHelperLegacy.loadMiningWeapons(MINING_WEAPON_DEFS);
            JSONArray resourcesCsv = Global.getSettings().getMergedSpreadsheetDataForMod("id", RESOURCE_DEFS, "nexerelin");
            for (int x = 0; x < resourcesCsv.length(); ++x) {
                String id = "";
                try {
                    JSONObject row = resourcesCsv.getJSONObject(x);
                    id = row.getString("id");
                    if (id.isEmpty()) continue;
                    HashMap<String, Float> resources = new HashMap<String, Float>();
                    for (String commodityId : OUTPUT_COMMODITIES) {
                        float value = (float)row.optDouble(commodityId, 0.0);
                        if (!(value > 0.0f)) continue;
                        resources.put(commodityId, Float.valueOf(value));
                    }
                    miningConditions.put(id, resources);
                    continue;
                }
                catch (JSONException ex) {
                    log.error((Object)("Error loading market condition entry " + id + ": " + (Object)((Object)ex)));
                }
            }
        }
        catch (IOException | JSONException ex) {
            log.error((Object)("Error loading market condition data: " + ex));
        }
        MiningHelperLegacy.initCacheDefs();
        accidentPicker.add((Object)AccidentType.HULL_DAMAGE, 1.0f);
        accidentPicker.add((Object)AccidentType.CR_LOSS, 1.5f);
        accidentPicker.add((Object)AccidentType.CREW_LOSS, 1.5f);
        accidentPicker.add((Object)AccidentType.MACHINERY_LOSS, 2.0f);
    }

    public static enum AccidentType {
        HULL_DAMAGE,
        CR_LOSS,
        CREW_LOSS,
        MACHINERY_LOSS;

    }

    public static enum CacheType {
        WEAPON,
        FRIGATE,
        FIGHTER_WING,
        COMMODITY;

    }

    public static class MiningAccident {
        public int crewLost = 0;
        public int machineryLost = 0;
        public Map<FleetMemberAPI, Float> damage = new HashMap<FleetMemberAPI, Float>();
        public List<FleetMemberAPI> shipsDestroyed = new ArrayList<FleetMemberAPI>();
        public Map<FleetMemberAPI, Float> crLost = new HashMap<FleetMemberAPI, Float>();
    }

    public static class CacheResult {
        public CacheDef def;
        public String name = "";
        public int numItems = 0;

        public CacheResult(CacheDef def, String name, int numItems) {
            this.def = def;
            this.name = name;
            this.numItems = numItems;
        }
    }

    public static class MiningReport {
        public Map<String, Map<String, Float>> outputByCondition = new HashMap<String, Map<String, Float>>();
        public Map<String, Float> totalOutput = new HashMap<String, Float>();
        public float exhaustion = 0.0f;
        public float danger = 0.0f;
        public boolean isPlayer = false;
    }

    public static class CacheDef {
        public String id;
        public CacheType type;
        public String commodityId;
        public float mult;
        public float chance;

        public CacheDef(String id, CacheType type, String commodityId, float mult, float chance) {
            this.id = id;
            this.type = type;
            this.mult = mult;
            this.chance = chance;
            this.commodityId = commodityId;
        }
    }

    public static class MiningResult {
        public MiningReport report;
        public MiningAccident accidents;
        public List<CacheResult> cachesFound = new ArrayList<CacheResult>();
    }
}

