/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NexFleetEncounterContext
extends FleetEncounterContext {
    public static final float FRIGATE_XP_BONUS = 1.5f;
    public static final float DESTROYER_XP_BONUS = 1.25f;
    protected List<OfficerDataAPI> playerLostOfficers = new ArrayList<OfficerDataAPI>(10);
    protected List<OfficerDataAPI> playerOfficersEscaped = new ArrayList<OfficerDataAPI>(10);
    protected List<OfficerDataAPI> playerOfficersKIA = new ArrayList<OfficerDataAPI>(10);
    protected List<OfficerDataAPI> playerOfficersMIA = new ArrayList<OfficerDataAPI>(10);
    protected List<OfficerDataAPI> playerRecoverableOfficerLosses = new ArrayList<OfficerDataAPI>(10);
    protected List<OfficerDataAPI> playerUnconfirmedOfficers = new ArrayList<OfficerDataAPI>(10);

    public List<OfficerDataAPI> getPlayerLostOfficers() {
        return Collections.unmodifiableList(this.playerLostOfficers);
    }

    public List<OfficerDataAPI> getPlayerOfficersEscaped() {
        return Collections.unmodifiableList(this.playerOfficersEscaped);
    }

    public List<OfficerDataAPI> getPlayerOfficersKIA() {
        return Collections.unmodifiableList(this.playerOfficersKIA);
    }

    public List<OfficerDataAPI> getPlayerOfficersMIA() {
        return Collections.unmodifiableList(this.playerOfficersMIA);
    }

    public List<OfficerDataAPI> getPlayerRecoverableOfficers() {
        return Collections.unmodifiableList(this.playerRecoverableOfficerLosses);
    }

    public List<OfficerDataAPI> getPlayerUnconfirmedOfficers() {
        return Collections.unmodifiableList(this.playerUnconfirmedOfficers);
    }

    public void recoverPlayerOfficers() {
        for (OfficerDataAPI officer : this.playerRecoverableOfficerLosses) {
            Global.getSector().getPlayerFleet().getFleetData().addOfficer(officer.getPerson());
            officer.addXP(0L);
            if (officer.canLevelUp()) {
                officer.getSkillPicks();
            }
            this.playerUnconfirmedOfficers.remove(officer);
        }
        this.playerRecoverableOfficerLosses.clear();
    }

    protected void applyOfficerLosses(EngagementResultAPI result) {
        EngagementResultForFleetAPI winner = result.getWinnerResult();
        EngagementResultForFleetAPI loser = result.getLoserResult();
        this.playerOfficersEscaped.clear();
        this.playerOfficersKIA.clear();
        this.playerOfficersMIA.clear();
        boolean playerInvolved = this.battle.isPlayerInvolved();
        this.calculateAndApplyOfficerLosses(winner, playerInvolved);
        this.calculateAndApplyOfficerLosses(loser, playerInvolved);
    }

    protected void applyResultToFleets(EngagementResultAPI result) {
        super.applyResultToFleets(result);
        this.applyOfficerLosses(result);
    }

    protected void calculateAndApplyOfficerLosses(EngagementResultForFleetAPI result, boolean playerInvolved) {
        if (!ExerelinConfig.officerDeaths) {
            return;
        }
        if (!playerInvolved) {
            return;
        }
        FleetEncounterContextPlugin.DataForEncounterSide data = this.getDataFor(result.getFleet());
        ArrayList all = new ArrayList(result.getDisabled().size() + result.getDestroyed().size());
        all.addAll(result.getDisabled());
        all.addAll(result.getDestroyed());
        CampaignFleetAPI playerFleet = null;
        for (FleetMemberAPI member : all) {
            boolean isPlayer;
            float recoverableChance;
            float escapeChance;
            OfficerDataAPI officer;
            if (this.battle.getSourceFleet(member) == null || member.isFighterWing() || member.getCaptain().isDefault() || (officer = this.battle.getSourceFleet(member).getFleetData().getOfficerData(member.getCaptain())) == null) continue;
            if (result.getDestroyed().contains(member)) {
                escapeChance = ExerelinUtils.lerp(0.5f, 1.0f, 1.0f - member.getStats().getCrewLossMult().getModifiedValue());
                recoverableChance = 0.0f;
            } else {
                escapeChance = ExerelinUtils.lerp(0.5f, 1.0f, 1.0f - member.getStats().getCrewLossMult().getModifiedValue());
                recoverableChance = 0.75f;
            }
            if (this.battle.getSourceFleet(member).isPlayerFleet()) {
                playerFleet = this.battle.getSourceFleet(member);
                isPlayer = true;
            } else {
                isPlayer = false;
            }
            if ((float)Math.random() < escapeChance) {
                if (!isPlayer) continue;
                this.playerOfficersEscaped.add(officer);
                continue;
            }
            if (recoverableChance == 0.0f) {
                member.setCaptain(null);
                this.battle.getSourceFleet(member).getFleetData().removeOfficer(officer.getPerson());
                if (!isPlayer) continue;
                this.playerOfficersKIA.add(officer);
                this.playerLostOfficers.add(officer);
                continue;
            }
            member.setCaptain(null);
            this.battle.getSourceFleet(member).getFleetData().removeOfficer(officer.getPerson());
            if (isPlayer) {
                this.playerOfficersMIA.add(officer);
                this.playerUnconfirmedOfficers.add(officer);
            }
            if ((float)Math.random() < recoverableChance) {
                if (!isPlayer) continue;
                this.playerRecoverableOfficerLosses.add(officer);
                continue;
            }
            if (!isPlayer) continue;
            this.playerLostOfficers.add(officer);
        }
        if (playerFleet != null && !playerFleet.isValidPlayerFleet()) {
            for (OfficerDataAPI officer : this.playerOfficersEscaped) {
                playerFleet.getFleetData().removeOfficer(officer.getPerson());
                this.playerOfficersMIA.add(officer);
                this.playerLostOfficers.add(officer);
                this.playerUnconfirmedOfficers.add(officer);
            }
            this.playerOfficersEscaped.clear();
        }
    }

    protected void gainOfficerXP(FleetEncounterContextPlugin.DataForEncounterSide data, float xp) {
        float num;
        float max = data.getMaxTimeDeployed();
        if (max < 1.0f) {
            max = 1.0f;
        }
        if ((num = (float)data.getOfficerData().size()) < 1.0f) {
            num = 1.0f;
        }
        for (PersonAPI person : data.getOfficerData().keySet()) {
            OfficerDataAPI od;
            FleetEncounterContextPlugin.DataForEncounterSide.OfficerEngagementData oed = (FleetEncounterContextPlugin.DataForEncounterSide.OfficerEngagementData)data.getOfficerData().get(person);
            if (oed.sourceFleet == null || !oed.sourceFleet.isPlayerFleet() || (od = oed.sourceFleet.getFleetData().getOfficerData(person)) == null) continue;
            float f = oed.timeDeployed / max;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            float bonus = 1.0f;
            if (data.getFleet().getCommanderStats() != null) {
                bonus *= data.getFleet().getCommanderStats().getDynamic().getValue("officerXPMult");
            }
            if (ExerelinConfig.officerDaredevilBonus) {
                FleetMemberAPI member = oed.sourceFleet.getFleetData().getMemberWithCaptain(person);
                if (member != null && member.isFrigate()) {
                    bonus = 1.5f;
                } else if (member != null && member.isDestroyer()) {
                    bonus = 1.25f;
                }
            }
            od.addXP((long)(bonus * f * xp / num), this.textPanelForXPGain);
        }
    }
}

