/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.NexFleetEncounterContext;
import exerelin.campaign.events.FactionInsuranceEvent;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.histidine.foundation.campaign.events.FoundationInsuranceEvent;
import org.lwjgl.util.vector.Vector2f;

public class NexFleetInteractionDialogPluginImpl
extends FleetInteractionDialogPluginImpl {
    public static Logger log = Global.getLogger(NexFleetInteractionDialogPluginImpl.class);
    protected static final String STRING_HELPER_CAT = "exerelin_officers";
    protected static final Color NEUTRAL_COLOR = Global.getSettings().getColor("textNeutralColor");
    protected boolean recoveredOfficers = false;
    protected FleetInteractionDialogPluginImpl.FIDConfig config;

    protected String getTextString(String id) {
        return StringHelper.getString(STRING_HELPER_CAT, id);
    }

    public NexFleetInteractionDialogPluginImpl() {
        this.context = new NexFleetEncounterContext();
    }

    public NexFleetInteractionDialogPluginImpl(FleetInteractionDialogPluginImpl.FIDConfig params) {
        super(params);
        this.config = params;
        this.context = new NexFleetEncounterContext();
    }

    public void backFromEngagement(EngagementResultAPI result) {
        super.backFromEngagement(result);
        boolean totalDefeat = !this.playerFleet.isValidPlayerFleet();
        boolean mutualDestruction = this.context.getLastEngagementOutcome() == FleetEncounterContextPlugin.EngagementOutcome.MUTUAL_DESTRUCTION;
        List<OfficerDataAPI> officersEscaped = ((NexFleetEncounterContext)this.context).getPlayerOfficersEscaped();
        List<OfficerDataAPI> officersMIA = ((NexFleetEncounterContext)this.context).getPlayerOfficersMIA();
        List<OfficerDataAPI> officersKIA = ((NexFleetEncounterContext)this.context).getPlayerOfficersKIA();
        if (!(officersEscaped.isEmpty() || totalDefeat || mutualDestruction)) {
            String s2;
            String s1;
            ArrayList<String> escaped = new ArrayList<String>(officersEscaped.size());
            for (OfficerDataAPI officer : officersEscaped) {
                escaped.add(officer.getPerson().getName().getFullName());
            }
            if (escaped.size() == 1) {
                s1 = this.getTextString("officer");
                s2 = StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "hisOrHerShip", "$pronoun", StringHelper.getHisOrHer(officersEscaped.get(0).getPerson()));
            } else {
                s1 = this.getTextString("officers");
                s2 = this.getTextString("theirShips");
            }
            String str = this.getTextString("battle_escaped") + ".";
            str = StringHelper.substituteToken(str, "$officers", s1, true);
            str = StringHelper.substituteToken(str, "$officerNames", Misc.getAndJoined((String[])escaped.toArray(new String[escaped.size()])));
            str = StringHelper.substituteToken(str, "$theirShips", s2);
            this.addText(str);
        }
        if (!(officersMIA.isEmpty() && officersKIA.isEmpty() || totalDefeat || mutualDestruction)) {
            String s2;
            String text;
            String s1;
            int lost = officersMIA.size() + officersKIA.size();
            if (officersKIA.isEmpty()) {
                s1 = lost == 1 ? this.getTextString("officer") : this.getTextString("officers");
                text = StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "battle_noReportIn", "$officers", s1, true) + ":";
            } else if (lost == 1) {
                s1 = this.getTextString("officer");
                text = StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "battle_casualties", "$officer", s1, true) + ":";
            } else {
                s1 = this.getTextString("officers");
                text = StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "battle_casualties_plural", "$officers", s1, true) + ":";
            }
            ArrayList<String> highlights = new ArrayList<String>((officersMIA.size() + officersKIA.size()) * 2);
            ArrayList<Color> highlightColors = new ArrayList<Color>((officersMIA.size() + officersKIA.size()) * 2);
            for (OfficerDataAPI officer : officersMIA) {
                s1 = officer.getPerson().getName().getFullName();
                s2 = this.getTextString("missingInAction");
                text = text + "\n" + s1 + " (" + officer.getPerson().getStats().getLevel() + ") - " + s2;
                highlights.add(s1);
                highlights.add(s2);
                highlightColors.add(NEUTRAL_COLOR);
                highlightColors.add(ENEMY_COLOR);
            }
            for (OfficerDataAPI officer : officersKIA) {
                s1 = officer.getPerson().getName().getFullName();
                s2 = this.getTextString("killedInAction");
                text = text + "\n" + s1 + " (" + officer.getPerson().getStats().getLevel() + ") - " + s2;
                highlights.add(s1);
                highlights.add(s2);
                highlightColors.add(NEUTRAL_COLOR);
                highlightColors.add(ENEMY_COLOR);
            }
            this.addText(text);
            this.textPanel.highlightInLastPara(highlights.toArray(new String[highlights.size()]));
            this.textPanel.setHighlightColorsInLastPara(highlightColors.toArray(new Color[highlightColors.size()]));
        }
    }

    protected void losingPath() {
        if (!this.recoveredOfficers) {
            this.recoveredOfficers = true;
            List<OfficerDataAPI> recoverableOfficers = ((NexFleetEncounterContext)this.context).getPlayerRecoverableOfficers();
            List<OfficerDataAPI> lostOfficers = ((NexFleetEncounterContext)this.context).getPlayerLostOfficers();
            List<OfficerDataAPI> unconfirmedOfficers = ((NexFleetEncounterContext)this.context).getPlayerUnconfirmedOfficers();
            if (!lostOfficers.isEmpty() || !recoverableOfficers.isEmpty()) {
                String s2;
                String s1 = lostOfficers.size() + recoverableOfficers.size() == 1 ? this.getTextString("officer") : this.getTextString("officers");
                String text = StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "confirmDeath", "$officers", s1) + ":";
                ArrayList<String> highlights = new ArrayList<String>((lostOfficers.size() + recoverableOfficers.size()) * 2);
                ArrayList<Color> highlightColors = new ArrayList<Color>((lostOfficers.size() + recoverableOfficers.size()) * 2);
                for (OfficerDataAPI officer : lostOfficers) {
                    s1 = officer.getPerson().getName().getFullName();
                    s2 = unconfirmedOfficers.contains(officer) ? this.getTextString("miaPresumedDead") : this.getTextString("killedInAction");
                    text = text + "\n" + s1 + " (" + officer.getPerson().getStats().getLevel() + ") - " + s2;
                    highlights.add(s1);
                    highlights.add(s2);
                    highlightColors.add(NEUTRAL_COLOR);
                    highlightColors.add(ENEMY_COLOR);
                }
                for (OfficerDataAPI officer : recoverableOfficers) {
                    s1 = officer.getPerson().getName().getFullName();
                    s2 = this.getTextString("miaPresumedDead");
                    text = text + "\n" + s1 + " (" + officer.getPerson().getStats().getLevel() + ") - " + s2;
                    highlights.add(s1);
                    highlights.add(s2);
                    highlightColors.add(NEUTRAL_COLOR);
                    highlightColors.add(ENEMY_COLOR);
                }
                this.addText(text);
                this.textPanel.highlightInLastPara(highlights.toArray(new String[highlights.size()]));
                this.textPanel.setHighlightColorsInLastPara(highlightColors.toArray(new Color[highlightColors.size()]));
                this.handleLifeInsurance(lostOfficers, recoverableOfficers);
            }
        }
        super.losingPath();
    }

    protected void winningPath() {
        if (!this.recoveredOfficers) {
            String s2;
            ArrayList<Color> highlightColors;
            ArrayList<String> highlights;
            String text;
            String s1;
            this.recoveredOfficers = true;
            List<OfficerDataAPI> recoverableOfficers = ((NexFleetEncounterContext)this.context).getPlayerRecoverableOfficers();
            List<OfficerDataAPI> lostOfficers = ((NexFleetEncounterContext)this.context).getPlayerLostOfficers();
            if (!recoverableOfficers.isEmpty()) {
                if (recoverableOfficers.size() == 1) {
                    s1 = this.getTextString("officer");
                    text = StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "savedFromWreckage", "$officer", s1) + ":";
                } else {
                    s1 = this.getTextString("officers");
                    text = StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "savedFromWreckagePlural", "$officers", s1) + ":";
                }
                highlights = new ArrayList<String>(recoverableOfficers.size() * 2);
                highlightColors = new ArrayList<Color>(recoverableOfficers.size() * 2);
                for (OfficerDataAPI officer : recoverableOfficers) {
                    s1 = officer.getPerson().getName().getFullName();
                    s2 = "rescued";
                    text = text + "\n" + s1 + " (" + officer.getPerson().getStats().getLevel() + ") - " + s2;
                    highlights.add(s1);
                    highlights.add(s2);
                    highlightColors.add(NEUTRAL_COLOR);
                    highlightColors.add(FRIEND_COLOR);
                }
                this.addText(text);
                this.textPanel.highlightInLastPara(highlights.toArray(new String[highlights.size()]));
                this.textPanel.setHighlightColorsInLastPara(highlightColors.toArray(new Color[highlightColors.size()]));
                ((NexFleetEncounterContext)this.context).recoverPlayerOfficers();
            }
            if (!lostOfficers.isEmpty()) {
                s1 = lostOfficers.size() == 1 ? this.getTextString("officer") : this.getTextString("officers");
                text = StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "confirmDeath", "$officers", s1) + ":";
                highlights = new ArrayList(lostOfficers.size() * 2);
                highlightColors = new ArrayList(lostOfficers.size() * 2);
                for (OfficerDataAPI officer : lostOfficers) {
                    s1 = officer.getPerson().getName().getFullName();
                    s2 = this.getTextString("killedInAction");
                    text = text + "\n" + s1 + " (" + officer.getPerson().getStats().getLevel() + ") - " + s2;
                    highlights.add(s1);
                    highlights.add(s2);
                    highlightColors.add(NEUTRAL_COLOR);
                    highlightColors.add(ENEMY_COLOR);
                }
                this.addText(text);
                this.textPanel.highlightInLastPara(highlights.toArray(new String[highlights.size()]));
                this.textPanel.setHighlightColorsInLastPara(highlightColors.toArray(new Color[highlightColors.size()]));
            }
            this.handleLifeInsurance(lostOfficers, null);
        }
        super.winningPath();
    }

    protected void handleLifeInsurance(List<OfficerDataAPI> deadOfficers, List<OfficerDataAPI> miaOfficers) {
        FactionInsuranceEvent event;
        ArrayList<OfficerDataAPI> officers = new ArrayList<OfficerDataAPI>(deadOfficers);
        if (miaOfficers != null) {
            officers.addAll(miaOfficers);
        }
        if (Global.getSector().getEventManager().isOngoing(null, "exerelin_faction_insurance")) {
            event = (FactionInsuranceEvent)Global.getSector().getEventManager().getOngoingEvent(null, "exerelin_faction_insurance");
            event.addDeadOfficers(officers);
        }
        if (Global.getSector().getEventManager().isOngoing(null, "foundation_insurance")) {
            event = (FoundationInsuranceEvent)Global.getSector().getEventManager().getOngoingEvent(null, "foundation_insurance");
            event.addDeadOfficers(officers);
        }
    }

    public void init(InteractionDialogAPI dialog) {
        if (this.config == null) {
            MemoryAPI memory = dialog.getInteractionTarget().getMemoryWithoutUpdate();
            this.config = memory.contains("$fidConifgGen") ? ((FleetInteractionDialogPluginImpl.FIDConfigGen)memory.get("$fidConifgGen")).createConfig() : new FleetInteractionDialogPluginImpl.FIDConfig();
        }
        super.init(dialog);
    }

    protected boolean shouldPullInFleet(BattleAPI battle, CampaignFleetAPI fleet, float dist) {
        float baseSensorRange = this.playerFleet.getBaseSensorRangeToDetect(fleet.getSensorProfile());
        boolean visible = fleet.isVisibleToPlayerFleet();
        SectorEntityToken.VisibilityLevel level = fleet.getVisibilityLevelToPlayerFleet();
        if (dist > Misc.getBattleJoinRange()) {
            return false;
        }
        if (dist > baseSensorRange && (!visible || level == SectorEntityToken.VisibilityLevel.SENSOR_CONTACT)) {
            return false;
        }
        if (fleet.getAI() != null && fleet.getAI().wantsToJoin(battle, true)) {
            return true;
        }
        if (fleet.isStationMode()) {
            return false;
        }
        if (fleet.getAI() != null) {
            FleetAssignmentDataAPI assignment = fleet.getAI().getCurrentAssignment();
            if (assignment == null) {
                return true;
            }
            SectorEntityToken target = assignment.getTarget();
            if (target != null && target instanceof CampaignFleetAPI) {
                List fleets = battle.getBothSides();
                for (CampaignFleetAPI inBattle : fleets) {
                    if (inBattle != target) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void pullInNearbyFleets() {
        boolean hostile;
        BattleAPI b = this.context.getBattle();
        boolean bl = hostile = this.otherFleet.getAI() != null && this.otherFleet.getAI().isHostileTo(this.playerFleet);
        if (this.ongoingBattle) {
            hostile = true;
        }
        if (!this.ongoingBattle) {
            b.join(Global.getSector().getPlayerFleet());
        }
        BattleAPI.BattleSide playerSide = b.pickSide(Global.getSector().getPlayerFleet());
        CampaignFleetAPI actualPlayer = Global.getSector().getPlayerFleet();
        CampaignFleetAPI actualOther = (CampaignFleetAPI)this.dialog.getInteractionTarget();
        this.pulledIn.clear();
        for (CampaignFleetAPI fleet : actualPlayer.getContainingLocation().getFleets()) {
            if (b == fleet.getBattle() || fleet.getBattle() != null) continue;
            float dist = Misc.getDistance((Vector2f)actualOther.getLocation(), (Vector2f)fleet.getLocation());
            dist -= actualOther.getRadius();
            if (!this.shouldPullInFleet(b, fleet, dist -= fleet.getRadius())) continue;
            BattleAPI.BattleSide joiningSide = b.pickSide(fleet, true);
            if (!this.config.pullInAllies && joiningSide == playerSide || !this.config.pullInEnemies && joiningSide != playerSide) continue;
            b.join(fleet);
            this.pulledIn.add(fleet);
            String fleetName = Misc.ucFirst((String)fleet.getNameWithFactionKeepCase());
            String action = b.getSide(playerSide) == b.getSideFor(fleet) ? StringHelper.getString("exerelin_fleets", "supportingYourForces") : (hostile ? StringHelper.getString("exerelin_fleets", "joiningTheEnemy") : StringHelper.getString("exerelin_fleets", "supportingOpposingSide"));
            this.textPanel.addParagraph(fleetName + ": " + action + ".");
            this.textPanel.highlightFirstInLastPara(fleetName + ":", fleet.getFaction().getBaseUIColor());
        }
        if (!this.ongoingBattle) {
            b.genCombined();
            b.takeSnapshots();
            this.playerFleet = b.getPlayerCombined();
            this.otherFleet = b.getNonPlayerCombined();
            this.showFleetInfo();
        }
    }
}

