/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlayerFactionStore {
    private static final String PLAYER_FACTION_ID_KEY = "exerelin_playerFactionId";
    private static final String PLAYER_RELATIONS_KEY = "exerelin_independentPlayerRelations";
    private static String factionId = "player_npc";
    public static Logger log = Global.getLogger(PlayerFactionStore.class);

    public static void setPlayerFactionId(String newFactionId) {
        factionId = newFactionId;
        Map data = Global.getSector().getPersistentData();
        data.put(PLAYER_FACTION_ID_KEY, factionId);
        log.info((Object)("Stored player faction ID as " + factionId));
    }

    public static void setPlayerFactionIdNGC(String newFactionId) {
        factionId = newFactionId;
    }

    public static String getPlayerFactionIdNGC() {
        return factionId;
    }

    public static String getPlayerFactionId() {
        Map data = Global.getSector().getPersistentData();
        String storedId = (String)data.get(PLAYER_FACTION_ID_KEY);
        if (storedId != null) {
            factionId = storedId;
            return storedId;
        }
        return factionId;
    }

    public static void saveIndependentPlayerRelation(String factionId) {
        SectorAPI sector = Global.getSector();
        Map data = sector.getPersistentData();
        HashMap<String, Float> storedRelations = (HashMap<String, Float>)data.get(PLAYER_RELATIONS_KEY);
        if (storedRelations == null) {
            storedRelations = new HashMap<String, Float>();
        }
        FactionAPI playerFaction = sector.getFaction("player");
        float relation = playerFaction.getRelationship(factionId);
        storedRelations.put(factionId, Float.valueOf(relation));
        data.put(PLAYER_RELATIONS_KEY, storedRelations);
    }

    public static void saveIndependentPlayerRelations() {
        SectorAPI sector = Global.getSector();
        Map data = sector.getPersistentData();
        HashMap<String, Float> storedRelations = new HashMap<String, Float>();
        FactionAPI playerFaction = sector.getFaction("player");
        for (FactionAPI faction : sector.getAllFactions()) {
            float relation = playerFaction.getRelationship(faction.getId());
            storedRelations.put(faction.getId(), Float.valueOf(relation));
            log.info((Object)("Saving independent player relations with " + faction.getDisplayName() + " as " + relation));
        }
        data.put(PLAYER_RELATIONS_KEY, storedRelations);
    }

    public static void loadIndependentPlayerRelations(boolean retainWithCurrentFaction) {
        SectorAPI sector = Global.getSector();
        Map data = sector.getPersistentData();
        HashMap storedRelations = (HashMap)data.get(PLAYER_RELATIONS_KEY);
        if (storedRelations == null) {
            return;
        }
        FactionAPI playerFaction = sector.getFaction("player");
        for (FactionAPI faction : sector.getAllFactions()) {
            Float relation = (Float)storedRelations.get(faction.getId());
            if (relation == null || retainWithCurrentFaction && faction.getId().equals(factionId)) continue;
            faction.setRelationship("player", relation.floatValue());
            log.info((Object)("Loading independent player relations with " + faction.getDisplayName() + " as " + relation));
        }
    }
}

