/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.SectorManager;
import exerelin.utilities.StringHelper;
import java.util.Map;

public class ReinitScreenScript
implements EveryFrameScript {
    private static final float DAYS_TO_WAIT = 0.1f;
    private boolean isDone = false;
    private float timer = 0.0f;

    public boolean isDone() {
        return this.isDone;
    }

    public boolean runWhilePaused() {
        return true;
    }

    public void advance(float amount) {
        CampaignUIAPI ui = Global.getSector().getCampaignUI();
        if (Global.getSector().isInNewGameAdvance() || ui.isShowingDialog()) {
            return;
        }
        this.timer += Global.getSector().getClock().convertToDays(amount);
        if (this.timer < 0.1f) {
            return;
        }
        if (!this.isDone) {
            ui.showInteractionDialog((InteractionDialogPlugin)new ReinitDialog(), (SectorEntityToken)Global.getSector().getPlayerFleet());
            this.isDone = true;
        }
    }

    private static class ReinitDialog
    implements InteractionDialogPlugin,
    CoreInteractionListener {
        private InteractionDialogAPI dialog;
        private TextPanelAPI text;
        private OptionPanelAPI options;
        private boolean allowRespawn = false;
        private boolean allowRespawnNonOriginal = false;
        private boolean randomizeRelationships = false;
        private boolean hardMode = false;

        private ReinitDialog() {
        }

        private void populateOptions() {
            this.options.clearOptions();
            this.options.addOption(Misc.ucFirst((String)this.getString("allowRespawn")) + ": " + StringHelper.getString(String.valueOf(this.allowRespawn)), (Object)Menu.OPTION_RESPAWN);
            if (this.allowRespawn) {
                this.options.addOption(Misc.ucFirst((String)this.getString("allowRespawnNonOriginal")) + ": " + StringHelper.getString(String.valueOf(this.allowRespawnNonOriginal)), (Object)Menu.OPTION_RESPAWN_NON_ORIGINAL);
            }
            this.options.addOption(Misc.ucFirst((String)this.getString("randomizeRelationships")) + ": " + StringHelper.getString(String.valueOf(this.randomizeRelationships)), (Object)Menu.OPTION_RANDOM_RELATIONSHIPS);
            this.options.addOption(Misc.ucFirst((String)this.getString("hardMode")) + ": " + StringHelper.getString(String.valueOf(this.hardMode)), (Object)Menu.OPTION_HARD_MODE);
            this.options.addOption(Misc.ucFirst((String)StringHelper.getString("done")), (Object)Menu.DONE);
        }

        protected String getString(String id) {
            return StringHelper.getString("exerelin_reinitScreen", id);
        }

        public void init(InteractionDialogAPI dialog) {
            this.dialog = dialog;
            this.options = dialog.getOptionPanel();
            this.text = dialog.getTextPanel();
            this.text.addParagraph(this.getString("introText"));
            this.populateOptions();
            dialog.setPromptText(Misc.ucFirst((String)StringHelper.getString("options")));
        }

        public void optionSelected(String optionText, Object optionData) {
            if (optionText != null) {
                this.text.addParagraph(optionText, Global.getSettings().getColor("buttonText"));
            }
            if (optionData == Menu.OPTION_RESPAWN) {
                this.allowRespawn = !this.allowRespawn;
                this.populateOptions();
            } else if (optionData == Menu.OPTION_RESPAWN_NON_ORIGINAL) {
                this.allowRespawnNonOriginal = !this.allowRespawnNonOriginal;
                this.populateOptions();
            } else if (optionData == Menu.OPTION_RANDOM_RELATIONSHIPS) {
                this.randomizeRelationships = !this.randomizeRelationships;
                this.populateOptions();
            } else if (optionData == Menu.OPTION_HARD_MODE) {
                this.hardMode = !this.hardMode;
                this.populateOptions();
            } else if (optionData == Menu.DONE) {
                SectorManager.setAllowRespawnFactions(this.allowRespawn, this.allowRespawnNonOriginal);
                SectorManager.setHardMode(this.hardMode);
                if (this.randomizeRelationships) {
                    DiplomacyManager.setRandomFactionRelationships(this.randomizeRelationships);
                    DiplomacyManager.initFactionRelationships(true);
                }
                this.dialog.dismiss();
            }
        }

        public void optionMousedOver(String optionText, Object optionData) {
        }

        public void advance(float amount) {
        }

        public void backFromEngagement(EngagementResultAPI battleResult) {
        }

        public Object getContext() {
            return null;
        }

        public Map<String, MemoryAPI> getMemoryMap() {
            return null;
        }

        public void coreUIDismissed() {
        }

        private static enum Menu {
            OPTION_RESPAWN,
            OPTION_RESPAWN_NON_ORIGINAL,
            OPTION_RANDOM_RELATIONSHIPS,
            OPTION_HARD_MODE,
            DONE;

        }
    }
}

