/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.ExerelinSetupData;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.StatsTracker;
import exerelin.campaign.VictoryScreenScript;
import exerelin.campaign.events.FactionChangedEvent;
import exerelin.campaign.events.RevengeanceManagerEvent;
import exerelin.campaign.events.SlavesSoldEvent;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.ExerelinUtilsMarket;
import exerelin.utilities.ExerelinUtilsReputation;
import exerelin.world.ExerelinCorvusLocations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;

public class SectorManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(SectorManager.class);
    protected static SectorManager sectorManager;
    protected static final String MANAGER_MAP_KEY = "exerelin_sectorManager";
    public static final List<String> POSTS_TO_CHANGE_ON_CAPTURE;
    public static final Set<String> NO_BLACK_MARKET;
    public static final Set<String> FORCE_MILITARY_MARKET;
    public static final Set<String> ALWAYS_CAPTURE_SUBMARKET;
    public static final Set<String> NO_WARMONGER_FACTIONS;
    protected List<String> factionIdsAtStart = new ArrayList<String>();
    protected List<String> liveFactionIds = new ArrayList<String>();
    protected Set<String> historicFactionIds = new HashSet<String>();
    protected Map<String, Integer> factionRespawnCounts = new HashMap<String, Integer>();
    protected Map<String, String> systemToRelayMap = new HashMap<String, String>();
    protected Map<String, String> planetToRelayMap = new HashMap<String, String>();
    protected boolean victoryHasOccured = false;
    protected boolean respawnFactions = false;
    protected boolean onlyRespawnStartingFactions = false;
    protected SectorEntityToken homeworld;
    protected boolean corvusMode = false;
    protected boolean hardMode = false;
    protected boolean freeStart = false;
    protected int numSlavesRecentlySold = 0;
    protected MarketAPI marketLastSoldSlaves = null;
    protected float respawnInterval = 60.0f;
    protected final IntervalUtil respawnIntervalUtil;
    protected boolean wantExpelPlayerFromFaction = false;

    public SectorManager() {
        super(true);
        this.respawnFactions = ExerelinSetupData.getInstance().respawnFactions;
        this.onlyRespawnStartingFactions = ExerelinSetupData.getInstance().onlyRespawnStartingFactions;
        this.respawnInterval = ExerelinConfig.factionRespawnInterval;
        this.respawnIntervalUtil = new IntervalUtil(this.respawnInterval * 0.75f, this.respawnInterval * 1.25f);
    }

    public void advance(float amount) {
        if (this.numSlavesRecentlySold > 0) {
            this.handleSlaveTradeRep();
            this.numSlavesRecentlySold = 0;
        }
        if (this.wantExpelPlayerFromFaction) {
            this.wantExpelPlayerFromFaction = false;
            SectorManager.expelPlayerFromFaction();
        }
        if (this.respawnFactions) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.respawnIntervalUtil.advance(days);
            if (this.respawnIntervalUtil.intervalElapsed()) {
                this.handleFactionRespawn();
                this.respawnInterval = ExerelinConfig.factionRespawnInterval;
                this.respawnIntervalUtil.setInterval(this.respawnInterval * 0.75f, this.respawnInterval * 1.25f);
            }
        }
    }

    public void reportEncounterLootGenerated(FleetEncounterContextPlugin plugin, CargoAPI loot) {
        CampaignFleetAPI loser = plugin.getLoser();
        if (loser == null) {
            return;
        }
        String loserFactionId = loser.getFaction().getId();
        ExerelinFactionConfig loserConfig = ExerelinConfig.getExerelinFactionConfig(loserFactionId);
        if (loserConfig != null && !loserConfig.dropPrisoners) {
            return;
        }
        int numSurvivors = 0;
        int fp = 0;
        int crew = 0;
        int prisoners = 0;
        float contrib = plugin.computePlayerContribFraction();
        List casualties = plugin.getLoserData().getOwnCasualties();
        for (FleetEncounterContextPlugin.FleetMemberData member : casualties) {
            FleetEncounterContextPlugin.Status status = member.getStatus();
            if (status == FleetEncounterContextPlugin.Status.DESTROYED || status == FleetEncounterContextPlugin.Status.NORMAL) continue;
            fp += member.getMember().getFleetPointCost();
            crew = (int)((float)crew + member.getMember().getMinCrew());
            PersonAPI captain = member.getMember().getCaptain();
            if (captain == null || captain.isDefault()) continue;
            float survivalChance = 1.0f - 0.5f * member.getMember().getStats().getCrewLossMult().modified;
            float captureChance = 0.15f + 0.1f * (float)captain.getStats().getLevel() / 20.0f;
            if (!(Math.random() < (double)(survivalChance * captureChance))) continue;
            ++prisoners;
        }
        for (int i = 0; i < fp; i += 10) {
            if (!(Math.random() < (double)ExerelinConfig.prisonerLootChancePer10Fp)) continue;
            ++prisoners;
        }
        prisoners = (int)((float)prisoners * contrib + 0.5f);
        loot.addCommodity("prisoner", (float)prisoners);
        numSurvivors += prisoners;
        crew = (int)((float)crew * ExerelinConfig.crewLootMult * MathUtils.getRandomNumberInRange((float)0.5f, (float)1.5f));
        crew += MathUtils.getRandomNumberInRange((int)-3, (int)3);
        crew = (int)((float)crew * contrib);
        if (crew > 0) {
            loot.addCrew(crew);
            numSurvivors += crew;
        }
        StatsTracker.getStatsTracker().modifyOrphansMadeByCrewCount(-numSurvivors, loserFactionId);
    }

    public void reportPlayerEngagement(EngagementResultAPI result) {
        FactionAPI faction;
        boolean playerWin = result.didPlayerWin();
        EngagementResultForFleetAPI fleetResult = result.getWinnerResult();
        if (playerWin) {
            fleetResult = result.getLoserResult();
        }
        if ((faction = fleetResult.getFleet().getFaction()).isHostileTo("player")) {
            return;
        }
        if (fleetResult.getDisabled().isEmpty() && fleetResult.getDestroyed().isEmpty()) {
            return;
        }
        CampaignFleetAPI fleet = fleetResult.getFleet();
        if (fleet.getMemoryWithoutUpdate().getBoolean("$exerelinFleetAggressAgainstPlayer")) {
            return;
        }
        if (fleet.getMemoryWithoutUpdate().getBoolean("$Cabal_extortionAskedFor")) {
            return;
        }
        if (fleet.getMemoryWithoutUpdate().getBoolean("$lowRepImpact")) {
            return;
        }
        if (!result.getBattle().isPlayerPrimary()) {
            return;
        }
        if (!fleet.knowsWhoPlayerIs()) {
            return;
        }
        SectorManager.createWarmongerEvent(faction.getId(), (SectorEntityToken)fleet);
    }

    public void reportPlayerOpenedMarket(MarketAPI market) {
        market.getMemoryWithoutUpdate().set("$visitedBefore", (Object)true);
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static SectorManager create() {
        Map data = Global.getSector().getPersistentData();
        sectorManager = (SectorManager)((Object)data.get(MANAGER_MAP_KEY));
        if (sectorManager != null) {
            return sectorManager;
        }
        sectorManager = new SectorManager();
        data.put(MANAGER_MAP_KEY, sectorManager);
        return sectorManager;
    }

    public static boolean isSectorManagerSaved() {
        Map data = Global.getSector().getPersistentData();
        sectorManager = (SectorManager)((Object)data.get(MANAGER_MAP_KEY));
        return sectorManager != null;
    }

    public static void setCorvusMode(boolean mode) {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.corvusMode = mode;
    }

    public static boolean getCorvusMode() {
        if (sectorManager == null) {
            SectorManager.create();
        }
        if (sectorManager == null) {
            return false;
        }
        return SectorManager.sectorManager.corvusMode;
    }

    public static void setHardMode(boolean mode) {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.hardMode = mode;
    }

    public static boolean getHardMode() {
        if (sectorManager == null) {
            return false;
        }
        return SectorManager.sectorManager.hardMode;
    }

    public static void createWarmongerEvent(String targetFactionId, SectorEntityToken location) {
        if (ExerelinConfig.warmongerPenalty == 0) {
            return;
        }
        if (NO_WARMONGER_FACTIONS.contains(targetFactionId)) {
            return;
        }
        FactionAPI targetFaction = Global.getSector().getFaction(targetFactionId);
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        if (targetFaction.isHostileTo("player")) {
            return;
        }
        if (targetFactionId.equals(playerAlignedFactionId) || targetFactionId.equals("player_npc")) {
            return;
        }
        int numFactions = 0;
        float totalRepLoss = 0.0f;
        float myFactionLoss = 0.0f;
        HashMap<String, Float> repLoss = new HashMap<String, Float>();
        ArrayList<String> factions = SectorManager.getLiveFactionIdsCopy();
        for (String factionId : factions) {
            if (factionId.equals(targetFactionId) || targetFaction.isHostileTo(factionId) || factionId.equals("player_npc") && ExerelinConfig.warmongerPenalty <= 1) continue;
            float loss = 0.0f;
            RepLevel level = targetFaction.getRelationshipLevel(factionId);
            if (level == RepLevel.COOPERATIVE) {
                loss = 30.0f;
            } else if (level == RepLevel.FRIENDLY) {
                loss = 24.0f;
            } else if (level == RepLevel.WELCOMING) {
                loss = 18.0f;
            } else if (level == RepLevel.FAVORABLE) {
                loss = 12.0f;
            } else if (level == RepLevel.NEUTRAL) {
                loss = 8.0f;
            } else if (level == RepLevel.SUSPICIOUS) {
                loss = 5.0f;
            }
            loss *= 0.01f;
            if (factionId.equals(playerAlignedFactionId)) {
                myFactionLoss = loss;
                if (!factionId.equals("player_npc")) {
                    myFactionLoss = 2.0f * loss + 0.05f;
                }
                repLoss.put(factionId, Float.valueOf(myFactionLoss));
                continue;
            }
            if (loss <= 0.0f) continue;
            ++numFactions;
            totalRepLoss += loss;
            repLoss.put(factionId, Float.valueOf(loss));
        }
        if (numFactions == 0 && myFactionLoss == 0.0f) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("avgRepLoss", Float.valueOf(totalRepLoss / (float)numFactions));
        params.put("numFactions", numFactions);
        params.put("repLoss", repLoss);
        params.put("myFactionLoss", Float.valueOf(myFactionLoss));
        params.put("targetFaction", targetFactionId);
        Global.getSector().getEventManager().startEvent(new CampaignEventTarget(location), "exerelin_warmonger", params);
    }

    public void handleSlaveTradeRep() {
        if (ExerelinConfig.prisonerSlaveRepValue > 0.0f) {
            return;
        }
        LocationAPI loc = this.marketLastSoldSlaves.getPrimaryEntity().getContainingLocation();
        List markets = Misc.getMarketsInLocation((LocationAPI)loc);
        ArrayList<String> factionsToNotify = new ArrayList<String>();
        HashSet<String> seenFactions = new HashSet<String>();
        HashMap<String, Float> repPenalties = new HashMap<String, Float>();
        float sumRepDelta = 0.0f;
        for (MarketAPI market : markets) {
            FactionAPI faction = market.getFaction();
            String factionId = market.getFactionId();
            if (seenFactions.contains(factionId)) continue;
            seenFactions.add(factionId);
            float delta = SlavesSoldEvent.getSlaveRepPenalty(factionId, this.numSlavesRecentlySold);
            if (delta >= 0.0f) continue;
            factionsToNotify.add(factionId);
            repPenalties.put(factionId, Float.valueOf(delta));
            sumRepDelta += delta;
        }
        if (factionsToNotify.isEmpty()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("factionsToNotify", factionsToNotify);
        params.put("numSlaves", this.numSlavesRecentlySold);
        params.put("repPenalties", repPenalties);
        params.put("avgRepChange", Float.valueOf(sumRepDelta / (float)factionsToNotify.size()));
        SlavesSoldEvent event = (SlavesSoldEvent)Global.getSector().getEventManager().getOngoingEvent(null, "exerelin_slaves_sold");
        event.reportSlaveTrade(this.marketLastSoldSlaves, params);
    }

    public static InvasionFleetManager.InvasionFleetData spawnRespawnFleet(FactionAPI respawnFaction, MarketAPI sourceMarket, boolean useOriginLoc) {
        SectorAPI sector = Global.getSector();
        String respawnFactionId = respawnFaction.getId();
        WeightedRandomPicker sourcePicker = new WeightedRandomPicker();
        WeightedRandomPicker targetPicker = new WeightedRandomPicker();
        List markets = sector.getEconomy().getMarketsCopy();
        for (MarketAPI market : markets) {
            if (!ExerelinUtilsMarket.shouldTargetForInvasions(market, 4)) continue;
            int size = market.getSize();
            if (market.hasCondition("headquarters")) {
                size = (int)((float)size * 0.1f);
            }
            targetPicker.add((Object)market, (float)size);
        }
        MarketAPI targetMarket = (MarketAPI)targetPicker.pick();
        if (targetMarket == null) {
            return null;
        }
        if (sourceMarket == null) {
            for (MarketAPI market : markets) {
                FactionAPI marketFaction = market.getFaction();
                float weight = 100.0f;
                if (market == targetMarket) continue;
                if (marketFaction.isHostileTo(respawnFaction)) {
                    weight = 1.0E-4f;
                }
                sourcePicker.add((Object)market, weight);
            }
            sourceMarket = (MarketAPI)sourcePicker.pick();
        }
        if (sourceMarket == null) {
            return null;
        }
        return InvasionFleetManager.spawnRespawnFleet(respawnFaction, sourceMarket, targetMarket, useOriginLoc);
    }

    public void handleFactionRespawn() {
        if (this.factionRespawnCounts == null) {
            this.factionRespawnCounts = new HashMap<String, Integer>();
        }
        WeightedRandomPicker factionPicker = new WeightedRandomPicker();
        List<String> factionIds = this.factionIdsAtStart;
        if (!this.onlyRespawnStartingFactions) {
            factionIds = ExerelinSetupData.getInstance().getPlayableFactions();
        }
        for (String factionId : factionIds) {
            ExerelinFactionConfig config;
            if (factionId.equals("player_npc") || factionId.equals("independent") || (config = ExerelinConfig.getExerelinFactionConfig(factionId)) != null && !config.playableFaction) continue;
            int maxRespawns = ExerelinConfig.maxFactionRespawns;
            if (maxRespawns >= 0) {
                int count = -1;
                if (this.factionRespawnCounts.containsKey(factionId)) {
                    count = this.factionRespawnCounts.get(factionId);
                } else if (this.factionIdsAtStart.contains(factionId)) {
                    ++count;
                }
                if (count >= maxRespawns) continue;
            }
            if (this.liveFactionIds.contains(factionId)) continue;
            factionPicker.add((Object)Global.getSector().getFaction(factionId));
        }
        FactionAPI respawnFaction = (FactionAPI)factionPicker.pick();
        if (respawnFaction == null) {
            return;
        }
        SectorManager.spawnRespawnFleet(respawnFaction, null, false);
    }

    public static void setShowFactionInIntelTab(String factionId, boolean show) {
        if (factionId.equals("player_npc")) {
            return;
        }
        if (!show && ExerelinUtilsFaction.isExiInCorvus(factionId)) {
            return;
        }
        ExerelinFactionConfig conf = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (conf != null && !conf.showIntelEvenIfDead) {
            FactionAPI faction = Global.getSector().getFaction(factionId);
            faction.setShowInIntelTab(show);
        }
    }

    public static void factionEliminated(FactionAPI victor, FactionAPI defeated, MarketAPI market) {
        if (defeated.getId().equals("independent")) {
            return;
        }
        if (!defeated.getId().equals("player_npc")) {
            AllianceManager.leaveAlliance(defeated.getId(), true);
        }
        SectorManager.removeLiveFactionId(defeated.getId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("defeatedFaction", defeated);
        params.put("victorFaction", victor);
        FactionAPI playerFaction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        params.put("playerDefeated", defeated == playerFaction);
        Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_faction_eliminated", params);
        SectorManager.setShowFactionInIntelTab(defeated.getId(), false);
        ExerelinUtilsReputation.syncPlayerRelationshipsToFaction();
        SectorManager.checkForVictory();
    }

    public static void factionRespawned(FactionAPI faction, MarketAPI market) {
        String factionId = faction.getId();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        boolean existedBefore = false;
        if (sectorManager != null) {
            existedBefore = SectorManager.sectorManager.historicFactionIds.contains(factionId);
        }
        params.put("existedBefore", existedBefore);
        Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_faction_respawned", params);
        SectorManager.addLiveFactionId(faction.getId());
        if (sectorManager != null && !existedBefore) {
            SectorManager.sectorManager.historicFactionIds.add(factionId);
        }
        SectorManager.setShowFactionInIntelTab(factionId, true);
        if (sectorManager != null) {
            int count = 0;
            if (SectorManager.sectorManager.factionRespawnCounts.containsKey(factionId)) {
                count = SectorManager.sectorManager.factionRespawnCounts.get(factionId) + 1;
            } else if (SectorManager.sectorManager.factionIdsAtStart.contains(factionId)) {
                ++count;
            }
            SectorManager.sectorManager.factionRespawnCounts.put(factionId, count);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkForVictory() {
        if (sectorManager == null) {
            return;
        }
        if (SectorManager.sectorManager.victoryHasOccured) {
            return;
        }
        SectorAPI sector = Global.getSector();
        if (sector.isInNewGameAdvance()) {
            return;
        }
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI playerAlignedFaction = Global.getSector().getFaction(playerAlignedFactionId);
        String victorFactionId = playerAlignedFactionId;
        VictoryType victoryType = VictoryType.CONQUEST;
        ArrayList<String> liveFactions = SectorManager.getLiveFactionIdsCopy();
        for (String string : SectorManager.getLiveFactionIdsCopy()) {
            if (!ExerelinUtilsFaction.isPirateFaction(string) || ExerelinConfig.countPiratesForVictory || string.equals(playerAlignedFactionId)) continue;
            liveFactions.remove(string);
        }
        if (liveFactions.size() == 1) {
            victorFactionId = (String)liveFactions.get(0);
            if (!victorFactionId.equals(playerAlignedFactionId)) {
                victoryType = sector.getFaction("player").isAtBest(victorFactionId, RepLevel.WELCOMING) ? VictoryType.DEFEAT_CONQUEST : VictoryType.CONQUEST_ALLY;
            }
            SectorManager.sectorManager.victoryHasOccured = true;
        } else {
            void var7_10;
            ArrayList<String> eligibleWinners = new ArrayList<String>();
            for (String factionId : liveFactions) {
                boolean canWin = true;
                FactionAPI faction = sector.getFaction(factionId);
                if (faction.isNeutralFaction()) continue;
                for (String otherFactionId : liveFactions) {
                    if (faction.isAtWorst(otherFactionId, RepLevel.FRIENDLY)) continue;
                    canWin = false;
                    break;
                }
                if (!canWin) continue;
                eligibleWinners.add(factionId);
            }
            if (eligibleWinners.isEmpty()) {
                return;
            }
            String string = (String)eligibleWinners.get(0);
            int largestPopulation = 0;
            if (eligibleWinners.size() > 1) {
                for (String factionId : eligibleWinners) {
                    int pop = ExerelinUtilsFaction.getFactionMarketSizeSum(factionId);
                    if (pop <= largestPopulation) continue;
                    String string2 = factionId;
                    largestPopulation = pop;
                }
            }
            victoryType = var7_10.equals(playerAlignedFactionId) ? VictoryType.DIPLOMATIC : (playerAlignedFaction.isAtWorst((String)var7_10, RepLevel.FRIENDLY) ? VictoryType.DIPLOMATIC_ALLY : VictoryType.DEFEAT_DIPLOMATIC);
            victorFactionId = var7_10;
            SectorManager.sectorManager.victoryHasOccured = true;
        }
        if (SectorManager.sectorManager.victoryHasOccured) {
            Global.getSector().addScript((EveryFrameScript)new VictoryScreenScript(victorFactionId, victoryType));
        }
    }

    public static void retire() {
        Global.getSector().addScript((EveryFrameScript)new VictoryScreenScript("player", VictoryType.RETIRED));
        if (sectorManager != null) {
            SectorManager.sectorManager.victoryHasOccured = true;
        }
    }

    public static void captureMarket(MarketAPI market, FactionAPI newOwner, FactionAPI oldOwner, boolean playerInvolved, List<String> factionsToNotify, float repChangeStrength) {
        RevengeanceManagerEvent event;
        String newOwnerId = newOwner.getId();
        String oldOwnerId = oldOwner.getId();
        List linkedEntities = market.getConnectedEntities();
        for (Object entity : linkedEntities) {
            entity.setFaction(newOwnerId);
        }
        List people = market.getPeopleCopy();
        for (PersonAPI person : people) {
            if (!POSTS_TO_CHANGE_ON_CAPTURE.contains(person.getPostId())) continue;
            person.setFaction(newOwnerId);
        }
        market.setFactionId(newOwnerId);
        if (!newOwner.isHostileTo("player")) {
            market.getMemoryWithoutUpdate().unset("$playerHostileTimeout");
        }
        if (newOwnerId.equals("templars") && !oldOwnerId.equals("templars")) {
            market.removeSubmarket("open_market");
            market.removeSubmarket("black_market");
            market.removeSubmarket("generic_military");
            market.addSubmarket("tem_templarmarket");
            if (!market.hasCondition("exerelin_templar_control")) {
                market.addCondition("exerelin_templar_control");
            }
        } else if (!newOwnerId.equals("templars") && oldOwnerId.equals("templars")) {
            market.addSubmarket("open_market");
            if (!NO_BLACK_MARKET.contains(market.getId())) {
                market.addSubmarket("black_market");
            }
            if (market.hasCondition("military_base") || market.hasCondition("tem_avalon") || FORCE_MILITARY_MARKET.contains(market.getId())) {
                market.addSubmarket("generic_military");
            }
            market.removeSubmarket("tem_templarmarket");
            if (market.hasCondition("exerelin_templar_control")) {
                market.removeCondition("exerelin_templar_control");
            }
        }
        if (newOwnerId.equals("approlight") && !oldOwnerId.equals("approlight")) {
            if (market.hasCondition("military_base") || market.hasCondition("tem_avalon") || FORCE_MILITARY_MARKET.contains(market.getId()) && market.hasCondition("headquarters")) {
                market.removeSubmarket("generic_military");
                market.addSubmarket("AL_militaryMarket");
                market.addSubmarket("AL_plugofbarrack");
            }
        } else if (!newOwnerId.equals("approlight") && oldOwnerId.equals("approlight")) {
            if ((market.hasCondition("military_base") || market.hasCondition("tem_avalon") || FORCE_MILITARY_MARKET.contains(market.getId())) && !newOwnerId.equals("templars")) {
                market.addSubmarket("generic_military");
            }
            market.removeSubmarket("AL_militaryMarket");
            market.removeSubmarket("AL_plugofbarrack");
        }
        market.removeCondition("ii_imperialdoctrine");
        if (newOwnerId.equals("interstellarimperium") && market.getMemoryWithoutUpdate().contains("$startingFactionId") && market.getMemoryWithoutUpdate().getString("$startingFactionId").equals("interstellarimperium") && !market.hasCondition("dissident") && !market.hasCondition("large_refugee_population")) {
            market.addCondition("ii_imperialdoctrine");
        }
        ExerelinFactionConfig newOwnerConfig = ExerelinConfig.getExerelinFactionConfig(newOwnerId);
        if (!SectorManager.sectorManager.corvusMode && newOwnerConfig != null) {
            if (newOwnerConfig.freeMarket) {
                if (!market.hasCondition("free_market")) {
                    market.addCondition("free_market");
                }
            } else {
                market.removeCondition("free_market");
            }
        }
        ExerelinUtilsMarket.setTariffs(market);
        List submarkets = market.getSubmarketsCopy();
        for (SubmarketAPI submarket : submarkets) {
            String submarketId = submarket.getSpecId();
            if (!ALWAYS_CAPTURE_SUBMARKET.contains(submarketId) && (submarket.getPlugin().isFreeTransfer() || !submarket.getPlugin().isParticipatesInEconomy())) continue;
            if (submarketId.equals("black_market")) {
                PlayerTradeDataForSubmarket tradeData = SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(submarket);
                tradeData.setTotalPlayerTradeValue(0.0f);
                continue;
            }
            if (submarketId.equals("ssp_cabalmarket") || submarketId.equals("uw_cabalmarket")) continue;
            submarket.setFaction(newOwner);
        }
        market.reapplyConditions();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("newOwner", newOwner);
        params.put("oldOwner", oldOwner);
        params.put("playerInvolved", playerInvolved);
        params.put("factionsToNotify", factionsToNotify);
        params.put("repChangeStrength", Float.valueOf(repChangeStrength));
        Global.getSector().getEventManager().startEvent(new CampaignEventTarget(market), "exerelin_market_captured", params);
        DiplomacyManager.notifyMarketCaptured(market, oldOwner, newOwner);
        if (playerInvolved) {
            StatsTracker.getStatsTracker().notifyMarketCaptured(market);
        }
        int marketsRemaining = ExerelinUtilsFaction.getFactionMarkets(oldOwner.getId(), true).size();
        log.info((Object)("Faction " + oldOwner.getDisplayName() + " has " + marketsRemaining + " markets left"));
        if (marketsRemaining == 0) {
            SectorManager.factionEliminated(newOwner, oldOwner, market);
        }
        if ((marketsRemaining = ExerelinUtilsFaction.getFactionMarkets(newOwner.getId(), true).size()) == 1) {
            SectorManager.factionRespawned(newOwner, market);
        }
        if (sectorManager != null) {
            StarSystemAPI loc;
            boolean flipRelay = false;
            if (SectorManager.sectorManager.planetToRelayMap != null) {
                flipRelay = SectorManager.sectorManager.planetToRelayMap.containsKey(market.getPrimaryEntity().getId());
            }
            if (!flipRelay && ExerelinCorvusLocations.getSystemCapitalsCopy().containsValue(market.getPrimaryEntity().getId())) {
                flipRelay = true;
            }
            if (flipRelay && (loc = market.getStarSystem()) != null) {
                String relayId;
                SectorEntityToken relay = null;
                if (SectorManager.sectorManager.systemToRelayMap == null) {
                    SectorManager.setSystemToRelayMap(new HashMap<String, String>());
                }
                if ((relayId = SectorManager.sectorManager.systemToRelayMap.get(loc.getId())) != null) {
                    relay = Global.getSector().getEntityById(relayId);
                } else {
                    List relays = loc.getEntitiesWithTag("comm_relay");
                    if (!relays.isEmpty() && ((SectorEntityToken)relays.get(0)).getMarket() == null) {
                        relay = (SectorEntityToken)relays.get(0);
                    }
                }
                if (relay != null && relay.getFaction().getId().equals(oldOwnerId)) {
                    relay.setFaction(newOwnerId);
                }
            }
        }
        if ((newOwnerId.equals(PlayerFactionStore.getPlayerFactionId()) || newOwnerId.equals("player_npc")) && (event = RevengeanceManagerEvent.getOngoingEvent()) != null) {
            float sizeSq = market.getSize() * market.getSize();
            event.addPoints(sizeSq * ExerelinConfig.revengePointsForMarketCaptureMult);
        }
    }

    public static void notifySlavesSold(MarketAPI market, int count) {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.numSlavesRecentlySold += count;
        SectorManager.sectorManager.marketLastSoldSlaves = market;
    }

    public static void addLiveFactionId(String factionId) {
        if (sectorManager == null) {
            return;
        }
        if (!SectorManager.sectorManager.liveFactionIds.contains(factionId)) {
            SectorManager.sectorManager.liveFactionIds.add(factionId);
        }
    }

    public static void removeLiveFactionId(String factionId) {
        if (sectorManager == null) {
            return;
        }
        if (SectorManager.sectorManager.liveFactionIds.contains(factionId)) {
            SectorManager.sectorManager.liveFactionIds.remove(factionId);
        }
    }

    public static ArrayList<String> getLiveFactionIdsCopy() {
        if (sectorManager == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(SectorManager.sectorManager.liveFactionIds);
    }

    public static boolean isFactionAlive(String factionId) {
        if (sectorManager == null) {
            return false;
        }
        return SectorManager.sectorManager.liveFactionIds.contains(factionId);
    }

    public static void setSystemToRelayMap(Map<String, String> map) {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.systemToRelayMap = map;
    }

    public static void setPlanetToRelayMap(Map<String, String> map) {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.planetToRelayMap = map;
    }

    public static void setHomeworld(SectorEntityToken entity) {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.homeworld = entity;
    }

    public static SectorEntityToken getHomeworld() {
        if (sectorManager == null) {
            return null;
        }
        return SectorManager.sectorManager.homeworld;
    }

    public static void setFreeStart(boolean freeStart) {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.freeStart = freeStart;
    }

    public static boolean getFreeStart() {
        if (sectorManager == null) {
            return false;
        }
        return SectorManager.sectorManager.freeStart;
    }

    protected static void expelPlayerFromFaction() {
        String oldFactionId = PlayerFactionStore.getPlayerFactionId();
        if (oldFactionId.equals("player_npc")) {
            return;
        }
        SectorAPI sector = Global.getSector();
        FactionAPI newFaction = sector.getFaction("player_npc");
        FactionAPI oldFaction = sector.getFaction(oldFactionId);
        if (!ExerelinUtilsFaction.isPirateFaction(oldFactionId)) {
            PlayerFactionStore.loadIndependentPlayerRelations(true);
        }
        PlayerFactionStore.setPlayerFactionId("player_npc");
        ExerelinUtilsReputation.syncFactionRelationshipsToPlayer("player_npc");
        CampaignEventPlugin eventSuper = sector.getEventManager().getOngoingEvent(null, "exerelin_faction_changed");
        if (eventSuper == null) {
            eventSuper = sector.getEventManager().startEvent(null, "exerelin_faction_changed", null);
        }
        FactionChangedEvent event = (FactionChangedEvent)eventSuper;
        MarketAPI market = ExerelinUtils.getClosestMarket(oldFactionId);
        event.reportEvent(oldFaction, newFaction, "expelled", market.getPrimaryEntity());
    }

    public static void scheduleExpelPlayerFromFaction() {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.wantExpelPlayerFromFaction = true;
    }

    public static void reinitLiveFactions() {
        if (sectorManager == null) {
            return;
        }
        List<String> temp = ExerelinSetupData.getInstance().getAllFactions();
        SectorManager.sectorManager.liveFactionIds = new ArrayList<String>();
        SectorManager.sectorManager.factionIdsAtStart = new ArrayList<String>();
        SectorManager.sectorManager.historicFactionIds = new HashSet<String>();
        for (String factionId : temp) {
            if (!ExerelinUtilsFaction.getFactionMarkets(factionId, true).isEmpty()) {
                ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(factionId);
                if (config != null && !config.playableFaction) continue;
                SectorManager.sectorManager.liveFactionIds.add(factionId);
                SectorManager.sectorManager.factionIdsAtStart.add(factionId);
                SectorManager.sectorManager.historicFactionIds.add(factionId);
                SectorManager.setShowFactionInIntelTab(factionId, true);
                continue;
            }
            SectorManager.setShowFactionInIntelTab(factionId, false);
        }
    }

    public static String getFirstStarName() {
        if (sectorManager != null && SectorManager.sectorManager.corvusMode) {
            return "Corvus";
        }
        String firstStar = "Exerelin";
        try {
            JSONObject planetConfig = Global.getSettings().loadJSON("data/config/exerelin/planetNames.json");
            JSONArray systemNames = planetConfig.getJSONArray("stars");
            firstStar = systemNames.getString(0);
        }
        catch (IOException | JSONException ex) {
            log.error((Object)ex);
        }
        return firstStar;
    }

    public static void setAllowRespawnFactions(boolean respawn, boolean allowNew) {
        if (sectorManager == null) {
            return;
        }
        SectorManager.sectorManager.respawnFactions = respawn;
        SectorManager.sectorManager.onlyRespawnStartingFactions = !allowNew;
    }

    static {
        POSTS_TO_CHANGE_ON_CAPTURE = Arrays.asList(Ranks.POST_BASE_COMMANDER, Ranks.POST_OUTPOST_COMMANDER, Ranks.POST_STATION_COMMANDER, Ranks.POST_PORTMASTER, Ranks.POST_SUPPLY_OFFICER, Ranks.POST_ADMINISTRATOR);
        NO_BLACK_MARKET = new HashSet<String>(Arrays.asList("SCY_overwatchStation", "SCY_hephaistosStation", "uw_arigato"));
        FORCE_MILITARY_MARKET = new HashSet<String>(Arrays.asList("SCY_hephaistosStation"));
        ALWAYS_CAPTURE_SUBMARKET = new HashSet<String>(Arrays.asList("tiandong_retrofit"));
        NO_WARMONGER_FACTIONS = new HashSet<String>(Arrays.asList("derelict", "remnant", "neutral"));
    }

    public static enum VictoryType {
        CONQUEST,
        CONQUEST_ALLY,
        DIPLOMATIC,
        DIPLOMATIC_ALLY,
        DEFEAT_CONQUEST,
        DEFEAT_DIPLOMATIC,
        RETIRED;

    }
}

