/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.submarkets.StoragePlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.ExerelinSetupData;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.world.ExerelinCorvusLocations;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class StartSetupPostTimePass {
    public static void execute() {
        SectorAPI sector = Global.getSector();
        if (Global.getSector().isInNewGameAdvance()) {
            return;
        }
        SectorEntityToken entity = null;
        String factionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI myFaction = sector.getFaction(factionId);
        CampaignFleetAPI playerFleet = sector.getPlayerFleet();
        if (SectorManager.getCorvusMode()) {
            String homeEntity = null;
            ExerelinCorvusLocations.SpawnPointEntry spawnPoint = ExerelinCorvusLocations.getFactionSpawnPoint(factionId);
            if (spawnPoint != null && (homeEntity = spawnPoint.entityId) != null) {
                entity = sector.getEntityById(homeEntity);
            }
            int numIncompatibles = 0;
            for (FactionAPI faction : sector.getAllFactions()) {
                if (ExerelinUtilsFaction.isCorvusCompatible(faction.getId(), true)) continue;
                Global.getLogger(StartSetupPostTimePass.class).warn((Object)("Faction " + faction.getDisplayName() + " does not support non-random sector mode!"));
                ++numIncompatibles;
            }
            if (numIncompatibles > 0) {
                Color color = Misc.getHighlightColor();
                Color color2 = Color.RED;
                CampaignUIAPI ui = sector.getCampaignUI();
                ui.addMessage("You are using " + numIncompatibles + " mod faction(s) that do not support non-random sector mode!", color, numIncompatibles + "", color2);
                ui.addMessage("See starsector.log for details", color);
            }
        } else if (!SectorManager.getFreeStart()) {
            entity = SectorManager.getHomeworld();
        } else {
            WeightedRandomPicker picker = new WeightedRandomPicker();
            picker.setRandom(new Random(ExerelinUtils.getStartingSeed()));
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                if (market.getFaction().isAtBest("player", RepLevel.INHOSPITABLE)) continue;
                picker.add((Object)market.getPrimaryEntity());
            }
            entity = (SectorEntityToken)picker.pick();
        }
        if (entity != null) {
            StartSetupPostTimePass.sendPlayerFleetToLocation(playerFleet, entity);
        }
        int numOfficers = ExerelinSetupData.getInstance().numStartingOfficers;
        block2: for (int i = 0; i < numOfficers; ++i) {
            int level = (numOfficers - i) * 2 - 1;
            PersonAPI officer = OfficerManagerEvent.createOfficer((FactionAPI)myFaction, (int)level, (boolean)true);
            playerFleet.getFleetData().addOfficer(officer);
            for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
                PersonAPI cap = member.getCaptain();
                if ((cap == null || cap.isDefault()) && !member.isFighterWing()) {
                    member.setCaptain(officer);
                    continue block2;
                }
                if (cap != officer) continue;
                continue block2;
            }
        }
    }

    public static void sendPlayerFleetToLocation(CampaignFleetAPI playerFleet, SectorEntityToken entity) {
        StoragePlugin plugin;
        SubmarketAPI storage;
        playerFleet.getContainingLocation().removeEntity((SectorEntityToken)playerFleet);
        entity.getContainingLocation().addEntity((SectorEntityToken)playerFleet);
        Global.getSector().setCurrentLocation(entity.getContainingLocation());
        Vector2f loc = entity.getLocation();
        playerFleet.setLocation(loc.x, loc.y);
        MarketAPI homeMarket = entity.getMarket();
        if (homeMarket != null && (storage = homeMarket.getSubmarket("storage")) != null && (plugin = (StoragePlugin)homeMarket.getSubmarket("storage").getPlugin()) != null) {
            plugin.setPlayerPaidToUnlock(true);
        }
        String factionId = PlayerFactionStore.getPlayerFactionId();
        if (!PlayerFactionStore.getPlayerFactionId().equals("player_npc")) {
            if (!entity.getFaction().isNeutralFaction()) {
                ExerelinUtilsFaction.grantCommission(entity);
            } else if (ExerelinUtilsFaction.isExiInCorvus(factionId)) {
                ExerelinUtilsFaction.grantCommission(Global.getSector().getStarSystem("Tasserus").getEntityById("exigency_anomaly"));
            }
        }
    }
}

