/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import exerelin.campaign.events.RevengeanceManagerEvent;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;

public class StatsTracker
extends BaseCampaignEventListener {
    protected static final String TRACKER_MAP_KEY = "exerelin_statsTracker";
    protected static StatsTracker tracker;
    protected int shipsKilled = 0;
    protected int shipsLost = 0;
    protected float fpKilled = 0.0f;
    protected float fpLost = 0.0f;
    protected int marketsCaptured = 0;
    protected int agentsUsed = 0;
    protected int saboteursUsed = 0;
    protected int prisonersRepatriated = 0;
    protected int prisonersRansomed = 0;
    protected int slavesSold = 0;
    protected int orphansMade = 0;

    public StatsTracker() {
        super(true);
    }

    public float getFpKilled() {
        return this.fpKilled;
    }

    public float getFpLost() {
        return this.fpLost;
    }

    public int getMarketsCaptured() {
        return this.marketsCaptured;
    }

    public int getAgentsUsed() {
        return this.agentsUsed;
    }

    public int getSaboteursUsed() {
        return this.saboteursUsed;
    }

    public int getPrisonersRepatriated() {
        return this.prisonersRepatriated;
    }

    public int getPrisonersRansomed() {
        return this.prisonersRansomed;
    }

    public int getSlavesSold() {
        return this.slavesSold;
    }

    public int getOrphansMade() {
        return this.orphansMade;
    }

    public void modifyOrphansMade(int num) {
        this.orphansMade += num;
    }

    public void notifyAgentsUsed(int num) {
        this.agentsUsed += num;
    }

    public void notifySaboteursUsed(int num) {
        this.saboteursUsed += num;
    }

    public void notifyPrisonersRepatriated(int num) {
        this.prisonersRepatriated += num;
    }

    public void notifyPrisonersRansomed(int num) {
        this.prisonersRansomed += num;
    }

    public void notifySlavesSold(int num) {
        this.slavesSold += num;
    }

    public void notifyMarketCaptured(MarketAPI market) {
        ++this.marketsCaptured;
    }

    public void modifyOrphansMadeByCrewCount(int crew, String faction) {
        float numAvgKids = MathUtils.getRandomNumberInRange((float)0.0f, (float)1.5f) + MathUtils.getRandomNumberInRange((float)0.0f, (float)1.5f);
        if (faction.equals("templars")) {
            numAvgKids = MathUtils.getRandomNumberInRange((float)0.0f, (float)5.0f) + MathUtils.getRandomNumberInRange((float)0.0f, (float)5.0f);
        }
        this.orphansMade = (int)((float)this.orphansMade + (float)crew * numAvgKids);
    }

    public void reportBattleFinished(CampaignFleetAPI winner, BattleAPI battle) {
        if (RevengeanceManagerEvent.getOngoingEvent() != null) {
            RevengeanceManagerEvent.getOngoingEvent().reportBattle(winner, battle);
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        List killedFleets = battle.getNonPlayerSide();
        CampaignFleetAPI lossesFleet = Global.getSector().getPlayerFleet();
        Global.getLogger(StatsTracker.class).info((Object)"Tracker tracking battle");
        float involvedFraction = battle.getPlayerInvolvementFraction();
        float recentFpKilled = 0.0f;
        int recentShipsKilled = 0;
        for (CampaignFleetAPI killedFleet : killedFleets) {
            List killCurrent = killedFleet.getFleetData().getMembersListCopy();
            for (FleetMemberAPI member : killedFleet.getFleetData().getSnapshot()) {
                if (killCurrent.contains(member)) continue;
                recentFpKilled += (float)member.getFleetPointCost();
                ++recentShipsKilled;
                String factionId = member.getCaptain().getFaction().getId();
                if (factionId.equals("spire") || factionId.equals("darkspire")) continue;
                this.modifyOrphansMadeByCrewCount((int)(member.getMinCrew() * involvedFraction), factionId);
            }
        }
        this.fpKilled += recentFpKilled * involvedFraction;
        this.shipsKilled = (int)((float)this.shipsKilled + (float)recentShipsKilled * involvedFraction);
        List lossCurrent = lossesFleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : lossesFleet.getFleetData().getSnapshot()) {
            if (lossCurrent.contains(member)) continue;
            this.fpLost += (float)member.getFleetPointCost();
            ++this.shipsLost;
        }
    }

    public static StatsTracker getStatsTracker() {
        if (tracker == null) {
            return StatsTracker.create();
        }
        return tracker;
    }

    public static boolean isTrackerLoaded() {
        return tracker != null;
    }

    public static StatsTracker create() {
        Map data = Global.getSector().getPersistentData();
        tracker = (StatsTracker)((Object)data.get(TRACKER_MAP_KEY));
        if (tracker != null) {
            return tracker;
        }
        tracker = new StatsTracker();
        data.put(TRACKER_MAP_KEY, tracker);
        return tracker;
    }
}

