/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.InteractionDialogImageVisual;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.SectorManager;
import exerelin.campaign.StatsTracker;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.Map;

public class VictoryScreenScript
implements EveryFrameScript {
    private boolean isDone = false;
    private String faction = "player_npc";
    private SectorManager.VictoryType victoryType = SectorManager.VictoryType.CONQUEST;

    public VictoryScreenScript(String faction, SectorManager.VictoryType victoryType) {
        this.faction = faction;
        this.victoryType = victoryType;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean runWhilePaused() {
        return true;
    }

    public void advance(float amount) {
        CampaignUIAPI ui = Global.getSector().getCampaignUI();
        if (Global.getSector().isInNewGameAdvance() || ui.isShowingDialog()) {
            return;
        }
        if (!this.isDone) {
            ui.showInteractionDialog((InteractionDialogPlugin)new VictoryDialog(this.faction, this.victoryType), (SectorEntityToken)Global.getSector().getPlayerFleet());
            HashMap<String, Object> params = new HashMap<String, Object>();
            String victoryTypeStr = this.victoryType.toString().toLowerCase();
            boolean playerVictory = !victoryTypeStr.startsWith("defeat_");
            params.put("victorFactionId", this.faction);
            params.put("diplomaticVictory", victoryTypeStr.contains("diplomatic"));
            params.put("playerVictory", playerVictory);
            params.put("retired", this.victoryType == SectorManager.VictoryType.RETIRED);
            Global.getSector().getEventManager().startEvent(new CampaignEventTarget((SectorEntityToken)Global.getSector().getPlayerFleet()), "exerelin_victory", params);
            this.isDone = true;
        }
    }

    private static class VictoryDialog
    implements InteractionDialogPlugin {
        private InteractionDialogAPI dialog;
        private TextPanelAPI text;
        private OptionPanelAPI options;
        private final String factionId;
        private final SectorManager.VictoryType victoryType;

        private VictoryDialog(String factionId, SectorManager.VictoryType victoryType) {
            this.factionId = factionId;
            this.victoryType = victoryType;
        }

        protected String getString(String id) {
            return StringHelper.getString("exerelin_victoryScreen", id);
        }

        private void printCreditLine(String name, String contribution) {
            this.text.addParagraph(name + ": " + contribution);
            this.text.highlightInLastPara(new String[]{name});
        }

        private void printKeyValueLine(String key, String value) {
            this.text.addParagraph(key + ": " + value);
            this.text.highlightInLastPara(new String[]{value});
        }

        private void printCredits() {
            String category = "exerelin_credits";
            this.printCreditLine("Zaphide", StringHelper.getString(category, "contribution_zaphide"));
            this.printCreditLine("Histidine", StringHelper.getString(category, "contribution_histidine"));
            this.printCreditLine("Dark.Revenant", StringHelper.getString(category, "contribution_darkRevenant"));
            this.printCreditLine("LazyWizard", StringHelper.getString(category, "contribution_lazyWizard"));
            this.printCreditLine("Psiyon", StringHelper.getString(category, "contribution_psiyon"));
            this.printCreditLine("Tartiflette", StringHelper.getString(category, "contribution_tartiflette"));
            this.printCreditLine("The SS mod community", StringHelper.getString(category, "contribution_ssModCommunity"));
            this.printCreditLine("Alex, David, Stian, Ivaylo", StringHelper.getString(category, "contribution_fractalSoftworks"));
        }

        private void printStats() {
            StatsTracker tracker = StatsTracker.getStatsTracker();
            this.printKeyValueLine(this.getString("statsLevel"), Global.getSector().getPlayerPerson().getStats().getLevel() + "");
            this.printKeyValueLine(this.getString("statsFpKilled"), Misc.getWithDGS((float)((int)tracker.getFpKilled())));
            this.printKeyValueLine(this.getString("statsFpLost"), Misc.getWithDGS((float)((int)tracker.getFpLost())));
            this.printKeyValueLine(this.getString("statsOrphansMade"), Misc.getWithDGS((float)tracker.getOrphansMade()));
            this.printKeyValueLine(this.getString("statsMarketsCaptured"), tracker.getMarketsCaptured() + "");
            this.printKeyValueLine(this.getString("statsAgentsUsed"), tracker.getAgentsUsed() + "");
            this.printKeyValueLine(this.getString("statsSaboteursUsed"), tracker.getSaboteursUsed() + "");
            this.printKeyValueLine(this.getString("statsPrisonersRepatriated"), tracker.getPrisonersRepatriated() + "");
            this.printKeyValueLine(this.getString("statsPrisonersRansomed"), tracker.getPrisonersRansomed() + "");
            this.printKeyValueLine(this.getString("statsSlavesSold"), tracker.getSlavesSold() + "");
        }

        public void init(InteractionDialogAPI dialog) {
            this.dialog = dialog;
            this.options = dialog.getOptionPanel();
            this.text = dialog.getTextPanel();
            FactionAPI faction = Global.getSector().getFaction(this.factionId);
            String factionName = faction.getDisplayName();
            String theFactionName = faction.getDisplayNameWithArticle();
            String TheFactionName = Misc.ucFirst((String)theFactionName);
            String firstStar = SectorManager.getFirstStarName();
            String message = "";
            String victoryTypeStr = this.victoryType.toString().toLowerCase();
            message = victoryTypeStr.startsWith("defeat_") || this.victoryType == SectorManager.VictoryType.RETIRED ? this.getString(victoryTypeStr) : this.getString("victory_" + victoryTypeStr);
            message = StringHelper.substituteFactionTokens(message, faction);
            message = StringHelper.substituteToken(message, "$clusterName", firstStar);
            this.text.addParagraph(message);
            this.text.highlightInLastPara(Misc.getHighlightColor(), new String[]{TheFactionName, theFactionName});
            if (this.victoryType == SectorManager.VictoryType.RETIRED) {
                dialog.getVisualPanel().showImageVisual(new InteractionDialogImageVisual("graphics/illustrations/fly_away.jpg", 640.0f, 400.0f));
            } else if (this.victoryType != SectorManager.VictoryType.DEFEAT_CONQUEST && this.victoryType != SectorManager.VictoryType.DEFEAT_DIPLOMATIC) {
                victoryTypeStr = victoryTypeStr.replaceAll("_", " ");
                this.text.addParagraph(StringHelper.getStringAndSubstituteToken("exerelin_victoryScreen", "youHaveWon", "$victoryType", victoryTypeStr));
                this.text.highlightInLastPara(new String[]{victoryTypeStr});
                dialog.getVisualPanel().showImageVisual(new InteractionDialogImageVisual("graphics/illustrations/terran_orbit.jpg", 640.0f, 400.0f));
                Global.getSoundPlayer().playUISound("music_campaign_victory_theme", 1.0f, 1.0f);
            } else {
                dialog.getVisualPanel().showImageVisual(new InteractionDialogImageVisual("graphics/illustrations/space_wreckage.jpg", 640.0f, 400.0f));
                Global.getSoundPlayer().playUISound("music_campaign_defeat_theme", 1.0f, 1.0f);
            }
            this.options.addOption(Misc.ucFirst((String)StringHelper.getString("stats")), (Object)Menu.STATS);
            this.options.addOption(Misc.ucFirst((String)StringHelper.getString("credits")), (Object)Menu.CREDITS);
            this.options.addOption(Misc.ucFirst((String)StringHelper.getString("close")), (Object)Menu.EXIT);
            dialog.setPromptText(this.getString("whatNow"));
        }

        public void optionSelected(String optionText, Object optionData) {
            if (optionText != null) {
                this.text.addParagraph(optionText, Global.getSettings().getColor("buttonText"));
            }
            if (optionData == Menu.CREDITS) {
                this.printCredits();
            } else if (optionData == Menu.STATS) {
                this.printStats();
            } else if (optionData == Menu.EXIT) {
                this.dialog.dismiss();
            }
        }

        public void optionMousedOver(String optionText, Object optionData) {
        }

        public void advance(float amount) {
        }

        public void backFromEngagement(EngagementResultAPI battleResult) {
        }

        public Object getContext() {
            return null;
        }

        public Map<String, MemoryAPI> getMemoryMap() {
            return null;
        }

        private static enum Menu {
            CREDITS,
            STATS,
            EXIT;

        }
    }
}

