/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.abilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.abilities.BaseDurationAbility;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.utilities.StringHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class FollowMeAbility
extends BaseDurationAbility {
    protected static final String STRING_CATEGORY = "exerelin_abilities";
    public static final float FOLLOW_DURATION = 10.0f;
    public static final float FOLLOW_DURATION_PASSIVE = 10.0f;
    public static final float FOLLOW_FETCH_RANGE = 600.0f;
    public static final Set<String> FOLLOW_VALID_FLEET_TYPES = new HashSet<String>();

    protected String getActivationText() {
        return StringHelper.getString(STRING_CATEGORY, "followMeTitle");
    }

    protected void activateImpl() {
        String myFactionId;
        if (this.entity.isInCurrentLocation()) {
            this.entity.addFloatingText(StringHelper.getString(STRING_CATEGORY, "followMeFloatText"), this.entity.getFaction().getBaseUIColor(), 1.0f);
            SectorEntityToken.VisibilityLevel visibility = this.entity.getVisibilityLevelToPlayerFleet();
            if (visibility != SectorEntityToken.VisibilityLevel.NONE) {
                Global.getSector().addPing(this.entity, "follow_me_send");
            }
        }
        if ((myFactionId = this.entity.getFaction().getId()).equals("player")) {
            myFactionId = PlayerFactionStore.getPlayerFactionId();
        }
        List fleets = this.entity.getContainingLocation().getFleets();
        for (CampaignFleetAPI fleet : fleets) {
            MemoryAPI mem;
            String type;
            float dist;
            String fleetFactionId;
            if (fleet == this.entity || !myFactionId.equals(fleetFactionId = fleet.getFaction().getId()) && !fleetFactionId.equals("player_npc") && !AllianceManager.areFactionsAllied(myFactionId, fleetFactionId) || !((dist = Misc.getDistance((Vector2f)fleet.getLocation(), (Vector2f)this.entity.getLocation())) <= 600.0f) || !fleet.knowsWhoPlayerIs() || !FOLLOW_VALID_FLEET_TYPES.contains(type = (String)(mem = fleet.getMemoryWithoutUpdate()).get("$fleetType")) || mem.contains("$core_fleetBusy") || fleet.getBattle() != null) continue;
            CampaignFleetAIAPI ai = fleet.getAI();
            FleetAssignmentDataAPI currentAssignment = ai.getCurrentAssignment();
            currentAssignment = ai.getCurrentAssignment();
            if (currentAssignment != null && currentAssignment.getTarget() == this.entity) {
                ai.removeFirstAssignmentIfItIs(FleetAssignment.ORBIT_PASSIVE);
            }
            ai.addAssignmentAtStart(FleetAssignment.ORBIT_PASSIVE, this.entity, 10.0f, null);
            Global.getSector().addPing((SectorEntityToken)fleet, "follow_me_receive");
        }
    }

    protected void applyEffect(float amount, float level) {
    }

    protected void deactivateImpl() {
    }

    protected void cleanupImpl() {
    }

    public float getActivationDays() {
        return 0.0f;
    }

    public float getCooldownDays() {
        return 0.1f;
    }

    public float getDeactivationDays() {
        return 0.0f;
    }

    public float getDurationDays() {
        return 0.0f;
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        LabelAPI title = tooltip.addTitle(StringHelper.getString(STRING_CATEGORY, "followMeTitle"));
        float pad = 10.0f;
        String highlight = "10";
        String tooltip1 = StringHelper.getString(STRING_CATEGORY, "followMeTooltip1");
        tooltip1 = StringHelper.substituteToken(tooltip1, "$numDays", highlight);
        tooltip.addPara(tooltip1, pad, Misc.getHighlightColor(), new String[]{highlight});
        tooltip.addPara(StringHelper.getString(STRING_CATEGORY, "followMeTooltip2"), pad);
    }

    public boolean hasTooltip() {
        return true;
    }

    static {
        FOLLOW_VALID_FLEET_TYPES.add("patrolSmall");
        FOLLOW_VALID_FLEET_TYPES.add("patrolMedium");
        FOLLOW_VALID_FLEET_TYPES.add("patrolLarge");
        FOLLOW_VALID_FLEET_TYPES.add("exerelinInvasionSupportFleet");
        FOLLOW_VALID_FLEET_TYPES.add("exerelinDefenceFleet");
    }
}

