/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.alliances;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.events.AllianceChangedEvent;
import exerelin.campaign.events.AllianceVoteEvent;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class Alliance {
    protected String name;
    protected Set<String> members;
    protected Alignment alignment;
    protected AllianceChangedEvent event;
    protected AllianceVoteEvent voteEvent;
    public final String uuId;

    public Alliance(String name, Alignment alignment, String member1, String member2) {
        this.name = name;
        this.alignment = alignment;
        this.members = new HashSet<String>();
        this.members.add(member1);
        this.members.add(member2);
        this.uuId = UUID.randomUUID().toString();
    }

    public void createEvents(String member1, String member2) {
        this.event = this.createAllianceEvent(member1, member2);
        this.voteEvent = (AllianceVoteEvent)Global.getSector().getEventManager().primeEvent(null, "exerelin_alliance_vote", null);
    }

    public AllianceChangedEvent getEvent() {
        return this.event;
    }

    public AllianceVoteEvent getVoteEvent() {
        return this.voteEvent;
    }

    public void reportEvent(String faction1, String faction2, Alliance alliance, String stage) {
        CampaignEventTarget eventTarget;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("faction1Id", faction1);
        if (faction2 != null) {
            params.put("faction2Id", faction2);
        }
        params.put("stage", stage);
        if (AllianceManager.getPlayerInteractionTarget() != null) {
            eventTarget = new CampaignEventTarget(AllianceManager.getPlayerInteractionTarget());
        } else {
            List<MarketAPI> markets = ExerelinUtilsFaction.getFactionMarkets(faction1);
            MarketAPI market = markets.isEmpty() ? this.getRandomAllianceMarketForEvent(true) : (MarketAPI)ExerelinUtils.getRandomListElement(markets);
            eventTarget = new CampaignEventTarget(market);
        }
        this.event.setParam(params);
        this.event.setTarget(eventTarget);
        this.event.reportEvent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Set<String> getMembersCopy() {
        return new HashSet<String>(this.members);
    }

    public void addMember(String factionId) {
        this.members.add(factionId);
    }

    public void removeMember(String factionId) {
        this.members.remove(factionId);
    }

    public void clearMembers() {
        this.members.clear();
    }

    public List<MarketAPI> getAllianceMarkets() {
        ArrayList<MarketAPI> markets = new ArrayList<MarketAPI>();
        for (String memberId : this.members) {
            List<MarketAPI> factionMarkets = ExerelinUtilsFaction.getFactionMarkets(memberId);
            markets.addAll(factionMarkets);
        }
        return markets;
    }

    public MarketAPI getRandomAllianceMarketForEvent(boolean preferHq) {
        List<MarketAPI> markets = this.getAllianceMarkets();
        WeightedRandomPicker picker = new WeightedRandomPicker();
        WeightedRandomPicker picker2 = new WeightedRandomPicker();
        for (MarketAPI market : markets) {
            float weight = market.getSize();
            if (market.hasCondition("military_base")) {
                weight *= 1.5f;
            }
            picker2.add((Object)market, weight);
            if (!market.hasCondition("headquarters")) continue;
            picker.add((Object)market, weight);
        }
        if (preferHq && !picker.isEmpty()) {
            return (MarketAPI)picker.pick();
        }
        return (MarketAPI)picker2.pick();
    }

    public int getNumAllianceMarkets() {
        int numMarkets = 0;
        for (String memberId : this.members) {
            numMarkets += ExerelinUtilsFaction.getFactionMarkets(memberId).size();
        }
        return numMarkets;
    }

    public int getAllianceMarketSizeSum() {
        int size = 0;
        for (String memberId : this.members) {
            for (MarketAPI market : ExerelinUtilsFaction.getFactionMarkets(memberId)) {
                size += market.getSize();
            }
        }
        return size;
    }

    public String getAllianceNameAndMembers() {
        List<String> factionNames = StringHelper.factionIdListToFactionNameList(new ArrayList<String>(this.getMembersCopy()), true);
        String factions = StringHelper.writeStringCollection(factionNames);
        return this.name + " (" + factions + ")";
    }

    public float getAverageRelationshipWithFaction(String factionId) {
        float sumRelationships = 0.0f;
        int numFactions = 0;
        FactionAPI faction = Global.getSector().getFaction(factionId);
        for (String memberId : this.members) {
            if (memberId.equals(factionId)) continue;
            sumRelationships += faction.getRelationship(memberId);
            ++numFactions;
        }
        if (numFactions == 0) {
            return 1.0f;
        }
        return sumRelationships / (float)numFactions;
    }

    protected AllianceChangedEvent createAllianceEvent(String faction1, String faction2) {
        CampaignEventTarget eventTarget;
        HashMap<String, String> params = new HashMap<String, String>();
        SectorAPI sector = Global.getSector();
        String eventType = "exerelin_alliance_changed";
        params.put("faction1Id", faction1);
        if (faction2 != null) {
            params.put("faction2Id", faction2);
        }
        params.put("allianceId", this.uuId);
        params.put("stage", "formed");
        if (AllianceManager.getPlayerInteractionTarget() != null) {
            eventTarget = new CampaignEventTarget(AllianceManager.getPlayerInteractionTarget());
        } else {
            MarketAPI market = this.getRandomAllianceMarketForEvent(false);
            eventTarget = new CampaignEventTarget(market);
        }
        AllianceChangedEvent event = (AllianceChangedEvent)sector.getEventManager().startEvent(eventTarget, eventType, params);
        return event;
    }

    public static enum Alignment {
        CORPORATE,
        TECHNOCRATIC,
        MILITARIST,
        DIPLOMATIC,
        IDEOLOGICAL;

    }

    public static class AllianceSyncMessage {
        public String message;
        public String party1;
        public String party2;

        public AllianceSyncMessage(String message, String party1, String party2) {
            this.message = message;
            this.party1 = party1;
            this.party2 = party2;
        }
    }
}

