/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.alliances;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.alliances.Alliance;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.ExerelinUtilsReputation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;

public class AllianceVoter {
    public static final float BASE_POINTS = 75.0f;
    public static final float POINTS_NEEDED = 100.0f;
    public static final float MAX_POINTS_TO_DEFY = 50.0f;
    public static final float ABSTAIN_THRESHOLD = 25.0f;
    public static final float STRENGTH_POINT_MULT = 0.5f;
    public static final float HAWKISHNESS_POINTS = 50.0f;
    public static final float RANDOM_POINTS = 50.0f;
    public static final float DEFIER_REP_LOSS_YES = -0.1f;
    public static final float DEFIER_REP_LOSS_ABSTAIN = -0.05f;
    protected static final boolean DEBUG_LOGGING = true;
    public static Logger log = Global.getLogger(AllianceVoter.class);

    public static void allianceVote(String faction1Id, String faction2Id, boolean isWar) {
        Map<String, Object> params;
        Alliance ally1 = AllianceManager.getFactionAlliance(faction1Id);
        Alliance ally2 = AllianceManager.getFactionAlliance(faction2Id);
        if (ally1 == null && ally2 == null) {
            return;
        }
        if (ally1 == ally2) {
            return;
        }
        VoteResult vote1 = null;
        VoteResult vote2 = null;
        if (ally1 != null) {
            vote1 = AllianceVoter.allianceVote(ally1, faction1Id, faction2Id, isWar);
        }
        if (ally2 != null) {
            vote2 = AllianceVoter.allianceVote(ally2, faction2Id, faction1Id, isWar);
        }
        HashSet<String> defyingFactions = new HashSet<String>();
        if (vote1 != null) {
            defyingFactions.addAll(vote1.defied);
        }
        if (vote2 != null) {
            defyingFactions.addAll(vote2.defied);
        }
        if (vote1 != null && vote1.success) {
            if (vote2 != null && vote2.success) {
                AllianceManager.doAlliancePeaceStateChange(faction1Id, faction2Id, ally1, ally2, isWar, defyingFactions);
            } else {
                AllianceManager.doAlliancePeaceStateChange(faction1Id, faction2Id, ally1, null, isWar, defyingFactions);
            }
        } else if (vote2 != null && vote2.success) {
            AllianceManager.doAlliancePeaceStateChange(faction1Id, faction2Id, null, ally2, isWar, defyingFactions);
        }
        if (ally1 != null) {
            params = AllianceVoter.getEventParams(ally1, vote1, faction2Id, ally2, isWar);
            ally1.getVoteEvent().reportEvent(params);
        }
        if (ally2 != null) {
            params = AllianceVoter.getEventParams(ally2, vote2, faction1Id, ally1, isWar);
            ally2.getVoteEvent().reportEvent(params);
        }
        AllianceVoter.handleDefyRelations(vote1);
        AllianceVoter.handleDefyRelations(vote2);
    }

    protected static void handleDefyRelations(VoteResult vote) {
        if (vote == null) {
            return;
        }
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        if (vote.defied.isEmpty()) {
            return;
        }
        HashSet<String> toModify = new HashSet<String>(vote.yesVotes);
        toModify.addAll(vote.abstentions);
        for (String member : toModify) {
            FactionAPI faction = Global.getSector().getFaction(member);
            float penalty = -0.1f;
            if (toModify.contains(member)) {
                penalty = -0.05f;
            }
            for (String defier : vote.defied) {
                FactionAPI defierFaction = Global.getSector().getFaction(defier);
                if (member.equals(playerAlignedFactionId)) {
                    ExerelinUtilsReputation.adjustPlayerReputation(defierFaction, null, penalty);
                } else if (defier.equals(playerAlignedFactionId)) {
                    ExerelinUtilsReputation.adjustPlayerReputation(faction, null, penalty);
                } else {
                    DiplomacyManager.adjustRelations(faction, defierFaction, penalty, null, null, RepLevel.HOSTILE, true);
                }
                AllianceManager.remainInAllianceCheck(defier, member);
            }
        }
        ExerelinUtilsReputation.syncFactionRelationshipsToPlayer();
    }

    protected static Map<String, Object> getEventParams(Alliance alliance, VoteResult result, String otherFactionId, Alliance otherAlliance, boolean isWar) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("allianceId", alliance.uuId);
        params.put("result", result);
        params.put("isWar", isWar);
        if (otherAlliance != null) {
            params.put("otherParty", otherAlliance.uuId);
        } else {
            params.put("otherParty", otherFactionId);
        }
        params.put("otherPartyIsAlliance", otherAlliance != null);
        return params;
    }

    protected static VoteResult allianceVote(Alliance alliance, String factionId, String otherFactionId, boolean isWar) {
        HashSet<String> factionsToConsider = new HashSet<String>();
        Alliance otherAlliance = AllianceManager.getFactionAlliance(otherFactionId);
        float ourStrength = alliance.getAllianceMarketSizeSum();
        float theirStrength = 0.0f;
        HashSet<String> yesVotes = new HashSet<String>();
        HashSet<String> noVotes = new HashSet<String>();
        HashSet<String> abstentions = new HashSet<String>();
        HashSet<String> defied = new HashSet<String>();
        if (otherAlliance != null) {
            factionsToConsider.addAll(otherAlliance.members);
            theirStrength = otherAlliance.getAllianceMarketSizeSum();
        } else {
            theirStrength = ExerelinUtilsFaction.getFactionMarketSizeSum(otherFactionId);
        }
        if (theirStrength <= 0.0f) {
            theirStrength = 1.0f;
        }
        float strengthRatio = ourStrength / theirStrength;
        Iterator header = "== Vote for peace with ";
        if (isWar) {
            header = "== Vote for war with ";
        }
        header = (String)((Object)header) + otherFactionId + " ==";
        log.info((Object)header);
        for (String allianceMember : alliance.members) {
            Vote vote = AllianceVoter.factionVote(isWar, alliance, allianceMember, factionId, otherFactionId, factionsToConsider, strengthRatio);
            if (vote == Vote.YES) {
                yesVotes.add(allianceMember);
                continue;
            }
            if (vote == Vote.NO) {
                noVotes.add(allianceMember);
                continue;
            }
            abstentions.add(allianceMember);
        }
        for (String voter : noVotes) {
            if (!AllianceVoter.decideToDefyVote(isWar, alliance, voter, factionId, otherFactionId)) continue;
            defied.add(voter);
        }
        boolean success = yesVotes.size() > noVotes.size();
        log.info((Object)("Final vote: " + success + " (" + yesVotes.size() + " to " + noVotes.size() + ")"));
        return new VoteResult(success, yesVotes, noVotes, abstentions, defied);
    }

    protected static Vote factionVote(boolean isWar, Alliance alliance, String factionId, String friendId, String otherFactionId, Set<String> otherAllianceMembers, float strengthRatio) {
        if (factionId.equals(friendId)) {
            return Vote.YES;
        }
        FactionAPI us = Global.getSector().getFaction(factionId);
        ExerelinFactionConfig usConf = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (isWar ? ExerelinFactionConfig.getMinRelationship(factionId, otherFactionId) > AllianceManager.HOSTILE_THRESHOLD : ExerelinFactionConfig.getMaxRelationship(factionId, otherFactionId) < AllianceManager.HOSTILE_THRESHOLD) {
            return Vote.NO;
        }
        float friendRelationship = us.getRelationship(friendId);
        float otherRelationship = us.getRelationship(otherFactionId);
        int factionCount = 0;
        float otherAllianceRelationshipSum = 0.0f;
        float hawkishness = usConf.alignments.get((Object)Alliance.Alignment.MILITARIST).floatValue();
        float diplomaticness = usConf.alignments.get((Object)Alliance.Alignment.DIPLOMATIC).floatValue();
        for (String otherMember : otherAllianceMembers) {
            if (otherMember.equals(otherFactionId)) continue;
            otherAllianceRelationshipSum += us.getRelationship(otherMember);
            ++factionCount;
        }
        float totalPoints = 75.0f + friendRelationship * 100.0f;
        float otherRelationshipPoints = isWar ? -(otherRelationship + 0.25f) * 100.0f : (otherRelationship + 0.25f) * 100.0f;
        totalPoints += otherRelationshipPoints;
        float otherAllianceRelationshipAvg = factionCount > 0 ? otherAllianceRelationshipSum / (float)factionCount : 0.0f;
        float otherAllianceRelationshipPoints = isWar ? -(otherAllianceRelationshipAvg + 0.25f) * 50.0f : (otherAllianceRelationshipAvg + 0.25f) * 50.0f;
        totalPoints += otherAllianceRelationshipPoints;
        float strengthPoints = (strengthRatio - 1.0f) * 100.0f * 0.5f;
        if (!isWar) {
            strengthPoints *= -1.0f;
        }
        totalPoints += strengthPoints;
        float hawkPoints = (hawkishness - diplomaticness) * 50.0f;
        if (!isWar) {
            hawkPoints *= -1.0f;
        }
        totalPoints += hawkPoints;
        float randomPoints = 50.0f * (MathUtils.getRandomNumberInRange((float)-0.5f, (float)0.5f) + MathUtils.getRandomNumberInRange((float)-0.5f, (float)0.5f));
        totalPoints += randomPoints;
        Vote vote = Vote.ABSTAIN;
        if (totalPoints > 125.0f) {
            vote = Vote.YES;
        } else if (totalPoints < 75.0f) {
            vote = Vote.NO;
        }
        log.info((Object)(us.getDisplayName() + " votes: " + (Object)((Object)vote)));
        log.info((Object)("\tTotal points: " + totalPoints));
        log.info((Object)("\tFriend relationship: " + friendRelationship * 100.0f));
        log.info((Object)("\tOther relationship: " + otherRelationshipPoints));
        log.info((Object)("\tOther alliance relationship: " + otherAllianceRelationshipPoints));
        log.info((Object)("\tStrength points: " + strengthPoints));
        log.info((Object)("\tHawk/dove points: " + hawkPoints));
        log.info((Object)("\tRandom points: " + randomPoints));
        return vote;
    }

    protected static boolean decideToDefyVote(boolean isWar, Alliance alliance, String factionId, String friendId, String otherFactionId) {
        FactionAPI us = Global.getSector().getFaction(factionId);
        ExerelinFactionConfig usConf = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (isWar ? ExerelinFactionConfig.getMinRelationship(factionId, otherFactionId) > AllianceManager.HOSTILE_THRESHOLD : ExerelinFactionConfig.getMaxRelationship(factionId, otherFactionId) < AllianceManager.HOSTILE_THRESHOLD) {
            return true;
        }
        if (factionId.equals("player_npc")) {
            return false;
        }
        float hawkishness = usConf.alignments.get((Object)Alliance.Alignment.MILITARIST).floatValue();
        float diplomaticness = usConf.alignments.get((Object)Alliance.Alignment.DIPLOMATIC).floatValue();
        float friendRelationship = us.getRelationship(friendId);
        float totalPoints = 75.0f + friendRelationship * 100.0f;
        float hawkPoints = hawkishness * 50.0f;
        if (!isWar) {
            hawkPoints *= -1.0f;
        }
        totalPoints += hawkPoints;
        if (!isWar) {
            totalPoints += diplomaticness * 50.0f;
        }
        return totalPoints <= 50.0f;
    }

    public static enum Vote {
        YES,
        NO,
        ABSTAIN,
        NO_VOTE;

    }

    public static class VoteResult {
        public final boolean success;
        public final Set<String> yesVotes;
        public final Set<String> noVotes;
        public final Set<String> abstentions;
        public final Set<String> defied;

        public VoteResult(boolean success, Set<String> yesVotes, Set<String> noVotes, Set<String> abstentions, Set<String> defied) {
            this.success = success;
            this.yesVotes = yesVotes;
            this.noVotes = noVotes;
            this.abstentions = abstentions;
            this.defied = defied;
        }
    }
}

